package com.tydic.dyc.oc.service.saleorder;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.service.saleorder.bo.UocUpdateEvaluateReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocUpdateEvaluateRspBO;
import com.tydic.dyc.oc.transactionservice.UocUpdateEvaluateTransaction;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * @description 大兴修改评价接口
 * @author Luokan
 * @date 2024/08/15
 **/
@Slf4j
@HTServiceImpl
public class UocUpdateEvaluateServiceImpl implements UocUpdateEvaluateService{

    @Autowired
    private UocUpdateEvaluateTransaction uocUpdateEvaluateTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public UocUpdateEvaluateRspBO updateEvaluate(UocUpdateEvaluateReqBO reqBO) {
        UocUpdateEvaluateRspBO rspBo = uocUpdateEvaluateTransaction.updateEvaluate(reqBO);

        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //本地 线程同步es
            syncEs(reqBO, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocUpdateEvaluateReqBO reqBo, UocUpdateEvaluateRspBO rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
        saleBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
        saleBo.setOrderId(reqBo.getOrderId());
        saleBo.setObjId(reqBo.getSaleOrderId());
        saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

        list.add(saleBo);
        log.debug("验收单es同步：" + JSON.toJSONString(list));
        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}
