package com.tydic.dyc.oc.transactionservice;

import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocEvaluate;
import com.tydic.dyc.oc.service.saleorder.bo.UocUpdateEvaluateReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocUpdateEvaluateRspBO;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
@Slf4j
@Component
public class UocUpdateEvaluateTransaction {

    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public UocUpdateEvaluateRspBO updateEvaluate(UocUpdateEvaluateReqBO reqBO) { //更新评价内容
        UocEvaluate updateUocEvaluate = new UocEvaluate();
        updateUocEvaluate.setOrderId(reqBO.getOrderId());
        updateUocEvaluate.setObjId(reqBO.getSaleOrderId());
        updateUocEvaluate.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        updateUocEvaluate.setEvaluateInfo(reqBO.getEvaluateInfo());
        this.iUocOrderModel.updateOrderEvaluate(updateUocEvaluate);
        return UocRu.success(UocUpdateEvaluateRspBO.class);
    }
}
