/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.service.saleorder.UocUpdateEvaluateService;
import com.tydic.dyc.oc.service.saleorder.bo.UocUpdateEvaluateReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocUpdateEvaluateRspBO;
import com.tydic.dyc.oc.transactionservice.UocUpdateEvaluateTransaction;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.saleorder.UocUpdateEvaluateService"})
public class UocUpdateEvaluateServiceImpl
implements UocUpdateEvaluateService {
    private static final Logger log = LoggerFactory.getLogger(UocUpdateEvaluateServiceImpl.class);
    @Autowired
    private UocUpdateEvaluateTransaction uocUpdateEvaluateTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @PostMapping(value={"updateEvaluate"})
    public UocUpdateEvaluateRspBO updateEvaluate(@RequestBody UocUpdateEvaluateReqBO reqBO) {
        UocUpdateEvaluateRspBO rspBo = this.uocUpdateEvaluateTransaction.updateEvaluate(reqBO);
        if ("0000".equals(rspBo.getRespCode())) {
            this.syncEs(reqBO, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocUpdateEvaluateReqBO reqBo, UocUpdateEvaluateRspBO rspBo) {
        ArrayList<SyncEsRunnableBo> list = new ArrayList<SyncEsRunnableBo>();
        SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
        saleBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        saleBo.setOrderId(reqBo.getOrderId());
        saleBo.setObjId(reqBo.getSaleOrderId());
        saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(saleBo);
        log.debug("\u9a8c\u6536\u5355es\u540c\u6b65\uff1a" + JSON.toJSONString(list));
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}

