/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.busicommon.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.utils.DycEsbUtil;
import com.tydic.dyc.atom.base.utils.DycPropertiesUtil;
import com.tydic.dyc.atom.busicommon.api.DycUocHitBatchBiddingFunction;
import com.tydic.dyc.atom.busicommon.bo.DycUocHitBatchBiddingFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocHitBatchBiddingFuncRspBO;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.service.order.UocAddOrderInterLogService;
import com.tydic.dyc.oc.service.order.bo.UocAddOrderInterLogReqBO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DycUocHitBatchBiddingFunctionImpl
implements DycUocHitBatchBiddingFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocHitBatchBiddingFunctionImpl.class);
    @Autowired
    private UocAddOrderInterLogService uocAddOrderInterLogService;

    @Override
    public DycUocHitBatchBiddingFuncRspBO hitBatchBidding(DycUocHitBatchBiddingFuncReqBO reqBO) {
        this.verifyParam(reqBO);
        String callUrl = null;
        callUrl = DycPropertiesUtil.getProperty((String)"ESB_HIT_BATCH_BIDDING_URL");
        String hsn = DycPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + reqBO.getSupplierId()));
        log.info("\u4e2d\u6807\u901a\u77e5\u63a5\u53e3\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqBO));
        log.info("\u4e2d\u6807\u901a\u77e5\u63a5\u53e3\u8bf7\u6c42\u5730\u5740:{}", (Object)callUrl);
        log.info("\u4e2d\u6807\u901a\u77e5\u63a5\u53e3hsn:{}", (Object)hsn);
        Date callTime = new Date();
        String result = DycEsbUtil.doPostReuest((String)callUrl, (String)JSON.toJSONString((Object)reqBO), (String)hsn);
        Date retTime = new Date();
        this.intsertInterLog(reqBO.getBargainingId(), Long.valueOf(reqBO.getThirdApplyId()), callTime, retTime, hsn, callUrl, JSON.toJSONString((Object)reqBO), result);
        log.info("\u4e2d\u6807\u901a\u77e5\u63a5\u53e3\u51fa\u53c2: " + result);
        return this.resolveRsp(result);
    }

    private void verifyParam(DycUocHitBatchBiddingFuncReqBO reqBo) {
        if (StringUtils.isEmpty((Object)reqBo.getThirdApplyId())) {
            throw new ZTBusinessException("\u7b2c\u4e09\u65b9\u7533\u8bf7\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getResult())) {
            throw new ZTBusinessException("\u4e2d\u6807\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private DycUocHitBatchBiddingFuncRspBO resolveRsp(String returnString) {
        DycUocHitBatchBiddingFuncRspBO hitBatchBiddingFuncRspBO = new DycUocHitBatchBiddingFuncRspBO();
        JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
        if (rspJsonObject.getBoolean("success").booleanValue()) {
            JSONObject jsonObject = (JSONObject)rspJsonObject.get((Object)"result");
            hitBatchBiddingFuncRspBO = (DycUocHitBatchBiddingFuncRspBO)((Object)JSON.parseObject((String)jsonObject.toJSONString(), DycUocHitBatchBiddingFuncRspBO.class));
            hitBatchBiddingFuncRspBO.setRespCode("0000");
            hitBatchBiddingFuncRspBO.setRespDesc("\u6210\u529f");
            return hitBatchBiddingFuncRspBO;
        }
        hitBatchBiddingFuncRspBO.setRespCode(rspJsonObject.getString("resultCode"));
        hitBatchBiddingFuncRspBO.setRespDesc(rspJsonObject.getString("resultMessage"));
        return hitBatchBiddingFuncRspBO;
    }

    private void intsertInterLog(Long orderId, Long objId, Date callTime, Date retTime, String hsn, String callUrl, String reqJson, String result) {
        UocAddOrderInterLogReqBO uocAddOrderInterLogReqBO = new UocAddOrderInterLogReqBO();
        uocAddOrderInterLogReqBO.setOrderId(orderId);
        uocAddOrderInterLogReqBO.setObjId(objId);
        uocAddOrderInterLogReqBO.setObjType(UocDicConstant.OBJ_TYPE.BARGAIN);
        uocAddOrderInterLogReqBO.setRetTime(retTime);
        uocAddOrderInterLogReqBO.setCallTime(callTime);
        uocAddOrderInterLogReqBO.setInterSn(hsn);
        uocAddOrderInterLogReqBO.setInterCode(callUrl);
        uocAddOrderInterLogReqBO.setFlowFlag(Integer.valueOf(1));
        uocAddOrderInterLogReqBO.setInContent(reqJson);
        uocAddOrderInterLogReqBO.setOutContent(result);
        this.uocAddOrderInterLogService.addOrderInterLog(uocAddOrderInterLogReqBO);
    }
}

