/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.dao.UccCatRCommdTypeMapper;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.dao.UccCommodityTypeAddCoefficientMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccSkuAddCoefficientMapper;
import com.tydic.commodity.estore.ability.api.UccSkuAddPriceListQueryService;
import com.tydic.commodity.estore.ability.bo.UccFullNameCatalogBo;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceListQueryInfoBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceListQueryReqBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceListQueryRspBO;
import com.tydic.commodity.po.CnncUccSkuAddPricePO;
import com.tydic.commodity.po.UccCatalogConnectCommdTypeDealPO;
import com.tydic.commodity.po.UccCatalogDealPO;
import com.tydic.commodity.po.UccCommodityTypeAddCoefficientPO;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccSkuAddPriceListQueryService"})
public class UccSkuAddPriceListQueryServiceImpl
implements UccSkuAddPriceListQueryService {
    @Autowired
    private UccSkuAddCoefficientMapper uccSkuAddCoefficientMapper;
    @Autowired
    private UccEMdmCatalogMapper cnncUccEMdmCatalogMapper;
    public static final Long TOP_CATALOG_ID = 0L;
    public static final String SEPARATOR = "/";
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccCatRCommdTypeMapper uccCatRCommdTypeMapper;
    @Autowired
    private UccCatalogDealMapper uccCatalogDealMapper;
    @Autowired
    private UccCommodityTypeAddCoefficientMapper uccCommodityTypeAddCoefficientMapper;

    @PostMapping(value={"querySkuAddPriceList"})
    public UccSkuAddPriceListQueryRspBO querySkuAddPriceList(@RequestBody UccSkuAddPriceListQueryReqBO reqBO) {
        Page page;
        List cnncUccSkuAddPricePOS;
        UccSkuAddPriceListQueryRspBO rspBO = new UccSkuAddPriceListQueryRspBO();
        if (reqBO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isEmpty((Object)reqBO.getExtSkuId())) {
            reqBO.setExtSkuId(null);
        }
        if (StringUtils.isEmpty((Object)reqBO.getSkuName())) {
            reqBO.setSkuName(null);
        }
        CnncUccSkuAddPricePO cnncUccSkuAddPricePO = new CnncUccSkuAddPricePO();
        BeanUtils.copyProperties((Object)reqBO, (Object)cnncUccSkuAddPricePO);
        cnncUccSkuAddPricePO.setSupplierShopId(reqBO.getSupplierId());
        List<Object> proOrgIdsList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)cnncUccSkuAddPricePO.getProExtendOrgIds())) {
            proOrgIdsList.addAll(cnncUccSkuAddPricePO.getProExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty((Collection)cnncUccSkuAddPricePO.getProNotExtendOrgIds())) {
            proOrgIdsList.addAll(cnncUccSkuAddPricePO.getProNotExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty((Collection)cnncUccSkuAddPricePO.getPurExtendOrgIds())) {
            proOrgIdsList.addAll(cnncUccSkuAddPricePO.getPurExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty((Collection)cnncUccSkuAddPricePO.getPurNotExtendOrgIds())) {
            proOrgIdsList.addAll(cnncUccSkuAddPricePO.getPurNotExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty((Collection)cnncUccSkuAddPricePO.getSupExtendOrgIds())) {
            proOrgIdsList.addAll(cnncUccSkuAddPricePO.getSupExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty((Collection)cnncUccSkuAddPricePO.getSupNotExtendOrgIds())) {
            proOrgIdsList.addAll(cnncUccSkuAddPricePO.getSupNotExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty(proOrgIdsList)) {
            proOrgIdsList = proOrgIdsList.stream().distinct().collect(Collectors.toList());
        }
        if (!Objects.isNull(reqBO.getUserId())) {
            cnncUccSkuAddPricePO.setCreateOperId(reqBO.getUserId());
        }
        if (null != reqBO.getCatalogId()) {
            List uccCommodityTypePos = this.uccCatRCommdTypeMapper.selectByCatalogId(reqBO.getCatalogId());
            if (!CollectionUtils.isEmpty((Collection)uccCommodityTypePos)) {
                cnncUccSkuAddPricePO.setCommodityTypeIds(uccCommodityTypePos.stream().map(UccCommodityTypePo::getCommodityTypeId).distinct().collect(Collectors.toList()));
                cnncUccSkuAddPricePO.setCatalogId(null);
            } else {
                rspBO.setPageNo(1);
                rspBO.setTotal(1);
                rspBO.setRecordsTotal(0);
                rspBO.setRows(new ArrayList());
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
                return rspBO;
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(cnncUccSkuAddPricePOS = this.uccSkuAddCoefficientMapper.queryPage(cnncUccSkuAddPricePO, proOrgIdsList, page = new Page(reqBO.getPageNo(), reqBO.getPageSize()))))) {
            List<Long> typeIds = cnncUccSkuAddPricePOS.stream().map(CnncUccSkuAddPricePO::getCommodityTypeId).distinct().collect(Collectors.toList());
            UccCommodityTypeAddCoefficientPO uccCommodityTypeAddCoefficientPO = new UccCommodityTypeAddCoefficientPO();
            uccCommodityTypeAddCoefficientPO.setCommodityTypeIds(typeIds);
            uccCommodityTypeAddCoefficientPO.setDelFlag("0");
            List uccCommodityTypeAddCoefficientPOList = this.uccCommodityTypeAddCoefficientMapper.getList(uccCommodityTypeAddCoefficientPO);
            Map<Object, Object> addPriceMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)uccCommodityTypeAddCoefficientPOList)) {
                addPriceMap = uccCommodityTypeAddCoefficientPOList.stream().collect(Collectors.toMap(UccCommodityTypeAddCoefficientPO::getCommodityTypeId, UccCommodityTypeAddCoefficientPO::getAddCoefficient, (o1, o2) -> o1));
            }
            Map<Long, List<UccCatalogConnectCommdTypeDealPO>> uccCatalogConnectCommdTypeDealMap = this.getCommodityRelMap(typeIds);
            Map<Long, UccCatalogDealPO> guideCatalogMap = this.getGuideCatalogMap();
            ArrayList<UccSkuAddPriceListQueryInfoBO> rows = new ArrayList<UccSkuAddPriceListQueryInfoBO>(16);
            for (CnncUccSkuAddPricePO uccSkuAddPricePO : cnncUccSkuAddPricePOS) {
                UccSkuAddPriceListQueryInfoBO uccSkuAddPriceListQueryInfoBO = new UccSkuAddPriceListQueryInfoBO();
                BeanUtils.copyProperties((Object)uccSkuAddPricePO, (Object)uccSkuAddPriceListQueryInfoBO);
                ArrayList<Long> catalogIds = new ArrayList<Long>();
                catalogIds.add(uccSkuAddPriceListQueryInfoBO.getCatalogId());
                List<UccEMdmCatalogPO> parent = this.findParent(catalogIds);
                StringBuffer catalogName = new StringBuffer();
                for (int i = parent.size() - 1; i >= 0; --i) {
                    catalogName.append(parent.get(i).getCatalogName()).append(SEPARATOR);
                }
                if (!StringUtils.isEmpty((Object)catalogName) && catalogName.length() > 1) {
                    catalogName.deleteCharAt(catalogName.length() - 1);
                    uccSkuAddPriceListQueryInfoBO.setCatalogName(catalogName.toString());
                }
                uccSkuAddPriceListQueryInfoBO.setAgreementPrice(uccSkuAddPriceListQueryInfoBO.getAgreementPrice() == null ? null : MoneyUtils.haoToYuan((BigDecimal)uccSkuAddPriceListQueryInfoBO.getAgreementPrice()));
                uccSkuAddPriceListQueryInfoBO.setSalePrice(uccSkuAddPriceListQueryInfoBO.getSalePrice() == null ? null : MoneyUtils.haoToYuan((BigDecimal)uccSkuAddPriceListQueryInfoBO.getSalePrice()));
                uccSkuAddPriceListQueryInfoBO.setMarketPrice(uccSkuAddPriceListQueryInfoBO.getMarketPrice() == null ? null : MoneyUtils.haoToYuan((BigDecimal)uccSkuAddPriceListQueryInfoBO.getMarketPrice()));
                if (uccSkuAddPricePO.getLongTimeFlag() == 1) {
                    uccSkuAddPriceListQueryInfoBO.setExpTimeDesc("\u957f\u671f\u6709\u6548");
                }
                uccSkuAddPriceListQueryInfoBO.setCatalogAddCoefficient((BigDecimal)addPriceMap.get(uccSkuAddPriceListQueryInfoBO.getCommodityTypeId()));
                uccSkuAddPriceListQueryInfoBO.setAddCoefficientCatalogBoList(this.getUccAddCoefficientCatalogBos(uccCatalogConnectCommdTypeDealMap, guideCatalogMap, uccSkuAddPriceListQueryInfoBO));
                rows.add(uccSkuAddPriceListQueryInfoBO);
            }
            rspBO.setRows(rows);
            rspBO.setPageNo(page.getPageNo());
            rspBO.setTotal(page.getTotalCount());
            rspBO.setRecordsTotal(page.getTotalCount());
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    List<UccEMdmCatalogPO> findParent(List<Long> catalogId) {
        ArrayList<UccEMdmCatalogPO> poList = new ArrayList<UccEMdmCatalogPO>();
        List qryRspList = this.cnncUccEMdmCatalogMapper.queryByIds(catalogId);
        if (CollectionUtils.isEmpty((Collection)qryRspList)) {
            return poList;
        }
        poList.addAll(qryRspList);
        ArrayList<Long> next = new ArrayList<Long>();
        qryRspList.forEach(a -> {
            if (a.getCatalogLevel() > 1) {
                next.add(a.getParentCatalogId());
            }
        });
        if (CollectionUtils.isEmpty(next)) {
            return poList;
        }
        List<UccEMdmCatalogPO> parent = this.findParent(next);
        poList.addAll(parent);
        return poList;
    }

    private String getFullName(String name, Map<Long, UccCatalogDealPO> guideCatalogMap, Long guideId) {
        UccCatalogDealPO uccCatalogDealPO = guideCatalogMap.get(guideId);
        if (ObjectUtils.isEmpty((Object)uccCatalogDealPO)) {
            return name;
        }
        String guideCatalogFullName = uccCatalogDealPO.getCatalogName() + SEPARATOR + name;
        if (!TOP_CATALOG_ID.equals(uccCatalogDealPO.getUpperCatalogId())) {
            guideCatalogFullName = this.getFullName(guideCatalogFullName, guideCatalogMap, uccCatalogDealPO.getUpperCatalogId());
        }
        return guideCatalogFullName;
    }

    private Map<Long, UccCatalogDealPO> getGuideCatalogMap() {
        List uccCatalogDealPOS = this.uccCatalogDealMapper.queryAllCatalog(null);
        if (CollectionUtils.isEmpty((Collection)uccCatalogDealPOS)) {
            return new HashMap<Long, UccCatalogDealPO>(0);
        }
        return uccCatalogDealPOS.stream().collect(Collectors.toMap(UccCatalogDealPO::getGuideCatalogId, Function.identity()));
    }

    private Map<Long, List<UccCatalogConnectCommdTypeDealPO>> getCommodityRelMap(List<Long> typeIds) {
        if (CollectionUtils.isEmpty(typeIds)) {
            return new HashMap<Long, List<UccCatalogConnectCommdTypeDealPO>>(0);
        }
        List uccCatalogConnectCommdTypeDealPOS = this.uccCatRCommdTypeMapper.queryByCommodityTypeIds(typeIds);
        if (CollectionUtils.isEmpty((Collection)uccCatalogConnectCommdTypeDealPOS)) {
            return new HashMap<Long, List<UccCatalogConnectCommdTypeDealPO>>(0);
        }
        return uccCatalogConnectCommdTypeDealPOS.stream().collect(Collectors.groupingBy(UccCatalogConnectCommdTypeDealPO::getCommodityTypeId));
    }

    private List<UccFullNameCatalogBo> getUccAddCoefficientCatalogBos(Map<Long, List<UccCatalogConnectCommdTypeDealPO>> uccCatalogConnectCommdTypeDealMap, Map<Long, UccCatalogDealPO> guideCatalogMap, UccSkuAddPriceListQueryInfoBO uccCommodityTypeOfCoefficientBO) {
        ArrayList<UccFullNameCatalogBo> uccAddCoefficientCatalogBoList = new ArrayList<UccFullNameCatalogBo>(10);
        List<UccCatalogConnectCommdTypeDealPO> uccCatalogConnectCommdTypeDealPOS = uccCatalogConnectCommdTypeDealMap.get(uccCommodityTypeOfCoefficientBO.getCommodityTypeId());
        if (!CollectionUtils.isEmpty(uccCatalogConnectCommdTypeDealPOS)) {
            for (UccCatalogConnectCommdTypeDealPO uccCatalogConnectCommdTypeDealPO : uccCatalogConnectCommdTypeDealPOS) {
                UccFullNameCatalogBo uccAddCoefficientCatalogBo = new UccFullNameCatalogBo();
                uccAddCoefficientCatalogBo.setGuideCatalogId(uccCatalogConnectCommdTypeDealPO.getGuideCatalogId());
                uccAddCoefficientCatalogBo.setGuideCatalogName(guideCatalogMap.get(uccCatalogConnectCommdTypeDealPO.getGuideCatalogId()).getCatalogName());
                uccAddCoefficientCatalogBo.setGuideCatalogFullName(this.getFullName(uccCommodityTypeOfCoefficientBO.getCommodityTypeName(), guideCatalogMap, uccCatalogConnectCommdTypeDealPO.getGuideCatalogId()));
                uccAddCoefficientCatalogBoList.add(uccAddCoefficientCatalogBo);
            }
        }
        return uccAddCoefficientCatalogBoList;
    }
}

