/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.BatchUpdateCommoStatusForMarketBO;
import com.tydic.commodity.base.bo.CommodityBo;
import com.tydic.commodity.base.bo.RspUccBo;
import com.tydic.commodity.base.bo.SelfRunSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.enumType.AuditResultStatusEnum;
import com.tydic.commodity.base.enumType.CommodityStatusEnum;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccCommodityLogMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuLogMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.atom.api.UccCommodityAtomService;
import com.tydic.commodity.estore.atom.bo.BatchUpdateCommodityBO;
import com.tydic.commodity.estore.atom.bo.BatchUpdateCommodityStatusReqBo;
import com.tydic.commodity.estore.atom.bo.BatchUpdateSkuBO;
import com.tydic.commodity.estore.atom.bo.BatchUpdateSkuStatusReqBO;
import com.tydic.commodity.estore.busi.api.BatchUpdateCommoStatusForMarketService;
import com.tydic.commodity.po.UccCommodityLogPO;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccJoinQuerySkusPo;
import com.tydic.commodity.po.UccSkuLogPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.commodity.utils.ValidatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BatchUpdateCommoStatusForMarketServiceImpl
implements BatchUpdateCommoStatusForMarketService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchUpdateCommoStatusForMarketServiceImpl.class);
    @Autowired
    private UccCommodityAtomService uccCommodityAtomService;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccCommodityLogMapper uccCommodityLogMapper;
    @Autowired
    private UccSkuMapper skuMapper;
    @Autowired
    private UccSkuLogMapper uccSkuLogMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @Override
    public RspUccBo batchUpdateCommoStatusForMarket(BatchUpdateCommoStatusForMarketBO statusForMarketBO, CommodityStatusEnum commodityStatusEnum, SkuStatusEnum skuStatusEnum) {
        Date upateTime = new Date();
        ValidatorUtil.validator((Object)statusForMarketBO);
        if (statusForMarketBO.getBusinessId() == null || statusForMarketBO.getBusinessId().length == 0) {
            throw new BusinessException(RspConstantEnums.REQUIRED_NON_EMPTY.code(), "\u4e1a\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Object batchId = null;
        ArrayList uccCommodityLogPOS = Lists.newArrayList();
        ArrayList batchUpdateSkuBOS = Lists.newArrayList();
        ArrayList batchUpdateCommodityBOs = Lists.newArrayList();
        BatchUpdateSkuStatusReqBO batchUpdateSkuStatusReqBO = new BatchUpdateSkuStatusReqBO();
        BatchUpdateCommodityStatusReqBo commodityStatusReqBo = new BatchUpdateCommodityStatusReqBo();
        long[] sequence = new long[statusForMarketBO.getBusinessId().length];
        sequence = this.uccBatchSequence.nextIds(statusForMarketBO.getBusinessId().length);
        for (int i = 0; i < statusForMarketBO.getBusinessId().length; ++i) {
            UccCommodityPo uccCommodityPo = this.uccCommodityMapper.getCommodityById(statusForMarketBO.getBusinessId()[i]);
            if (uccCommodityPo == null) continue;
            if (commodityStatusEnum != null) {
                UccCommodityLogPO uccCommodityLogPO = new UccCommodityLogPO();
                BeanUtils.copyProperties((Object)uccCommodityPo, (Object)uccCommodityLogPO);
                uccCommodityLogPO.setBatchId(Long.valueOf(sequence[i]));
                uccCommodityLogPO.setAduitResult(statusForMarketBO.getReason());
                uccCommodityLogPO.setUpdateTime(upateTime);
                uccCommodityLogPO.setCommodityStatus(commodityStatusEnum.getStatus());
                uccCommodityLogPO.setOperType(UccConstants.CommodityPoolOperType.UPDATE);
                uccCommodityLogPOS.add(uccCommodityLogPO);
                BatchUpdateCommodityBO batchUpdateCommodityBO = new BatchUpdateCommodityBO();
                batchUpdateCommodityBO.setCommodityId(uccCommodityPo.getCommodityId());
                batchUpdateCommodityBO.setStatus(commodityStatusEnum.getStatus());
                commodityStatusReqBo.setSupplierShopId(uccCommodityPo.getSupplierShopId());
                batchUpdateCommodityBOs.add(batchUpdateCommodityBO);
            }
            if (skuStatusEnum == null) continue;
            BatchUpdateSkuBO batchUpdateSkuBO = new BatchUpdateSkuBO();
            batchUpdateSkuBO.setCommodityId(statusForMarketBO.getBusinessId()[i]);
            batchUpdateSkuBO.setSupplierShopId(uccCommodityPo.getSupplierShopId());
            batchUpdateSkuBO.setStatus(skuStatusEnum.getStatus());
            batchUpdateSkuBOS.add(batchUpdateSkuBO);
        }
        if (skuStatusEnum != null) {
            UccJoinQuerySkusPo uccJoinQuerySkusPo = new UccJoinQuerySkusPo();
            uccJoinQuerySkusPo.setCommodityIdArrays(statusForMarketBO.getBusinessId());
            List skuPos = this.skuMapper.queryJoinSkuByCommodityId(uccJoinQuerySkusPo);
            List<UccSkuLogPo> UccSkuLogPo2 = this.cloneUccSkuPo(skuPos);
            batchUpdateSkuStatusReqBO.setStatus(skuStatusEnum.getStatus());
            batchUpdateSkuStatusReqBO.setBoList(batchUpdateSkuBOS);
            if (skuStatusEnum.getStatus().equals(SkuStatusEnum.WARN_DOWN_STATUS.getStatus())) {
                batchUpdateSkuStatusReqBO.setOffShelveWay(3);
            }
            this.processUpdateSkuAndLog(batchUpdateSkuStatusReqBO, UccSkuLogPo2);
        }
        if (commodityStatusEnum != null) {
            commodityStatusReqBo.setBoList(batchUpdateCommodityBOs);
            this.processUpdateCommodityAndLog(commodityStatusReqBo, uccCommodityLogPOS);
        }
        if (!CollectionUtils.isEmpty((Collection)batchUpdateSkuBOS)) {
            SelfRunSyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SelfRunSyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setCommodityIds(batchUpdateSkuBOS.stream().map(BatchUpdateSkuBO::getCommodityId).collect(Collectors.toList()));
            syncSceneCommodityToEsReqBO.setSupplierId(((BatchUpdateSkuBO)batchUpdateSkuBOS.get(0)).getSupplierShopId());
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS.intValue());
            this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
        }
        LOGGER.info("\u5904\u7406\u5546\u54c1\u5355\u54c1\u72b6\u6001\u5b8c\u6210");
        RspUccBo rspUccBo = new RspUccBo();
        rspUccBo.setRespCode("0000");
        rspUccBo.setRespDesc("\u6210\u529f");
        return rspUccBo;
    }

    @Override
    public void updateCommoApprovalStatus(CommodityBo commodityBo, AuditResultStatusEnum auditResultStatusEnum) {
        UccCommodityPo uccCommodityPo = new UccCommodityPo();
        uccCommodityPo.setCommodityId(commodityBo.getCommodityId());
        uccCommodityPo.setApprovalStatus(commodityBo.getApprovalStatus());
        uccCommodityPo.setSupplierShopId(commodityBo.getSupplierShopId());
        this.uccCommodityMapper.updateCommodity(uccCommodityPo);
    }

    @Override
    public void batchUpdateCommoApprovalStatus(List<CommodityBo> commodityBos) {
        if (!CollectionUtils.isEmpty(commodityBos)) {
            Map<Integer, List<CommodityBo>> map = commodityBos.stream().filter(a -> a.getApprovalStatus() != null).collect(Collectors.groupingBy(CommodityBo::getApprovalStatus));
            Iterator<Map.Entry<Integer, List<CommodityBo>>> iterator = map.entrySet().iterator();
            try {
                while (iterator.hasNext()) {
                    Map.Entry<Integer, List<CommodityBo>> each = iterator.next();
                    Integer approvalStatus = each.getKey();
                    List<CommodityBo> bos = each.getValue();
                    if (approvalStatus == null || CollectionUtils.isEmpty(bos)) continue;
                    List commodityIds = bos.stream().map(CommodityBo::getCommodityId).collect(Collectors.toList());
                    UccCommodityPo uccCommodityPo = new UccCommodityPo();
                    uccCommodityPo.setApprovalStatus(approvalStatus);
                    this.uccCommodityMapper.batchUpdateById(commodityIds, uccCommodityPo);
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new ZTBusinessException(e.getMessage());
            }
        }
    }

    private void processUpdateCommodityAndLog(BatchUpdateCommodityStatusReqBo reqBO, List<UccCommodityLogPO> commodityLogPOS) {
        try {
            if (CollectionUtils.isNotEmpty(commodityLogPOS)) {
                this.uccCommodityLogMapper.batchInsert(commodityLogPOS);
            }
            this.uccCommodityAtomService.batchUpdateCommodityByCommodityId(reqBO);
        }
        catch (Exception e) {
            LOGGER.error("\u6279\u91cf\u4fee\u6539\u5546\u54c1\u72b6\u6001\u5931\u8d25", (Throwable)e);
            throw new BusinessException("8888", "\u6279\u91cf\u4fee\u6539\u5546\u54c1\u72b6\u6001\u5931\u8d25");
        }
    }

    private void processUpdateSkuAndLog(BatchUpdateSkuStatusReqBO reqBO, List<UccSkuLogPo> uccSkuLogPos) {
        try {
            if (CollectionUtils.isNotEmpty(uccSkuLogPos)) {
                this.uccSkuLogMapper.addSkuLog(uccSkuLogPos);
            }
            this.uccCommodityAtomService.batchSkuInStatus(reqBO);
        }
        catch (Exception e) {
            LOGGER.error("\u6279\u91cf\u4fee\u6539\u5355\u54c1\u72b6\u6001\u5931\u8d25", (Throwable)e);
            throw new BusinessException("8888", "\u6279\u91cf\u4fee\u6539\u5355\u54c1\u72b6\u6001\u5931\u8d25");
        }
    }

    private List<UccSkuLogPo> cloneUccSkuPo(List<UccSkuPo> skuPos) {
        ArrayList uccSkuLogPos = Lists.newArrayList();
        for (UccSkuPo skuPo : skuPos) {
            Long batchId = this.uccBatchSequence.nextId();
            UccSkuLogPo uccSkuLogPo = new UccSkuLogPo();
            uccSkuLogPo.setBatchId(batchId);
            BeanUtils.copyProperties((Object)skuPo, (Object)uccSkuLogPo);
            uccSkuLogPos.add(uccSkuLogPo);
        }
        return uccSkuLogPos;
    }
}

