/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.atom.api.InterfaceCurrentPriceQryService;
import com.tydic.commodity.mall.atom.bo.InterfaceCommdPriceBO;
import com.tydic.commodity.mall.atom.bo.InterfaceCurrentPriceQryReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceCurrentPriceQryRspBO;
import com.tydic.commodity.mall.atom.bo.InterfaceJdPriceBO;
import com.tydic.commodity.mall.atom.bo.InterfaceNotJdPriceBO;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.utils.ESBParamUtil;
import com.tydic.commodity.mall.utils.HSHttpHelper;
import com.tydic.commodity.mall.utils.HSNHttpHeader;
import com.tydic.commodity.mall.utils.HttpRetBean;
import com.tydic.commodity.mall.utils.PropertiesUtil;
import java.net.URI;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="uccCurrentPriceQryService")
public class InterfaceCurrentPriceQryServiceImpl
implements InterfaceCurrentPriceQryService {
    private static final Logger log = LoggerFactory.getLogger(InterfaceCurrentPriceQryServiceImpl.class);

    @Override
    public InterfaceCurrentPriceQryRspBO qryCommdCurrentPrice(InterfaceCurrentPriceQryReqBO reqBO) {
        try {
            String reqStr = this.initReqStr(reqBO);
            String hsn = reqBO.getSupplierCode();
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtil.getProperty("ESB_QRY_SKU_PRICE_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("ESB_QRY_SKU_PRICE_URL") + "]");
                InterfaceCurrentPriceQryRspBO resolveRsp = new InterfaceCurrentPriceQryRspBO();
                resolveRsp.setResultCode(UccMallConstantsEnums.HTTP_OUT_FAIL.code());
                resolveRsp.setResultMessage(UccMallConstantsEnums.HTTP_OUT_FAIL.code() + httpRetBean.getStatus());
                return resolveRsp;
            }
            log.info("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                InterfaceCurrentPriceQryRspBO resolveRsp = new InterfaceCurrentPriceQryRspBO();
                resolveRsp.setResultCode(UccMallConstantsEnums.OUT_MESSAGE_QUERY_NULL_FAILED.code());
                resolveRsp.setResultMessage("\u67e5\u8be2\u7535\u5546\u5916\u90e8\u63a5\u53e3-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                return resolveRsp;
            }
            InterfaceCurrentPriceQryRspBO resolveRsp = this.resolveRsp(reqBO, returnString);
            if (resolveRsp != null) {
                log.info("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u89e3\u6790\u54cd\u5e94\u6570\u636e\uff1a" + resolveRsp.toString());
            }
            return resolveRsp;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
    }

    private String initReqStr(InterfaceCurrentPriceQryReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sku", reqBO.getSkuIds());
        jsonObject.put("hsn", (Object)reqBO.getSupplierCode());
        if ("jd".equals(reqBO.getSupplierCode()) || "jdvop".equals(reqBO.getSupplierCode())) {
            jsonObject.put("queryExts ", (Object)"containsTax,marketPrice");
        }
        return jsonObject.toString();
    }

    private InterfaceCurrentPriceQryRspBO resolveRsp(InterfaceCurrentPriceQryReqBO reqBO, String returnString) {
        InterfaceCurrentPriceQryRspBO rspBO = new InterfaceCurrentPriceQryRspBO();
        ArrayList<InterfaceJdPriceBO> list = new ArrayList<InterfaceJdPriceBO>();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            rspBO.setSuccess((Boolean)rspJsonObject.get((Object)"success"));
            rspBO.setResultCode((String)rspJsonObject.get((Object)"resultCode"));
            rspBO.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
            String respCode = (String)rspJsonObject.get((Object)"resultCode");
            if (!"0000".equals(respCode)) {
                if ("2007".equals(respCode)) {
                    rspBO.setResultMessage("token\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5237\u65b0\u6216\u8005\u83b7\u53d6token");
                    rspBO.setResultCode(UccMallConstantsEnums.TOKEN_EXPIRE_FAIL.code());
                    return rspBO;
                }
                return rspBO;
            }
            JSONArray object = rspJsonObject.getJSONArray("result");
            if (null != object) {
                InterfaceCommdPriceBO commdPriceBO = new InterfaceCommdPriceBO();
                if ("jd".equals(reqBO.getSupplierCode()) || "jdvop".equals(reqBO.getSupplierCode())) {
                    for (int i = 0; i < object.size(); ++i) {
                        JSONObject obj = (JSONObject)object.get(i);
                        String jsonStr = JSONObject.toJSONString((Object)obj);
                        if (StringUtils.isEmpty((Object)jsonStr)) continue;
                        InterfaceJdPriceBO jsonStringToJavaBean = (InterfaceJdPriceBO)JSON.parseObject((String)jsonStr, InterfaceJdPriceBO.class);
                        list.add(jsonStringToJavaBean);
                    }
                    commdPriceBO.setJdPriceInfos(list);
                    rspBO.setResult(commdPriceBO);
                } else {
                    for (int i = 0; i < object.size(); ++i) {
                        JSONObject jsonObject = (JSONObject)object.get(i);
                        InterfaceNotJdPriceBO notJdPriceBO = (InterfaceNotJdPriceBO)JSONObject.toJavaObject((JSON)jsonObject, InterfaceNotJdPriceBO.class);
                        list.add((InterfaceJdPriceBO)((Object)notJdPriceBO));
                    }
                    commdPriceBO.setNotJdPriceInfo(list);
                }
                rspBO.setResult(commdPriceBO);
            }
            return rspBO;
        }
        catch (Exception var10) {
            log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
            rspBO.setResultMessage("\u67e5\u8be2\u7535\u5546\u5916\u90e8\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519");
            rspBO.setResultCode(UccMallConstantsEnums.OUT_MESSAGE_QUERY_RESOLVE_FAILED.code());
            return rspBO;
        }
    }
}

