/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.ability.bo.UccMallQueryParam;
import com.tydic.commodity.mall.busi.api.UccMallSearchEsQueryService;
import com.tydic.commodity.mall.busi.bo.UccMallCommodityRspBo;
import com.tydic.commodity.mall.busi.bo.UccMallCommoditySingileRspBo;
import com.tydic.commodity.mall.busi.bo.UccMallSearchEsRspBo;
import com.tydic.commodity.mall.busi.bo.UccMallSearchEsSQLRspBO;
import com.tydic.commodity.mall.config.MallElasticsearchUtil;
import com.tydic.commodity.mall.config.MallEsConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UccMallSearchEsQueryServiceImpl
implements UccMallSearchEsQueryService {
    private static final Logger log = LoggerFactory.getLogger(UccMallSearchEsQueryServiceImpl.class);
    @Autowired
    private MallEsConfig mallEsConfig;
    @Autowired
    private MallElasticsearchUtil mallElasticsearchUtil;

    @Override
    public UccMallSearchEsRspBo executeSQL(UccMallSearchEsSQLRspBO uccMallSearchEsSQLRspBO) {
        String endPoint = "/" + this.mallEsConfig.getIndexName() + "/" + this.mallEsConfig.getEsType() + "/_search";
        String queryString = this.getQueryString(uccMallSearchEsSQLRspBO);
        if (log.isDebugEnabled()) {
            log.debug("source---->" + queryString);
        }
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.mallElasticsearchUtil.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (log.isDebugEnabled()) {
                log.debug("result---->" + result);
            }
            UccMallSearchEsRspBo uccMallSearchEsRspBo = this.dealSearchData(result, uccMallSearchEsSQLRspBO.isNeedKeyWorld());
            if (uccMallSearchEsSQLRspBO.isField()) {
                String agss = JSONObject.parseObject((String)result).get((Object)"aggregations").toString();
                int total = Integer.valueOf(JSONObject.parseObject((String)JSONObject.parseObject((String)agss).get((Object)"books_count").toString()).get((Object)"value").toString());
                uccMallSearchEsRspBo.setTotal(total);
            }
            return uccMallSearchEsRspBo;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return null;
        }
    }

    private String getQueryString(UccMallSearchEsSQLRspBO uccMallSearchEsSQLRspBO) {
        TermsAggregationBuilder teamAggSupplierCategory;
        JSONObject queryJson = new JSONObject();
        queryJson.put("size", (Object)uccMallSearchEsSQLRspBO.getPageSize());
        queryJson.put("from", (Object)(uccMallSearchEsSQLRspBO.getPageSize() * (uccMallSearchEsSQLRspBO.getPageNo() - 1)));
        String queryString = null;
        queryString = uccMallSearchEsSQLRspBO.getFunctionScoreQueryBuilder() != null ? uccMallSearchEsSQLRspBO.getFunctionScoreQueryBuilder().toString() : uccMallSearchEsSQLRspBO.getBoolQueryBuilder().toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        String sortString = uccMallSearchEsSQLRspBO.getSortQuery().toString();
        queryJson.put("sort", (Object)JSONObject.parseArray((String)uccMallSearchEsSQLRspBO.getSortQuery().toString()));
        if (uccMallSearchEsSQLRspBO.isField()) {
            JSONObject collapse = new JSONObject();
            collapse.put("field", (Object)"commodity_id");
            queryJson.put("collapse", (Object)collapse);
        }
        JSONObject aggs = new JSONObject();
        boolean filterSupplier = true;
        boolean filterBrand = false;
        boolean filterCategory = false;
        boolean filterVendor = false;
        List<String> params = uccMallSearchEsSQLRspBO.getHiddenParamsForRsp();
        if (params != null) {
            for (String param : params) {
                if ("supplier_id_name".equals(param)) {
                    filterSupplier = true;
                }
                if ("brand_id_name".equals(param)) {
                    filterBrand = true;
                }
                if ("l3_category_id_name".equals(param)) {
                    filterCategory = true;
                }
                if (!"vendor_id_name".equals(param)) continue;
                filterVendor = true;
            }
        }
        if (uccMallSearchEsSQLRspBO.getLevel() != null && uccMallSearchEsSQLRspBO.getLevel() == 3) {
            filterCategory = true;
        }
        if (!filterSupplier) {
            TermsAggregationBuilder teamAggSupplier = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_supplier_name").field("supplier_name.keyword")).size(2000);
            aggs.put("group_by_supplier_name", JSON.parseObject((String)teamAggSupplier.toString()).get((Object)"group_by_supplier_name"));
        }
        if (!filterBrand) {
            TermsAggregationBuilder teamAggSupplierBrand = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_brand_name").field("brand_name.keyword")).size(2000);
            aggs.put("group_by_brand_name", JSON.parseObject((String)teamAggSupplierBrand.toString()).get((Object)"group_by_brand_name"));
        }
        if (!filterCategory) {
            teamAggSupplierCategory = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_l3_category_name").field("l3_category_name.keyword")).size(2000);
            aggs.put("group_by_l3_category_name", JSON.parseObject((String)teamAggSupplierCategory.toString()).get((Object)"group_by_l3_category_name"));
        }
        if (!filterVendor) {
            teamAggSupplierCategory = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_vendor_name").field("vendor_name.keyword")).size(2000);
            aggs.put("group_by_vendor_name", JSON.parseObject((String)teamAggSupplierCategory.toString()).get((Object)"group_by_vendor_name"));
        }
        if (uccMallSearchEsSQLRspBO.isField()) {
            JSONObject total = new JSONObject();
            JSONObject cardinality = new JSONObject();
            total.put("field", (Object)"commodity_id");
            total.put("precision_threshold", (Object)40000);
            cardinality.put("cardinality", (Object)total);
            aggs.put("books_count", (Object)cardinality);
        }
        queryJson.put("aggs", (Object)aggs);
        return queryJson.toString();
    }

    private UccMallSearchEsRspBo dealSearchData(String result, boolean isNeedKeyWorld) {
        UccMallSearchEsRspBo rspBo = new UccMallSearchEsRspBo();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = 0;
        try {
            total = hitsObj.getInteger("total");
        }
        catch (Exception e) {
            JSONObject totalObj = (JSONObject)hitsObj.get((Object)"total");
            total = totalObj.getInteger("value");
        }
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (log.isDebugEnabled()) {
            log.debug("\u603b\u8bb0\u5f55\u6570:" + total + " \u8fd4\u56de\u8bb0\u5f55\u6570\u636e" + listObject.size());
        }
        ArrayList<UccMallCommodityRspBo> commodityModels = new ArrayList<UccMallCommodityRspBo>();
        HashSet<Long> skuIdSet = new HashSet<Long>();
        ArrayList<String> propertyList = new ArrayList<String>();
        ArrayList<UccMallCommodityRspBo> otherProperty = new ArrayList<UccMallCommodityRspBo>();
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                UccMallCommodityRspBo commodity;
                block22: {
                    JSONObject hitObj = listObject.getJSONObject(i);
                    JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                    commodity = new UccMallCommodityRspBo();
                    try {
                        commodity = (UccMallCommodityRspBo)JSON.toJavaObject((JSON)data, UccMallCommodityRspBo.class);
                    }
                    catch (Exception e) {
                        log.info("\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5" + e.getMessage());
                        UccMallCommoditySingileRspBo single = new UccMallCommoditySingileRspBo();
                        try {
                            single = (UccMallCommoditySingileRspBo)JSON.toJavaObject((JSON)data, UccMallCommoditySingileRspBo.class);
                        }
                        catch (Exception e1) {
                            log.error("\u6570\u636e\u8f6c\u6362\u5f02\u5e38\uff1a" + e.getMessage());
                            return rspBo;
                        }
                        BeanUtils.copyProperties((Object)single, (Object)commodity);
                        if (single.getL1_category_id() != null) {
                            commodity.setL1_category_id(new ArrayList<Long>(Arrays.asList(single.getL1_category_id())));
                        }
                        if (single.getL2_category_id() != null) {
                            commodity.setL2_category_id(new ArrayList<Long>(Arrays.asList(single.getL2_category_id())));
                        }
                        if (single.getL3_category_id() != null) {
                            commodity.setL3_category_id(new ArrayList<Long>(Arrays.asList(single.getL3_category_id())));
                        }
                        if (!StringUtils.isEmpty((Object)single.getL1_category_name())) {
                            commodity.setL1_category_name(new ArrayList<String>(Arrays.asList(single.getL1_category_name())));
                        }
                        if (!StringUtils.isEmpty((Object)single.getL2_category_name())) {
                            commodity.setL2_category_name(new ArrayList<String>(Arrays.asList(single.getL2_category_name())));
                        }
                        if (!StringUtils.isEmpty((Object)single.getL3_category_name())) {
                            commodity.setL3_category_name(new ArrayList<String>(Arrays.asList(single.getL3_category_name())));
                        }
                        if (single.getChannel_id() == null) break block22;
                        commodity.setChannel_id(new ArrayList<Long>(Arrays.asList(single.getChannel_id())));
                    }
                }
                if (!skuIdSet.contains(commodity.getSku_id())) {
                    String properties = commodity.getProperties();
                    if (!StringUtils.isEmpty((Object)properties)) {
                        propertyList.add(properties);
                        otherProperty.add(commodity);
                    }
                    commodityModels.add(commodity);
                }
                skuIdSet.add(commodity.getSku_id());
            }
        }
        rspBo.setTotal(total);
        rspBo.setUccMallCommodityRspBos(commodityModels);
        LinkedList<UccMallQueryParam> resultParams = new LinkedList<UccMallQueryParam>();
        JSONObject aggsObj = (JSONObject)resultObj.get((Object)"aggregations");
        if (aggsObj != null && !aggsObj.isEmpty()) {
            JSONObject vendorObject;
            JSONObject supplierObject;
            JSONObject brandObject;
            JSONObject categoryObject = aggsObj.getJSONObject("group_by_l3_category_name");
            if (categoryObject != null && !categoryObject.isEmpty()) {
                List<String> categoryValues = this.getNameList(categoryObject);
                UccMallQueryParam category3IdQP = new UccMallQueryParam();
                category3IdQP.setFilterId("l3_category_id_name");
                category3IdQP.setFilterName("\u5206\u7c7b");
                category3IdQP.setFilterValues(categoryValues);
                resultParams.add(category3IdQP);
            }
            if ((brandObject = aggsObj.getJSONObject("group_by_brand_name")) != null && !brandObject.isEmpty()) {
                List<String> brandValues = this.getNameList(brandObject);
                UccMallQueryParam brandQP = new UccMallQueryParam();
                brandQP.setFilterId("brand_id_name");
                brandQP.setFilterName("\u54c1\u724c");
                brandQP.setFilterValues(brandValues);
                resultParams.add(brandQP);
            }
            if ((supplierObject = aggsObj.getJSONObject("group_by_supplier_name")) != null && !supplierObject.isEmpty()) {
                List<String> supplierValues = this.getNameList(supplierObject);
                UccMallQueryParam supplierQP = new UccMallQueryParam();
                supplierQP.setFilterId("supplier_id_name");
                supplierQP.setFilterName("\u5546\u6237");
                supplierQP.setFilterValues(supplierValues);
                resultParams.add(supplierQP);
            }
            if ((vendorObject = aggsObj.getJSONObject("group_by_vendor_name")) != null && !vendorObject.isEmpty()) {
                List<String> vendorValues = this.getNameList(vendorObject);
                UccMallQueryParam vendorQP = new UccMallQueryParam();
                vendorQP.setFilterId("vendor_id_name");
                vendorQP.setFilterName("\u4f9b\u5e94\u5546");
                vendorQP.setFilterValues(vendorValues);
                resultParams.add(vendorQP);
            }
        }
        rspBo.setUccMallQueryParams(resultParams);
        return rspBo;
    }

    private List<String> getNameList(JSONObject object) {
        ArrayList<String> nameList = new ArrayList<String>();
        JSONArray bucketObject = object.getJSONArray("buckets");
        for (int i = 0; i < bucketObject.size(); ++i) {
            JSONObject jsonObject = bucketObject.getJSONObject(i);
            String name = jsonObject.getString("key");
            nameList.add(name);
        }
        return nameList;
    }
}

