/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.tydic.commodity.mall.ability.api.UccMallComparePriceAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallComparePriceReqBo;
import com.tydic.commodity.mall.ability.bo.UccMallComparePriceRspBo;
import com.tydic.commodity.mall.ability.bo.UccMallSearchBarEsRspInfo;
import com.tydic.commodity.mall.busi.api.UccMallCompareCommodityService;
import com.tydic.commodity.mall.busi.bo.UccMallCommodityRspBo;
import com.tydic.commodity.mall.busi.bo.UccMallCompareEsReqBo;
import com.tydic.commodity.mall.busi.bo.UccMallCompareEsRspBo;
import com.tydic.commodity.mall.utils.UccMallMoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallComparePriceAbilityService"})
public class UccMallComparePriceAbilityServiceImpl
implements UccMallComparePriceAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallComparePriceAbilityServiceImpl.class);
    @Autowired
    private UccMallCompareCommodityService uccMallCompareCommodityService;

    @PostMapping(value={"compare"})
    public UccMallComparePriceRspBo compare(@RequestBody UccMallComparePriceReqBo reqBo) {
        UccMallComparePriceRspBo rspBo = new UccMallComparePriceRspBo();
        if (StringUtils.isEmpty((CharSequence)reqBo.getUpc()) && StringUtils.isEmpty((CharSequence)reqBo.getMfgsku())) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u65e0\u6bd4\u4ef7\u5173\u952e\u4fe1\u606f");
            rspBo.setResult(new ArrayList());
            return rspBo;
        }
        UccMallCompareEsReqBo uccMallCompareEsReqBo = new UccMallCompareEsReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)uccMallCompareEsReqBo);
        UccMallCompareEsRspBo uccMallCompareEsRspBo = this.uccMallCompareCommodityService.compare(uccMallCompareEsReqBo);
        if (!"0000".equals(uccMallCompareEsRspBo.getRespCode())) {
            BeanUtils.copyProperties((Object)((Object)uccMallCompareEsRspBo), (Object)reqBo);
            return rspBo;
        }
        List<UccMallCommodityRspBo> uccMallCommodityRspBos = uccMallCompareEsRspBo.getUccMallCommodityRspBos();
        List<UccMallSearchBarEsRspInfo> result = this.convertRspBo(uccMallCommodityRspBos);
        HashMap<Long, Integer> filter = new HashMap<Long, Integer>();
        int i = 0;
        if (!result.isEmpty()) {
            for (UccMallSearchBarEsRspInfo each : result) {
                if (filter.containsKey(each.getSupplierShopId())) {
                    if (result.get((Integer)filter.get(each.getSupplierShopId())).getSalePrice().compareTo(each.getSalePrice()) > 0) {
                        filter.put(each.getSupplierShopId(), i);
                    }
                } else {
                    filter.put(each.getSupplierShopId(), i);
                }
                ++i;
            }
            ArrayList<UccMallSearchBarEsRspInfo> supplierShopPrice = new ArrayList<UccMallSearchBarEsRspInfo>();
            for (Long each : filter.keySet()) {
                supplierShopPrice.add(result.get((Integer)filter.get(each)));
            }
            result.clear();
            result.addAll(supplierShopPrice);
        }
        rspBo.setResult(result);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private List<UccMallSearchBarEsRspInfo> convertRspBo(List<UccMallCommodityRspBo> uccMallCommodityRspBos) {
        ArrayList<UccMallSearchBarEsRspInfo> uccMallSearchBarEsRspInfos = new ArrayList<UccMallSearchBarEsRspInfo>();
        if (uccMallCommodityRspBos != null && uccMallCommodityRspBos.size() > 0) {
            for (UccMallCommodityRspBo uccMallCommodityRspBo : uccMallCommodityRspBos) {
                UccMallSearchBarEsRspInfo uccMallSearchBarEsRspInfo = new UccMallSearchBarEsRspInfo();
                uccMallSearchBarEsRspInfo.setCommodityId(Long.valueOf(uccMallCommodityRspBo.getCommodity_id()));
                uccMallSearchBarEsRspInfo.setSkuId(Long.valueOf(uccMallCommodityRspBo.getSku_id()));
                uccMallSearchBarEsRspInfo.setExtSkuId(uccMallCommodityRspBo.getExt_sku_id());
                uccMallSearchBarEsRspInfo.setPriPicUrl(uccMallCommodityRspBo.getPicture_url());
                uccMallSearchBarEsRspInfo.setMarketPrice(UccMallMoneyUtils.haoToYuan(new BigDecimal(uccMallCommodityRspBo.getMarket_price())));
                uccMallSearchBarEsRspInfo.setSalePrice(UccMallMoneyUtils.haoToYuan(new BigDecimal(uccMallCommodityRspBo.getSale_price())));
                uccMallSearchBarEsRspInfo.setMemberPrice1(UccMallMoneyUtils.haoToYuan(new BigDecimal(uccMallCommodityRspBo.getMember_price1())));
                uccMallSearchBarEsRspInfo.setMemberPrice2(UccMallMoneyUtils.haoToYuan(new BigDecimal(uccMallCommodityRspBo.getMember_price2())));
                uccMallSearchBarEsRspInfo.setMemberPrice3(UccMallMoneyUtils.haoToYuan(new BigDecimal(uccMallCommodityRspBo.getMember_price3())));
                uccMallSearchBarEsRspInfo.setMemberPrice4(UccMallMoneyUtils.haoToYuan(new BigDecimal(uccMallCommodityRspBo.getMember_price4())));
                uccMallSearchBarEsRspInfo.setMemberPrice5(UccMallMoneyUtils.haoToYuan(new BigDecimal(uccMallCommodityRspBo.getMember_price5())));
                uccMallSearchBarEsRspInfo.setSkuName(uccMallCommodityRspBo.getSku_name());
                uccMallSearchBarEsRspInfo.setSupplierShopId(uccMallCommodityRspBo.getSupplier_shop_id());
                uccMallSearchBarEsRspInfo.setSupplierShopName(uccMallCommodityRspBo.getShop_name());
                uccMallSearchBarEsRspInfo.setSupplierId(String.valueOf(uccMallCommodityRspBo.getSupplier_id()));
                uccMallSearchBarEsRspInfo.setSupplierName(uccMallCommodityRspBo.getSupplier_name());
                uccMallSearchBarEsRspInfo.setSkuSource(Integer.valueOf(uccMallCommodityRspBo.getSku_source()));
                uccMallSearchBarEsRspInfos.add(uccMallSearchBarEsRspInfo);
            }
        }
        return uccMallSearchBarEsRspInfos;
    }
}

