/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.atom.api.InterfaceCommdDetailsQryService;
import com.tydic.commodity.mall.atom.bo.InterfaceCommdDetailsQryReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceCommdDetailsQryRspBO;
import com.tydic.commodity.mall.atom.bo.InterfaceESupermarketCommdBO;
import com.tydic.commodity.mall.atom.bo.InterfaceJdBookBO;
import com.tydic.commodity.mall.atom.bo.InterfaceJdCommdBO;
import com.tydic.commodity.mall.atom.bo.InterfaceJdVedioBO;
import com.tydic.commodity.mall.atom.bo.InterfaceNotJdCommdDetailsBO;
import com.tydic.commodity.mall.atom.bo.InterfaceParam_entity;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.utils.UccMallESBParamUtil;
import com.tydic.commodity.mall.utils.UccMallHSHttpHelper;
import com.tydic.commodity.mall.utils.UccMallHSNHttpHeader;
import com.tydic.commodity.mall.utils.UccMallHttpRetBean;
import com.tydic.commodity.mall.utils.UccMallPropertiesUtil;
import com.tydic.dyc.resource.parse.api.ReStaticResourceParseService;
import com.tydic.dyc.resource.parse.bo.ReStaticResourceParseReqBO;
import com.tydic.dyc.resource.parse.bo.ReStaticResourceParseRspBO;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="uccCommdDetailsQryService")
public class InterfaceCommdDetailsQryServiceImpl
implements InterfaceCommdDetailsQryService {
    private static final Logger log = LoggerFactory.getLogger(InterfaceCommdDetailsQryServiceImpl.class);
    @Value(value="${jd_imgPath}")
    private String jd_imgPath;
    @Value(value="${grainger_imgPath}")
    private String grainger_imgPath;
    @Autowired
    private ReStaticResourceParseService reStaticResourceParseService;
    @Value(value="${ucc.sku.replace.url.enable:true}")
    private boolean replaceUrlEnable;

    @Override
    public InterfaceCommdDetailsQryRspBO qryCommdDetails(InterfaceCommdDetailsQryReqBO reqBO) {
        try {
            String reqStr = this.initReqStr(reqBO);
            String hsn = reqBO.getSupplierCode();
            String reqEsbStr = UccMallESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            UccMallHttpRetBean uccMallHttpRetBean = UccMallHSHttpHelper.doUrlPostRequest(new URI(UccMallPropertiesUtil.getProperty("ESB_QRY_SKU_DETAIL_URL")), UccMallHSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes("UTF-8"), "UTF-8", false);
            if (uccMallHttpRetBean.getStatus() != 200) {
                log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + uccMallHttpRetBean.getStatus() + "], [http_url=" + UccMallPropertiesUtil.getProperty("ESB_QRY_SKU_DETAIL_URL") + "]");
                InterfaceCommdDetailsQryRspBO resolveRsp = new InterfaceCommdDetailsQryRspBO();
                resolveRsp.setResultCode(UccMallConstantsEnums.HTTP_OUT_FAIL.code());
                resolveRsp.setResultMessage(UccMallConstantsEnums.HTTP_OUT_FAIL.code() + uccMallHttpRetBean.getStatus());
                return resolveRsp;
            }
            log.info("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + uccMallHttpRetBean.getStr());
            String returnString = uccMallHttpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                InterfaceCommdDetailsQryRspBO resolveRsp = new InterfaceCommdDetailsQryRspBO();
                resolveRsp.setResultCode(UccMallConstantsEnums.OUT_MESSAGE_QUERY_NULL_FAILED.code());
                resolveRsp.setResultMessage("\u67e5\u8be2\u7535\u5546\u5916\u90e8\u63a5\u53e3-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                return resolveRsp;
            }
            InterfaceCommdDetailsQryRspBO resolveRsp = this.resolveRsp(returnString, reqBO);
            if (resolveRsp != null) {
                log.info("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u89e3\u6790\u54cd\u5e94\u6570\u636e\uff1a" + resolveRsp.toString());
            }
            this.statisUrlReplace(reqBO, resolveRsp);
            return resolveRsp;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
    }

    private void statisUrlReplace(InterfaceCommdDetailsQryReqBO reqBO, InterfaceCommdDetailsQryRspBO resolveRsp) {
        if (!this.replaceUrlEnable) {
            return;
        }
        ReStaticResourceParseReqBO reStaticResourceParseReqBO = new ReStaticResourceParseReqBO();
        if (!"jd".equals(reqBO.getSupplierCode()) && !"jdvop".equals(reqBO.getSupplierCode())) {
            reStaticResourceParseReqBO.setStaticResourceHtml(resolveRsp.getResult().getNotJdCommdDetails().getIntroduction());
            reStaticResourceParseReqBO.setStaticResourceUrl(resolveRsp.getResult().getNotJdCommdDetails().getImagePath());
        } else {
            reStaticResourceParseReqBO.setStaticResourceHtml(resolveRsp.getResult().getJdCommdInfo().getIntroduction());
            reStaticResourceParseReqBO.setStaticResourceUrl(resolveRsp.getResult().getJdCommdInfo().getImagePath());
        }
        ReStaticResourceParseRspBO reStaticResourceParseRspBO = this.reStaticResourceParseService.parseStaticResource(reStaticResourceParseReqBO);
        if (!"jd".equals(reqBO.getSupplierCode()) && !"jdvop".equals(reqBO.getSupplierCode())) {
            resolveRsp.getResult().getNotJdCommdDetails().setIntroduction(reStaticResourceParseRspBO.getNewStaticResourceHtml());
            resolveRsp.getResult().getNotJdCommdDetails().getSkuGroup().get(0).setIntroduction(reStaticResourceParseRspBO.getNewStaticResourceHtml());
            resolveRsp.getResult().getNotJdCommdDetails().setImagePath(reStaticResourceParseRspBO.getNewStaticResourceUrl());
        } else {
            resolveRsp.getResult().getJdCommdInfo().setIntroduction(reStaticResourceParseRspBO.getNewStaticResourceHtml());
            resolveRsp.getResult().getJdCommdInfo().setImagePath(reStaticResourceParseRspBO.getNewStaticResourceUrl());
        }
    }

    private String initReqStr(InterfaceCommdDetailsQryReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        if (!"jd".equals(reqBO.getSupplierCode()) && !"jdvop".equals(reqBO.getSupplierCode())) {
            if (!CollectionUtils.isEmpty(reqBO.getSkuIds())) {
                jsonObject.put("sku", reqBO.getSkuIds());
            } else {
                jsonObject.put("spu", (Object)reqBO.getSpuId());
            }
            jsonObject.put("hsn", (Object)reqBO.getSupplierCode());
            jsonObject.put("isShow", (Object)false);
        } else {
            jsonObject.put("sku", reqBO.getSkuIds());
            jsonObject.put("hsn", (Object)reqBO.getSupplierCode());
            jsonObject.put("queryExts", (Object)"appintroduce,shouhou,isFactoryShip,isEnergySaving,contractSkuExt,ChinaCatalog,LowestBuy,isJDLogistics,isSelf,taxInfo,taxCode,seoModel");
        }
        return jsonObject.toString();
    }

    private InterfaceCommdDetailsQryRspBO resolveRsp(String returnString, InterfaceCommdDetailsQryReqBO reqBO) {
        InterfaceCommdDetailsQryRspBO rspBO = new InterfaceCommdDetailsQryRspBO();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            rspBO.setSuccess((Boolean)rspJsonObject.get((Object)"success"));
            rspBO.setResultCode((String)rspJsonObject.get((Object)"resultCode"));
            rspBO.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
            String respCode = (String)rspJsonObject.get((Object)"resultCode");
            if (!"0000".equals(respCode)) {
                if ("2007".equals(respCode)) {
                    rspBO.setResultMessage("token\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5237\u65b0\u6216\u8005\u83b7\u53d6token");
                    rspBO.setResultCode(UccMallConstantsEnums.TOKEN_EXPIRE_FAIL.code());
                    return rspBO;
                }
                return rspBO;
            }
            InterfaceESupermarketCommdBO eSupermarketCommdBO = new InterfaceESupermarketCommdBO();
            if ("jd".equals(reqBO.getSupplierCode()) || "jdvop".equals(reqBO.getSupplierCode())) {
                JSONObject result = (JSONObject)rspJsonObject.get((Object)"result");
                if (result != null) {
                    String skuType = (String)result.get((Object)"skuType");
                    String str = JSONObject.toJSONString((Object)result);
                    if (null == skuType) {
                        InterfaceJdCommdBO jdCommdBO = (InterfaceJdCommdBO)JSONObject.parseObject((String)str, InterfaceJdCommdBO.class);
                        JSONArray category = result.getJSONArray("category");
                        ArrayList<String> categorys = new ArrayList<String>();
                        if (category != null && category.size() > 0) {
                            for (int i = 0; i < category.size(); ++i) {
                                categorys.add((String)category.get(i));
                            }
                        }
                        jdCommdBO.setCategory(categorys);
                        String imgPath = (String)result.get((Object)"imagePath");
                        imgPath = this.jd_imgPath + imgPath;
                        jdCommdBO.setImagePath(imgPath);
                        if (result.get((Object)"LowestBuy") != null) {
                            jdCommdBO.setMoq(String.valueOf(result.get((Object)"LowestBuy")));
                        }
                        if (result.get((Object)"seoModel") != null) {
                            jdCommdBO.setModel(String.valueOf(result.get((Object)"seoModel")));
                        }
                        eSupermarketCommdBO.setJdCommdInfo(jdCommdBO);
                    } else if ("book".equals(skuType)) {
                        InterfaceJdBookBO jdBookBO = (InterfaceJdBookBO)JSONObject.parseObject((String)str, InterfaceJdBookBO.class);
                        String img = jdBookBO.getImage();
                        img = this.jd_imgPath + img;
                        jdBookBO.setImage(img);
                        if (result.get((Object)"LowestBuy") != null) {
                            jdBookBO.setMoq(String.valueOf(result.get((Object)"LowestBuy")));
                        }
                        if (result.get((Object)"seoModel") != null) {
                            jdBookBO.setModel(String.valueOf(result.get((Object)"seoModel")));
                        }
                        eSupermarketCommdBO.setJdBookInfo(jdBookBO);
                    } else if ("vedio".equals(skuType)) {
                        InterfaceJdVedioBO jdVedioBO = (InterfaceJdVedioBO)JSONObject.parseObject((String)str, InterfaceJdVedioBO.class);
                        String img = jdVedioBO.getImage();
                        img = img + this.jd_imgPath;
                        jdVedioBO.setImage(img);
                        if (result.get((Object)"LowestBuy") != null) {
                            jdVedioBO.setMoq(String.valueOf(result.get((Object)"LowestBuy")));
                        }
                        if (result.get((Object)"seoModel") != null) {
                            jdVedioBO.setModel(String.valueOf(result.get((Object)"seoModel")));
                        }
                        eSupermarketCommdBO.setJdVedioInfo(jdVedioBO);
                    }
                }
            } else {
                String result = JSONObject.toJSONString((Object)rspJsonObject.get((Object)"result"));
                InterfaceNotJdCommdDetailsBO notJdCommdDetailsBO = (InterfaceNotJdCommdDetailsBO)JSONObject.parseObject((String)result, InterfaceNotJdCommdDetailsBO.class);
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                String category = JSONObject.toJSONString((Object)jsonObject.get((Object)"category"));
                List categoryList = JSONObject.parseArray((String)category, String.class);
                notJdCommdDetailsBO.setCategory(categoryList);
                String spuParam = JSONObject.toJSONString((Object)jsonObject.get((Object)"param"));
                List param_entities = JSONObject.parseArray((String)spuParam, InterfaceParam_entity.class);
                notJdCommdDetailsBO.setParam(param_entities);
                String imgPath = notJdCommdDetailsBO.getSkuGroup().get(0).getImagePath();
                if ("grainger".equals(reqBO.getSupplierCode())) {
                    imgPath = this.grainger_imgPath + imgPath;
                }
                notJdCommdDetailsBO.setImagePath(imgPath);
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)notJdCommdDetailsBO.getIntroduction())) {
                    notJdCommdDetailsBO.setIntroduction(notJdCommdDetailsBO.getSkuGroup().get(0).getIntroduction());
                }
                eSupermarketCommdBO.setNotJdCommdDetails(notJdCommdDetailsBO);
            }
            rspBO.setResult(eSupermarketCommdBO);
            return rspBO;
        }
        catch (Exception var10) {
            log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
            rspBO.setResultMessage("\u67e5\u8be2\u7535\u5546\u5916\u90e8\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519");
            rspBO.setResultCode(UccMallConstantsEnums.OUT_MESSAGE_QUERY_RESOLVE_FAILED.code());
            return rspBO;
        }
    }
}

