/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.atom.api.InterfaceDeliveryTimeQryService;
import com.tydic.commodity.mall.atom.bo.InterfaceDeliveryTimeQueryReqBo;
import com.tydic.commodity.mall.atom.bo.InterfaceDeliveryTimeQueryRspBo;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.utils.UccMallESBParamUtil;
import com.tydic.commodity.mall.utils.UccMallHSHttpHelper;
import com.tydic.commodity.mall.utils.UccMallHSNHttpHeader;
import com.tydic.commodity.mall.utils.UccMallHttpRetBean;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class InterfaceDeliveryTimeQueryServiceImpl
implements InterfaceDeliveryTimeQryService {
    private static final Logger log = LoggerFactory.getLogger(InterfaceDeliveryTimeQueryServiceImpl.class);

    @Override
    public InterfaceDeliveryTimeQueryRspBo getPromiseTips(InterfaceDeliveryTimeQueryReqBo reqBo) {
        UccMallHttpRetBean uccMallHttpRetBean;
        String reqEsbStr;
        InterfaceDeliveryTimeQueryRspBo rspBo = new InterfaceDeliveryTimeQueryRspBo();
        String reqJson = this.initReqStr(reqBo);
        try {
            reqEsbStr = UccMallESBParamUtil.getEsbReqStr(reqJson, reqBo.getSupplierCode(), "BUSINESS_COMMODITY");
            log.info("\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u5165\u53c2\uff1a" + reqEsbStr);
            uccMallHttpRetBean = UccMallHSHttpHelper.doUrlPostRequest(new URI(reqBo.getUrl()), UccMallHSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes("UTF-8"), "UTF-8", false);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
        if (uccMallHttpRetBean.getStatus() != 200) {
            log.error("\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u5931\u8d25\uff1a" + reqEsbStr);
            throw new RuntimeException("\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u5931\u8d25");
        }
        log.info("\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + uccMallHttpRetBean.getStr());
        String returnString = uccMallHttpRetBean.getStr();
        if (StringUtils.isEmpty((CharSequence)returnString)) {
            throw new RuntimeException("\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        rspBo = this.resolveRsp(returnString, reqBo);
        if (!rspBo.isSuccess()) {
            throw new BusinessException(rspBo.getResultCode(), rspBo.getResultMessage());
        }
        return rspBo;
    }

    private String initReqStr(InterfaceDeliveryTimeQueryReqBo reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("skuId", (Object)reqBO.getSkuId());
        jsonObject.put("num", (Object)reqBO.getNum());
        jsonObject.put("province", (Object)reqBO.getProvince());
        jsonObject.put("city", (Object)reqBO.getCity());
        jsonObject.put("county", (Object)reqBO.getCounty());
        jsonObject.put("town", (Object)reqBO.getTown());
        return jsonObject.toString();
    }

    private InterfaceDeliveryTimeQueryRspBo resolveRsp(String returnString, InterfaceDeliveryTimeQueryReqBo reqBO) {
        InterfaceDeliveryTimeQueryRspBo rspBo = new InterfaceDeliveryTimeQueryRspBo();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            if (rspJsonObject.get((Object)"success") instanceof String) {
                rspBo.setSuccess("true".equals(rspJsonObject.get((Object)"success")));
            } else {
                rspBo.setSuccess((Boolean)rspJsonObject.get((Object)"success"));
            }
            rspBo.setResultCode(String.valueOf(rspJsonObject.get((Object)"resultCode")));
            rspBo.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
            if ("jd".equals(reqBO.getSupplierCode())) {
                rspBo.setResult(rspJsonObject.getString("result"));
            } else {
                JSONObject result = rspJsonObject.getJSONObject("result");
                if ("jdvop".equals(reqBO.getSupplierCode())) {
                    rspBo.setResult(result.getString("promiseTips"));
                } else {
                    rspBo.setResult(result.getString("tips"));
                }
            }
            return rspBo;
        }
        catch (Exception var10) {
            log.error("\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
            throw new RuntimeException("\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
        }
    }
}

