/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.JsonUtils;
import com.tydic.commodity.mall.atom.api.InterfaceCommdDetailsQryService;
import com.tydic.commodity.mall.atom.api.InterfaceQryGiftFromEcommerceService;
import com.tydic.commodity.mall.atom.bo.InterfaceCommdDetailsQryReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceCommdDetailsQryRspBO;
import com.tydic.commodity.mall.atom.bo.InterfaceGiftRspVO;
import com.tydic.commodity.mall.atom.bo.InterfaceQryGiftFromEcommerceReqBo;
import com.tydic.commodity.mall.atom.bo.InterfaceQryGiftFromEcommerceRspBo;
import com.tydic.commodity.mall.utils.UccMallESBParamUtil;
import com.tydic.commodity.mall.utils.UccMallHSHttpHelper;
import com.tydic.commodity.mall.utils.UccMallHSNHttpHeader;
import com.tydic.commodity.mall.utils.UccMallHttpRetBean;
import com.tydic.commodity.mall.utils.UccMallPropertiesUtil;
import java.net.URI;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="uccQryGiftFromEcommerceService")
public class InterfaceQryGiftFromEcommerceServiceImpl
implements InterfaceQryGiftFromEcommerceService {
    private static final Logger log = LoggerFactory.getLogger(InterfaceQryGiftFromEcommerceServiceImpl.class);
    @Autowired
    private InterfaceCommdDetailsQryService interfaceCommdDetailsQryService;

    @Override
    public InterfaceQryGiftFromEcommerceRspBo qryGift(InterfaceQryGiftFromEcommerceReqBo reqBo) {
        InterfaceQryGiftFromEcommerceRspBo busiQrySKUGiftRspBO = new InterfaceQryGiftFromEcommerceRspBo();
        try {
            String reqStr = this.initReqStr(reqBo);
            String hsn = reqBo.getSupplierCode();
            String reqEsbStr = UccMallESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            UccMallHttpRetBean uccMallHttpRetBean = UccMallHSHttpHelper.doUrlPostRequest(new URI(UccMallPropertiesUtil.getProperty("ESB_QRY_SKU_GIFT_URL")), UccMallHSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes("UTF-8"), "UTF-8", false);
            if (uccMallHttpRetBean.getStatus() != 200) {
                log.error("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u8d60\u54c1\u4fe1\u606f\u5931\u8d25[http_status=" + uccMallHttpRetBean.getStatus() + "], [http_url=" + UccMallPropertiesUtil.getProperty("ESB_QRY_SKU_GIFT_URL") + "]");
                busiQrySKUGiftRspBO.setRespCode("8888");
                busiQrySKUGiftRspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u8d60\u54c1\u4fe1\u606f\u5931\u8d25");
                return busiQrySKUGiftRspBO;
            }
            String returnString = uccMallHttpRetBean.getStr();
            log.debug("\u83b7\u53d6\u8d60\u54c1\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u8d60\u54c1\u4fe1\u606f\u54cd\u5e94\u62a5\u6587\uff1a" + returnString);
            if (StringUtils.isEmpty((Object)returnString)) {
                busiQrySKUGiftRspBO.setRespCode("8888");
                busiQrySKUGiftRspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u8d60\u54c1\u4fe1\u606f\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
                return busiQrySKUGiftRspBO;
            }
            busiQrySKUGiftRspBO = this.resolveRspMsg(reqBo, returnString);
            List<InterfaceGiftRspVO> giftList = busiQrySKUGiftRspBO.getGifts();
            if (giftList != null && giftList.size() > 0) {
                for (InterfaceGiftRspVO giftRspVO : giftList) {
                    InterfaceCommdDetailsQryRspBO busiQrySKURspBO = this.qrySKUInfo(reqBo, giftRspVO);
                    if (busiQrySKURspBO == null || !busiQrySKURspBO.isSuccess()) continue;
                    if (busiQrySKURspBO.getResult().getJdBookInfo() != null) {
                        giftRspVO.setSkuName(busiQrySKURspBO.getResult().getJdBookInfo().getName());
                    }
                    if (busiQrySKURspBO.getResult().getJdCommdInfo() != null) {
                        giftRspVO.setSkuName(busiQrySKURspBO.getResult().getJdCommdInfo().getName());
                    }
                    if (busiQrySKURspBO.getResult().getJdVedioInfo() != null) {
                        giftRspVO.setSkuName(busiQrySKURspBO.getResult().getJdVedioInfo().getName());
                    }
                    if (busiQrySKURspBO.getResult().getNotJdCommdDetails() == null) continue;
                    giftRspVO.setSkuName(busiQrySKURspBO.getResult().getNotJdCommdDetails().getName());
                }
            }
            busiQrySKUGiftRspBO.setRespCode("0000");
            busiQrySKUGiftRspBO.setRespDesc("\u6210\u529f");
            return busiQrySKUGiftRspBO;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8d60\u54c1\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + e);
            busiQrySKUGiftRspBO.setRespCode("8888");
            busiQrySKUGiftRspBO.setRespDesc("\u83b7\u53d6\u8d60\u54c1\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
            return busiQrySKUGiftRspBO;
        }
    }

    private InterfaceCommdDetailsQryRspBO qrySKUInfo(InterfaceQryGiftFromEcommerceReqBo busiQrySKUGiftReqBO, InterfaceGiftRspVO giftRspVO) {
        InterfaceCommdDetailsQryReqBO busiQrySKUReqBO = new InterfaceCommdDetailsQryReqBO();
        busiQrySKUReqBO.setSkuId(giftRspVO.getSkuId().toString());
        busiQrySKUReqBO.setSupplierCode(busiQrySKUGiftReqBO.getSupplierCode());
        busiQrySKUReqBO.setShow(false);
        InterfaceCommdDetailsQryRspBO uccCommdDetailsQryRspBO = this.interfaceCommdDetailsQryService.qryCommdDetails(busiQrySKUReqBO);
        return uccCommdDetailsQryRspBO;
    }

    private String initReqStr(InterfaceQryGiftFromEcommerceReqBo busiQrySKUGiftReqBO) {
        StringBuffer sb = new StringBuffer();
        sb.append("{").append("\"skuId\":").append('\"' + busiQrySKUGiftReqBO.getSkuId() + '\"').append(",").append("\"province\":").append(busiQrySKUGiftReqBO.getProvince()).append(",").append("\"city\":").append(busiQrySKUGiftReqBO.getCity()).append(",").append("\"county\":").append(busiQrySKUGiftReqBO.getCounty()).append(",").append("\"town\":").append(busiQrySKUGiftReqBO.getTown()).append("}");
        return sb.toString();
    }

    private InterfaceQryGiftFromEcommerceRspBo resolveRspMsg(InterfaceQryGiftFromEcommerceReqBo QryGiftFromEcommerceReqBo, String rspStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)rspStr);
        InterfaceQryGiftFromEcommerceRspBo busiQrySKUGiftRspBO = new InterfaceQryGiftFromEcommerceRspBo();
        if ("0010".equals(jsonObject.get((Object)"resultCode"))) {
            busiQrySKUGiftRspBO.setRespCode("0000");
            busiQrySKUGiftRspBO.setRespDesc("\u8be5\u5546\u54c1\u65e0\u8d60\u54c1\u4fe1\u606f");
            return busiQrySKUGiftRspBO;
        }
        String resultStr = JSONObject.toJSONString((Object)jsonObject.get((Object)"result"));
        if (((Boolean)jsonObject.get((Object)"success")).booleanValue()) {
            if (!StringUtils.isEmpty((Object)resultStr) && !"null".equals(resultStr)) {
                try {
                    busiQrySKUGiftRspBO = (InterfaceQryGiftFromEcommerceRspBo)((Object)JsonUtils.jsonStringToJavaBean((String)JSONObject.toJSONString((Object)jsonObject.get((Object)"result")), InterfaceQryGiftFromEcommerceRspBo.class));
                    busiQrySKUGiftRspBO.setRespCode("0000");
                    busiQrySKUGiftRspBO.setRespDesc("\u6210\u529f");
                    return busiQrySKUGiftRspBO;
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6\u8d60\u54c1\u4e1a\u52a1\u670d\u52a1\u89e3\u6790\u54cd\u5e94\u6570\u636e\u5931\u8d25" + e);
                    busiQrySKUGiftRspBO.setRespCode("8888");
                    busiQrySKUGiftRspBO.setRespDesc("\u89e3\u6790\u54cd\u5e94\u6570\u636e\u5931\u8d25");
                    return busiQrySKUGiftRspBO;
                }
            }
            busiQrySKUGiftRspBO.setRespCode("0000");
            busiQrySKUGiftRspBO.setRespDesc("\u8be5\u5546\u54c1\u65e0\u8d60\u54c1\u4fe1\u606f");
            return busiQrySKUGiftRspBO;
        }
        log.error("\u83b7\u53d6\u8d60\u54c1\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u8d60\u54c1\u4fe1\u606f\u5931\u8d25:" + jsonObject.get((Object)"resultMessage"));
        busiQrySKUGiftRspBO.setRespCode("0000");
        busiQrySKUGiftRspBO.setRespDesc("\u8be5\u5546\u54c1\u65e0\u8d60\u54c1\u4fe1\u606f");
        return busiQrySKUGiftRspBO;
    }
}

