/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.JsonUtils;
import com.tydic.commodity.mall.atom.api.InterfaceYanbaoFromInterService;
import com.tydic.commodity.mall.atom.bo.InterfaceQrySKUYanbaoReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceQrySKUYanbaoRspBO;
import com.tydic.commodity.mall.atom.bo.InterfaceQrySKUYanbaoRspVO;
import com.tydic.commodity.mall.atom.bo.InterfaceSKUYanbaoRspVO;
import com.tydic.commodity.mall.atom.bo.InterfaceYanBaoDeatilRspVO;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.utils.UccMallESBParamUtil;
import com.tydic.commodity.mall.utils.UccMallHSHttpHelper;
import com.tydic.commodity.mall.utils.UccMallHSNHttpHeader;
import com.tydic.commodity.mall.utils.UccMallHttpRetBean;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="qrySKUYanbaoFromInterService")
public class InterfaceYanbaoFromInterServiceImpl
implements InterfaceYanbaoFromInterService {
    private static final Logger logger = LoggerFactory.getLogger(InterfaceYanbaoFromInterServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();

    @Override
    public InterfaceQrySKUYanbaoRspBO qrySKUYanbao(InterfaceQrySKUYanbaoReqBO busiQrySKUYanbaoReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u670d\u52a1\u5165\u53c2\uff1a" + busiQrySKUYanbaoReqBO.toString());
        }
        InterfaceQrySKUYanbaoRspBO busiQrySKUYanbaoRspBO = new InterfaceQrySKUYanbaoRspBO();
        if (busiQrySKUYanbaoReqBO.getSkuIds().size() > 50) {
            throw new BusinessException("8888", "\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u670d\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u6700\u591a\u652f\u630150\u79cd\u5546\u54c1");
        }
        try {
            String reqStr = this.initReqStr(busiQrySKUYanbaoReqBO);
            String hsn = busiQrySKUYanbaoReqBO.getSupplierCode();
            String reqEsbStr = UccMallESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            UccMallHttpRetBean uccMallHttpRetBean = UccMallHSHttpHelper.doUrlPostRequest(new URI(busiQrySKUYanbaoReqBO.getUrl()), UccMallHSNHttpHeader.getRequestHeaders("json"), reqEsbStr.toString().getBytes("UTF-8"), "UTF-8", false);
            if (uccMallHttpRetBean.getStatus() != 200) {
                logger.error("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u7cfb\u7edf\u5931\u8d25[http_status=" + uccMallHttpRetBean.getStatus() + "], [http_url=" + busiQrySKUYanbaoReqBO.getUrl() + "]");
                busiQrySKUYanbaoRspBO.setRespCode(null);
                busiQrySKUYanbaoRspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u7cfb\u7edf\u5931\u8d25");
                return busiQrySKUYanbaoRspBO;
            }
            String returnString = uccMallHttpRetBean.getStr();
            if (this.isDebugEnabled) {
                logger.debug("\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u670d\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u54cd\u5e94\u62a5\u6587\uff1a" + returnString);
            }
            if (StringUtils.isEmpty((Object)returnString)) {
                busiQrySKUYanbaoRspBO.setRespCode("8888");
                busiQrySKUYanbaoRspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
                return busiQrySKUYanbaoRspBO;
            }
            busiQrySKUYanbaoRspBO = this.resolveRspMsg(returnString, busiQrySKUYanbaoReqBO.getSupplierId());
            busiQrySKUYanbaoRspBO.setRespCode("0000");
            busiQrySKUYanbaoRspBO.setRespDesc("\u6210\u529f");
            return busiQrySKUYanbaoRspBO;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u670d\u52a1\u5931\u8d25" + e);
            busiQrySKUYanbaoRspBO.setRespCode("8888");
            busiQrySKUYanbaoRspBO.setRespDesc("\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u670d\u52a1\u5931\u8d25");
            return busiQrySKUYanbaoRspBO;
        }
    }

    private String initReqStr(InterfaceQrySKUYanbaoReqBO busiQrySKUYanbaoReqBO) {
        ArrayList<String> reqSkuIds = new ArrayList<String>();
        for (Long skuIds : busiQrySKUYanbaoReqBO.getSkuIds()) {
            reqSkuIds.add('\"' + skuIds.toString() + '\"');
        }
        StringBuffer sb = new StringBuffer();
        sb.append("{").append("\"skuIds\":").append(reqSkuIds).append(",").append("\"province\":").append(busiQrySKUYanbaoReqBO.getProvince()).append(",").append("\"city\":").append(busiQrySKUYanbaoReqBO.getCity()).append(",").append("\"county\":").append(busiQrySKUYanbaoReqBO.getCounty()).append(",").append("\"town\":").append(busiQrySKUYanbaoReqBO.getTown()).append("}");
        return sb.toString();
    }

    private InterfaceQrySKUYanbaoRspBO resolveRspMsg(String rspStr, Long supplierId) {
        JSONObject jsonObject = JSONObject.parseObject((String)rspStr);
        List resultList = (List)jsonObject.get((Object)"result");
        ArrayList<InterfaceQrySKUYanbaoRspVO> resultBusiQrySKUYanbaoRspVOs = new ArrayList<InterfaceQrySKUYanbaoRspVO>();
        InterfaceQrySKUYanbaoRspBO busiQrySKUYanbaoRspBO = new InterfaceQrySKUYanbaoRspBO();
        if (((Boolean)jsonObject.get((Object)"success")).booleanValue() && null != resultList) {
            if (!resultList.isEmpty()) {
                try {
                    InterfaceQrySKUYanbaoRspVO[] busiQrySKUYanbaoRspVOArr = (InterfaceQrySKUYanbaoRspVO[])JsonUtils.jsonStringToJavaBean((String)JSONObject.toJSONString((Object)jsonObject.get((Object)"result")), InterfaceQrySKUYanbaoRspVO[].class);
                    List<InterfaceQrySKUYanbaoRspVO> busiQrySKUYanbaoRspVOs = Arrays.asList(busiQrySKUYanbaoRspVOArr);
                    ArrayList<InterfaceQrySKUYanbaoRspVO> busiQrySKUYanbaoRsps = new ArrayList<InterfaceQrySKUYanbaoRspVO>();
                    for (InterfaceQrySKUYanbaoRspVO busiQrySKUYanbaoRspVO : busiQrySKUYanbaoRspVOs) {
                        InterfaceQrySKUYanbaoRspVO busiQrySKUYanbaoRsp = new InterfaceQrySKUYanbaoRspVO();
                        if (null != busiQrySKUYanbaoRspVO.getYanBao()) {
                            this.calcYanbaoPrice(busiQrySKUYanbaoRspVO.getYanBao(), supplierId);
                        }
                        busiQrySKUYanbaoRsp.setSkuId(busiQrySKUYanbaoRspVO.getSkuId());
                        busiQrySKUYanbaoRsp.setYanBao(busiQrySKUYanbaoRspVO.getYanBao());
                        busiQrySKUYanbaoRsps.add(busiQrySKUYanbaoRsp);
                    }
                    resultBusiQrySKUYanbaoRspVOs.addAll(busiQrySKUYanbaoRsps);
                    busiQrySKUYanbaoRspBO.setSkuYanbaos(resultBusiQrySKUYanbaoRspVOs);
                    return busiQrySKUYanbaoRspBO;
                }
                catch (Exception e) {
                    logger.error("\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u670d\u52a1\u89e3\u6790\u54cd\u5e94\u6570\u636e\u5931\u8d25" + e);
                    busiQrySKUYanbaoRspBO.setRespCode(null);
                    busiQrySKUYanbaoRspBO.setRespDesc("\u89e3\u6790\u54cd\u5e94\u6570\u636e\u5931\u8d25");
                    return busiQrySKUYanbaoRspBO;
                }
            }
            logger.info("\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u670d\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u6570\u636e\u4e3a\u7a7a");
            busiQrySKUYanbaoRspBO.setRespCode(null);
            busiQrySKUYanbaoRspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u5ef6\u4fdd\u4fe1\u606f\u6570\u636e\u4e3a\u7a7a");
            return busiQrySKUYanbaoRspBO;
        }
        return busiQrySKUYanbaoRspBO;
    }

    private void calcYanbaoPrice(List<InterfaceSKUYanbaoRspVO> yanBao, Long supplierId) {
        for (InterfaceSKUYanbaoRspVO sKUYanbaoRspVO : yanBao) {
            List<InterfaceYanBaoDeatilRspVO> yanBaoDeatilList = sKUYanbaoRspVO.getFuwuSkuDetailList();
            for (InterfaceYanBaoDeatilRspVO yanBaoDeatilRspVO : yanBaoDeatilList) {
                yanBaoDeatilRspVO.setSalePrice(yanBaoDeatilRspVO.getPrice());
                if (1L == supplierId) {
                    yanBaoDeatilRspVO.setPrice(yanBaoDeatilRspVO.getPrice().multiply(new BigDecimal(1.04)).setScale(2, 1));
                    continue;
                }
                yanBaoDeatilRspVO.setPrice(yanBaoDeatilRspVO.getPrice().multiply(new BigDecimal(1.04)).setScale(2, 1));
            }
        }
    }
}

