/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.mall.ability.api.UccMallAgrGoodListQueryAbilityService;
import com.tydic.commodity.mall.ability.api.UccMallReplacementPriceAbilityService;
import com.tydic.commodity.mall.ability.bo.ReplacePriceInfoBO;
import com.tydic.commodity.mall.ability.bo.UccMallAgrGoodListQueryAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallAgrGoodListQueryAbilityRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallCommodityPackBO;
import com.tydic.commodity.mall.ability.bo.UccMallCommodityRecordBO;
import com.tydic.commodity.mall.ability.bo.UccMallLadderPriceBo;
import com.tydic.commodity.mall.ability.bo.UccMallReplacementPriceReqBo;
import com.tydic.commodity.mall.ability.bo.UccMallReplacementPriceRspBo;
import com.tydic.commodity.mall.constants.ApprovalTypeEnum;
import com.tydic.commodity.mall.constants.AuditResultStatusEnum;
import com.tydic.commodity.mall.constants.SkuStatusEnum;
import com.tydic.commodity.mall.constants.UccMallConstants;
import com.tydic.commodity.mall.constants.YesNoEnum;
import com.tydic.commodity.mall.dao.UccMallBrandRelMapper;
import com.tydic.commodity.mall.dao.UccMallCatRCommdTypeMapper;
import com.tydic.commodity.mall.dao.UccMallCatalogDealMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityMeasureMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityPicMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityTypeMapper;
import com.tydic.commodity.mall.dao.UccMallExamineEditInfoMapper;
import com.tydic.commodity.mall.dao.UccMallLadderPriceMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.CommodityRecordPO;
import com.tydic.commodity.mall.po.CommodityRecordVO;
import com.tydic.commodity.mall.po.UccCatalogDealPO;
import com.tydic.commodity.mall.po.UccCommodityMeasurePo;
import com.tydic.commodity.mall.po.UccCommodityPicPo;
import com.tydic.commodity.mall.po.UccCommodityTypePo;
import com.tydic.commodity.mall.po.UccLadderPricePO;
import com.tydic.commodity.mall.po.UccMallBrandRelPO;
import com.tydic.commodity.mall.po.UccSkuPo;
import com.tydic.commodity.mall.utils.MoneyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallAgrGoodListQueryAbilityService"})
public class UccMallAgrGoodListQueryAbilityServiceImpl
implements UccMallAgrGoodListQueryAbilityService {
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccMallCommodityMapper uccMallCommodityMapper;
    @Autowired
    private UccMallCatalogDealMapper uccMallCatalogDealMapper;
    @Autowired
    private UccMallCatRCommdTypeMapper uccMallCatRCommdTypeMapper;
    @Autowired
    private UccMallExamineEditInfoMapper uccMallExamineEditInfoMapper;
    @Autowired
    private UccMallLadderPriceMapper uccMallLadderPriceMapper;
    @Autowired
    private UccMallCommodityTypeMapper uccMallCommodityTypeMapper;
    @Autowired
    private UccMallCommodityPicMapper uccMallCommodityPicMapper;
    @Autowired
    private UccMallCommodityMeasureMapper uccMallCommodityMeasureMapper;
    @Autowired
    private UccMallBrandRelMapper uccMallBrandRelMapper;
    @Autowired
    private UccMallReplacementPriceAbilityService uccMallReplacementPriceAbilityService;
    private static final String DateFormat = "yyyy-MM-dd HH:mm:ss";
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMallAgrGoodListQueryAbilityServiceImpl.class);

    @PostMapping(value={"getUccAgrGoodListQuery"})
    public UccMallAgrGoodListQueryAbilityRspBO getUccAgrGoodListQuery(@RequestBody UccMallAgrGoodListQueryAbilityReqBO reqBO) {
        List<Object> commodityRecordPOS;
        CommodityRecordVO commodityRecordVO;
        Page page;
        UccMallAgrGoodListQueryAbilityRspBO rspBO;
        block52: {
            rspBO = new UccMallAgrGoodListQueryAbilityRspBO();
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
            if (!StringUtils.isEmpty((Object)reqBO.getSkuCode())) {
                reqBO.setSkuId(Long.valueOf(Long.parseLong(reqBO.getSkuCode())));
            }
            page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
            if (reqBO.getSkuId() != null && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
                if (!reqBO.getSkuIds().contains(reqBO.getSkuId())) {
                    rspBO.setRows(new ArrayList());
                    rspBO.setPageNo(reqBO.getPageNo());
                    rspBO.setTotal(0);
                    rspBO.setRecordsTotal(0);
                    return rspBO;
                }
                reqBO.setSkuId(null);
            }
            if (null == (commodityRecordVO = this.dealReq(reqBO))) {
                rspBO.setRows(new ArrayList());
                rspBO.setPageNo(reqBO.getPageNo());
                rspBO.setTotal(0);
                rspBO.setRecordsTotal(0);
                return rspBO;
            }
            commodityRecordPOS = new ArrayList();
            if (!StringUtils.isEmpty((Object)reqBO.getUccOperCode())) {
                if ("uadCode".equals(reqBO.getUccOperCode())) {
                    commodityRecordVO.setExtField1(Lists.newArrayList((Object[])new String[]{"upCode", "downCode"}));
                } else {
                    commodityRecordVO.setExtField1(Lists.newArrayList((Object[])new String[]{reqBO.getUccOperCode()}));
                }
            }
            try {
                if (reqBO.getType() == 4) {
                    Boolean isPage = false;
                    if (!CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
                        commodityRecordPOS = this.uccMallSkuMapper.qryOtherCommdList(commodityRecordVO);
                    } else {
                        UccSkuPo skuPo = new UccSkuPo();
                        skuPo.setSkuId(reqBO.getSkuId());
                        List<UccSkuPo> mallsku = this.uccMallSkuMapper.qerySku(skuPo);
                        if (!org.apache.commons.collections.CollectionUtils.isEmpty(mallsku)) {
                            commodityRecordVO.setIgrAgreementSkuId(mallsku.get(0).getAgreementDetailsId());
                            if (UccMallConstants.OrderByColumn.SALE_NUM.equals(reqBO.getOrderByColumn())) {
                                commodityRecordVO.setOrderBy("sn.SOLD_NUMBER DESC");
                                if (UccMallConstants.Sort.ASC.equals(reqBO.getOrderType())) {
                                    commodityRecordVO.setOrderBy("sn.SOLD_NUMBER");
                                }
                            }
                            if (UccMallConstants.OrderByColumn.SALE_PRICE.equals(reqBO.getOrderByColumn())) {
                                commodityRecordVO.setOrderBy("usp.SALE_PRICE DESC");
                                if (UccMallConstants.Sort.ASC.equals(reqBO.getOrderType())) {
                                    commodityRecordVO.setOrderBy("usp.SALE_PRICE");
                                }
                            }
                            commodityRecordPOS = this.uccMallSkuMapper.qryOtherCommdList(commodityRecordVO);
                        }
                    }
                    if (reqBO.getIsShowSpu().booleanValue()) {
                        commodityRecordPOS = commodityRecordPOS.stream().collect(Collectors.toMap(CommodityRecordPO::getCommodityId, Function.identity(), (k1, k2) -> k1)).values().stream().collect(Collectors.toList());
                        commodityRecordPOS.forEach(each -> each.setSkuName(each.getCommodityName()));
                    }
                    if (!org.apache.commons.collections.CollectionUtils.isEmpty(commodityRecordPOS)) {
                        List<UccCommodityMeasurePo> measurePoList = this.uccMallCommodityMeasureMapper.queryAll();
                        Map<Long, UccCommodityMeasurePo> measureMap = null;
                        if (!org.apache.commons.collections.CollectionUtils.isEmpty(measurePoList)) {
                            measureMap = measurePoList.stream().collect(Collectors.toMap(UccCommodityMeasurePo::getMeasureId, UccCommodityMeasurePo2 -> UccCommodityMeasurePo2));
                        }
                        for (CommodityRecordPO commodityRecordPO : commodityRecordPOS) {
                            if (commodityRecordPO.getMeasure() == null || measureMap.isEmpty()) continue;
                            if (measureMap.containsKey(commodityRecordPO.getMeasureId())) {
                                commodityRecordPO.setMeasureType(measureMap.get(commodityRecordPO.getMeasureId()).getMeasureType());
                                continue;
                            }
                            LOGGER.error("\u8ba1\u91cf\u5355\u4f4d\u67e5\u8be2\u5f02\u5e38->{}" + commodityRecordPO.getMeasureId());
                        }
                    }
                    break block52;
                }
                throw new BusinessException("8888", "\u6ca1\u6709\u8be5\u67e5\u8be2\u7c7b\u578b");
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new BusinessException("8888", "\u67e5\u8be2\u5931\u8d25");
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(commodityRecordPOS)) {
            rspBO.setRows(new ArrayList());
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(0);
            return rspBO;
        }
        ArrayList<UccMallCommodityRecordBO> commodityRecordBOS = new ArrayList<UccMallCommodityRecordBO>();
        List<Long> skuIds = commodityRecordPOS.stream().map(CommodityRecordPO::getSkuId).collect(Collectors.toList());
        List<UccLadderPricePO> uccLadderPricePOList = this.uccMallLadderPriceMapper.selectBySkuIds(skuIds, null);
        List<Long> commodityTypeIds = commodityRecordPOS.stream().map(CommodityRecordPO::getCommodityTypeId).collect(Collectors.toList());
        List<UccCommodityTypePo> list = this.uccMallCommodityTypeMapper.queryPoByCommodityTypeIds(commodityTypeIds);
        ArrayList<ReplacePriceInfoBO> replacePriceInfo = new ArrayList<ReplacePriceInfoBO>();
        for (CommodityRecordPO commodityRecordPO : commodityRecordPOS) {
            UccMallCommodityRecordBO commodityRecordBO = new UccMallCommodityRecordBO();
            commodityRecordBOS.add(commodityRecordBO);
            commodityRecordBO.setCommodityId(commodityRecordPO.getCommodityId());
            commodityRecordBO.setSalesUnitName(commodityRecordPO.getSalesUnitName());
            commodityRecordBO.setSalesUnitRate(commodityRecordPO.getSalesUnitRate());
            commodityRecordBO.setPackageSpec(commodityRecordPO.getPackageSpec());
            commodityRecordBO.setSettlementUnit(commodityRecordPO.getSettlementUnit());
            commodityRecordBO.setUpdateTime(commodityRecordPO.getUpdateTime());
            commodityRecordBO.setSkuId(commodityRecordPO.getSkuId());
            commodityRecordBO.setSkuCode(commodityRecordPO.getSkuCode());
            commodityRecordBO.setSkuStatus(commodityRecordPO.getSkuStatus());
            if (commodityRecordPO.getSkuStatus() != null) {
                commodityRecordBO.setSkuStatusDesc(SkuStatusEnum.getStatusDesc(commodityRecordPO.getSkuStatus()).getStatusDesc());
            }
            commodityRecordBO.setCatalogName(commodityRecordPO.getCatalogName());
            commodityRecordBO.setSkuPicUrl(commodityRecordPO.getSkuPicUrl());
            commodityRecordBO.setSkuName(commodityRecordPO.getSkuName());
            commodityRecordBO.setBrandName(commodityRecordPO.getBrandName());
            commodityRecordBO.setSupplierName(commodityRecordPO.getSupplierName());
            commodityRecordBO.setSupplierId(commodityRecordPO.getSupplierId());
            commodityRecordBO.setMiniOrderNum(commodityRecordPO.getMiniOrderNum());
            commodityRecordBO.setReleaseTime(commodityRecordPO.getCreateTime());
            commodityRecordBO.setSkuDesc(commodityRecordPO.getSkuDesc());
            commodityRecordBO.setSupplierShopName(commodityRecordPO.getShopName());
            commodityRecordBO.setDownReason(commodityRecordPO.getDownReason());
            commodityRecordBO.setDownTime(commodityRecordPO.getDownTime());
            commodityRecordBO.setRestoreUpTime(commodityRecordPO.getRestoreUpTime());
            commodityRecordBO.setMeasure(commodityRecordPO.getMeasure());
            commodityRecordBO.setOrgName(commodityRecordPO.getOrgName());
            commodityRecordBO.setDeliveryCycle(commodityRecordPO.getDeliveryCycle());
            commodityRecordBO.setGuaranteePeriod(commodityRecordPO.getGuaranteePeriod());
            commodityRecordBO.setAuditType(commodityRecordPO.getAuditType());
            commodityRecordBO.setMaterialCode(commodityRecordPO.getMaterialCode());
            if (commodityRecordPO.getAuditType() != null) {
                commodityRecordBO.setAuditTypeDesc(ApprovalTypeEnum.findByStep(commodityRecordPO.getAuditType().toString()).getMessage());
            }
            commodityRecordBO.setDealResult(commodityRecordPO.getDealResult());
            if (commodityRecordPO.getDealResult() != null) {
                commodityRecordBO.setDealResultDesc(AuditResultStatusEnum.getByStatus(commodityRecordPO.getDealResult()).getMessage());
            }
            commodityRecordBO.setDealName(commodityRecordPO.getDealName());
            commodityRecordBO.setAuditTime(commodityRecordPO.getAuditTime());
            commodityRecordBO.setSpec(commodityRecordPO.getSpec());
            commodityRecordBO.setModel(commodityRecordPO.getModel());
            commodityRecordBO.setFigure(commodityRecordPO.getFigure());
            commodityRecordBO.setTexture(commodityRecordPO.getTexture());
            commodityRecordBO.setSupplierShopId(commodityRecordPO.getSupplierShopId());
            commodityRecordBO.setShowPack(commodityRecordPO.getShowPack());
            commodityRecordBO.setMaterialName(commodityRecordPO.getMeterialName());
            if (commodityRecordPO.getShowPack() != null) {
                commodityRecordBO.setShowPackDesc(YesNoEnum.getTypeDesc(commodityRecordPO.getShowPack()));
            }
            commodityRecordBO.setCreateTime(commodityRecordPO.getCreateTime());
            if (commodityRecordPO.getSalePrice() != null) {
                commodityRecordBO.setSalePrice(MoneyUtils.haoToYuan(commodityRecordPO.getSalePrice()));
            }
            if (commodityRecordPO.getMarketPrice() != null) {
                commodityRecordBO.setMarketPrice(MoneyUtils.haoToYuan(commodityRecordPO.getMarketPrice()));
            }
            commodityRecordBO.setTaxCategoryCode(commodityRecordPO.getTaxCategoryCode());
            commodityRecordBO.setBelongCategory(commodityRecordPO.getBelongCategory());
            commodityRecordBO.setAgreementDetailsId(commodityRecordPO.getAgreementDetailsId());
            commodityRecordBO.setVendorName(commodityRecordPO.getVendorName());
            commodityRecordBO.setVendorId(commodityRecordPO.getVendorId());
            commodityRecordBO.setManufacturer(commodityRecordPO.getManufacturer());
            UccMallCommodityPackBO commodityPackBO = new UccMallCommodityPackBO();
            ArrayList<UccMallCommodityPackBO> commodityPackBOS = new ArrayList<UccMallCommodityPackBO>();
            commodityPackBOS.add(commodityPackBO);
            commodityPackBO.setCommodityId(commodityRecordPO.getCommodityId());
            commodityPackBO.setWeight(commodityRecordPO.getWeight());
            commodityPackBO.setHeight(commodityRecordPO.getHeight());
            commodityPackBO.setLength(commodityRecordPO.getLength());
            commodityPackBO.setWidth(commodityRecordPO.getWidth());
            commodityPackBO.setList(commodityRecordPO.getList());
            commodityRecordBO.setCommodityPackInfo(commodityPackBOS);
            List<UccMallLadderPriceBo> ladderPriceBOS = new ArrayList();
            if (reqBO.getAuditType() != null && ApprovalTypeEnum.APPROVAL_EDIT.getStep().equals(reqBO.getAuditType().toString())) {
                String ladderPrice = commodityRecordPO.getLadderPrice();
                if (!StringUtils.isEmpty((Object)ladderPrice)) {
                    ladderPriceBOS = JSONObject.parseArray((String)ladderPrice, UccMallLadderPriceBo.class);
                }
            } else {
                try {
                    if (!org.apache.commons.collections.CollectionUtils.isEmpty(uccLadderPricePOList)) {
                        List uccLadderPricePOS = uccLadderPricePOList.stream().filter(s -> s.getSkuId().equals(commodityRecordBO.getSkuId())).collect(Collectors.toList());
                        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(uccLadderPricePOS)) {
                            for (UccLadderPricePO uccLadderPricePO : uccLadderPricePOS) {
                                UccMallLadderPriceBo ladderPriceBO = new UccMallLadderPriceBo();
                                if (uccLadderPricePO.getStart() != null) {
                                    ladderPriceBO.setStartPrice(MoneyUtils.haoToYuan(uccLadderPricePO.getStart()));
                                }
                                if (uccLadderPricePO.getStop() != null) {
                                    ladderPriceBO.setStopPrice(MoneyUtils.haoToYuan(uccLadderPricePO.getStop()));
                                }
                                if (uccLadderPricePO.getPrice() != null) {
                                    ladderPriceBO.setPrice(MoneyUtils.haoToYuan(uccLadderPricePO.getPrice()));
                                }
                                ladderPriceBOS.add(ladderPriceBO);
                            }
                        }
                    } else {
                        ReplacePriceInfoBO replacePriceInfoBO = new ReplacePriceInfoBO();
                        replacePriceInfoBO.setSkuId(commodityRecordPO.getSkuId());
                        replacePriceInfoBO.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong(commodityRecordPO.getAgreementPrice())));
                        replacePriceInfoBO.setSalePrice(Long.valueOf(MoneyUtils.yuanToHaoToLong(commodityRecordPO.getSalePrice())));
                        replacePriceInfoBO.setVendorId(commodityRecordPO.getVendorId());
                        replacePriceInfoBO.setSkuSource(commodityRecordPO.getSkuSource());
                        replacePriceInfoBO.setCommodityId(commodityRecordPO.getCommodityId());
                        replacePriceInfoBO.setCommodityTypeId(commodityRecordPO.getCommodityTypeId());
                        replacePriceInfoBO.setAgreementId(Long.valueOf(Long.parseLong(commodityRecordVO.getAgreementId())));
                        replacePriceInfo.add(replacePriceInfoBO);
                    }
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                    throw new BusinessException("8888", "\u67e5\u8be2\u9636\u68af\u4ef7\u683c\u5931\u8d25");
                }
            }
            if (reqBO.getExportType() == null || reqBO.getExportType() != 1) {
                // empty if block
            }
            commodityRecordBO.setLadderPrice(ladderPriceBOS);
            Long catalogId = null;
            if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) continue;
            List catalogIds = list.stream().filter(s -> s.getCommodityTypeId().equals(commodityRecordPO.getCommodityTypeId())).collect(Collectors.toList());
            if (catalogIds != null && catalogIds.size() > 0) {
                UccCommodityTypePo uccCommodityTypePo = (UccCommodityTypePo)catalogIds.get(0);
                catalogId = uccCommodityTypePo.getCatalogId();
            }
            commodityRecordBO.setCatalogId(catalogId);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(replacePriceInfo)) {
            UccMallReplacementPriceReqBo uccMallReplacementPriceReqBo = new UccMallReplacementPriceReqBo();
            uccMallReplacementPriceReqBo.setIsprofess(reqBO.getIsprofess());
            uccMallReplacementPriceReqBo.setCompanyId(reqBO.getCompanyId());
            uccMallReplacementPriceReqBo.setUserTypeIn(reqBO.getUserTypeIn());
            uccMallReplacementPriceReqBo.setReplacePriceInfo(replacePriceInfo);
            UccMallReplacementPriceRspBo uccMallReplacementPriceRspBo = this.uccMallReplacementPriceAbilityService.replacePrice(uccMallReplacementPriceReqBo);
            if ("0000".equals(uccMallReplacementPriceRspBo.getRespCode()) && !CollectionUtils.isEmpty((Collection)uccMallReplacementPriceRspBo.getRows())) {
                Map repalceMap = uccMallReplacementPriceRspBo.getRows().stream().distinct().collect(Collectors.toMap(ReplacePriceInfoBO::getSkuId, Function.identity()));
                for (UccMallCommodityRecordBO price : commodityRecordBOS) {
                    if (!repalceMap.containsKey(price.getSkuId()) || null == repalceMap.get(price.getSkuId()) || null == ((ReplacePriceInfoBO)repalceMap.get(price.getSkuId())).getSalePrice()) continue;
                    price.setSalePrice(MoneyUtils.haoToYuan(MoneyUtils.haoToYuan(((ReplacePriceInfoBO)repalceMap.get(price.getSkuId())).getSalePrice())));
                }
            }
        }
        this.getComPic(commodityRecordBOS);
        int count = commodityRecordBOS.size();
        int n = reqBO.getPageSize();
        ArrayList pageList = new ArrayList();
        for (int i = 0; i < count; i += n) {
            int j;
            ArrayList temp = new ArrayList();
            if (count - i >= n) {
                for (j = 0; j < n; ++j) {
                    temp.add(commodityRecordBOS.get(i + j));
                }
            } else {
                for (j = 0; j < count - i; ++j) {
                    temp.add(commodityRecordBOS.get(i + j));
                }
            }
            pageList.add(temp);
        }
        rspBO.setRows((List)pageList.get(reqBO.getPageNo() - 1));
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(commodityRecordBOS.size() % reqBO.getPageSize() == 0 ? commodityRecordBOS.size() / reqBO.getPageSize() : commodityRecordBOS.size() / reqBO.getPageSize() + 1);
        rspBO.setRecordsTotal(commodityRecordBOS.size());
        return rspBO;
    }

    private List<Long> getCommodityTypeIds(Long catalogId) {
        List<UccCatalogDealPO> uccCatalogDealPOS;
        if (catalogId == null) {
            return null;
        }
        List<Long> catalogIds = new ArrayList<Long>();
        catalogIds.add(catalogId);
        while (!org.apache.commons.collections.CollectionUtils.isEmpty(uccCatalogDealPOS = this.uccMallCatalogDealMapper.selectByUpperCatIds(catalogIds))) {
            catalogIds = uccCatalogDealPOS.stream().map(UccCatalogDealPO::getGuideCatalogId).collect(Collectors.toList());
            if (uccCatalogDealPOS.get(0).getCatalogLevel() != 3) continue;
            break;
        }
        List<Long> commodityTypeIds = this.uccMallCatRCommdTypeMapper.queryTypeByGuideCatalogIds(catalogIds);
        return commodityTypeIds;
    }

    private Long getCatalogId(Long commodityTypeId) {
        UccCommodityTypePo uccCommodityTypePo;
        Long catalogId = null;
        if (commodityTypeId != null && (uccCommodityTypePo = this.uccMallCommodityTypeMapper.queryPoByCommodityTypeId(commodityTypeId)) != null) {
            catalogId = uccCommodityTypePo.getCatalogId();
        }
        return catalogId;
    }

    private CommodityRecordVO dealReq(UccMallAgrGoodListQueryAbilityReqBO reqBO) {
        List<Long> commodityTypeIds = this.getCommodityTypeIds(reqBO.getCatalogId());
        if (reqBO.getCatalogId() != null && org.apache.commons.collections.CollectionUtils.isEmpty(commodityTypeIds)) {
            return null;
        }
        CommodityRecordVO commodityRecordVO = new CommodityRecordVO();
        if (reqBO.getAgreementId() != null) {
            commodityRecordVO.setAgreementId(String.valueOf(reqBO.getAgreementId()));
        }
        if (reqBO.getIsShowSpu().booleanValue()) {
            commodityRecordVO.setCommodityName(reqBO.getSkuName());
        } else {
            commodityRecordVO.setSkuName(reqBO.getSkuName());
        }
        commodityRecordVO.setSkuCode(reqBO.getSkuCode());
        commodityRecordVO.setBrandName(reqBO.getBrandName());
        commodityRecordVO.setSkuStatus(reqBO.getSkuStatus());
        commodityRecordVO.setSkuId(reqBO.getSkuId());
        commodityRecordVO.setSkuIds(reqBO.getSkuIds());
        commodityRecordVO.setShowPack(reqBO.getShowPack());
        commodityRecordVO.setModel(reqBO.getModel());
        commodityRecordVO.setSpec(reqBO.getSpec());
        commodityRecordVO.setFigure(reqBO.getFigure());
        commodityRecordVO.setManufacturer(reqBO.getManufacturer());
        commodityRecordVO.setMaterialCode(reqBO.getMaterialCode());
        commodityRecordVO.setCommodityTypeIds(commodityTypeIds);
        commodityRecordVO.setVendorName(reqBO.getSupplierName());
        return commodityRecordVO;
    }

    private void getComPic(List<UccMallCommodityRecordBO> bos) {
        List<Long> commodityIds;
        List<UccCommodityPicPo> uccCommodityPicPos;
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(bos) && !org.apache.commons.collections.CollectionUtils.isEmpty(uccCommodityPicPos = this.uccMallCommodityPicMapper.queryBatchByCommdId(commodityIds = bos.stream().map(UccMallCommodityRecordBO::getCommodityId).collect(Collectors.toList()), null))) {
            for (UccMallCommodityRecordBO bo : bos) {
                for (UccCommodityPicPo uccCommodityPicPo : uccCommodityPicPos) {
                    if (!bo.getCommodityId().equals(uccCommodityPicPo.getCommodityId()) || uccCommodityPicPo.getCommodityPicType() != 1) continue;
                    bo.setSkuPicUrl(uccCommodityPicPo.getCommodityPicUrl());
                }
            }
        }
    }

    private void getBrandInfo(List<CommodityRecordPO> pos) {
        List<UccMallBrandRelPO> uccMallBrandRelPOS;
        List<Long> brandIds;
        if (!(org.apache.commons.collections.CollectionUtils.isEmpty(pos) || org.apache.commons.collections.CollectionUtils.isEmpty(brandIds = pos.stream().filter(a -> a.getBrandId() != null).map(CommodityRecordPO::getBrandId).collect(Collectors.toList())) || org.apache.commons.collections.CollectionUtils.isEmpty(uccMallBrandRelPOS = this.uccMallBrandRelMapper.getRelByBrandList(brandIds)))) {
            Map<Long, UccMallBrandRelPO> map = uccMallBrandRelPOS.stream().filter(a -> a.getBrandId() != null).collect(Collectors.toMap(a -> a.getBrandId(), b -> b, (oldKey, newKey) -> newKey));
            for (CommodityRecordPO commodityRecordPO : pos) {
                if (commodityRecordPO.getBrandId() == null || map.get(commodityRecordPO.getBrandId()) == null) continue;
                commodityRecordPO.setBrandId(map.get(commodityRecordPO.getBrandId()).getMallBrandId());
                commodityRecordPO.setBrandName(map.get(commodityRecordPO.getBrandId()).getMallBrandName());
            }
        }
    }
}

