/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.tydic.commodity.mall.ability.api.UccSpuItemSpecInfodetailsAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallFilterSkuSpecBO;
import com.tydic.commodity.mall.ability.bo.UccMallSkuSpecListBo;
import com.tydic.commodity.mall.ability.bo.UccMallSkuSpecPropValueListBo;
import com.tydic.commodity.mall.ability.bo.UccSpuItemSpecInfodetailsAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccSpuItemSpecInfodetailsAbilityRspBO;
import com.tydic.commodity.mall.dao.UccSkuSpecMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccSpuItemSpecInfodetailsAbilityService"})
public class UccSpuItemSpecInfodetailsAbilityServiceImpl
implements UccSpuItemSpecInfodetailsAbilityService {
    @Autowired
    private UccSkuSpecMapper uccSkuSpecMapper;

    @PostMapping(value={"dealItemSpecInfo"})
    public UccSpuItemSpecInfodetailsAbilityRspBO dealItemSpecInfo(@RequestBody UccSpuItemSpecInfodetailsAbilityReqBO reqBO) {
        UccSpuItemSpecInfodetailsAbilityRspBO rspBO = new UccSpuItemSpecInfodetailsAbilityRspBO();
        if (reqBO == null || reqBO.getCommodityId() == null) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        ArrayList<Long> commodityPropDefIds = new ArrayList<Long>();
        ArrayList<Long> propValueListIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getQryInfoList())) {
            reqBO.getQryInfoList().stream().forEach(item -> {
                commodityPropDefIds.add(item.getCommodityPropDefId());
                propValueListIds.add(item.getPropValueListId());
            });
        }
        if (commodityPropDefIds.size() != propValueListIds.size()) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5c5e\u6027\u7b5b\u9009\u5185\u5bb9\u4e0d\u5339\u914d");
            return rspBO;
        }
        List<UccMallFilterSkuSpecBO> filterSkuSpecBOList = this.uccSkuSpecMapper.filterSkuSpec(reqBO.getCommodityId(), commodityPropDefIds, propValueListIds, reqBO.getSkuName());
        if (!CollectionUtils.isEmpty(filterSkuSpecBOList)) {
            Map<Long, List<UccMallFilterSkuSpecBO>> groubyDefId = filterSkuSpecBOList.stream().collect(Collectors.groupingBy(UccMallFilterSkuSpecBO::getCommodityPropDefId));
            Iterator<Map.Entry<Long, List<UccMallFilterSkuSpecBO>>> iterator = groubyDefId.entrySet().iterator();
            ArrayList<UccMallSkuSpecListBo> skuspecList = new ArrayList<UccMallSkuSpecListBo>();
            while (iterator.hasNext()) {
                Map.Entry<Long, List<UccMallFilterSkuSpecBO>> entry = iterator.next();
                UccMallSkuSpecListBo uccSkuSpecListBo = new UccMallSkuSpecListBo();
                uccSkuSpecListBo.setCommodityPropDefId(entry.getKey());
                uccSkuSpecListBo.setPropName(entry.getValue().get(0).getPropName());
                ArrayList<UccMallSkuSpecPropValueListBo> valueListBos = new ArrayList<UccMallSkuSpecPropValueListBo>();
                List mallFilterSkuSpecBOS = entry.getValue().stream().distinct().collect(Collectors.toList());
                for (UccMallFilterSkuSpecBO each : mallFilterSkuSpecBOS) {
                    UccMallSkuSpecPropValueListBo bo = new UccMallSkuSpecPropValueListBo();
                    bo.setPropValueListId(each.getPropValueListId());
                    bo.setPropValue(each.getPropValue());
                    valueListBos.add(bo);
                }
                uccSkuSpecListBo.setSkuSpecList(valueListBos);
                skuspecList.add(uccSkuSpecListBo);
            }
            rspBO.setSkuspecList(skuspecList);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }
}

