/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.JsonUtils;
import com.tydic.commodity.mall.atom.api.InterfaceQrySkuStateService;
import com.tydic.commodity.mall.atom.bo.InterfaceSkuStateReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceSkuStateRsp;
import com.tydic.commodity.mall.atom.bo.InterfaceSkuStateRspBo;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.utils.ESBParamUtil;
import com.tydic.commodity.mall.utils.HSHttpHelper;
import com.tydic.commodity.mall.utils.HSNHttpHeader;
import com.tydic.commodity.mall.utils.HttpRetBean;
import com.tydic.commodity.mall.utils.PropertiesUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="uccQrySkuStateService")
public class InterfaceQrySkuStateServiceImpl
implements InterfaceQrySkuStateService {
    private static final Logger log = LoggerFactory.getLogger(InterfaceQrySkuStateServiceImpl.class);

    @Override
    public InterfaceSkuStateRsp qrySkuStatus(InterfaceSkuStateReqBO reqBO) {
        InterfaceSkuStateRsp skuStateRsp = new InterfaceSkuStateRsp();
        if (null == reqBO.getSupplierId()) {
            skuStateRsp.setRespCode("8888");
            skuStateRsp.setRespDesc("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e1a\u52a1\u670d\u52a1\u4f9b\u5e94\u5546supplierId[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
            return skuStateRsp;
        }
        if (reqBO.getExtSkuIds().isEmpty()) {
            skuStateRsp.setRespCode("8888");
            skuStateRsp.setRespDesc("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e1a\u52a1\u670d\u52a1\u5546\u54c1ID\u96c6\u5408[extSkuIds]\u4e0d\u80fd\u4e3a\u7a7a");
            return skuStateRsp;
        }
        try {
            ArrayList<Long> existSkuIds = new ArrayList<Long>();
            String resultCode = this.initReqStr(reqBO);
            String hsn = reqBO.getSupplierCode();
            String reqEsbStr = ESBParamUtil.getEsbReqStr(resultCode, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtil.getProperty("ESB_QRY_SKU_STATE_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.toString().getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                log.error("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("ESB_QRY_SKU_STATE_URL") + "]");
                skuStateRsp.setRespCode(UccMallConstantsEnums.HTTP_OUT_FAIL.code());
                skuStateRsp.setRespDesc(UccMallConstantsEnums.HTTP_OUT_FAIL.code() + httpRetBean.getStatus());
                return skuStateRsp;
            }
            String returnString = httpRetBean.getStr();
            log.debug("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u63a5\u53e3\u67e5\u8be2\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u54cd\u5e94\u53c2\u6570:{}", (Object)returnString);
            if (StringUtils.isEmpty((Object)returnString)) {
                skuStateRsp.setRespCode(UccMallConstantsEnums.OUT_MESSAGE_QUERY_NULL_FAILED.code());
                skuStateRsp.setRespDesc("\u67e5\u8be2\u7535\u5546\u5916\u90e8\u63a5\u53e3-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                return skuStateRsp;
            }
            skuStateRsp = this.resolveRspMsg(returnString, existSkuIds);
            return skuStateRsp;
        }
        catch (Exception var9) {
            var9.printStackTrace();
            log.error("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + var9);
            skuStateRsp.setRespCode(UccMallConstantsEnums.OUT_MESSAGE_QUERY_FAILED.code());
            skuStateRsp.setRespDesc("\u67e5\u8be2\u7535\u5546\u5916\u90e8\u63a5\u53e3\u5931\u8d25");
            return skuStateRsp;
        }
    }

    private String initReqStr(InterfaceSkuStateReqBO skuStateReqBO) {
        ArrayList<String> extSkuIds = new ArrayList<String>();
        for (String extSkuId : skuStateReqBO.getExtSkuIds()) {
            extSkuIds.add('\"' + extSkuId + '\"');
        }
        StringBuffer sb = new StringBuffer();
        sb.append("{").append("\"sku\":").append(extSkuIds).append("}");
        return sb.toString();
    }

    private InterfaceSkuStateRsp resolveRspMsg(String rspStr, List<Long> existSkuIds) {
        JSONObject jsonObject = JSONObject.parseObject((String)rspStr);
        List resultList = (List)jsonObject.get((Object)"result");
        InterfaceSkuStateRsp skuStateRsp = new InterfaceSkuStateRsp();
        if (((Boolean)jsonObject.get((Object)"success")).booleanValue() && null != resultList) {
            try {
                InterfaceSkuStateRspBo[] skuStateRspBoArr = (InterfaceSkuStateRspBo[])JsonUtils.jsonStringToJavaBean((String)JSONObject.toJSONString((Object)jsonObject.get((Object)"result")), InterfaceSkuStateRspBo[].class);
                List<InterfaceSkuStateRspBo> skuStateRspBos = Arrays.asList(skuStateRspBoArr);
                skuStateRsp.setSkuStates(skuStateRspBos);
                if (!StringUtils.isEmpty((Object)JSONObject.toJSONString((Object)jsonObject.get((Object)"resultMessage")))) {
                    skuStateRsp.setResultMessage(JSONObject.toJSONString((Object)jsonObject.get((Object)"resultMessage")));
                }
                if (!existSkuIds.isEmpty()) {
                    String existSkuIdStr = "";
                    for (int i = 0; i < existSkuIds.size(); ++i) {
                        existSkuIdStr = i == existSkuIds.size() - 1 ? existSkuIdStr + existSkuIds.get(i) : existSkuIdStr + existSkuIds.get(i) + ",";
                    }
                    skuStateRsp.setResultMessage("\u5546\u54c1SKUID[" + existSkuIdStr + "]\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728");
                }
                skuStateRsp.setRespCode("0000");
                skuStateRsp.setRespDesc("\u6210\u529f");
                return skuStateRsp;
            }
            catch (Exception var10) {
                log.error("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e1a\u52a1\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u5931\u8d25" + var10);
                skuStateRsp.setRespCode(UccMallConstantsEnums.OUT_MESSAGE_QUERY_RESOLVE_FAILED.code());
                skuStateRsp.setRespDesc("\u67e5\u8be2\u7535\u5546\u5916\u90e8\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519");
                return skuStateRsp;
            }
        }
        log.error("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e1a\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5546\u54c1\u533a\u57df\u8d2d\u4e70\u9650\u5236\u67e5\u8be2\uff1a" + jsonObject.get((Object)"resultMessage"));
        if ("2007".equals((String)jsonObject.get((Object)"resultCode"))) {
            skuStateRsp.setRespDesc("token\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5237\u65b0\u6216\u8005\u83b7\u53d6token");
            skuStateRsp.setRespCode(UccMallConstantsEnums.TOKEN_EXPIRE_FAIL.code());
            return skuStateRsp;
        }
        skuStateRsp.setRespDesc((String)jsonObject.get((Object)"resultMessage"));
        skuStateRsp.setRespCode((String)jsonObject.get((Object)"resultCode"));
        return skuStateRsp;
    }
}

