/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.tydic.commodity.mall.ability.bo.UccMallCommdStockBO_busi;
import com.tydic.commodity.mall.atom.api.InterfaceCurrentStockQryService;
import com.tydic.commodity.mall.atom.api.InterfaceJDAddressFromAddressQryService;
import com.tydic.commodity.mall.atom.api.UccMallCurrentStockQryAtomService;
import com.tydic.commodity.mall.atom.bo.InterfaceCommdStockBO;
import com.tydic.commodity.mall.atom.bo.InterfaceCurrentStockQryReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceCurrentStockQryRspBO;
import com.tydic.commodity.mall.atom.bo.InterfaceJDAddressFromAddressQryReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceJDAddressFromAddressQryRspBO;
import com.tydic.commodity.mall.atom.bo.InterfaceSkuNumBO;
import com.tydic.commodity.mall.atom.bo.UccMallCurrentStockQryReqBO;
import com.tydic.commodity.mall.atom.bo.UccMallCurrentStockQryRspBO;
import com.tydic.commodity.mall.atom.bo.UccMallSkuNumBO_Atom;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.dyc.umc.service.addrprovince.UmcQryAddressService;
import com.tydic.dyc.umc.service.addrprovince.bo.UmcQryAddressReqBo;
import com.tydic.dyc.umc.service.addrprovince.bo.UmcQryAddressRspBo;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccMallCurrentStockQryAtomServiceImpl
implements UccMallCurrentStockQryAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccMallCurrentStockQryAtomServiceImpl.class);
    @Autowired
    private InterfaceCurrentStockQryService interfaceCurrentStockQryService;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMallCurrentStockQryAtomServiceImpl.class);
    @Autowired
    private InterfaceJDAddressFromAddressQryService interfaceJDAddressFromAddressQryService;
    @Autowired
    private UmcQryAddressService umcQryAddressService;

    @Override
    public UccMallCurrentStockQryRspBO qryCommdCurrentStock(UccMallCurrentStockQryReqBO reqBO) {
        UccMallCurrentStockQryRspBO rspBO = new UccMallCurrentStockQryRspBO();
        try {
            if (CollectionUtils.isEmpty(reqBO.getSkuNum())) {
                rspBO.setRespCode(UccMallConstantsEnums.REQUIRED_NON_EMPTY.code());
                rspBO.setRespDesc("\u8bf7\u4f20\u5165\u5355\u54c1\u4fe1\u606f");
                return rspBO;
            }
            if ("jd".equals(reqBO.getSupplierCode()) || "jdvop".equals(reqBO.getSupplierCode())) {
                UmcQryAddressReqBo umcQryAddressReqBo = new UmcQryAddressReqBo();
                umcQryAddressReqBo.setProvinceCode(Convert.toStr((Object)reqBO.getProvince()));
                umcQryAddressReqBo.setCityCode(Convert.toStr((Object)reqBO.getCity()));
                umcQryAddressReqBo.setAreaCode(Convert.toStr((Object)reqBO.getCounty()));
                umcQryAddressReqBo.setTownsCode(Convert.toStr((Object)reqBO.getTown()));
                log.info("\u4f1a\u5458\u67e5\u8be2\u7701\u5e02\u53bf\u9547\u670d\u52a1\u5165\u53c2umcCrcQryAddressAbilityReqBO\uff1a" + JSONObject.toJSONString((Object)umcQryAddressReqBo));
                UmcQryAddressRspBo umcQryAddressRspBo = this.umcQryAddressService.qryAddress(umcQryAddressReqBo);
                log.info("\u4f1a\u5458\u67e5\u8be2\u7701\u5e02\u53bf\u9547\u670d\u52a1\u51fa\u53c2umcCrcQryAddressAbilityRspBO\uff1a" + JSONObject.toJSONString((Object)umcQryAddressRspBo));
                reqBO.setProvince(Convert.toLong((Object)umcQryAddressRspBo.getProvinceCode()));
                reqBO.setCity(Convert.toLong((Object)umcQryAddressRspBo.getCityCode()));
                reqBO.setCounty(Convert.toLong((Object)umcQryAddressRspBo.getAreaCode()));
                reqBO.setTown(Convert.toLong((Object)umcQryAddressRspBo.getTownsCode()));
                InterfaceJDAddressFromAddressQryReqBO jdAddressFromAddressQryReqBO = new InterfaceJDAddressFromAddressQryReqBO();
                jdAddressFromAddressQryReqBO.setProvinceName(umcQryAddressRspBo.getProvinceName());
                jdAddressFromAddressQryReqBO.setCityName(umcQryAddressRspBo.getCityName());
                jdAddressFromAddressQryReqBO.setAreaName(umcQryAddressRspBo.getAreaName());
                jdAddressFromAddressQryReqBO.setTownName(umcQryAddressRspBo.getTownName());
                jdAddressFromAddressQryReqBO.setSupplierCode(reqBO.getSupplierCode());
                InterfaceJDAddressFromAddressQryRspBO jdAddressFromAddressQryRspBO = this.interfaceJDAddressFromAddressQryService.getJDAddressFromAddress(jdAddressFromAddressQryReqBO);
                reqBO.setProvince(jdAddressFromAddressQryRspBO.getResult().getProvinceId() == null ? 0L : jdAddressFromAddressQryRspBO.getResult().getProvinceId().longValue());
                reqBO.setCity(jdAddressFromAddressQryRspBO.getResult().getCityId() == null ? 0L : jdAddressFromAddressQryRspBO.getResult().getCityId().longValue());
                reqBO.setCounty(jdAddressFromAddressQryRspBO.getResult().getCountyId() == null ? 0L : jdAddressFromAddressQryRspBO.getResult().getCountyId().longValue());
                reqBO.setTown(jdAddressFromAddressQryRspBO.getResult().getTownId() == null ? 0L : jdAddressFromAddressQryRspBO.getResult().getTownId().longValue());
            }
            InterfaceCurrentStockQryReqBO uccCurrentStockQryReqBO = new InterfaceCurrentStockQryReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)uccCurrentStockQryReqBO);
            ArrayList<InterfaceSkuNumBO> skuNums = new ArrayList<InterfaceSkuNumBO>();
            for (UccMallSkuNumBO_Atom each : reqBO.getSkuNum()) {
                InterfaceSkuNumBO bo = new InterfaceSkuNumBO();
                bo.setSkuId(each.getSkuId());
                bo.setNum(each.getNum());
                skuNums.add(bo);
            }
            uccCurrentStockQryReqBO.setSkuNum(skuNums);
            InterfaceCurrentStockQryRspBO uccCurrentStockQryRspBO = null;
            uccCurrentStockQryRspBO = this.interfaceCurrentStockQryService.qryCommdCurrentStock(uccCurrentStockQryReqBO);
            if (uccCurrentStockQryRspBO == null) {
                LOGGER.error("uccCurrentStockQryService ->{ 67 - null }");
                rspBO.setRespCode(UccMallConstantsEnums.QUERY_RESULT_IS_EMPTY.code());
                rspBO.setRespDesc("\u5e93\u5b58\u67e5\u8be2\u8fd4\u56de null");
                return rspBO;
            }
            if ("0000".equals(uccCurrentStockQryRspBO.getResultCode())) {
                if (uccCurrentStockQryRspBO.getCommdStockInfo() != null && uccCurrentStockQryRspBO.getCommdStockInfo().size() > 0) {
                    ArrayList<UccMallCommdStockBO_busi> commdStockBOBusis = new ArrayList<UccMallCommdStockBO_busi>();
                    for (InterfaceCommdStockBO commdStockBO : uccCurrentStockQryRspBO.getCommdStockInfo()) {
                        String json = JSONObject.toJSONString((Object)commdStockBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
                        UccMallCommdStockBO_busi commdStockBOBusi1 = (UccMallCommdStockBO_busi)JSON.parseObject((String)json, UccMallCommdStockBO_busi.class);
                        BeanUtils.copyProperties((Object)commdStockBO, (Object)commdStockBOBusi1);
                        if (commdStockBOBusi1.getRemainNum().compareTo(new BigDecimal("0")) > 0) {
                            for (UccMallSkuNumBO_Atom uccMallsSkuNumBO_atom : reqBO.getSkuNum()) {
                                if (!commdStockBOBusi1.getSkuId().equals(uccMallsSkuNumBO_atom.getSkuId()) || commdStockBOBusi1.getRemainNum().compareTo(uccMallsSkuNumBO_atom.getNum()) >= 0) continue;
                                commdStockBOBusi1.setStockStateId(Integer.valueOf(0));
                            }
                        }
                        commdStockBOBusis.add(commdStockBOBusi1);
                    }
                    rspBO.setCommdStockInfo(commdStockBOBusis);
                }
                uccCurrentStockQryRspBO.getCommdStockInfo();
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
            } else {
                rspBO.setRespCode(uccCurrentStockQryRspBO.getResultCode());
                rspBO.setRespDesc(uccCurrentStockQryRspBO.getResultMessage());
            }
            return rspBO;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
    }
}

