/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.invoiceaddress;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.invoiceaddress.IUmcInvoiceAddressModel;
import com.tydic.dyc.umc.model.invoiceaddress.UmcInvoiceAddressDo;
import com.tydic.dyc.umc.model.invoiceaddress.qrybo.UmcInvoiceAddressListRspBo;
import com.tydic.dyc.umc.model.invoiceaddress.qrybo.UmcInvoiceAddressQryBo;
import com.tydic.dyc.umc.service.invoiceaddress.UmcInvoiceAddressAddService;
import com.tydic.dyc.umc.service.invoiceaddress.bo.UmcInvoiceAddressAddReqBo;
import com.tydic.dyc.umc.service.invoiceaddress.bo.UmcInvoiceAddressAddRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.invoiceaddress.UmcInvoiceAddressAddService"})
public class UmcInvoiceAddressAddServiceImpl
implements UmcInvoiceAddressAddService {
    @Autowired
    private IUmcInvoiceAddressModel iUmcInvoiceAddressModel;
    private final String msgHead = "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u65b0\u589e\u670d\u52a1\u5165\u53c2";

    @PostMapping(value={"addInvoiceAddress"})
    public UmcInvoiceAddressAddRspBo addInvoiceAddress(@RequestBody UmcInvoiceAddressAddReqBo reqBo) {
        UmcInvoiceAddressAddRspBo rspBo = UmcRu.success(UmcInvoiceAddressAddRspBo.class);
        this.checkSameAddr(reqBo);
        UmcInvoiceAddressDo invoiceAddressDo = StrUtil.noNullStringAttr(UmcRu.js(reqBo, UmcInvoiceAddressDo.class));
        List<UmcInvoiceAddressDo> invoiceAddressDoList = null != reqBo.getAccountId() ? this.qryAddrByAccountId(reqBo.getAccountId()) : this.qryAddrByOrgId(reqBo.getOrgIdWeb());
        if (!CollectionUtils.isEmpty(invoiceAddressDoList) && reqBo.getMainFlag().equals(UmcCommConstant.InvAddrMainFlag.YES)) {
            this.cancleMainFlagAddr(invoiceAddressDoList);
        }
        invoiceAddressDo.setCreateTime(new Date());
        invoiceAddressDo.setInvoiceAddrId(IdUtil.nextId());
        invoiceAddressDo.setCompanyName(reqBo.getCompanyNameWeb());
        invoiceAddressDo.setOrgId(reqBo.getOrgIdWeb());
        invoiceAddressDo.setAddrStatus("01");
        invoiceAddressDo.setDelFlag("0");
        invoiceAddressDo.setName(reqBo.getContactNameWeb());
        invoiceAddressDo.setCreateOperName(reqBo.getName());
        invoiceAddressDo.setCreateTime(new Date());
        invoiceAddressDo.setCreateOperId(reqBo.getUserIdIn());
        if (reqBo.getUserIdIn() != null) {
            invoiceAddressDo.setUserId(reqBo.getUserIdIn() + "");
        }
        UmcInvoiceAddressDo invoiceAddress = this.iUmcInvoiceAddressModel.createInvoiceAddress(invoiceAddressDo);
        rspBo.setId(invoiceAddress.getInvoiceAddrId());
        return rspBo;
    }

    private void checkSameAddr(UmcInvoiceAddressAddReqBo reqBo) {
        UmcInvoiceAddressQryBo qryBo = StrUtil.noNullStringAttr(UmcRu.js(reqBo, UmcInvoiceAddressQryBo.class));
        qryBo.setCompanyName(reqBo.getCompanyNameWeb());
        qryBo.setOrgId(reqBo.getOrgIdWeb());
        qryBo.setName(reqBo.getContactNameWeb());
        qryBo.setCreateOperId(reqBo.getUserIdIn());
        UmcInvoiceAddressDo invoiceAddressCheck = this.iUmcInvoiceAddressModel.getInvoiceAddressCheck(qryBo);
        if (invoiceAddressCheck.getCount() > 0) {
            throw new BaseBusinessException("201003", "\u5df2\u6709\u76f8\u540c\u7684\u5730\u5740\u4fe1\u606f");
        }
    }

    private List<UmcInvoiceAddressDo> qryAddrByAccountId(Long accountId) {
        UmcInvoiceAddressQryBo qryBo = new UmcInvoiceAddressQryBo();
        qryBo.setAccountId(accountId);
        qryBo.setMainFlag(UmcCommConstant.InvAddrMainFlag.YES);
        qryBo.setDelFlag("0");
        UmcInvoiceAddressListRspBo umcInvoiceAddressListRspBo = this.iUmcInvoiceAddressModel.getInvoiceAddressList(qryBo);
        return umcInvoiceAddressListRspBo.getRows();
    }

    private List<UmcInvoiceAddressDo> qryAddrByOrgId(Long orgId) {
        UmcInvoiceAddressQryBo qryBo = new UmcInvoiceAddressQryBo();
        qryBo.setOrgId(orgId);
        qryBo.setMainFlag(UmcCommConstant.InvAddrMainFlag.YES);
        qryBo.setDelFlag("0");
        UmcInvoiceAddressListRspBo umcInvoiceAddressListRspBo = this.iUmcInvoiceAddressModel.getInvoiceAddressList(qryBo);
        return umcInvoiceAddressListRspBo.getRows();
    }

    private void cancleMainFlagAddr(List<UmcInvoiceAddressDo> invoiceAddressDoList) {
        for (UmcInvoiceAddressDo addressDo : invoiceAddressDoList) {
            UmcInvoiceAddressDo invoiceAddressDo = new UmcInvoiceAddressDo();
            invoiceAddressDo.setInvoiceAddrId(addressDo.getInvoiceAddrId());
            invoiceAddressDo.setMainFlag(UmcCommConstant.InvAddrMainFlag.NO);
            this.iUmcInvoiceAddressModel.updateInvoiceAddress(invoiceAddressDo);
        }
    }
}

