package com.tydic.dyc.pro.base.utils.esb;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * @Author yuhao
 * @Date 2025/5/20 11:01
 * @Description:调用能力平台工具
 **/

public class DycProBaseCallEsbUtil {
    /**
     * 获取电商商品详细信息（非京东）
     */
    public static DycProBaseCallEsbUtilGetSkuDetailRspBO getSkuDetail(String url, DycProBaseCallEsbUtilGetSkuDetailReqBO reqBO){
        DycProBaseCallEsbUtilGetSkuDetailRspBO rspBO = new DycProBaseCallEsbUtilGetSkuDetailRspBO();
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品详细信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            DycProBaseCallEsbUtilGetSkuDetailResultBO result = resultJsonObj.getObject("result", DycProBaseCallEsbUtilGetSkuDetailResultBO.class);
            rspBO.setResult(result);
        }
        return rspBO;
    }

    /**
     * 获取电商商品图片信息（非京东）
     */
    public static DycProBaseCallEsbUtilGetSkuImageRspBO getSkuImage(String url,DycProBaseCallEsbUtilGetSkuImageReqBO reqBO){
        DycProBaseCallEsbUtilGetSkuImageRspBO rspBO = new DycProBaseCallEsbUtilGetSkuImageRspBO();
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品图片信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            List<DycProBaseCallEsbUtilGetSkuImageResultBO> result = resultJsonObj.getJSONArray("result").toJavaList(DycProBaseCallEsbUtilGetSkuImageResultBO.class);
            rspBO.setResult(result);
        }
        return rspBO;
    }
}
