/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.agrchng.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.enums.BooleanFlag;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainAdjustPriceType;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainAgrSrc;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainAgrStatus;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainAgrType;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainAgrVersionFormWay;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainAgreementVariety;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainPurScopeType;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainQuaprotectUnit;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainTradeMode;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainVendorMode;
import com.tydic.dyc.pro.base.core.dictionary.enums.EnableFlag;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.dmc.repository.agrchng.api.DycProAgrChngRepository;
import com.tydic.dyc.pro.dmc.repository.agrchng.dto.DycProAgrChngMainDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.api.DycProAgrRepository;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrMainDTO;
import com.tydic.dyc.pro.dmc.service.agrchng.api.DycProAgrChngDetailQryService;
import com.tydic.dyc.pro.dmc.service.agrchng.bo.DycProAgrChngDetailQryReqBO;
import com.tydic.dyc.pro.dmc.service.agrchng.bo.DycProAgrChngDetailQryRspBO;
import com.tydic.dyc.pro.dmc.service.agrchng.bo.DycProAgrChngMainBO;
import com.tydic.dyc.pro.dmc.service.agrchng.bo.DycProAgrCooperationChngCatalogBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.agrchng.api.DycProAgrChngDetailQryService"})
public class DycProAgrChngDetailQryServiceImpl
implements DycProAgrChngDetailQryService {
    @Autowired
    private DycProAgrChngRepository agrChngRepository;
    @Autowired
    private DycProAgrRepository agrMainRepository;

    @Override
    @PostMapping(value={"qryAgrChngDetail"})
    public DycProAgrChngDetailQryRspBO qryAgrChngDetail(@RequestBody DycProAgrChngDetailQryReqBO reqBO) {
        DycProAgrChngDetailQryRspBO rspBO = new DycProAgrChngDetailQryRspBO();
        this.validateParam(reqBO);
        rspBO = (DycProAgrChngDetailQryRspBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)this.getAgrChngDetail(reqBO)), DycProAgrChngDetailQryRspBO.class));
        this.buildCannotChangeData(rspBO);
        return rspBO;
    }

    private void validateParam(DycProAgrChngDetailQryReqBO reqBO) {
        if (null == reqBO.getChngApplyId()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010agrObjPrimaryId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private DycProAgrChngMainBO getAgrChngDetail(DycProAgrChngDetailQryReqBO reqBO) {
        DycProAgrChngMainDTO qryDTO = new DycProAgrChngMainDTO();
        qryDTO.setChngApplyId(reqBO.getChngApplyId());
        DycProAgrChngMainDTO agrChngDetail = this.agrChngRepository.getAgrChngDetailInfo(qryDTO);
        DycProAgrChngMainBO agrChngInfo = (DycProAgrChngMainBO)JSON.parseObject((String)JSON.toJSONString((Object)agrChngDetail), DycProAgrChngMainBO.class);
        if (agrChngInfo.getWhetherManageCatalog() != null && BooleanFlag.YES.getCode().equals(agrChngInfo.getWhetherManageCatalog().toString()) && !CollectionUtils.isEmpty(agrChngInfo.getAgrCooperationChngCatalogBOList())) {
            agrChngInfo.setLastLevelCount(this.getLastLevelCount(agrChngInfo.getAgrCooperationChngCatalogBOList()));
            agrChngInfo.getAgrCooperationChngCatalogBOList().forEach(e -> {
                if (e.getEnableFlag() != null) {
                    e.setEnableFlagStr(DictionaryFrameworkUtils.getDicDataByCode((String)EnableFlag.class.getSimpleName(), (String)e.getEnableFlag().toString()));
                }
            });
            agrChngInfo.setAgrCooperationChngCatalogBOList(this.buildCatalogTree(agrChngInfo.getAgrCooperationChngCatalogBOList()));
        }
        return agrChngInfo;
    }

    public List<DycProAgrCooperationChngCatalogBO> buildCatalogTree(List<DycProAgrCooperationChngCatalogBO> flatList) {
        ArrayList<DycProAgrCooperationChngCatalogBO> result = new ArrayList<DycProAgrCooperationChngCatalogBO>();
        HashMap<Long, DycProAgrCooperationChngCatalogBO> nodeMap = new HashMap<Long, DycProAgrCooperationChngCatalogBO>();
        for (DycProAgrCooperationChngCatalogBO node : flatList) {
            node.setChildren(new ArrayList<DycProAgrCooperationChngCatalogBO>());
            nodeMap.put(node.getManageCatalogId(), node);
        }
        for (DycProAgrCooperationChngCatalogBO node : flatList) {
            Long parentId = node.getManageCatalogParentId();
            if (parentId != null && parentId > 0L) {
                DycProAgrCooperationChngCatalogBO parent = (DycProAgrCooperationChngCatalogBO)nodeMap.get(parentId);
                if (parent == null) continue;
                parent.getChildren().add(node);
                continue;
            }
            result.add(node);
        }
        return result;
    }

    public long getLastLevelCount(List<DycProAgrCooperationChngCatalogBO> catalogBOList) {
        List manageCatalogParentIds = catalogBOList.stream().map(DycProAgrCooperationChngCatalogBO::getManageCatalogParentId).collect(Collectors.toList());
        return catalogBOList.stream().filter(e -> !manageCatalogParentIds.contains(e.getManageCatalogId())).count();
    }

    public DycProAgrChngDetailQryRspBO buildCannotChangeData(DycProAgrChngDetailQryRspBO rspBO) {
        DycProAgrMainDTO qryDTO = new DycProAgrMainDTO();
        qryDTO.setAgrObjPrimaryId(rspBO.getAgrObjPrimaryId());
        qryDTO.setAgrId(rspBO.getAgrId());
        qryDTO.setAgrCode(rspBO.getAgrCode());
        DycProAgrMainDTO agrDetail = this.agrMainRepository.getAgrDetail(qryDTO);
        if (agrDetail.getAgrType() != null) {
            rspBO.setAgrType(agrDetail.getAgrType());
            rspBO.setAgrTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainAgrType.class.getSimpleName(), (String)rspBO.getAgrType().toString()));
        }
        if (agrDetail.getAgrSrc() != null) {
            rspBO.setAgrSrcStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainAgrSrc.class.getSimpleName(), (String)rspBO.getAgrSrc().toString()));
        }
        if (agrDetail.getAgrStatus() != null) {
            rspBO.setAgrStatusStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainAgrStatus.class.getSimpleName(), (String)rspBO.getAgrStatus().toString()));
        }
        if (agrDetail.getTradeMode() != null) {
            rspBO.setTradeModeStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainTradeMode.class.getSimpleName(), (String)rspBO.getTradeMode().toString()));
        }
        if (agrDetail.getAgreementVariety() != null) {
            rspBO.setAgreementVarietyStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainAgreementVariety.class.getSimpleName(), (String)rspBO.getAgreementVariety().toString()));
        }
        if (agrDetail.getAdjustPriceType() != null) {
            rspBO.setAdjustPriceTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainAdjustPriceType.class.getSimpleName(), (String)rspBO.getAdjustPriceType().toString()));
        }
        if (agrDetail.getWhetherHaveItem() != null) {
            rspBO.setWhetherHaveItemStr(DictionaryFrameworkUtils.getDicDataByCode((String)BooleanFlag.class.getSimpleName(), (String)rspBO.getWhetherHaveItem().toString()));
        }
        if (agrDetail.getWhetherStorePlan() != null) {
            rspBO.setWhetherStorePlanStr(DictionaryFrameworkUtils.getDicDataByCode((String)BooleanFlag.class.getSimpleName(), (String)rspBO.getWhetherStorePlan().toString()));
        }
        if (agrDetail.getWhetherManageCatalog() != null) {
            rspBO.setWhetherManageCatalogStr(DictionaryFrameworkUtils.getDicDataByCode((String)BooleanFlag.class.getSimpleName(), (String)rspBO.getWhetherManageCatalog().toString()));
        }
        if (agrDetail.getVendorMode() != null) {
            rspBO.setVendorModeStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainVendorMode.class.getSimpleName(), (String)rspBO.getVendorMode().toString()));
        }
        if (agrDetail.getQuaprotectUnit() != null) {
            rspBO.setQuaprotectUnitStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainQuaprotectUnit.class.getSimpleName(), (String)rspBO.getQuaprotectUnit().toString()));
        }
        if (agrDetail.getPurScopeType() != null) {
            rspBO.setPurScopeTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainPurScopeType.class.getSimpleName(), (String)rspBO.getPurScopeType().toString()));
        }
        if (agrDetail.getViewScopeType() != null) {
            rspBO.setViewScopeTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainPurScopeType.class.getSimpleName(), (String)rspBO.getViewScopeType().toString()));
        }
        if (agrDetail.getAgrVersionFormWay() != null) {
            rspBO.setAgrVersionFormWayStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainAgrVersionFormWay.class.getSimpleName(), (String)rspBO.getAgrVersionFormWay().toString()));
        }
        return rspBO;
    }
}

