/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.agrchng.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.dmc.constant.DycProAgrConstants;
import com.tydic.dyc.pro.dmc.repository.agrchng.api.DycProAgrChngRepository;
import com.tydic.dyc.pro.dmc.repository.agrchng.dto.DycProAgrApplicationScopeChngDTO;
import com.tydic.dyc.pro.dmc.repository.agrchng.dto.DycProAgrChngMainDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.api.DycProAgrRepository;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrItemDTO;
import com.tydic.dyc.pro.dmc.service.agrchng.api.DycProAgrChngMainSaveService;
import com.tydic.dyc.pro.dmc.service.agrchng.bo.DycProAgrApplicationScopeChngBO;
import com.tydic.dyc.pro.dmc.service.agrchng.bo.DycProAgrChngMainBO;
import com.tydic.dyc.pro.dmc.service.agrchng.bo.DycProAgrChngMainSaveReqBO;
import com.tydic.dyc.pro.dmc.service.agrchng.bo.DycProAgrChngMainSaveRspBO;
import com.tydic.dyc.pro.dmc.service.agrchng.bo.DycProAgrCooperationChngCatalogBO;
import com.tydic.dyc.pro.dmc.service.agrchng.bo.DycProAgrItemChngBO;
import com.tydic.dyc.pro.dmc.service.agrchng.bo.DycProAgrItemChngOperRecorBO;
import com.tydic.dyc.pro.dmc.service.agreement.bo.DycProAgrFileInfoBO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.agrchng.api.DycProAgrChngMainSaveService"})
public class DycProAgrChngMainSaveServiceImpl
implements DycProAgrChngMainSaveService {
    private static final Logger log = LoggerFactory.getLogger(DycProAgrChngMainSaveServiceImpl.class);
    @Autowired
    private DycProAgrRepository agrMainRepository;
    @Autowired
    private DycProAgrChngRepository agrChngRepository;

    @Override
    @PostMapping(value={"saveAgrChngMain"})
    public DycProAgrChngMainSaveRspBO saveAgrChngMain(@RequestBody DycProAgrChngMainSaveReqBO reqBO) {
        DycProAgrChngMainSaveRspBO rspBO = new DycProAgrChngMainSaveRspBO();
        this.validateParam(reqBO);
        if (reqBO.getAgrChngInfo().getChngType().equals(DycProAgrConstants.AgrChngType.SUPPLEMENT)) {
            this.handleSupplementAgrItemChngResult(reqBO);
        }
        if (reqBO.getAgrChngInfo().getChngApplyId() == null) {
            DycProAgrChngMainBO agrChngMain = this.createAgrChngMain(reqBO);
            rspBO.setChngApplyId(agrChngMain.getChngApplyId());
        } else {
            this.updateAgrChngMain(reqBO);
            rspBO.setChngApplyId(reqBO.getAgrChngInfo().getChngApplyId());
        }
        return rspBO;
    }

    public void handleSupplementAgrItemChngResult(DycProAgrChngMainSaveReqBO reqBO) {
        DycProAgrItemDTO dycProAgrItemDTO = new DycProAgrItemDTO();
        dycProAgrItemDTO.setAgrObjPrimaryId(reqBO.getAgrChngInfo().getAgrObjPrimaryId());
        List agrItemList = this.agrMainRepository.selectAgrItemList(dycProAgrItemDTO);
        log.debug("\u539f\u534f\u8bae\u660e\u7ec6\u96c6\u5408\uff1a{}", (Object)JSON.toJSONString((Object)agrItemList));
        List<DycProAgrItemChngOperRecorBO> changeRecordList = reqBO.getAgrChngInfo().getAgrItemChngOperRecorBOList();
        agrItemList.removeIf(item -> changeRecordList.stream().anyMatch(record -> record.getAgrItemId().equals(item.getAgrItemId()) && record.getAgrItemChngType() == 2));
        changeRecordList.stream().filter(record -> record.getAgrItemChngType() == 1).map(record -> {
            DycProAgrItemDTO dto = new DycProAgrItemDTO();
            BeanUtils.copyProperties((Object)dto, (Object)record);
            return dto;
        }).forEach(agrItemList::add);
        log.debug("\u53d8\u66f4\u540e\u7684\u660e\u7ec6\u7ed3\u679c\u96c6\uff1a{}", (Object)JSON.toJSONString((Object)agrItemList));
        reqBO.getAgrChngInfo().setAgrItemChngBOList(JSON.parseArray((String)JSON.toJSONString((Object)agrItemList), DycProAgrItemChngBO.class));
    }

    public DycProAgrChngMainBO createAgrChngMain(DycProAgrChngMainSaveReqBO reqBO) {
        DycProAgrChngMainDTO insertDTO = (DycProAgrChngMainDTO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO.getAgrChngInfo()), DycProAgrChngMainDTO.class);
        if (Objects.equals(reqBO.getOperType(), DycProAgrConstants.AgrInterfaceOperType.SUBMIT)) {
            insertDTO.setChngApplyStatus(DycProAgrConstants.AgrChngStatus.CONFIRMING);
        }
        ArrayList agrApplicationScopeChngDTOList = new ArrayList();
        if (!CollectionUtils.isEmpty(reqBO.getAgrChngInfo().getPurChngScopeList())) {
            agrApplicationScopeChngDTOList.addAll(JSON.parseArray((String)JSON.toJSONString(reqBO.getAgrChngInfo().getPurChngScopeList()), DycProAgrApplicationScopeChngDTO.class));
        }
        if (!CollectionUtils.isEmpty(reqBO.getAgrChngInfo().getViewChngScopeList())) {
            agrApplicationScopeChngDTOList.addAll(JSON.parseArray((String)JSON.toJSONString(reqBO.getAgrChngInfo().getViewChngScopeList()), DycProAgrApplicationScopeChngDTO.class));
        }
        insertDTO.setAgrApplicationScopeChngDTOList(agrApplicationScopeChngDTOList);
        insertDTO.setCreateUserId(reqBO.getUserId());
        insertDTO.setCreateUserName(reqBO.getName());
        insertDTO.setCreateUserAccount(reqBO.getUserName());
        insertDTO.setCreateCompanyId(reqBO.getCompanyId());
        insertDTO.setCreateOrgId(reqBO.getOrgId());
        insertDTO.setCreateOrgPath(reqBO.getOrgPath());
        insertDTO.setCreateCompanyName(reqBO.getCompanyName());
        insertDTO.setCreateOrgName(reqBO.getOrgName());
        DycProAgrChngMainDTO agrChngInfo = this.agrChngRepository.createAgrChngInfo(insertDTO);
        DycProAgrChngMainBO agrChngMainBO = new DycProAgrChngMainBO();
        agrChngMainBO.setChngApplyId(agrChngInfo.getChngApplyId());
        return agrChngMainBO;
    }

    public void updateAgrChngMain(DycProAgrChngMainSaveReqBO reqBO) {
        DycProAgrChngMainDTO updateChngMainDTO = (DycProAgrChngMainDTO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO.getAgrChngInfo()), DycProAgrChngMainDTO.class);
        if (Objects.equals(reqBO.getOperType(), DycProAgrConstants.AgrInterfaceOperType.SUBMIT)) {
            updateChngMainDTO.setChngApplyStatus(DycProAgrConstants.AgrChngStatus.CONFIRMING);
        }
        ArrayList agrApplicationScopeChngDTOList = new ArrayList();
        if (!CollectionUtils.isEmpty(reqBO.getAgrChngInfo().getPurChngScopeList())) {
            agrApplicationScopeChngDTOList.addAll(JSON.parseArray((String)JSON.toJSONString(reqBO.getAgrChngInfo().getPurChngScopeList()), DycProAgrApplicationScopeChngDTO.class));
        }
        if (!CollectionUtils.isEmpty(reqBO.getAgrChngInfo().getViewChngScopeList())) {
            agrApplicationScopeChngDTOList.addAll(JSON.parseArray((String)JSON.toJSONString(reqBO.getAgrChngInfo().getViewChngScopeList()), DycProAgrApplicationScopeChngDTO.class));
        }
        updateChngMainDTO.setAgrApplicationScopeChngDTOList(agrApplicationScopeChngDTOList);
        updateChngMainDTO.setUpdateUserId(reqBO.getUserId());
        updateChngMainDTO.setUpdateUserName(reqBO.getName());
        updateChngMainDTO.setUpdateUserAccount(reqBO.getUserName());
        updateChngMainDTO.setUpdateCompanyId(reqBO.getCompanyId());
        updateChngMainDTO.setUpdateOrgId(reqBO.getOrgId());
        updateChngMainDTO.setUpdateOrgPath(reqBO.getOrgPath());
        updateChngMainDTO.setUpdateCompanyName(reqBO.getCompanyName());
        updateChngMainDTO.setUpdateOrgName(reqBO.getOrgName());
        this.agrChngRepository.updateAgrChngInfo(updateChngMainDTO);
    }

    private void validateParam(DycProAgrChngMainSaveReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2[reqBO]\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperType()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010operType\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getAgrChngInfo()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010agrChngInfo\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        DycProAgrChngMainBO agrChngInfo = reqBO.getAgrChngInfo();
        if (null == agrChngInfo.getChngType()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010agrChngInfo.chngType\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == agrChngInfo.getChngApplyId()) {
            if (agrChngInfo.getChngType().equals(DycProAgrConstants.AgrChngType.ADJUST_PRICE) && CollectionUtils.isEmpty(agrChngInfo.getAgrItemChngBOList())) {
                throw new ZTBusinessException("\u5165\u53c2\u3010agrChngInfo.agrItemChngBOList\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (agrChngInfo.getChngType().equals(DycProAgrConstants.AgrChngType.SUPPLEMENT)) {
                if (CollectionUtils.isEmpty(agrChngInfo.getAgrItemChngOperRecorBOList())) {
                    throw new ZTBusinessException("\u5165\u53c2\u3010agrChngInfo.agrItemChngOperRecorBOList\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                for (DycProAgrItemChngOperRecorBO agrItemChngOperRecorBO : agrChngInfo.getAgrItemChngOperRecorBOList()) {
                    if (null == agrItemChngOperRecorBO.getAgrItemChngType()) {
                        throw new ZTBusinessException("\u5165\u53c2\u3010agrChngInfo.agrItemChngOperRecorBOList.agrItemChngType\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (1 != agrItemChngOperRecorBO.getAgrItemChngType() && 2 != agrItemChngOperRecorBO.getAgrItemChngType()) {
                        throw new ZTBusinessException("\u5165\u53c2\u3010agrChngInfo.agrItemChngOperRecorBOList.agrItemChngType\u3011\u4e0d\u5408\u6cd5\uff01");
                    }
                    if (2 != agrItemChngOperRecorBO.getAgrItemChngType() || null != agrItemChngOperRecorBO.getAgrItemId()) continue;
                    throw new ZTBusinessException("\u51cf\u5c11\u660e\u7ec6\u8865\u5145\u53d8\u66f4\u5165\u53c2\u3010agrChngInfo.agrItemChngOperRecorBOList.agrItemId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            }
            if (agrChngInfo.getChngType().equals(DycProAgrConstants.AgrChngType.OTHER)) {
                if (null == agrChngInfo.getVendorMode()) {
                    throw new ZTBusinessException("\u5165\u53c2\u3010agrChngInfo.vendorMode\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (agrChngInfo.getVendorMode().equals(DycProAgrConstants.AgrVendorMode.OPER)) {
                    agrChngInfo.setManagementOrgId(reqBO.getCompanyId());
                    agrChngInfo.setManagementOrgName(agrChngInfo.getSupplierName());
                } else if (agrChngInfo.getVendorMode().equals(DycProAgrConstants.AgrVendorMode.SUP)) {
                    agrChngInfo.setManagementOrgId(agrChngInfo.getSupplierId());
                    agrChngInfo.setManagementOrgName(agrChngInfo.getSupplierName());
                } else if (agrChngInfo.getVendorMode().equals(DycProAgrConstants.AgrVendorMode.PUR)) {
                    agrChngInfo.setManagementOrgId(reqBO.getCompanyId());
                    agrChngInfo.setManagementOrgName(reqBO.getCompanyName());
                }
                if (null == agrChngInfo.getAdjustPriceType()) {
                    throw new ZTBusinessException("\u5165\u53c2\u3010agrChngInfo.adjustPriceType\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (null == agrChngInfo.getWhetherHaveItem()) {
                    throw new ZTBusinessException("\u5165\u53c2\u3010agrChngInfo.whetherHaveItem\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (null == agrChngInfo.getWhetherStorePlan()) {
                    throw new ZTBusinessException("\u5165\u53c2\u3010agrChngInfo.whetherStorePlan\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (null != agrChngInfo.getWhetherManageCatalog()) {
                    if (CollectionUtils.isEmpty(agrChngInfo.getAgrCooperationChngCatalogBOList())) {
                        throw new ZTBusinessException("\u5165\u53c2\u3010agrChngInfo.agrCooperationChngCatalogBOList\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    for (DycProAgrCooperationChngCatalogBO catalogBO : agrChngInfo.getAgrCooperationChngCatalogBOList()) {
                        if (ObjectUtils.isEmpty((Object)catalogBO.getManageCatalogId())) {
                            throw new ZTBusinessException("\u3010\u5408\u4f5c\u7c7b\u76eeid\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (ObjectUtils.isEmpty((Object)catalogBO.getManageCatalogName())) {
                            throw new ZTBusinessException("\u3010\u5408\u4f5c\u7c7b\u76ee\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (ObjectUtils.isEmpty((Object)catalogBO.getManageCatalogLevel())) {
                            throw new ZTBusinessException("\u3010\u5408\u4f5c\u7c7b\u76ee\u7b49\u7ea7\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (ObjectUtils.isEmpty((Object)catalogBO.getManageCatalogParentId())) {
                            throw new ZTBusinessException("\u3010\u5408\u4f5c\u76ee\u5f55\u4e0a\u7ea7id\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (ObjectUtils.isEmpty((Object)catalogBO.getDiscountRate())) {
                            throw new ZTBusinessException("\u3010\u6298\u6263\u7387\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (!ObjectUtils.isEmpty((Object)catalogBO.getServiceChargeRate())) continue;
                        throw new ZTBusinessException("\u3010\u670d\u52a1\u8d39\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                }
                if (ObjectUtils.isEmpty((Object)agrChngInfo.getPurScopeType())) {
                    throw new ZTBusinessException("\u3010\u53ef\u91c7\u8d2d\u8303\u56f4\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (DycProAgrConstants.AgrScopeType.SPECIFIED_COMPANY.equals(agrChngInfo.getPurScopeType())) {
                    if (CollectionUtils.isEmpty(agrChngInfo.getPurChngScopeList())) {
                        throw new ZTBusinessException("\u3010\u534f\u8bae\u9002\u7528\u8303\u56f4\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    for (DycProAgrApplicationScopeChngBO scopeBO : agrChngInfo.getPurChngScopeList()) {
                        if (ObjectUtils.isEmpty((Object)scopeBO.getApplicationType())) {
                            throw new ZTBusinessException("\u3010\u9002\u7528\u7c7b\u578b\u9009\u9879\u503c\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (ObjectUtils.isEmpty((Object)scopeBO.getApplicationType())) {
                            throw new ZTBusinessException("\u3010\u9002\u7528\u8303\u56f4\u5355\u4f4dID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (!ObjectUtils.isEmpty((Object)scopeBO.getApplicationScopeOrgTreePath())) continue;
                        throw new ZTBusinessException("\u3010\u9002\u7528\u5355\u4f4d\u673a\u6784\u6811\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                }
                if (DycProAgrConstants.AgrScopeType.SPECIFIED_COMPANY.equals(agrChngInfo.getViewScopeType())) {
                    if (CollectionUtils.isEmpty(agrChngInfo.getViewChngScopeList())) {
                        throw new ZTBusinessException("\u3010\u534f\u8bae\u9002\u7528\u8303\u56f4\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    for (DycProAgrApplicationScopeChngBO scopeBO : agrChngInfo.getViewChngScopeList()) {
                        if (ObjectUtils.isEmpty((Object)scopeBO.getApplicationType())) {
                            throw new ZTBusinessException("\u3010\u9002\u7528\u7c7b\u578b\u9009\u9879\u503c\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (ObjectUtils.isEmpty((Object)scopeBO.getApplicationType())) {
                            throw new ZTBusinessException("\u3010\u9002\u7528\u8303\u56f4\u5355\u4f4dID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (!ObjectUtils.isEmpty((Object)scopeBO.getApplicationScopeOrgTreePath())) continue;
                        throw new ZTBusinessException("\u3010\u9002\u7528\u5355\u4f4d\u673a\u6784\u6811\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                }
            }
        } else if (ObjectUtils.isEmpty((Object)agrChngInfo.getChngApplyId())) {
            throw new ZTBusinessException("\u3010\u53d8\u66f4\u7533\u8bf7ID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!ObjectUtils.isEmpty(agrChngInfo.getAgrFileInfoBOList())) {
            for (DycProAgrFileInfoBO fileInfoBO : agrChngInfo.getAgrFileInfoBOList()) {
                if (ObjectUtils.isEmpty((Object)fileInfoBO.getFileName())) {
                    throw new ZTBusinessException("\u3010\u9644\u4ef6\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!ObjectUtils.isEmpty((Object)fileInfoBO.getFileUrl())) continue;
                throw new ZTBusinessException("\u3010\u9644\u4ef6url\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

