/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.agreement.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.enums.BooleanFlag;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainAdjustPriceType;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainAgrMode;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainAgrSrc;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainAgrStatus;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainAgrType;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainAgrVersionFormWay;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainAgreementVariety;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainPurScopeType;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainQuaprotectUnit;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainTradeMode;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainVendorMode;
import com.tydic.dyc.pro.base.core.dictionary.enums.EnableFlag;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.dmc.repository.agreement.api.DycProAgrRepository;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrMainDTO;
import com.tydic.dyc.pro.dmc.service.agreement.api.DycProAgrDetailQryService;
import com.tydic.dyc.pro.dmc.service.agreement.bo.DycProAgrCooperationCatalogBO;
import com.tydic.dyc.pro.dmc.service.agreement.bo.DycProAgrDetailQryReqBO;
import com.tydic.dyc.pro.dmc.service.agreement.bo.DycProAgrDetailQryRspBO;
import com.tydic.dyc.pro.dmc.service.agreement.bo.DycProAgrMainBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.agreement.api.DycProAgrDetailQryService"})
public class DycProAgrDetailQryServiceImpl
implements DycProAgrDetailQryService {
    @Autowired
    private DycProAgrRepository agrMainRepository;

    @Override
    @PostMapping(value={"qryAgrDetail"})
    public DycProAgrDetailQryRspBO qryAgrDetail(@RequestBody DycProAgrDetailQryReqBO reqBO) {
        this.judge(reqBO);
        DycProAgrDetailQryRspBO rspBO = new DycProAgrDetailQryRspBO();
        rspBO.setAgrInfo(this.getAgrDetail(reqBO));
        return rspBO;
    }

    private void judge(DycProAgrDetailQryReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getAgrObjPrimaryId())) {
            if (ObjectUtils.isEmpty((Object)reqBO.getAgrVersion())) {
                throw new ZTBusinessException("\u3010\u534f\u8bae\u7248\u672c\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)reqBO.getAgrCode()) && ObjectUtils.isEmpty((Object)reqBO.getAgrId())) {
                throw new ZTBusinessException("\u3010\u534f\u8baeid\u3011\u6216\u3010\u534f\u8bae\u7f16\u53f7\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    private DycProAgrMainBO getAgrDetail(DycProAgrDetailQryReqBO reqBO) {
        DycProAgrMainDTO qryDTO = new DycProAgrMainDTO();
        qryDTO.setAgrObjPrimaryId(reqBO.getAgrObjPrimaryId());
        qryDTO.setAgrId(reqBO.getAgrId());
        qryDTO.setAgrCode(reqBO.getAgrCode());
        qryDTO.setAgrVersion(reqBO.getAgrVersion());
        DycProAgrMainDTO agrDetail = this.agrMainRepository.getAgrDetail(qryDTO);
        DycProAgrMainBO agrInfo = (DycProAgrMainBO)JSON.parseObject((String)JSON.toJSONString((Object)agrDetail), DycProAgrMainBO.class);
        if (agrInfo.getWhetherManageCatalog() != null && BooleanFlag.YES.getCode().equals(agrInfo.getWhetherManageCatalog().toString()) && !CollectionUtils.isEmpty(agrInfo.getAgrCooperationCatalogList())) {
            agrInfo.setLastLevelCount(this.getLastLevelCount(agrInfo.getAgrCooperationCatalogList()));
            agrInfo.getAgrCooperationCatalogList().forEach(e -> {
                if (e.getEnableFlag() != null) {
                    e.setEnableFlagStr(DictionaryFrameworkUtils.getDicDataByCode((String)EnableFlag.class.getSimpleName(), (String)e.getEnableFlag().toString()));
                }
            });
            agrInfo.setAgrCooperationCatalogList(this.buildCatalogTree(agrInfo.getAgrCooperationCatalogList()));
        }
        if (agrInfo.getAgrType() != null) {
            agrInfo.setAgrTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainAgrType.class.getSimpleName(), (String)agrInfo.getAgrType().toString()));
        }
        if (agrInfo.getAgrSrc() != null) {
            agrInfo.setAgrSrcStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainAgrSrc.class.getSimpleName(), (String)agrInfo.getAgrSrc().toString()));
        }
        if (agrInfo.getAgrStatus() != null) {
            agrInfo.setAgrStatusStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainAgrStatus.class.getSimpleName(), (String)agrInfo.getAgrStatus().toString()));
        }
        if (agrInfo.getAgrMode() != null) {
            agrInfo.setAgrModeStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainAgrMode.class.getSimpleName(), (String)agrInfo.getAgrMode().toString()));
        }
        if (agrInfo.getTradeMode() != null) {
            agrInfo.setTradeModeStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainTradeMode.class.getSimpleName(), (String)agrInfo.getTradeMode().toString()));
        }
        if (agrInfo.getAgreementVariety() != null) {
            agrInfo.setAgreementVarietyStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainAgreementVariety.class.getSimpleName(), (String)agrInfo.getAgreementVariety().toString()));
        }
        if (agrInfo.getAdjustPriceType() != null) {
            agrInfo.setAdjustPriceTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainAdjustPriceType.class.getSimpleName(), (String)agrInfo.getAdjustPriceType().toString()));
        }
        if (agrInfo.getWhetherHaveItem() != null) {
            agrInfo.setWhetherHaveItemStr(DictionaryFrameworkUtils.getDicDataByCode((String)BooleanFlag.class.getSimpleName(), (String)agrInfo.getWhetherHaveItem().toString()));
        }
        if (agrInfo.getWhetherStorePlan() != null) {
            agrInfo.setWhetherStorePlanStr(DictionaryFrameworkUtils.getDicDataByCode((String)BooleanFlag.class.getSimpleName(), (String)agrInfo.getWhetherStorePlan().toString()));
        }
        if (agrInfo.getWhetherManageCatalog() != null) {
            agrInfo.setWhetherManageCatalogStr(DictionaryFrameworkUtils.getDicDataByCode((String)BooleanFlag.class.getSimpleName(), (String)agrInfo.getWhetherManageCatalog().toString()));
        }
        if (agrInfo.getVendorMode() != null) {
            agrInfo.setVendorModeStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainVendorMode.class.getSimpleName(), (String)agrInfo.getVendorMode().toString()));
        }
        if (agrInfo.getQuaprotectUnit() != null) {
            agrInfo.setQuaprotectUnitStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainQuaprotectUnit.class.getSimpleName(), (String)agrInfo.getQuaprotectUnit().toString()));
        }
        if (agrInfo.getPurScopeType() != null) {
            agrInfo.setPurScopeTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainPurScopeType.class.getSimpleName(), (String)agrInfo.getPurScopeType().toString()));
        }
        if (agrInfo.getViewScopeType() != null) {
            agrInfo.setViewScopeTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainPurScopeType.class.getSimpleName(), (String)agrInfo.getViewScopeType().toString()));
        }
        if (agrInfo.getAgrVersionFormWay() != null) {
            agrInfo.setAgrVersionFormWayStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrMainAgrVersionFormWay.class.getSimpleName(), (String)agrInfo.getAgrVersionFormWay().toString()));
        }
        return agrInfo;
    }

    public List<DycProAgrCooperationCatalogBO> buildCatalogTree(List<DycProAgrCooperationCatalogBO> flatList) {
        ArrayList<DycProAgrCooperationCatalogBO> result = new ArrayList<DycProAgrCooperationCatalogBO>();
        HashMap<Long, DycProAgrCooperationCatalogBO> nodeMap = new HashMap<Long, DycProAgrCooperationCatalogBO>();
        for (DycProAgrCooperationCatalogBO node : flatList) {
            node.setChildren(new ArrayList<DycProAgrCooperationCatalogBO>());
            nodeMap.put(node.getManageCatalogId(), node);
        }
        for (DycProAgrCooperationCatalogBO node : flatList) {
            Long parentId = node.getManageCatalogParentId();
            if (parentId != null && parentId > 0L) {
                DycProAgrCooperationCatalogBO parent = (DycProAgrCooperationCatalogBO)nodeMap.get(parentId);
                if (parent == null) continue;
                parent.getChildren().add(node);
                continue;
            }
            result.add(node);
        }
        return result;
    }

    public long getLastLevelCount(List<DycProAgrCooperationCatalogBO> catalogBOList) {
        List manageCatalogParentIds = catalogBOList.stream().map(DycProAgrCooperationCatalogBO::getManageCatalogParentId).collect(Collectors.toList());
        return catalogBOList.stream().filter(e -> !manageCatalogParentIds.contains(e.getManageCatalogId())).count();
    }
}

