/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.agreement.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainAgrStatus;
import com.tydic.dyc.pro.dmc.constant.DycProAgrConstants;
import com.tydic.dyc.pro.dmc.repository.agreement.api.DycProAgrRepository;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrItemDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrListQryDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrMainDTO;
import com.tydic.dyc.pro.dmc.service.agreement.api.DycProAgrMainSaveService;
import com.tydic.dyc.pro.dmc.service.agreement.bo.DycProAgrApplicationScopeBO;
import com.tydic.dyc.pro.dmc.service.agreement.bo.DycProAgrCooperationCatalogBO;
import com.tydic.dyc.pro.dmc.service.agreement.bo.DycProAgrFileInfoBO;
import com.tydic.dyc.pro.dmc.service.agreement.bo.DycProAgrMainBO;
import com.tydic.dyc.pro.dmc.service.agreement.bo.DycProAgrMainSaveReqBO;
import com.tydic.dyc.pro.dmc.service.agreement.bo.DycProAgrMainSaveRspBO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.agreement.api.DycProAgrMainSaveService"})
public class DycProAgrMainSaveServiceImpl
implements DycProAgrMainSaveService {
    @Autowired
    private DycProAgrRepository agrMainRepository;

    @Override
    @PostMapping(value={"saveAgrMain"})
    public DycProAgrMainSaveRspBO saveAgrMain(@RequestBody DycProAgrMainSaveReqBO reqBO) {
        this.judge(reqBO);
        DycProAgrMainSaveRspBO rspBO = new DycProAgrMainSaveRspBO();
        if (reqBO.getAgrInfo().getAgrObjPrimaryId() == null) {
            DycProAgrMainDTO agrMain = this.createAgrMain(reqBO);
            rspBO.setAgrObjPrimaryId(agrMain.getAgrObjPrimaryId());
            rspBO.setAgrId(agrMain.getAgrId());
        } else {
            this.updateAgrMain(reqBO);
            rspBO.setAgrObjPrimaryId(reqBO.getAgrInfo().getAgrObjPrimaryId());
            rspBO.setAgrId(reqBO.getAgrInfo().getAgrId());
        }
        if (Objects.equals(reqBO.getOperType(), DycProAgrConstants.AgrInterfaceOperType.SUBMIT)) {
            this.checkBeforeFlow(rspBO);
        }
        return rspBO;
    }

    private DycProAgrMainDTO createAgrMain(DycProAgrMainSaveReqBO reqBO) {
        DycProAgrMainDTO insertDTO = (DycProAgrMainDTO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO.getAgrInfo()), DycProAgrMainDTO.class);
        insertDTO.setAgrSrc(DycProAgrConstants.AgrSrc.HANDLE_CERATE);
        insertDTO.setManagementOrgId(reqBO.getOrgId());
        insertDTO.setManagementOrgName(reqBO.getOrgName());
        if (Objects.equals(reqBO.getOperType(), DycProAgrConstants.AgrInterfaceOperType.SUBMIT)) {
            insertDTO.setAgrStatus(Integer.valueOf(Integer.parseInt(DmcAgrMainAgrStatus.PENDING_REVIEW.getCode())));
        }
        insertDTO.setAgrApplicationScopeList(null);
        insertDTO.setCreateUserId(reqBO.getUserId());
        insertDTO.setCreateUserName(reqBO.getName());
        insertDTO.setCreateUserAccount(reqBO.getUserName());
        insertDTO.setCreateCompanyId(reqBO.getCompanyId());
        insertDTO.setCreateOrgId(reqBO.getOrgId());
        insertDTO.setCreateOrgPath(reqBO.getOrgPath());
        insertDTO.setCreateCompanyName(reqBO.getCompanyName());
        insertDTO.setCreateOrgName(reqBO.getOrgName());
        insertDTO.setCreateTime(new Date(System.currentTimeMillis()));
        return this.agrMainRepository.createAgrMain(insertDTO);
    }

    private void checkBeforeFlow(DycProAgrMainSaveRspBO rspBO) {
        if (ObjectUtils.isEmpty((Object)rspBO.getAgrObjPrimaryId())) {
            throw new ZTBusinessException("\u63d0\u4ea4\u65f6agrObjPrimaryId\u8fd4\u56de\u4e3a\u7a7a");
        }
        DycProAgrListQryDTO agrListQryDTO = new DycProAgrListQryDTO();
        agrListQryDTO.setAgrObjPrimaryId(rspBO.getAgrObjPrimaryId());
        List agrMainList = this.agrMainRepository.selectAgrMainList(agrListQryDTO);
        if (CollectionUtils.isEmpty((Collection)agrMainList)) {
            throw new ZTBusinessException("\u534f\u8bae\u67e5\u8be2\u4e3a\u7a7a");
        }
        if (DycProAgrConstants.AgrBooleanFlag.YES.equals(((DycProAgrMainDTO)agrMainList.get(0)).getWhetherHaveItem())) {
            DycProAgrItemDTO dycProAgrItemDTO = new DycProAgrItemDTO();
            dycProAgrItemDTO.setAgrObjPrimaryId(rspBO.getAgrObjPrimaryId());
            List agrItemList = this.agrMainRepository.selectAgrItemList(dycProAgrItemDTO);
            if (!CollectionUtils.isEmpty((Collection)agrItemList)) {
                throw new ZTBusinessException("\u534f\u8bae\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    private void updateAgrMain(DycProAgrMainSaveReqBO reqBO) {
        DycProAgrMainDTO updateDTO = (DycProAgrMainDTO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO.getAgrInfo()), DycProAgrMainDTO.class);
        updateDTO.setAgrApplicationScopeList(null);
        updateDTO.setUpdateUserId(reqBO.getUserId());
        updateDTO.setUpdateUserName(reqBO.getName());
        updateDTO.setUpdateUserAccount(reqBO.getUserName());
        updateDTO.setUpdateCompanyId(reqBO.getCompanyId());
        updateDTO.setUpdateOrgId(reqBO.getOrgId());
        updateDTO.setUpdateOrgPath(reqBO.getOrgPath());
        updateDTO.setUpdateCompanyName(reqBO.getCompanyName());
        updateDTO.setUpdateOrgName(reqBO.getOrgName());
        updateDTO.setUpdateTime(new Date(System.currentTimeMillis()));
        this.agrMainRepository.updateAgrMain(updateDTO);
    }

    private void judge(DycProAgrMainSaveReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getOperType())) {
            throw new ZTBusinessException("\u3010\u64cd\u4f5c\u7c7b\u578b\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getAgrInfo())) {
            throw new ZTBusinessException("\u3010\u534f\u8bae\u4fe1\u606f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DycProAgrMainBO agrInfo = reqBO.getAgrInfo();
        if (ObjectUtils.isEmpty((Object)agrInfo.getAgrObjPrimaryId())) {
            if (ObjectUtils.isEmpty((Object)agrInfo.getAgrType())) {
                throw new ZTBusinessException("\u3010\u534f\u8bae\u79cd\u7c7b\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)agrInfo.getAgrSrc())) {
                throw new ZTBusinessException("\u3010\u534f\u8bae\u6765\u6e90\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)agrInfo.getAgrName())) {
                throw new ZTBusinessException("\u3010\u534f\u8bae\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)agrInfo.getAgrMode())) {
                throw new ZTBusinessException("\u3010\u534f\u8bae\u6a21\u5f0f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)agrInfo.getTradeMode())) {
                throw new ZTBusinessException("\u3010\u4ea4\u6613\u6a21\u5f0f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)agrInfo.getAgreementVariety())) {
                throw new ZTBusinessException("\u3010\u91c7\u8d2d\u7c7b\u522b\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)agrInfo.getAdjustPriceType())) {
                throw new ZTBusinessException("\u3010\u8c03\u4ef7\u673a\u5236\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)agrInfo.getWhetherHaveItem())) {
                throw new ZTBusinessException("\u3010\u662f\u5426\u521b\u5efa\u534f\u8bae\u660e\u7ec6\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)agrInfo.getWhetherStorePlan())) {
                throw new ZTBusinessException("\u3010\u662f\u5426\u94fa\u8d27\u6807\u8bc6\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)agrInfo.getWhetherManageCatalog())) {
                throw new ZTBusinessException("\u3010\u662f\u5426\u7ba1\u7406\u5408\u4f5c\u7c7b\u76ee\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (DycProAgrConstants.AgrBooleanFlag.YES.equals(agrInfo.getWhetherManageCatalog())) {
                if (CollectionUtils.isEmpty(agrInfo.getAgrCooperationCatalogList())) {
                    throw new ZTBusinessException("\u3010\u534f\u8bae\u5408\u4f5c\u7c7b\u76ee\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                for (DycProAgrCooperationCatalogBO catalogBO : agrInfo.getAgrCooperationCatalogList()) {
                    if (ObjectUtils.isEmpty((Object)catalogBO.getManageCatalogId())) {
                        throw new ZTBusinessException("\u3010\u5408\u4f5c\u7c7b\u76eeid\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (ObjectUtils.isEmpty((Object)catalogBO.getManageCatalogName())) {
                        throw new ZTBusinessException("\u3010\u5408\u4f5c\u7c7b\u76ee\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (ObjectUtils.isEmpty((Object)catalogBO.getManageCatalogLevel())) {
                        throw new ZTBusinessException("\u3010\u5408\u4f5c\u7c7b\u76ee\u7b49\u7ea7\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (ObjectUtils.isEmpty((Object)catalogBO.getManageCatalogParentId())) {
                        throw new ZTBusinessException("\u3010\u5408\u4f5c\u76ee\u5f55\u4e0a\u7ea7id\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (ObjectUtils.isEmpty((Object)catalogBO.getDiscountRate())) {
                        throw new ZTBusinessException("\u3010\u6298\u6263\u7387\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (ObjectUtils.isEmpty((Object)catalogBO.getServiceChargeRate())) {
                        throw new ZTBusinessException("\u3010\u670d\u52a1\u8d39\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (ObjectUtils.isEmpty((Object)catalogBO.getManageCatalogPath())) {
                        throw new ZTBusinessException("\u3010\u7ba1\u7406\u76ee\u5f55id\u8def\u5f84\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (!ObjectUtils.isEmpty((Object)catalogBO.getManageCatalogPathName())) continue;
                    throw new ZTBusinessException("\u3010\u7ba1\u7406\u76ee\u5f55\u540d\u79f0\u8def\u5f84\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            if (ObjectUtils.isEmpty((Object)agrInfo.getPurScopeType())) {
                throw new ZTBusinessException("\u3010\u53ef\u91c7\u8d2d\u8303\u56f4\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!DycProAgrConstants.AgrScopeType.ALL.equals(agrInfo.getPurScopeType())) {
                if (CollectionUtils.isEmpty(agrInfo.getPurScopeList())) {
                    throw new ZTBusinessException("\u3010\u534f\u8bae\u9002\u7528\u8303\u56f4\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                for (DycProAgrApplicationScopeBO scopeBO : agrInfo.getPurScopeList()) {
                    if (ObjectUtils.isEmpty((Object)scopeBO.getApplicationType())) {
                        throw new ZTBusinessException("\u3010\u9002\u7528\u7c7b\u578b\u9009\u9879\u503c\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (ObjectUtils.isEmpty((Object)scopeBO.getApplicationType())) {
                        throw new ZTBusinessException("\u3010\u9002\u7528\u8303\u56f4\u5355\u4f4dID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (!ObjectUtils.isEmpty((Object)scopeBO.getApplicationScopeOrgTreePath())) continue;
                    throw new ZTBusinessException("\u3010\u9002\u7528\u5355\u4f4d\u673a\u6784\u6811\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            if (ObjectUtils.isEmpty((Object)agrInfo.getViewScopeType())) {
                agrInfo.setViewScopeType(agrInfo.getPurScopeType());
                if (!CollectionUtils.isEmpty(agrInfo.getPurScopeList())) {
                    List viewScopeList = JSON.parseArray((String)JSON.toJSONString(agrInfo.getPurScopeList()), DycProAgrApplicationScopeBO.class);
                    viewScopeList.forEach(e -> e.setApplicationType(DycProAgrConstants.AgrScopeApplicationType.VIEW_SCOPE));
                    agrInfo.setViewScopeList(viewScopeList);
                }
            }
            if (!DycProAgrConstants.AgrScopeType.ALL.equals(agrInfo.getViewScopeType())) {
                if (CollectionUtils.isEmpty(agrInfo.getViewScopeList())) {
                    throw new ZTBusinessException("\u3010\u534f\u8bae\u9002\u7528\u8303\u56f4\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                for (DycProAgrApplicationScopeBO scopeBO : agrInfo.getViewScopeList()) {
                    if (ObjectUtils.isEmpty((Object)scopeBO.getApplicationType())) {
                        throw new ZTBusinessException("\u3010\u9002\u7528\u7c7b\u578b\u9009\u9879\u503c\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (ObjectUtils.isEmpty((Object)scopeBO.getApplicationType())) {
                        throw new ZTBusinessException("\u3010\u9002\u7528\u8303\u56f4\u5355\u4f4dID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (!ObjectUtils.isEmpty((Object)scopeBO.getApplicationScopeOrgTreePath())) continue;
                    throw new ZTBusinessException("\u3010\u9002\u7528\u5355\u4f4d\u673a\u6784\u6811\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            if (ObjectUtils.isEmpty((Object)agrInfo.getVendorMode())) {
                throw new ZTBusinessException("\u3010\u94fa\u8d27\u65b9\u5f0f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)agrInfo.getAgrSignDate())) {
                throw new ZTBusinessException("\u3010\u534f\u8bae\u7b7e\u8ba2\u65e5\u671f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)agrInfo.getEffDate())) {
                throw new ZTBusinessException("\u3010\u534f\u8bae\u751f\u6548\u65e5\u671f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)agrInfo.getExpDate())) {
                throw new ZTBusinessException("\u3010\u534f\u8bae\u5931\u6548\u65e5\u671f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)agrInfo.getSupplierId())) {
                throw new ZTBusinessException("\u3010\u4f9b\u8d27\u5546ID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)agrInfo.getSupplierName())) {
                throw new ZTBusinessException("\u3010\u4f9b\u8d27\u5546\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)agrInfo.getSupplierContact())) {
                throw new ZTBusinessException("\u3010\u4f9b\u8d27\u5546\u8054\u7cfb\u4eba\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)agrInfo.getSupplierPhone())) {
                throw new ZTBusinessException("\u3010\u4f9b\u8d27\u5546\u8054\u7cfb\u7535\u8bdd\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)agrInfo.getQuaprotectCount())) {
                throw new ZTBusinessException("\u3010\u8d28\u4fdd\u671f\u65f6\u95f4\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)agrInfo.getQuaprotectUnit())) {
                throw new ZTBusinessException("\u3010\u8d28\u4fdd\u5468\u671f\u5355\u4f4d\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            if (ObjectUtils.isEmpty((Object)agrInfo.getAgrObjPrimaryId())) {
                throw new ZTBusinessException("\u3010\u534f\u8bae\u5bf9\u8c61\u552f\u4e00ID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)agrInfo.getAgrId())) {
                throw new ZTBusinessException("\u3010\u534f\u8baeID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (!ObjectUtils.isEmpty(agrInfo.getAgrFileInfoList())) {
            for (DycProAgrFileInfoBO fileInfoBO : agrInfo.getAgrFileInfoList()) {
                if (ObjectUtils.isEmpty((Object)fileInfoBO.getFileName())) {
                    throw new ZTBusinessException("\u3010\u9644\u4ef6\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!ObjectUtils.isEmpty((Object)fileInfoBO.getFileUrl())) continue;
                throw new ZTBusinessException("\u3010\u9644\u4ef6url\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

