/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.repository.agreement.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.core.dictionary.enums.BooleanFlag;
import com.tydic.dyc.pro.base.core.dictionary.enums.DelFlag;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainAgrStatus;
import com.tydic.dyc.pro.base.core.encode.service.api.EncodeSerialService;
import com.tydic.dyc.pro.base.core.encode.service.bo.EncodeSerialReqBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.EncodeSerialRspBO;
import com.tydic.dyc.pro.dmc.constant.DycProAgrConstants;
import com.tydic.dyc.pro.dmc.dao.AgrApplicationScopeMapper;
import com.tydic.dyc.pro.dmc.dao.AgrCooperationCatalogMapper;
import com.tydic.dyc.pro.dmc.dao.AgrFileInfoMapper;
import com.tydic.dyc.pro.dmc.dao.AgrItemMapper;
import com.tydic.dyc.pro.dmc.dao.AgrMainMapper;
import com.tydic.dyc.pro.dmc.po.AgrApplicationScopePO;
import com.tydic.dyc.pro.dmc.po.AgrCooperationCatalogPO;
import com.tydic.dyc.pro.dmc.po.AgrFileInfoPO;
import com.tydic.dyc.pro.dmc.po.AgrItemPO;
import com.tydic.dyc.pro.dmc.po.AgrMainPO;
import com.tydic.dyc.pro.dmc.po.AgrMainQryPO;
import com.tydic.dyc.pro.dmc.repository.agreement.api.DycProAgrRepository;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrApplicationScopeDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrCooperationCatalogDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrFileInfoDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrItemDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrItemListQryDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrListQryDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrMainDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class DycProAgrRepositoryImpl
implements DycProAgrRepository {
    @Autowired
    private AgrMainMapper agrMainMapper;
    @Autowired
    private AgrCooperationCatalogMapper agrCooperationCatalogMapper;
    @Autowired
    private AgrApplicationScopeMapper agrApplicationScopeMapper;
    @Autowired
    private AgrFileInfoMapper agrFileInfoMapper;
    @Autowired
    private AgrItemMapper agrItemMapper;
    @Autowired
    private EncodeSerialService encodeSerialService;

    @Override
    public DycProAgrMainDTO createAgrMain(DycProAgrMainDTO dycProAgrMainDTO) {
        if (ObjectUtils.isEmpty((Object)dycProAgrMainDTO.getAgrSrc())) {
            throw new ZTBusinessException("\u3010\u534f\u8bae\u6765\u6e90\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        dycProAgrMainDTO.setAgrObjPrimaryId(Sequence.getInstance().nextId());
        dycProAgrMainDTO.setAgrId(Sequence.getInstance().nextId());
        EncodeSerialReqBO encodeSerialReqBO = new EncodeSerialReqBO();
        encodeSerialReqBO.setCenterCode("agreement");
        encodeSerialReqBO.setEncodeRuleCode("AGREEMENT_RULE_CODE");
        encodeSerialReqBO.setNum(Long.valueOf(1L));
        EncodeSerialRspBO encode = this.encodeSerialService.getEncode(encodeSerialReqBO);
        dycProAgrMainDTO.setAgrCode((String)encode.getSerialNoList().get(0));
        if (ObjectUtils.isEmpty((Object)dycProAgrMainDTO.getAgrVersion())) {
            dycProAgrMainDTO.setAgrVersion(1);
        }
        if (ObjectUtils.isEmpty((Object)dycProAgrMainDTO.getAgrStatus())) {
            dycProAgrMainDTO.setAgrStatus(DycProAgrConstants.AgrStatus.DRAFT);
        }
        if (ObjectUtils.isEmpty((Object)dycProAgrMainDTO.getAgrVersionFormWay())) {
            dycProAgrMainDTO.setAgrVersionFormWay(DycProAgrConstants.AgrVersionFormWay.ORIGINAL);
        }
        if (ObjectUtils.isEmpty((Object)dycProAgrMainDTO.getDelFlag())) {
            dycProAgrMainDTO.setDelFlag(DycProAgrConstants.AgrDelFlag.UN_DELETE);
        }
        AgrMainPO agrMainPO = (AgrMainPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProAgrMainDTO), AgrMainPO.class);
        this.agrMainMapper.insert(agrMainPO);
        if (DycProAgrConstants.AgrBooleanFlag.YES.equals(dycProAgrMainDTO.getWhetherManageCatalog()) && !CollectionUtils.isEmpty(dycProAgrMainDTO.getAgrCooperationCatalogList())) {
            for (DycProAgrCooperationCatalogDTO dycProAgrCooperationCatalogDTO : dycProAgrMainDTO.getAgrCooperationCatalogList()) {
                dycProAgrCooperationCatalogDTO.setAgrCooperationCatalogId(Sequence.getInstance().nextId());
                dycProAgrCooperationCatalogDTO.setAgrObjPrimaryId(agrMainPO.getAgrObjPrimaryId());
                dycProAgrCooperationCatalogDTO.setAgrId(agrMainPO.getAgrId());
            }
            List catalogPOS = JSON.parseArray((String)JSON.toJSONString(dycProAgrMainDTO.getAgrCooperationCatalogList()), AgrCooperationCatalogPO.class);
            this.agrCooperationCatalogMapper.insertBatch(catalogPOS);
        }
        this.dealScopList(dycProAgrMainDTO, agrMainPO.getAgrObjPrimaryId(), agrMainPO.getAgrId(), agrMainPO);
        if (!CollectionUtils.isEmpty(dycProAgrMainDTO.getAgrFileInfoList())) {
            for (DycProAgrFileInfoDTO dycProAgrFileInfoDTO : dycProAgrMainDTO.getAgrFileInfoList()) {
                dycProAgrFileInfoDTO.setAgrFileId(Sequence.getInstance().nextId());
                dycProAgrFileInfoDTO.setObjId(agrMainPO.getAgrObjPrimaryId());
                dycProAgrFileInfoDTO.setObjType(DycProAgrConstants.AgrFilObjType.AGR_MAIN);
            }
            List fileInfoPOS = JSON.parseArray((String)JSON.toJSONString(dycProAgrMainDTO.getAgrFileInfoList()), AgrFileInfoPO.class);
            this.agrFileInfoMapper.insertBatch(fileInfoPOS);
        }
        return dycProAgrMainDTO;
    }

    private void dealScopList(DycProAgrMainDTO dycProAgrMainDTO, Long agrObjPrimaryId, Long agrId, AgrMainPO agrMainPO) {
        if (!CollectionUtils.isEmpty(dycProAgrMainDTO.getPurScopeList())) {
            if (!CollectionUtils.isEmpty(dycProAgrMainDTO.getAgrApplicationScopeList())) {
                dycProAgrMainDTO.getAgrApplicationScopeList().addAll(dycProAgrMainDTO.getPurScopeList());
            } else {
                dycProAgrMainDTO.setAgrApplicationScopeList(dycProAgrMainDTO.getPurScopeList());
            }
        }
        if (!CollectionUtils.isEmpty(dycProAgrMainDTO.getViewScopeList())) {
            if (!CollectionUtils.isEmpty(dycProAgrMainDTO.getAgrApplicationScopeList())) {
                dycProAgrMainDTO.getAgrApplicationScopeList().addAll(dycProAgrMainDTO.getViewScopeList());
            } else {
                dycProAgrMainDTO.setAgrApplicationScopeList(dycProAgrMainDTO.getViewScopeList());
            }
        }
        if (!CollectionUtils.isEmpty(dycProAgrMainDTO.getAgrApplicationScopeList())) {
            for (DycProAgrApplicationScopeDTO each : dycProAgrMainDTO.getAgrApplicationScopeList()) {
                each.setApplicationScopeId(Sequence.getInstance().nextId());
                each.setAgrObjPrimaryId(agrObjPrimaryId);
                each.setAgrId(agrId);
            }
            List scopePOS = JSON.parseArray((String)JSON.toJSONString(dycProAgrMainDTO.getAgrApplicationScopeList()), AgrApplicationScopePO.class);
            this.agrApplicationScopeMapper.insertBatch(scopePOS);
        }
    }

    @Override
    public DycProAgrMainDTO getAgrDetail(DycProAgrMainDTO dycProAgrMainDTO) {
        AgrMainPO agrMainPO;
        if (dycProAgrMainDTO == null) {
            throw new ZTBusinessException("\u534f\u8bae\u8be6\u60c5\u67e5\u8be2 \u57fa\u5efa\u5c42\u5165\u53c2\u4e3a\u7a7a");
        }
        LambdaQueryWrapper mainQryWrapper = new LambdaQueryWrapper();
        mainQryWrapper.eq(!ObjectUtils.isEmpty((Object)dycProAgrMainDTO.getAgrObjPrimaryId()), AgrMainPO::getAgrObjPrimaryId, (Object)dycProAgrMainDTO.getAgrObjPrimaryId());
        mainQryWrapper.eq(!ObjectUtils.isEmpty((Object)dycProAgrMainDTO.getAgrId()), AgrMainPO::getAgrId, (Object)dycProAgrMainDTO.getAgrId());
        mainQryWrapper.eq(!ObjectUtils.isEmpty((Object)dycProAgrMainDTO.getAgrCode()), AgrMainPO::getAgrCode, (Object)dycProAgrMainDTO.getAgrCode());
        mainQryWrapper.eq(!ObjectUtils.isEmpty((Object)dycProAgrMainDTO.getAgrVersion()), AgrMainPO::getAgrVersion, (Object)dycProAgrMainDTO.getAgrVersion());
        if (dycProAgrMainDTO.getAgrId() != null && dycProAgrMainDTO.getAgrVersion() == null && dycProAgrMainDTO.getAgrObjPrimaryId() == null) {
            mainQryWrapper.ne(AgrMainPO::getAgrStatus, (Object)Integer.parseInt(DmcAgrMainAgrStatus.HISTORY.getCode()));
        }
        if ((agrMainPO = (AgrMainPO)this.agrMainMapper.selectOne((Wrapper)mainQryWrapper)) == null) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u534f\u8bae\u8be6\u60c5");
        }
        DycProAgrMainDTO agrDetail = (DycProAgrMainDTO)JSON.parseObject((String)JSON.toJSONString((Object)agrMainPO), DycProAgrMainDTO.class);
        if (DycProAgrConstants.AgrBooleanFlag.YES.equals(agrDetail.getWhetherManageCatalog())) {
            LambdaQueryWrapper catalogQryWrapper = new LambdaQueryWrapper();
            catalogQryWrapper.eq(AgrCooperationCatalogPO::getAgrObjPrimaryId, (Object)agrDetail.getAgrObjPrimaryId());
            List agrCooperationCatalogPOS = this.agrCooperationCatalogMapper.selectList((Wrapper)catalogQryWrapper);
            if (!CollectionUtils.isEmpty((Collection)agrCooperationCatalogPOS)) {
                agrDetail.setAgrCooperationCatalogList(JSON.parseArray((String)JSON.toJSONString((Object)agrCooperationCatalogPOS), DycProAgrCooperationCatalogDTO.class));
            }
        }
        LambdaQueryWrapper scopePOQueryWrapper = new LambdaQueryWrapper();
        scopePOQueryWrapper.eq(AgrApplicationScopePO::getAgrObjPrimaryId, (Object)agrDetail.getAgrObjPrimaryId());
        List scopePOS = this.agrApplicationScopeMapper.selectList((Wrapper)scopePOQueryWrapper);
        if (!CollectionUtils.isEmpty((Collection)scopePOS)) {
            agrDetail.setAgrApplicationScopeList(JSON.parseArray((String)JSON.toJSONString((Object)scopePOS), DycProAgrApplicationScopeDTO.class));
            agrDetail.setPurScopeList(agrDetail.getAgrApplicationScopeList().stream().filter(e -> DycProAgrConstants.AgrScopeApplicationType.PUR_SCOPE.equals(e.getApplicationType())).collect(Collectors.toList()));
            agrDetail.setViewScopeList(agrDetail.getAgrApplicationScopeList().stream().filter(e -> DycProAgrConstants.AgrScopeApplicationType.VIEW_SCOPE.equals(e.getApplicationType())).collect(Collectors.toList()));
        }
        LambdaQueryWrapper fileQueryWrapper = new LambdaQueryWrapper();
        fileQueryWrapper.eq(AgrFileInfoPO::getObjId, (Object)agrDetail.getAgrObjPrimaryId());
        fileQueryWrapper.eq(AgrFileInfoPO::getObjType, (Object)DycProAgrConstants.AgrFilObjType.AGR_MAIN);
        List fileInfoPOS = this.agrFileInfoMapper.selectList((Wrapper)fileQueryWrapper);
        if (!CollectionUtils.isEmpty((Collection)fileInfoPOS)) {
            agrDetail.setAgrFileInfoList(JSON.parseArray((String)JSON.toJSONString((Object)fileInfoPOS), DycProAgrFileInfoDTO.class));
        }
        return agrDetail;
    }

    @Override
    public void updateAgrMain(DycProAgrMainDTO dycProAgrMainDTO) {
        AgrMainPO agrMainPO = (AgrMainPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProAgrMainDTO), AgrMainPO.class);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(AgrMainPO::getAgrObjPrimaryId, (Object)agrMainPO.getAgrObjPrimaryId());
        updateWrapper.set(AgrMainPO::getEnAgrCode, (Object)agrMainPO.getEnAgrCode());
        updateWrapper.set(AgrMainPO::getRemark, (Object)agrMainPO.getRemark());
        updateWrapper.set(AgrMainPO::getViewScopeType, (Object)agrMainPO.getViewScopeType());
        this.agrMainMapper.update(agrMainPO, (Wrapper)updateWrapper);
        LambdaQueryWrapper deleteCatalogWrapper = new LambdaQueryWrapper();
        deleteCatalogWrapper.eq(AgrCooperationCatalogPO::getAgrObjPrimaryId, (Object)dycProAgrMainDTO.getAgrObjPrimaryId());
        this.agrCooperationCatalogMapper.delete((Wrapper)deleteCatalogWrapper);
        if (DycProAgrConstants.AgrBooleanFlag.YES.equals(dycProAgrMainDTO.getWhetherManageCatalog()) && !CollectionUtils.isEmpty(dycProAgrMainDTO.getAgrCooperationCatalogList())) {
            for (DycProAgrCooperationCatalogDTO each : dycProAgrMainDTO.getAgrCooperationCatalogList()) {
                each.setAgrCooperationCatalogId(Sequence.getInstance().nextId());
                each.setAgrObjPrimaryId(dycProAgrMainDTO.getAgrObjPrimaryId());
                each.setAgrId(dycProAgrMainDTO.getAgrId());
            }
            List catalogPOS = JSON.parseArray((String)JSON.toJSONString(dycProAgrMainDTO.getAgrCooperationCatalogList()), AgrCooperationCatalogPO.class);
            this.agrCooperationCatalogMapper.insertBatch(catalogPOS);
        }
        LambdaQueryWrapper deleteScopeWrapper = new LambdaQueryWrapper();
        deleteScopeWrapper.eq(AgrApplicationScopePO::getAgrObjPrimaryId, (Object)dycProAgrMainDTO.getAgrObjPrimaryId());
        this.agrApplicationScopeMapper.delete((Wrapper)deleteScopeWrapper);
        this.dealScopList(dycProAgrMainDTO, dycProAgrMainDTO.getAgrObjPrimaryId(), dycProAgrMainDTO.getAgrId(), agrMainPO);
        LambdaQueryWrapper deleteFileWrapper = new LambdaQueryWrapper();
        deleteFileWrapper.eq(AgrFileInfoPO::getObjId, (Object)dycProAgrMainDTO.getAgrObjPrimaryId());
        deleteFileWrapper.eq(AgrFileInfoPO::getObjType, (Object)DycProAgrConstants.AgrFilObjType.AGR_MAIN);
        this.agrFileInfoMapper.delete((Wrapper)deleteFileWrapper);
        if (!CollectionUtils.isEmpty(dycProAgrMainDTO.getAgrFileInfoList())) {
            for (DycProAgrFileInfoDTO each : dycProAgrMainDTO.getAgrFileInfoList()) {
                each.setAgrFileId(Sequence.getInstance().nextId());
                each.setObjId(dycProAgrMainDTO.getAgrObjPrimaryId());
                each.setObjType(DycProAgrConstants.AgrFilObjType.AGR_MAIN);
            }
            List fileInfoPOS = JSON.parseArray((String)JSON.toJSONString(dycProAgrMainDTO.getAgrFileInfoList()), AgrFileInfoPO.class);
            this.agrFileInfoMapper.insertBatch(fileInfoPOS);
        }
        if (new Integer(BooleanFlag.NO.getCode()).equals(dycProAgrMainDTO.getWhetherHaveItem())) {
            this.deleteAgrItem(dycProAgrMainDTO.getAgrObjPrimaryId(), null);
        }
    }

    @Override
    public void updateAgrMainByIds(List<DycProAgrMainDTO> dycProAgrMainDTOList) {
        if (CollectionUtils.isEmpty(dycProAgrMainDTOList)) {
            throw new ZTBusinessException("\u534f\u8bae\u4e3b\u4f53\u66f4\u65b0 \u57fa\u5efa\u5c42\u5165\u53c2\u4e3a\u7a7a");
        }
        dycProAgrMainDTOList.forEach(e -> {
            if (ObjectUtils.isEmpty((Object)e.getAgrObjPrimaryId())) {
                throw new ZTBusinessException("\u534f\u8bae\u5bf9\u8c61\u552f\u4e00ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
        List updateArrayList = JSON.parseArray((String)JSON.toJSONString(dycProAgrMainDTOList), AgrMainPO.class);
        this.agrMainMapper.updateBatchByIds(updateArrayList);
    }

    @Override
    public List<DycProAgrMainDTO> selectAgrMainList(DycProAgrListQryDTO agrListQryDTO) {
        List<DycProAgrMainDTO> agrMainDTOS = new ArrayList<DycProAgrMainDTO>();
        AgrMainPO qryPO = (AgrMainPO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)agrListQryDTO)), AgrMainPO.class);
        QueryWrapper qryWrapper = new QueryWrapper((Object)qryPO);
        qryWrapper.lambda().ne(agrListQryDTO.getHistoryFlag().booleanValue(), AgrMainPO::getAgrStatus, (Object)Integer.parseInt(DmcAgrMainAgrStatus.HISTORY.getCode()));
        List agrMainPOS = this.agrMainMapper.selectList((Wrapper)qryWrapper);
        if (!CollectionUtils.isEmpty((Collection)agrMainPOS)) {
            agrMainDTOS = JSON.parseArray((String)JSON.toJSONString((Object)agrMainPOS), DycProAgrMainDTO.class);
        }
        return agrMainDTOS;
    }

    @Override
    public RspPage<DycProAgrMainDTO> selectAgrMainListPage(DycProAgrListQryDTO agrListQryDTO) {
        AgrMainPO agrMainPO = (AgrMainPO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)agrListQryDTO)), AgrMainPO.class);
        agrMainPO.setAgrName(null);
        agrMainPO.setAgrCode(null);
        agrMainPO.setEnAgrCode(null);
        agrMainPO.setSupplierName(null);
        Page page = new Page((long)agrListQryDTO.getPageNo(), (long)agrListQryDTO.getPageSize());
        Page result = (Page)this.agrMainMapper.selectPage((IPage)page, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery((Object)agrMainPO).like(!ObjectUtils.isEmpty((Object)agrListQryDTO.getAgrName()), AgrMainPO::getAgrName, (Object)agrListQryDTO.getAgrName())).like(!ObjectUtils.isEmpty((Object)agrListQryDTO.getAgrCode()), AgrMainPO::getAgrCode, (Object)agrListQryDTO.getAgrCode())).like(!ObjectUtils.isEmpty((Object)agrListQryDTO.getEnAgrCode()), AgrMainPO::getEnAgrCode, (Object)agrListQryDTO.getEnAgrCode())).like(!ObjectUtils.isEmpty((Object)agrListQryDTO.getSupplierName()), AgrMainPO::getSupplierName, (Object)agrListQryDTO.getSupplierName())).ge(!ObjectUtils.isEmpty((Object)agrListQryDTO.getEffDateStart()), AgrMainPO::getEffDate, (Object)agrListQryDTO.getEffDateStart())).le(!ObjectUtils.isEmpty((Object)agrListQryDTO.getEffDateEnd()), AgrMainPO::getEffDate, (Object)agrListQryDTO.getEffDateEnd())).ge(!ObjectUtils.isEmpty((Object)agrListQryDTO.getExpDateStart()), AgrMainPO::getExpDate, (Object)agrListQryDTO.getExpDateStart())).le(!ObjectUtils.isEmpty((Object)agrListQryDTO.getExpDateEnd()), AgrMainPO::getExpDate, (Object)agrListQryDTO.getExpDateEnd())).in(!CollectionUtils.isEmpty(agrListQryDTO.getAgrStatusList()), AgrMainPO::getAgrStatus, agrListQryDTO.getAgrStatusList())).eq(agrListQryDTO.getDelFlag() == null, AgrMainPO::getDelFlag, (Object)Integer.parseInt(DelFlag.UN_DELETE.getCode()))).ne(agrListQryDTO.getHistoryFlag().booleanValue(), AgrMainPO::getAgrStatus, (Object)Integer.parseInt(DmcAgrMainAgrStatus.HISTORY.getCode()))).orderByDesc(AgrMainPO::getCreateTime)).orderByDesc(AgrMainPO::getAgrVersion));
        RspPage rspPage = new RspPage();
        if (!CollectionUtils.isEmpty((Collection)result.getRecords())) {
            rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)result.getRecords()), DycProAgrMainDTO.class));
        }
        rspPage.setPageNo((int)result.getCurrent());
        rspPage.setTotal((int)result.getPages());
        rspPage.setRecordsTotal((int)result.getTotal());
        return rspPage;
    }

    @Override
    public void saveAgrItems(List<DycProAgrItemDTO> dycProAgrItemDTOS) {
        List insertAgrItemDTOS;
        if (CollectionUtils.isEmpty(dycProAgrItemDTOS)) {
            throw new ZTBusinessException("\u534f\u8bae\u660e\u7ec6\u4fdd\u5b58 \u57fa\u5efa\u5c42\u5165\u53c2\u4e3a\u7a7a");
        }
        List<DycProAgrItemDTO> updateAgrItemDTOS = dycProAgrItemDTOS.stream().filter(e -> e.getAgrItemId() != null).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(updateAgrItemDTOS)) {
            this.updateAgrItemByIds(updateAgrItemDTOS);
        }
        if (!CollectionUtils.isEmpty(insertAgrItemDTOS = dycProAgrItemDTOS.stream().filter(e -> e.getAgrItemId() == null).collect(Collectors.toList()))) {
            List insertItemPOList = JSON.parseArray((String)JSON.toJSONString(insertAgrItemDTOS), AgrItemPO.class);
            for (AgrItemPO each : insertItemPOList) {
                if (each.getAgrItemId() == null) {
                    each.setAgrItemId(Sequence.getInstance().nextId());
                }
                each.setInitCommFlag(DycProAgrConstants.AgrBooleanFlag.NO);
            }
            this.agrItemMapper.insertBatch(insertItemPOList);
        }
    }

    @Override
    public void updateAgrItemByIds(List<DycProAgrItemDTO> dycProAgrItemDTOS) {
        if (CollectionUtils.isEmpty(dycProAgrItemDTOS)) {
            throw new ZTBusinessException("\u534f\u8bae\u660e\u7ec6\u66f4\u65b0 \u57fa\u5efa\u5c42\u5165\u53c2\u4e3a\u7a7a");
        }
        List agrItemPOs = JSON.parseArray((String)JSON.toJSONString(dycProAgrItemDTOS), AgrItemPO.class);
        this.agrItemMapper.updateBatchByIds(agrItemPOs);
    }

    @Override
    public void deleteAgrItem(Long agrObjPrimaryId, List<Long> agrItemIds) {
        if (ObjectUtils.isEmpty((Object)agrObjPrimaryId) && CollectionUtils.isEmpty(agrItemIds)) {
            throw new ZTBusinessException("\u534f\u8bae\u660e\u7ec6\u5220\u9664 \u57fa\u5efa\u5c42\u5165\u53c2\u4e3a\u7a7a");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (agrObjPrimaryId != null) {
            queryWrapper.eq(AgrItemPO::getAgrObjPrimaryId, (Object)agrObjPrimaryId);
        }
        if (!CollectionUtils.isEmpty(agrItemIds)) {
            queryWrapper.in(AgrItemPO::getAgrItemId, agrItemIds);
        }
        this.agrItemMapper.delete((Wrapper)queryWrapper);
    }

    @Override
    public List<DycProAgrItemDTO> selectAgrItemList(DycProAgrItemDTO dycProAgrItemDTO) {
        List<DycProAgrItemDTO> itemTDOS = new ArrayList<DycProAgrItemDTO>();
        AgrItemPO qryPO = (AgrItemPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProAgrItemDTO), AgrItemPO.class);
        QueryWrapper itemQryWrapper = new QueryWrapper((Object)qryPO);
        List agrItemPOS = this.agrItemMapper.selectList((Wrapper)itemQryWrapper);
        if (!CollectionUtils.isEmpty((Collection)agrItemPOS)) {
            itemTDOS = JSON.parseArray((String)JSON.toJSONString((Object)agrItemPOS), DycProAgrItemDTO.class);
            for (DycProAgrItemDTO each : itemTDOS) {
                each.setSupplyPriceTotal(each.getSupplyPrice().multiply(each.getAgrItemNumber()).setScale(2, 4));
            }
        }
        return itemTDOS;
    }

    @Override
    public RspPage<DycProAgrItemDTO> selectAgrItemListPage(DycProAgrItemListQryDTO qryDTO) {
        if (qryDTO.getAgrId() != null && qryDTO.getAgrObjPrimaryId() == null) {
            QueryWrapper mainQryWrapper = new QueryWrapper();
            mainQryWrapper.lambda().eq(AgrMainPO::getAgrId, (Object)qryDTO.getAgrId());
            mainQryWrapper.lambda().ne(AgrMainPO::getAgrStatus, (Object)Integer.parseInt(DmcAgrMainAgrStatus.HISTORY.getCode()));
            AgrMainPO agrMainPO = (AgrMainPO)this.agrMainMapper.selectOne((Wrapper)mainQryWrapper);
            if (agrMainPO == null) {
                throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u534f\u8bae\u8be6\u60c5");
            }
            qryDTO.setAgrObjPrimaryId(agrMainPO.getAgrObjPrimaryId());
        }
        AgrItemPO qryPO = (AgrItemPO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)qryDTO)), AgrItemPO.class);
        Page page = new Page((long)qryDTO.getPageNo(), (long)qryDTO.getPageSize());
        QueryWrapper queryWrapper = new QueryWrapper((Object)qryPO);
        Page result = (Page)this.agrItemMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        RspPage rspPage = new RspPage();
        if (!CollectionUtils.isEmpty((Collection)result.getRecords())) {
            rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)result.getRecords()), DycProAgrItemDTO.class));
            for (DycProAgrItemDTO each : rspPage.getRows()) {
                if (each.getSupplyPrice() != null) {
                    each.setSupplyPrice(each.getSupplyPrice().setScale(2, 4));
                }
                if (each.getSupplyPrice() == null || each.getAgrItemNumber() == null) continue;
                each.setSupplyPriceTotal(each.getSupplyPrice().multiply(each.getAgrItemNumber()).setScale(2, 4));
            }
        }
        rspPage.setPageNo((int)result.getCurrent());
        rspPage.setTotal((int)result.getPages());
        rspPage.setRecordsTotal((int)result.getTotal());
        return rspPage;
    }

    @Override
    public RspPage<DycProAgrMainDTO> getAgrCouldChngListPage(DycProAgrListQryDTO agrListQryDTO) {
        RspPage rspPage = new RspPage();
        AgrMainQryPO qryPO = (AgrMainQryPO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)agrListQryDTO)), AgrMainQryPO.class);
        qryPO.setDelFlag(DycProAgrConstants.AgrDelFlag.UN_DELETE);
        qryPO.setHistoryFlag(Boolean.FALSE);
        Page page = new Page((long)agrListQryDTO.getPageNo(), (long)agrListQryDTO.getPageSize());
        List<AgrMainPO> agrCouldChngListPage = this.agrMainMapper.getAgrCouldChngListPage(qryPO, (Page<AgrMainQryPO>)page);
        if (!CollectionUtils.isEmpty(agrCouldChngListPage)) {
            rspPage.setRows(JSON.parseArray((String)JSON.toJSONString(agrCouldChngListPage), DycProAgrMainDTO.class));
        }
        rspPage.setPageNo((int)page.getCurrent());
        rspPage.setTotal((int)page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    @Override
    public RspPage<DycProAgrMainDTO> qryAgrSupplierListPage(DycProAgrListQryDTO agrListQryDTO) {
        RspPage rspPage = new RspPage();
        AgrMainPO agrMainPO = (AgrMainPO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)agrListQryDTO)), AgrMainPO.class);
        agrMainPO.setSupplierName(null);
        Page page = new Page((long)agrListQryDTO.getPageNo(), (long)agrListQryDTO.getPageSize());
        Page result = (Page)this.agrMainMapper.selectPage((IPage)page, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery((Object)agrMainPO).eq(AgrMainPO::getDelFlag, (Object)Integer.parseInt(DelFlag.UN_DELETE.getCode()))).ne(AgrMainPO::getDelFlag, (Object)Integer.parseInt(DmcAgrMainAgrStatus.HISTORY.getCode()))).like(!ObjectUtils.isEmpty((Object)agrListQryDTO.getSupplierName()), AgrMainPO::getSupplierName, (Object)agrListQryDTO.getSupplierName())).groupBy(AgrMainPO::getSupplierId));
        if (!CollectionUtils.isEmpty((Collection)result.getRecords())) {
            rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)result.getRecords()), DycProAgrMainDTO.class));
        }
        rspPage.setPageNo((int)page.getCurrent());
        rspPage.setTotal((int)page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    @Override
    public RspPage<DycProAgrMainDTO> qryAgrConfirmListPage(DycProAgrListQryDTO agrListQryDTO) {
        AgrMainQryPO agrMainQryPO = (AgrMainQryPO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)agrListQryDTO)), AgrMainQryPO.class);
        Page page = new Page((long)agrListQryDTO.getPageNo(), (long)agrListQryDTO.getPageSize());
        List<AgrMainPO> agrMainPOS = this.agrMainMapper.qryAgrConfirmListPage(agrMainQryPO, (Page<AgrMainQryPO>)page);
        RspPage rspPage = new RspPage();
        if (!CollectionUtils.isEmpty(agrMainPOS)) {
            rspPage.setRows(JSON.parseArray((String)JSON.toJSONString(agrMainPOS), DycProAgrMainDTO.class));
        }
        rspPage.setPageNo((int)page.getCurrent());
        rspPage.setTotal((int)page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    @Override
    public RspPage<DycProAgrMainDTO> queryPriceRuleToSelectAgrListPage(DycProAgrListQryDTO agrListQryDTO) {
        Page page = new Page((long)agrListQryDTO.getPageNo(), (long)agrListQryDTO.getPageSize());
        AgrMainPO agrMainPO = (AgrMainPO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)agrListQryDTO)), AgrMainPO.class);
        List<AgrMainPO> agrMainPOS = this.agrMainMapper.queryPriceRuleToSelectAgrListPage(agrMainPO, (Page<AgrMainPO>)page);
        RspPage rspPage = new RspPage();
        if (!CollectionUtils.isEmpty(agrMainPOS)) {
            rspPage.setRows(JSON.parseArray((String)JSON.toJSONString(agrMainPOS), DycProAgrMainDTO.class));
        }
        rspPage.setPageNo((int)page.getCurrent());
        rspPage.setTotal((int)page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    @Override
    public RspPage<DycProAgrMainDTO> queryPriceRuleToSelectSupplierListPage(DycProAgrListQryDTO agrListQryDTO) {
        Page page = new Page((long)agrListQryDTO.getPageNo(), (long)agrListQryDTO.getPageSize());
        AgrMainPO agrMainPO = (AgrMainPO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)agrListQryDTO)), AgrMainPO.class);
        List<AgrMainPO> agrMainPOS = this.agrMainMapper.queryPriceRuleToSelectSupplierListPage(agrMainPO, (Page<AgrMainPO>)page);
        RspPage rspPage = new RspPage();
        if (!CollectionUtils.isEmpty(agrMainPOS)) {
            rspPage.setRows(JSON.parseArray((String)JSON.toJSONString(agrMainPOS), DycProAgrMainDTO.class));
        }
        rspPage.setPageNo((int)page.getCurrent());
        rspPage.setTotal((int)page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }
}

