/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.checkrule.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckRuleStatusEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckRuleTypeEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommOperateRecordActionTypeEnum;
import com.tydic.dyc.pro.base.core.encode.service.api.EncodeSerialService;
import com.tydic.dyc.pro.base.core.encode.service.bo.EncodeSerialReqBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.EncodeSerialRspBO;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.checkrule.api.DycProCommCheckRuleInfoRepository;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckCatalogDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckRuleInfoDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckRuleItemInfoDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckSupplierDTO;
import com.tydic.dyc.pro.dmc.repository.operaterecord.api.DycProCommOperateRecordRepository;
import com.tydic.dyc.pro.dmc.repository.operaterecord.dto.DycProCommOperateRecordDTO;
import com.tydic.dyc.pro.dmc.service.checkrule.api.DycProCommAddCheckRuleInfoService;
import com.tydic.dyc.pro.dmc.service.checkrule.bo.DycProCommAddCheckRuleInfoReqBO;
import com.tydic.dyc.pro.dmc.service.checkrule.bo.DycProCommAddCheckRuleInfoRspBO;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.checkrule.api.DycProCommAddCheckRuleInfoService"})
public class DycProCommAddCheckRuleInfoServiceImpl
implements DycProCommAddCheckRuleInfoService {
    @Autowired
    private DycProCommCheckRuleInfoRepository dycProCommCheckRuleInfoRepository;
    @Autowired
    DycProCommOperateRecordRepository dycProCommOperateRecordRepository;
    @Autowired
    private EncodeSerialService encodeSerialService;

    @Override
    @PostMapping(value={"addCheckRuleInfo"})
    public DycProCommAddCheckRuleInfoRspBO addCheckRuleInfo(@RequestBody DycProCommAddCheckRuleInfoReqBO reqBO) {
        this.validParam(reqBO);
        DycProCommCheckRuleInfoDTO dycProCommCheckRuleInfoDTO = this.buildCheckRuleInfo(reqBO);
        if (!CollectionUtils.isEmpty(reqBO.getCheckSuppliers())) {
            List checkSupplierDTOList = JSONArray.parseArray((String)JSON.toJSONString(reqBO.getCheckSuppliers()), DycProCommCheckSupplierDTO.class);
            dycProCommCheckRuleInfoDTO.setCheckSupplierDTOList(checkSupplierDTOList);
        }
        if (!CollectionUtils.isEmpty(reqBO.getCheckCatalogs())) {
            List checkCatalogDTOList = JSONArray.parseArray((String)JSON.toJSONString(reqBO.getCheckCatalogs()), DycProCommCheckCatalogDTO.class);
            dycProCommCheckRuleInfoDTO.setCheckCatalogDTOList(checkCatalogDTOList);
        }
        if (!CollectionUtils.isEmpty(reqBO.getCheckRuleItems())) {
            List checkRuleItemInfoDTOList = JSONArray.parseArray((String)JSON.toJSONString(reqBO.getCheckRuleItems()), DycProCommCheckRuleItemInfoDTO.class);
            dycProCommCheckRuleInfoDTO.setCheckRuleItemInfoDTOList(checkRuleItemInfoDTOList);
        }
        this.dycProCommCheckRuleInfoRepository.addCheckRuleInfo(dycProCommCheckRuleInfoDTO);
        this.addOperateRecord(reqBO, dycProCommCheckRuleInfoDTO);
        DycProCommAddCheckRuleInfoRspBO rspBO = new DycProCommAddCheckRuleInfoRspBO();
        rspBO.setCheckRuleId(dycProCommCheckRuleInfoDTO.getCheckRuleId());
        return rspBO;
    }

    private void addOperateRecord(DycProCommAddCheckRuleInfoReqBO reqBO, DycProCommCheckRuleInfoDTO dycProCommCheckRuleInfoDTO) {
        DycProCommOperateRecordDTO dycProCommOperateRecordDTO = new DycProCommOperateRecordDTO();
        dycProCommOperateRecordDTO.setOperateRecordId(Long.valueOf(Sequence.getInstance().nextId()));
        dycProCommOperateRecordDTO.setObjId(dycProCommCheckRuleInfoDTO.getCheckRuleId());
        dycProCommOperateRecordDTO.setObjType(DycProCommConstants.OperateRecordObjType.CHECK_RULE);
        dycProCommOperateRecordDTO.setOperateUserId(reqBO.getUserId());
        dycProCommOperateRecordDTO.setOperateUserName(reqBO.getName());
        dycProCommOperateRecordDTO.setOperateUserAccount(reqBO.getUserName());
        dycProCommOperateRecordDTO.setOperateTime(new Date());
        dycProCommOperateRecordDTO.setActionName(DmcCommOperateRecordActionTypeEnum.ADD.getValue());
        dycProCommOperateRecordDTO.setObjCode(dycProCommCheckRuleInfoDTO.getCheckRuleCode());
        dycProCommOperateRecordDTO.setActionType(Integer.valueOf(Integer.parseInt(DmcCommOperateRecordActionTypeEnum.ADD.getCode())));
        this.dycProCommOperateRecordRepository.addOperateRecord(dycProCommOperateRecordDTO);
    }

    private DycProCommCheckRuleInfoDTO buildCheckRuleInfo(DycProCommAddCheckRuleInfoReqBO reqBO) {
        DycProCommCheckRuleInfoDTO dycProCommCheckRuleInfoDTO = (DycProCommCheckRuleInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO.getCheckRuleInfo()), DycProCommCheckRuleInfoDTO.class);
        dycProCommCheckRuleInfoDTO.setCheckRuleStatus(Integer.valueOf(Integer.parseInt(DmcCommCheckRuleStatusEnum.DRAFT.getCode())));
        dycProCommCheckRuleInfoDTO.setDelFlag(DycProCommConstants.DelFlag.NO);
        dycProCommCheckRuleInfoDTO.setCreateUserId(reqBO.getUserId());
        dycProCommCheckRuleInfoDTO.setCreateUserName(reqBO.getName());
        dycProCommCheckRuleInfoDTO.setCreateUserAccount(reqBO.getUserName());
        dycProCommCheckRuleInfoDTO.setCreateOrgId(reqBO.getOrgId());
        dycProCommCheckRuleInfoDTO.setCreateOrgName(reqBO.getOrgName());
        dycProCommCheckRuleInfoDTO.setCreateCompanyId(reqBO.getCompanyId());
        dycProCommCheckRuleInfoDTO.setCreateCompanyName(reqBO.getCompanyName());
        dycProCommCheckRuleInfoDTO.setCreateOrgPath(reqBO.getOrgPath());
        dycProCommCheckRuleInfoDTO.setCheckRuleSrc(DycProCommConstants.CheckRuleSource.CHECK_RULE_SOURCE_MANUAL);
        dycProCommCheckRuleInfoDTO.setCreateTime(new Date());
        dycProCommCheckRuleInfoDTO.setUpdateTime(new Date());
        dycProCommCheckRuleInfoDTO.setUpdateUserId(reqBO.getUserId());
        dycProCommCheckRuleInfoDTO.setUpdateUserName(reqBO.getName());
        dycProCommCheckRuleInfoDTO.setUpdateUserAccount(reqBO.getUserName());
        EncodeSerialReqBO encodeSerialReqBO = new EncodeSerialReqBO();
        encodeSerialReqBO.setCenterCode("commodity");
        encodeSerialReqBO.setEncodeRuleCode("CHECK_RULE_CODE");
        EncodeSerialRspBO encode = this.encodeSerialService.getEncode(encodeSerialReqBO);
        dycProCommCheckRuleInfoDTO.setCheckRuleCode((String)encode.getSerialNoList().get(0));
        if (DmcCommCheckRuleTypeEnum.IMAGE_CHECK.getCode().equals(String.valueOf(dycProCommCheckRuleInfoDTO.getCheckRuleType()))) {
            dycProCommCheckRuleInfoDTO.setNeedAuditFlag(Integer.valueOf(1));
        }
        return dycProCommCheckRuleInfoDTO;
    }

    private void validParam(DycProCommAddCheckRuleInfoReqBO reqBO) {
        if (reqBO == null || reqBO.getCheckRuleInfo() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getCheckRuleInfo().getCheckRuleType() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u3010checkRuleType\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getCheckRuleInfo().getCheckExecActionCode() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u3010checkExecActionCode\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getCheckRuleInfo().getCheckSenceCode() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u3010checkSenceCode\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getCheckRuleInfo().getCheckObjType() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u3010checkObjType\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

