/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.checkrule.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.dmc.repository.checkrule.api.DycProCommCheckRuleInfoRepository;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckRuleInfoQryDTO;
import com.tydic.dyc.pro.dmc.service.checkrule.api.DycProCommQueryCheckRuleCatalogTreeService;
import com.tydic.dyc.pro.dmc.service.checkrule.bo.DycProCommCheckRuleCatalogTreeBO;
import com.tydic.dyc.pro.dmc.service.checkrule.bo.DycProCommQueryCheckRuleCatalogTreeReqBO;
import com.tydic.dyc.pro.dmc.service.checkrule.bo.DycProCommQueryCheckRuleCatalogTreeRspBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.checkrule.api.DycProCommQueryCheckRuleCatalogTreeService"})
public class DycProCommQueryCheckRuleCatalogTreeServiceImpl
implements DycProCommQueryCheckRuleCatalogTreeService {
    @Autowired
    private DycProCommCheckRuleInfoRepository dycProCommCheckRuleInfoRepository;

    @Override
    @PostMapping(value={"queryCheckRuleCatalogTree"})
    public DycProCommQueryCheckRuleCatalogTreeRspBO queryCheckRuleCatalogTree(@RequestBody DycProCommQueryCheckRuleCatalogTreeReqBO reqBO) {
        this.validParam(reqBO);
        DycProCommCheckRuleInfoQryDTO dycProCommCheckRuleInfoQryDTO = new DycProCommCheckRuleInfoQryDTO();
        dycProCommCheckRuleInfoQryDTO.setCheckRuleId(reqBO.getCheckRuleId());
        List checkCatalogDTOs = this.dycProCommCheckRuleInfoRepository.queryCheckRuleCatalogTree(dycProCommCheckRuleInfoQryDTO);
        List rows = JSON.parseArray((String)JSON.toJSONString((Object)checkCatalogDTOs), DycProCommCheckRuleCatalogTreeBO.class);
        HashMap<Long, Object> map = new HashMap<Long, Object>();
        for (Object row : rows) {
            map.put(((DycProCommCheckRuleCatalogTreeBO)row).getCatalogId(), row);
        }
        ArrayList<DycProCommCheckRuleCatalogTreeBO> tree = new ArrayList<DycProCommCheckRuleCatalogTreeBO>();
        for (DycProCommCheckRuleCatalogTreeBO row : rows) {
            Long parentId = row.getParentCatalogId();
            if (parentId == null || !map.containsKey(parentId)) {
                tree.add(row);
                continue;
            }
            DycProCommCheckRuleCatalogTreeBO parent = (DycProCommCheckRuleCatalogTreeBO)map.get(parentId);
            if (parent.getChildren() == null) {
                parent.setChildren(new ArrayList<DycProCommCheckRuleCatalogTreeBO>());
            }
            parent.getChildren().add(row);
        }
        DycProCommQueryCheckRuleCatalogTreeRspBO rspBO = new DycProCommQueryCheckRuleCatalogTreeRspBO();
        rspBO.setRows(tree);
        return rspBO;
    }

    private void validParam(DycProCommQueryCheckRuleCatalogTreeReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getCheckRuleId() == null) {
            throw new ZTBusinessException("\u89c4\u5219ID\u3010checkRuleId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

