/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.checkrule.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckRuleStatusEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommOperateRecordActionTypeEnum;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.checkrule.api.DycProCommCheckRuleInfoRepository;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckCatalogDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckRuleInfoDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckRuleInfoQryDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckRuleItemInfoDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckSupplierDTO;
import com.tydic.dyc.pro.dmc.repository.operaterecord.api.DycProCommOperateRecordRepository;
import com.tydic.dyc.pro.dmc.repository.operaterecord.dto.DycProCommOperateRecordDTO;
import com.tydic.dyc.pro.dmc.service.checkrule.api.DycProCommUpdateCheckRuleInfoService;
import com.tydic.dyc.pro.dmc.service.checkrule.bo.DycProCommUpdateCheckRuleInfoReqBO;
import com.tydic.dyc.pro.dmc.service.checkrule.bo.DycProCommUpdateCheckRuleInfoRspBO;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.checkrule.api.DycProCommUpdateCheckRuleInfoService"})
public class DycProCommUpdateCheckRuleInfoServiceImpl
implements DycProCommUpdateCheckRuleInfoService {
    @Autowired
    private DycProCommCheckRuleInfoRepository dycProCommCheckRuleInfoRepository;
    @Autowired
    DycProCommOperateRecordRepository dycProCommOperateRecordRepository;

    @Override
    @PostMapping(value={"updateCheckRuleInfo"})
    public DycProCommUpdateCheckRuleInfoRspBO updateCheckRuleInfo(@RequestBody DycProCommUpdateCheckRuleInfoReqBO reqBO) {
        this.vaildParam(reqBO);
        DycProCommCheckRuleInfoDTO oldRuleDto = this.deleteOldCheckRuleInfo(reqBO);
        DycProCommCheckRuleInfoDTO newRuleDto = this.buildRuleInfo(reqBO, oldRuleDto);
        if (!CollectionUtils.isEmpty(reqBO.getCheckSuppliers())) {
            List checkSupplierDTOList = JSONArray.parseArray((String)JSON.toJSONString(reqBO.getCheckSuppliers()), DycProCommCheckSupplierDTO.class);
            newRuleDto.setCheckSupplierDTOList(checkSupplierDTOList);
        }
        if (!CollectionUtils.isEmpty(reqBO.getCheckCatalogs())) {
            List checkCatalogDTOList = JSONArray.parseArray((String)JSON.toJSONString(reqBO.getCheckCatalogs()), DycProCommCheckCatalogDTO.class);
            newRuleDto.setCheckCatalogDTOList(checkCatalogDTOList);
        }
        if (!CollectionUtils.isEmpty(reqBO.getCheckRuleItems())) {
            List checkRuleItemInfoDTOList = JSONArray.parseArray((String)JSON.toJSONString(reqBO.getCheckRuleItems()), DycProCommCheckRuleItemInfoDTO.class);
            newRuleDto.setCheckRuleItemInfoDTOList(checkRuleItemInfoDTOList);
        }
        this.dycProCommCheckRuleInfoRepository.addCheckRuleInfo(newRuleDto);
        this.addOperateRecord(reqBO, newRuleDto);
        DycProCommUpdateCheckRuleInfoRspBO rspBO = new DycProCommUpdateCheckRuleInfoRspBO();
        rspBO.setCheckRuleId(newRuleDto.getCheckRuleId());
        return rspBO;
    }

    private void addOperateRecord(DycProCommUpdateCheckRuleInfoReqBO reqBO, DycProCommCheckRuleInfoDTO newRuleDto) {
        DycProCommOperateRecordDTO dycProCommOperateRecordDTO = new DycProCommOperateRecordDTO();
        dycProCommOperateRecordDTO.setOperateRecordId(Long.valueOf(Sequence.getInstance().nextId()));
        dycProCommOperateRecordDTO.setObjId(reqBO.getCheckRuleInfo().getCheckRuleId());
        dycProCommOperateRecordDTO.setObjCode(newRuleDto.getCheckRuleCode());
        dycProCommOperateRecordDTO.setObjType(DycProCommConstants.OperateRecordObjType.CHECK_RULE);
        dycProCommOperateRecordDTO.setOperateUserId(reqBO.getUserId());
        dycProCommOperateRecordDTO.setOperateUserName(reqBO.getName());
        dycProCommOperateRecordDTO.setOperateUserAccount(reqBO.getUserName());
        dycProCommOperateRecordDTO.setOperateTime(new Date());
        dycProCommOperateRecordDTO.setActionName(DmcCommOperateRecordActionTypeEnum.UPDATE.getValue());
        dycProCommOperateRecordDTO.setActionType(Integer.valueOf(Integer.parseInt(DmcCommOperateRecordActionTypeEnum.UPDATE.getCode())));
        this.dycProCommOperateRecordRepository.addOperateRecord(dycProCommOperateRecordDTO);
    }

    private DycProCommCheckRuleInfoDTO buildRuleInfo(DycProCommUpdateCheckRuleInfoReqBO reqBO, DycProCommCheckRuleInfoDTO oldRuleDto) {
        DycProCommCheckRuleInfoDTO addDTO = (DycProCommCheckRuleInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO.getCheckRuleInfo()), DycProCommCheckRuleInfoDTO.class);
        addDTO.setCheckRuleStatus(Integer.valueOf(Integer.parseInt(DmcCommCheckRuleStatusEnum.DRAFT.getCode())));
        addDTO.setDelFlag(DycProCommConstants.DelFlag.NO);
        addDTO.setUpdateUserId(reqBO.getUserId());
        addDTO.setUpdateUserName(reqBO.getName());
        addDTO.setUpdateUserAccount(reqBO.getUserName());
        addDTO.setUpdateOrgId(reqBO.getOrgId());
        addDTO.setUpdateOrgName(reqBO.getOrgName());
        addDTO.setUpdateCompanyId(reqBO.getCompanyId());
        addDTO.setUpdateCompanyName(reqBO.getCompanyName());
        addDTO.setUpdateOrgPath(reqBO.getOrgPath());
        addDTO.setUpdateTime(new Date());
        addDTO.setCreateUserId(oldRuleDto.getCreateUserId());
        addDTO.setCreateUserName(oldRuleDto.getCreateUserName());
        addDTO.setCreateUserAccount(oldRuleDto.getCreateUserAccount());
        addDTO.setCreateOrgId(oldRuleDto.getCreateOrgId());
        addDTO.setCreateOrgName(oldRuleDto.getCreateOrgName());
        addDTO.setCreateCompanyId(oldRuleDto.getCreateCompanyId());
        addDTO.setCreateCompanyName(oldRuleDto.getCreateCompanyName());
        addDTO.setCreateOrgPath(oldRuleDto.getCreateOrgPath());
        addDTO.setCreateTime(oldRuleDto.getCreateTime());
        addDTO.setCheckRuleSrc(oldRuleDto.getCheckRuleSrc());
        addDTO.setCheckRuleCode(oldRuleDto.getCheckRuleCode());
        addDTO.setNeedAuditFlag(oldRuleDto.getNeedAuditFlag());
        addDTO.setNoticeCode(oldRuleDto.getNoticeCode());
        return addDTO;
    }

    private DycProCommCheckRuleInfoDTO deleteOldCheckRuleInfo(DycProCommUpdateCheckRuleInfoReqBO reqBO) {
        DycProCommCheckRuleInfoQryDTO queryDTO = new DycProCommCheckRuleInfoQryDTO();
        queryDTO.setCheckRuleId(reqBO.getCheckRuleInfo().getCheckRuleId());
        DycProCommCheckRuleInfoDTO detailDto = this.dycProCommCheckRuleInfoRepository.queryCheckRuleInfoDetail(queryDTO);
        if (detailDto == null) {
            throw new ZTBusinessException("\u89c4\u5219ID" + reqBO.getCheckRuleInfo().getCheckRuleId() + "\u4e0d\u5b58\u5728!");
        }
        DycProCommCheckRuleInfoDTO deleteDto = new DycProCommCheckRuleInfoDTO();
        deleteDto.setCheckRuleId(reqBO.getCheckRuleInfo().getCheckRuleId());
        if (detailDto.getCheckRuleStatus().equals(Integer.parseInt(DmcCommCheckRuleStatusEnum.DRAFT.getCode()))) {
            this.dycProCommCheckRuleInfoRepository.deleteCheckRuleInfoByReal(deleteDto);
        } else {
            this.dycProCommCheckRuleInfoRepository.deleteCheckRuleInfo(deleteDto);
        }
        return detailDto;
    }

    private void vaildParam(DycProCommUpdateCheckRuleInfoReqBO reqBO) {
        if (reqBO == null || reqBO.getCheckRuleInfo() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getCheckRuleInfo().getCheckRuleId() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u3010checkRuleId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

