/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.managecatalog.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.managecatalog.api.DycProCommManageCatalogRepository;
import com.tydic.dyc.pro.dmc.repository.managecatalog.dto.DycProCommQryManageCatalogQryDTO;
import com.tydic.dyc.pro.dmc.service.managecatalog.api.DycProCommQryManageCatalogTreeService;
import com.tydic.dyc.pro.dmc.service.managecatalog.bo.DycProCommManageCatalogBO;
import com.tydic.dyc.pro.dmc.service.managecatalog.bo.DycProCommQryManageCatalogTreeReqBO;
import com.tydic.dyc.pro.dmc.service.managecatalog.bo.DycProCommQryManageCatalogTreeRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.managecatalog.api.DycProCommQryManageCatalogTreeService"})
public class DycProCommQryManageCatalogTreeServiceImpl
implements DycProCommQryManageCatalogTreeService {
    @Autowired
    private DycProCommManageCatalogRepository dycProCommManageCatalogRepository;

    @Override
    @PostMapping(value={"qryManageCatalogTree"})
    public DycProCommQryManageCatalogTreeRspBO qryManageCatalogTree(@RequestBody DycProCommQryManageCatalogTreeReqBO reqBO) {
        DycProCommQryManageCatalogTreeRspBO rspBO = new DycProCommQryManageCatalogTreeRspBO();
        DycProCommQryManageCatalogQryDTO qryDTO = new DycProCommQryManageCatalogQryDTO();
        List dycProCommManageCatalogDTOList = this.dycProCommManageCatalogRepository.qryManageCatalogListByCondition(qryDTO);
        if (CollectionUtils.isEmpty((Collection)dycProCommManageCatalogDTOList)) {
            return rspBO;
        }
        List rows = JSON.parseArray((String)JSON.toJSONString((Object)dycProCommManageCatalogDTOList), DycProCommManageCatalogBO.class);
        HashMap<Long, DycProCommManageCatalogBO> map = new HashMap<Long, DycProCommManageCatalogBO>();
        for (DycProCommManageCatalogBO row : rows) {
            map.put(row.getManageCatalogId(), row);
        }
        ArrayList<DycProCommManageCatalogBO> tree = new ArrayList<DycProCommManageCatalogBO>();
        for (DycProCommManageCatalogBO row : rows) {
            Long parentId = row.getManageCatalogParentId();
            if (parentId == null || !map.containsKey(parentId)) {
                tree.add(row);
                continue;
            }
            DycProCommManageCatalogBO parent = (DycProCommManageCatalogBO)map.get(parentId);
            if (parent.getChildren() == null) {
                parent.setChildren(new ArrayList<DycProCommManageCatalogBO>());
            }
            parent.getChildren().add(row);
        }
        this.setOrderFlag(tree);
        rspBO.setRows(tree);
        if (reqBO.isFilterUnUseFul()) {
            this.filterUnUserFulInfo(tree);
        }
        if (reqBO.isQryCatalogPathName()) {
            for (DycProCommManageCatalogBO root : tree) {
                this.buildManageCatalogPathName(root, "");
            }
        }
        return rspBO;
    }

    private void filterUnUserFulInfo(List<DycProCommManageCatalogBO> tree) {
        Iterator<DycProCommManageCatalogBO> iterator = tree.iterator();
        while (iterator.hasNext()) {
            DycProCommManageCatalogBO item = iterator.next();
            if (DycProCommConstants.ManageCatalogEnableFlag.DISABLE.equals(item.getEnableFlag()) || ObjectUtils.isEmpty(item.getChildren()) && DycProCommConstants.ManageCatalogLastLevelFlag.NO.equals(item.getLastLevelFlag())) {
                iterator.remove();
            }
            if (ObjectUtils.isEmpty(item.getChildren())) continue;
            this.filterUnUserFulInfo(item.getChildren());
            if (!ObjectUtils.isEmpty(item.getChildren()) || !DycProCommConstants.ManageCatalogLastLevelFlag.NO.equals(item.getLastLevelFlag())) continue;
            iterator.remove();
        }
    }

    private void setOrderFlag(List<DycProCommManageCatalogBO> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return;
        }
        nodes.sort(Comparator.comparing(DycProCommManageCatalogBO::getManageCatalogOrder));
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            DycProCommManageCatalogBO node = nodes.get(i);
            if (size == 1) {
                node.setOrderFlag(0);
            } else if (i == 0) {
                node.setOrderFlag(1);
            } else if (i == size - 1) {
                node.setOrderFlag(2);
            } else {
                node.setOrderFlag(3);
            }
            this.setOrderFlag(node.getChildren());
        }
    }

    private void buildManageCatalogPathName(DycProCommManageCatalogBO node, String parentPath) {
        String currentPath = parentPath + node.getManageCatalogName();
        node.setManageCatalogPathName(currentPath);
        if (!ObjectUtils.isEmpty(node.getChildren())) {
            for (DycProCommManageCatalogBO child : node.getChildren()) {
                this.buildManageCatalogPathName(child, currentPath + "/");
            }
        }
    }
}

