/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.saleorder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderOrdEvaluateDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.service.constants.DycProOrderApiServiceConstant;
import com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderEvaluateDealService;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderEvaluateDealReqBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderEvaluateDealRspBO;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderEvaluateDealService"})
public class DycProOrderEvaluateDealServiceImpl
implements DycProOrderEvaluateDealService {
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;

    @PostMapping(value={"dealEvaluate"})
    public DycProOrderEvaluateDealRspBO dealEvaluate(@RequestBody DycProOrderEvaluateDealReqBO reqBO) {
        this.verifyParam(reqBO);
        Long saleOrderId = null;
        Long orderId = null;
        if (null != reqBO.getSaleOrderId() && null != reqBO.getOrderId()) {
            saleOrderId = reqBO.getSaleOrderId();
            orderId = reqBO.getOrderId();
        } else {
            DycProOrderSaleOrderDTO dycProOrderSaleOrderDTO = new DycProOrderSaleOrderDTO();
            dycProOrderSaleOrderDTO.setSaleOrderNo(reqBO.getSaleOrderNo());
            DycProOrderSaleOrderDTO saleOrderMainInfo = this.dycProOrderSaleOrderRepository.querySaleOrderOneByCondition(dycProOrderSaleOrderDTO);
            if (null != saleOrderMainInfo) {
                saleOrderId = saleOrderMainInfo.getSaleOrderId();
                orderId = saleOrderMainInfo.getOrderId();
            } else {
                throw new ZTBusinessException("\u6839\u636e\u9500\u552e\u5355\u7f16\u53f7\u67e5\u8be2\u9500\u552e\u5355\u4fe1\u606f\u5931\u8d25");
            }
        }
        List<DycProOrderOrdEvaluateDTO> saleOrderEvaluateInfo = this.querySaleOrderEvaluateInfo(saleOrderId, orderId);
        if (CollectionUtils.isNotEmpty(saleOrderEvaluateInfo)) {
            for (DycProOrderOrdEvaluateDTO uocEvaluate : saleOrderEvaluateInfo) {
                DycProOrderOrdEvaluateDTO updateEva = new DycProOrderOrdEvaluateDTO();
                updateEva.setId(uocEvaluate.getId());
                updateEva.setObjId(uocEvaluate.getObjId());
                updateEva.setEvaluateState(reqBO.getEvaluateState());
                this.dycProOrderSaleOrderRepository.updateEvaluateAndSysnSaleNosql(updateEva);
            }
        } else {
            DycProOrderOrdEvaluateDTO addEvaluate = new DycProOrderOrdEvaluateDTO();
            addEvaluate.setObjType(DycProOrderApiServiceConstant.OBJ_TYPE.SALE);
            addEvaluate.setId(Long.valueOf(Sequence.getInstance().nextId()));
            addEvaluate.setOrderId(orderId);
            addEvaluate.setCreateOperId(String.valueOf(reqBO.getUserId()));
            addEvaluate.setEvaluateState(reqBO.getEvaluateState());
            addEvaluate.setObjId(saleOrderId);
            this.dycProOrderSaleOrderRepository.addEvaluateAndSysnSaleNosql(addEvaluate);
        }
        return new DycProOrderEvaluateDealRspBO();
    }

    private List<DycProOrderOrdEvaluateDTO> querySaleOrderEvaluateInfo(Long saleOrderId, Long orderId) {
        DycProOrderOrdEvaluateDTO uocEvaluateQryBo = new DycProOrderOrdEvaluateDTO();
        uocEvaluateQryBo.setObjType(DycProOrderApiServiceConstant.OBJ_TYPE.SALE);
        uocEvaluateQryBo.setObjId(saleOrderId);
        uocEvaluateQryBo.setOrderId(orderId);
        List uocEvaluates = this.dycProOrderSaleOrderRepository.qryOrderEvaluateList(uocEvaluateQryBo);
        return uocEvaluates;
    }

    private void verifyParam(DycProOrderEvaluateDealReqBO reqBO) {
        if (ObjectUtil.isNull((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getSaleOrderNo())) {
            if (reqBO.getOrderId() == null) {
                throw new ZTBusinessException("\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (reqBO.getSaleOrderId() == null) {
                throw new ZTBusinessException("\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (reqBO.getEvaluateState() == null) {
            throw new ZTBusinessException("\u8bc4\u4ef7\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

