/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.saleorder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.egc.constant.DycProOrderRepositoryConstant;
import com.tydic.dyc.pro.egc.constant.DycProOrderServiceConstant;
import com.tydic.dyc.pro.egc.repository.approve.api.DycProOrderApproveRepository;
import com.tydic.dyc.pro.egc.repository.approve.dto.DycProOrderApprovalObjDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderQueryIndexDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.service.constants.DycProOrderApiServiceConstant;
import com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderResoveEsPreOrderService;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderResoveEsPreOrderServiceReqBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderResoveEsPreOrderServiceReqSkuBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderResoveEsPreOrderServiceRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderResoveEsPreOrderService"})
public class DycProOrderResoveEsPreOrderServiceImpl
implements DycProOrderResoveEsPreOrderService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderResoveEsPreOrderServiceImpl.class);
    @Autowired
    private DycProOrderSaleOrderRepository saleOrderRepository;
    @Autowired
    private DycProOrderApproveRepository dycProOrderApproveRepository;

    @PostMapping(value={"dealEsPreOrder"})
    public DycProOrderResoveEsPreOrderServiceRspBO dealEsPreOrder(@RequestBody DycProOrderResoveEsPreOrderServiceReqBO reqBo) {
        DycProOrderResoveEsPreOrderServiceRspBO rspBo = new DycProOrderResoveEsPreOrderServiceRspBO();
        if (DycProOrderServiceConstant.CREATED_RESULT.FAILED.equals(reqBo.getCreatedResult())) {
            DycProOrderSaleOrderDTO updateExtOrderIdDo = new DycProOrderSaleOrderDTO();
            updateExtOrderIdDo.setOrderId(reqBo.getOrderId());
            updateExtOrderIdDo.setSaleOrderId(reqBo.getSaleOrderId());
            updateExtOrderIdDo.setCreatedResult(reqBo.getCreatedResult());
            updateExtOrderIdDo.setSaleOrderState("XS_XD_SB");
            updateExtOrderIdDo.setCancelReason(reqBo.getCancelReason());
            updateExtOrderIdDo.setOrderStage(DycProOrderRepositoryConstant.ORDER_STAPE.TRADE_CLOSE);
            this.saleOrderRepository.updateSaleOrderByCondition(updateExtOrderIdDo, true);
        } else {
            DycProOrderSaleOrderDTO saleOrderDTO = this.assembleUpdateDo(reqBo);
            this.saleOrderRepository.updateSaleItemBatch(saleOrderDTO);
            DycProOrderOrderQueryIndexDTO index = new DycProOrderOrderQueryIndexDTO();
            index.setId(Long.valueOf(Sequence.getInstance().nextId()));
            index.setOrderId(reqBo.getOrderId());
            index.setObjType(DycProOrderApiServiceConstant.OBJ_TYPE.SALE);
            index.setObjId(reqBo.getSaleOrderId());
            index.setOutObjId(reqBo.getOutOrderId());
            this.saleOrderRepository.addOrderQueryIndex(index);
            DycProOrderSaleOrderDTO updateExtOrderIdDo = new DycProOrderSaleOrderDTO();
            updateExtOrderIdDo.setOrderId(reqBo.getOrderId());
            updateExtOrderIdDo.setSaleOrderId(reqBo.getSaleOrderId());
            updateExtOrderIdDo.setSaleOrderNoExt(reqBo.getOutOrderId());
            updateExtOrderIdDo.setCreatedResult(reqBo.getCreatedResult());
            this.saleOrderRepository.updateSaleOrderByCondition(updateExtOrderIdDo, true);
        }
        DycProOrderSaleOrderDTO dycProOrderSaleOrderDTO = new DycProOrderSaleOrderDTO();
        dycProOrderSaleOrderDTO.setOrderId(reqBo.getOrderId());
        List saleOrderDTOList = this.saleOrderRepository.querySaleOrderListByCondition(dycProOrderSaleOrderDTO);
        if (saleOrderDTOList.stream().noneMatch(bo -> DycProOrderApiServiceConstant.CREATED_RESULT.PROCESSING.equals(bo.getCreatedResult())) && saleOrderDTOList.stream().anyMatch(bo -> DycProOrderApiServiceConstant.CREATED_RESULT.SUCCESS.equals(bo.getCreatedResult()))) {
            DycProOrderApprovalObjDTO dycProOrderApprovalObjDTO = new DycProOrderApprovalObjDTO();
            dycProOrderApprovalObjDTO.setObjId(reqBo.getOrderId().toString());
            dycProOrderApprovalObjDTO.setObjType(DycProOrderApiServiceConstant.ObjType.ORDER);
            dycProOrderApprovalObjDTO.setObjBusiType(DycProOrderApiServiceConstant.OBJ_BUSI_TYPE.ORDER);
            DycProOrderApprovalObjDTO approvalObjDTO = this.dycProOrderApproveRepository.queryApprovalObjOneByCondition(dycProOrderApprovalObjDTO);
            rspBo.setAuditId(approvalObjDTO.getAuditOrderId());
        }
        rspBo.setUserId(((DycProOrderSaleOrderDTO)saleOrderDTOList.get(0)).getCreateOperId());
        rspBo.setOrderId(reqBo.getOrderId());
        rspBo.setSaleOrderId(reqBo.getSaleOrderId());
        rspBo.setOutOrderId(reqBo.getOutOrderId());
        return rspBo;
    }

    private DycProOrderSaleOrderDTO assembleUpdateDo(DycProOrderResoveEsPreOrderServiceReqBO reqBo) {
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8ba2\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderId())) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u9500\u552e\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DycProOrderSaleOrderDTO saleOrderDTO = new DycProOrderSaleOrderDTO();
        saleOrderDTO.setOrderId(reqBo.getOrderId());
        saleOrderDTO.setSaleOrderId(reqBo.getSaleOrderId());
        List sku = reqBo.getSku();
        ArrayList<DycProOrderSaleOrderItemDTO> saleItemList = new ArrayList<DycProOrderSaleOrderItemDTO>();
        saleOrderDTO.setSaleItemList(saleItemList);
        for (DycProOrderResoveEsPreOrderServiceReqSkuBO skuBo : sku) {
            if (ObjectUtil.isEmpty((Object)skuBo.getSkuId())) {
                throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[SkuExtSkuId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)skuBo.getNakedPrice())) {
                throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[NakedPrice]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)skuBo.getTax())) {
                throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[Tax]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)skuBo.getTaxPrice())) {
                throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[TaxPrice]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            DycProOrderSaleOrderItemDTO item = new DycProOrderSaleOrderItemDTO();
            item.setSkuExtSkuId(skuBo.getSkuId());
            item.setOrderId(reqBo.getOrderId());
            item.setSaleOrderId(reqBo.getSaleOrderId());
            item.setTax(new BigDecimal(skuBo.getTax()));
            item.setTaxPrice(skuBo.getTaxPrice());
            item.setNakedPrice(skuBo.getNakedPrice());
            saleItemList.add(item);
        }
        return saleOrderDTO;
    }
}

