/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.aforder.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtil;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilUpdateSendSkuForJdReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilUpdateSendSkuForJdRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilUpdateSendSkuParamForJdBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilUpdateSendSkuReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilUpdateSendSkuRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilUpdateSendSkuWaybillInfoForJdBO;
import com.tydic.dyc.pro.egc.repository.aforder.api.DycProOrderAfOrderRepository;
import com.tydic.dyc.pro.egc.repository.aforder.dto.DycProOrderAfOrderDTO;
import com.tydic.dyc.pro.egc.repository.aforder.dto.DycProOrderAfOrderWaybillDTO;
import com.tydic.dyc.pro.egc.repository.order.api.DycProOrderOrderRepository;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderStakeholderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderDealWaybillUpholdAfterOrderService;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderAfterOrderWaybillUpholdBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderAfterOrderWaybillUpholdReqBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderAfterOrderWaybillUpholdRspBO;
import com.tydic.dyc.pro.egc.utils.DycPropertiesUtil;
import com.tydic.dyc.pro.egc.utils.IdUtil;
import com.tydic.dyc.pro.egc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderDealWaybillUpholdAfterOrderService"})
public class DycProOrderDealWaybillUpholdAfterOrderServiceImpl
implements DycProOrderDealWaybillUpholdAfterOrderService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderDealWaybillUpholdAfterOrderServiceImpl.class);
    public static final String patton = "YYYY-MM-dd HH:mm:ss";
    @Value(value="${call.esb.url.dealWaybillUpholdOrder}")
    private String dealWaybillUpholdOrderUrl;
    @Autowired
    private DycProOrderAfOrderRepository dycProOrderAfOrderRepository;
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;
    @Autowired
    private DycProOrderOrderRepository dycProOrderOrderRepository;

    @Override
    @PostMapping(value={"dealWaybillUphold"})
    public DycProOrderAfterOrderWaybillUpholdRspBO dealWaybillUphold(@RequestBody DycProOrderAfterOrderWaybillUpholdReqBO reqBO) {
        List<DycProOrderAfterOrderWaybillUpholdBO> waybillUpholdList = reqBO.getWaybillUpholdList();
        if (CollectionUtil.isNotEmpty(waybillUpholdList)) {
            for (DycProOrderAfterOrderWaybillUpholdBO waybillUpholdBO : waybillUpholdList) {
                DycProOrderAfterOrderWaybillUpholdReqBO req = (DycProOrderAfterOrderWaybillUpholdReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)waybillUpholdBO), DycProOrderAfterOrderWaybillUpholdReqBO.class));
                req.setRequestUrl(this.dealWaybillUpholdOrderUrl);
                DycProOrderAfterOrderWaybillUpholdRspBO dycProOrderAfterOrderWaybillUpholdRspBO = this.applyUpdate(req);
            }
        }
        return new DycProOrderAfterOrderWaybillUpholdRspBO();
    }

    public DycProOrderAfterOrderWaybillUpholdRspBO applyUpdate(DycProOrderAfterOrderWaybillUpholdReqBO reqBO) {
        DycProOrderAfterOrderWaybillUpholdRspBO rspBo;
        DycProOrderAfterOrderWaybillUpholdRspBO rsp;
        block9: {
            rsp = new DycProOrderAfterOrderWaybillUpholdRspBO();
            rsp.setBusiCode("0000");
            rsp.setBusiMsg("\u6210\u529f");
            this.validateArg(reqBO);
            rspBo = this.dealOrderWaybillUphold(reqBO);
            if (!"0000".equals(rspBo.getBusiCode())) {
                throw new ZTBusinessException("\u552e\u540e\u5355\u65b0\u589e\u8fd0\u5355\u4fe1\u606f\u5f02\u5e38,\u5f02\u5e38\u7f16\u7801\u3010" + rspBo.getBusiCode() + "\u3011," + rspBo.getBusiMsg());
            }
            if (ObjectUtil.isNotEmpty((Object)rspBo.getExtAfId())) {
                String hsn = DycPropertiesUtil.getProperty("SUPPLIER_ID_" + rspBo.getSupId());
                if (rspBo.getSupId().equals(DycPropertiesUtil.getProperty("SUPPLIER_JD_ID")) || rspBo.getSupId().equals(DycPropertiesUtil.getProperty("SUPPLIER_JDVOP_ID"))) {
                    try {
                        DycProOrderSaleOrderDTO uocGetSaleOrderDetailDto = new DycProOrderSaleOrderDTO();
                        uocGetSaleOrderDetailDto.setSaleOrderId(rspBo.getSaleOrderId());
                        DycProOrderSaleOrderDTO saleOrderDetail = this.dycProOrderSaleOrderRepository.querySaleOrderAllInfoById(uocGetSaleOrderDetailDto);
                        DycProBaseCallEsbUtilUpdateSendSkuForJdReqBO callEsbUtilReqBO = new DycProBaseCallEsbUtilUpdateSendSkuForJdReqBO();
                        DycProBaseCallEsbUtilUpdateSendSkuParamForJdBO param = new DycProBaseCallEsbUtilUpdateSendSkuParamForJdBO();
                        callEsbUtilReqBO.setHsn(hsn);
                        callEsbUtilReqBO.setUrl(reqBO.getRequestUrl());
                        param.setOrderId(Long.valueOf(saleOrderDetail.getSaleOrderNoExt()));
                        param.setThirdApplyId(rspBo.getThirdApplyId());
                        ArrayList<DycProBaseCallEsbUtilUpdateSendSkuWaybillInfoForJdBO> waybillInfoList = new ArrayList<DycProBaseCallEsbUtilUpdateSendSkuWaybillInfoForJdBO>();
                        DycProBaseCallEsbUtilUpdateSendSkuWaybillInfoForJdBO waybillInfo = new DycProBaseCallEsbUtilUpdateSendSkuWaybillInfoForJdBO();
                        waybillInfo.setExpressCompany(reqBO.getForwardCompany());
                        waybillInfo.setExpressCode(reqBO.getForwardOrderNo());
                        waybillInfo.setDeliverDate(DateUtil.format((Date)reqBO.getForwardDate(), (String)patton));
                        waybillInfo.setFreightMoney(new BigDecimal(reqBO.getFreight()));
                        waybillInfo.setWareId(Long.valueOf(((DycProOrderSaleOrderItemDTO)saleOrderDetail.getSaleItemList().get(0)).getSkuExtSkuId()));
                        waybillInfo.setWareType(Integer.valueOf(10));
                        waybillInfo.setWareNum(Integer.valueOf(reqBO.getSendCount()));
                        waybillInfoList.add(waybillInfo);
                        param.setWaybillInfoList(waybillInfoList);
                        callEsbUtilReqBO.setParam(param);
                        DycProBaseCallEsbUtilUpdateSendSkuForJdRspBO CallEsbUtilUpdateSendSkuForJdRspBo = DycProBaseCallEsbUtil.updateSendSkuForJd((DycProBaseCallEsbUtilUpdateSendSkuForJdReqBO)callEsbUtilReqBO);
                        if (!CallEsbUtilUpdateSendSkuForJdRspBo.getSuccess().booleanValue()) {
                            throw new ZTBusinessException("\u8c03\u7528\u4e09\u65b9\u7535\u5546\u63a8\u9001\u8fd0\u5355\u4fe1\u606f\u5931\u8d25");
                        }
                        break block9;
                    }
                    catch (ZTBusinessException e) {
                        throw new ZTBusinessException(e.getMessage());
                    }
                }
                try {
                    DycProBaseCallEsbUtilUpdateSendSkuReqBO callEsbUtilUpdateSendSkuReqBo = new DycProBaseCallEsbUtilUpdateSendSkuReqBO();
                    callEsbUtilUpdateSendSkuReqBo.setHsn(hsn);
                    callEsbUtilUpdateSendSkuReqBo.setUrl(reqBO.getRequestUrl());
                    callEsbUtilUpdateSendSkuReqBo.setAfsServiceId(rspBo.getExtAfId());
                    callEsbUtilUpdateSendSkuReqBo.setFreightMoney(new BigDecimal(reqBO.getFreight()));
                    callEsbUtilUpdateSendSkuReqBo.setExpressCompany(reqBO.getForwardCompany());
                    callEsbUtilUpdateSendSkuReqBo.setDeliverDate(DateUtil.format((Date)reqBO.getForwardDate(), (String)patton));
                    callEsbUtilUpdateSendSkuReqBo.setTrackingCode(reqBO.getForwardOrderNo());
                    DycProBaseCallEsbUtilUpdateSendSkuRspBO CallEsbUtilUpdateSendSkuRspBO = DycProBaseCallEsbUtil.updateSendSku((DycProBaseCallEsbUtilUpdateSendSkuReqBO)callEsbUtilUpdateSendSkuReqBo);
                    if (!CallEsbUtilUpdateSendSkuRspBO.getSuccess().booleanValue()) {
                        throw new ZTBusinessException("\u8c03\u7528\u4e09\u65b9\u7535\u5546\u63a8\u9001\u8fd0\u5355\u4fe1\u606f\u5931\u8d25");
                    }
                }
                catch (ZTBusinessException e) {
                    throw new ZTBusinessException(e.getMessage());
                }
            }
        }
        rsp.setTaskId(rspBo.getTaskId());
        rsp.setStepId(rspBo.getStepId());
        return rsp;
    }

    public DycProOrderAfterOrderWaybillUpholdRspBO dealOrderWaybillUphold(DycProOrderAfterOrderWaybillUpholdReqBO reqBo) {
        DycProOrderAfterOrderWaybillUpholdRspBO rspBo = UocRu.success(DycProOrderAfterOrderWaybillUpholdRspBO.class);
        this.validateArg(reqBo);
        DycProOrderAfOrderWaybillDTO uocAfOrderWaybillDto = UocRu.js((Object)reqBo, DycProOrderAfOrderWaybillDTO.class);
        try {
            uocAfOrderWaybillDto.setFreight(Long.valueOf(Long.parseLong(reqBo.getFreight())));
        }
        catch (NumberFormatException e) {
            throw new ZTBusinessException("\u8f6c\u6362\u8fd0\u8d39\u5931\u8d25," + e.getMessage());
        }
        uocAfOrderWaybillDto.setToPay(Long.valueOf(Long.parseLong(reqBo.getToPay().toString())));
        uocAfOrderWaybillDto.setCreateTime(new Date());
        uocAfOrderWaybillDto.setCreateOperId(String.valueOf(reqBo.getUserId()));
        uocAfOrderWaybillDto.setId(Long.valueOf(IdUtil.nextId()));
        this.dycProOrderAfOrderRepository.saveAfOrderWayBill(uocAfOrderWaybillDto);
        DycProOrderAfOrderDTO uocAfOrderDto = new DycProOrderAfOrderDTO();
        uocAfOrderDto.setOrderId(reqBo.getOrderId());
        uocAfOrderDto.setAfOrderId(reqBo.getAfOrderId());
        DycProOrderAfOrderDTO afOrderById = this.dycProOrderAfOrderRepository.getAfOrderById(uocAfOrderDto);
        String extAfId = afOrderById.getExtAfId();
        rspBo.setExtAfId(extAfId);
        rspBo.setSaleOrderId(afOrderById.getSaleOrderId());
        rspBo.setThirdApplyId(extAfId);
        DycProOrderSaleOrderDTO qry = new DycProOrderSaleOrderDTO();
        qry.setSaleOrderId(afOrderById.getSaleOrderId());
        DycProOrderSaleOrderDTO saleOrderMain = this.dycProOrderSaleOrderRepository.querySaleOrderOneByCondition(qry);
        DycProOrderOrderStakeholderDTO uocOrderStakeholderQryBo = new DycProOrderOrderStakeholderDTO();
        uocOrderStakeholderQryBo.setOrderId(reqBo.getOrderId());
        uocOrderStakeholderQryBo.setStakeholderId(saleOrderMain.getStakeholderId());
        List uocOrderStakeholderQryBos = this.dycProOrderOrderRepository.qryStakeholderList(uocOrderStakeholderQryBo);
        if (CollectionUtil.isNotEmpty((Collection)uocOrderStakeholderQryBos)) {
            String supId = ((DycProOrderOrderStakeholderDTO)uocOrderStakeholderQryBos.get(0)).getSupId();
            rspBo.setSupId(supId);
        }
        DycProOrderAfOrderDTO uocAfterOrderDto = new DycProOrderAfOrderDTO();
        uocAfterOrderDto.setAfOrderId(reqBo.getAfOrderId());
        uocAfterOrderDto.setWaybillFlag(Integer.valueOf(0));
        this.dycProOrderAfOrderRepository.modifyAfOrder(uocAfterOrderDto);
        return rspBo;
    }

    private void validateArg(DycProOrderAfterOrderWaybillUpholdReqBO reqBo) {
        if (reqBo == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null != reqBo.getOrderId()) {
            throw new ZTBusinessException("\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null != reqBo.getAfOrderId()) {
            throw new ZTBusinessException("\u552e\u540e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((String)reqBo.getFreight())) {
            throw new ZTBusinessException("\u8fd0\u8d39\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null != reqBo.getToPay()) {
            throw new ZTBusinessException("\u662f\u5426\u5230\u4ed8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((String)reqBo.getForwardCompany())) {
            throw new ZTBusinessException("\u53d1\u8fd0\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null != reqBo.getForwardDate()) {
            throw new ZTBusinessException("\u53d1\u8fd0\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((String)reqBo.getForwardOrderNo())) {
            throw new ZTBusinessException("\u8fd0\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((String)reqBo.getSendCount())) {
            throw new ZTBusinessException("\u672c\u6b21\u53d1\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

