/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.aforder.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtil;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTypeBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTypeForJdReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTypeForJdRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTypeParamForJdBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTypeReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTypeRspBO;
import com.tydic.dyc.pro.egc.constant.DycProOrderManageServiceConstant;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemQryDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.api.DycProOrderShipOrderRepository;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderQryDTO;
import com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderQryAfterTypeService;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderAfterOrderTypeBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderQryAfterTypeServiceBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderQryAfterTypeServiceReqBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderQryAfterTypeServiceRspBO;
import com.tydic.dyc.pro.egc.utils.DycPropertiesUtil;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderQryAfterTypeService"})
public class DycProOrderQryAfterTypeServiceImpl
implements DycProOrderQryAfterTypeService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderQryAfterTypeServiceImpl.class);
    @Autowired
    private DycProOrderShipOrderRepository dycProOrderShipOrderRepository;
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;
    @Value(value="${call.esb.url.afterType}")
    private String callEsbAfterTypeUrl;

    @Override
    @PostMapping(value={"qryAfterServiceType"})
    public DycProOrderQryAfterTypeServiceRspBO qryAfterServiceType(@RequestBody DycProOrderQryAfterTypeServiceReqBO reqBo) {
        this.paramVerify(reqBo);
        if (DycProOrderManageServiceConstant.OrderSource.E_ORDER.equals(reqBo.getOrderSource())) {
            DycProOrderQryAfterTypeServiceRspBO rspBO = new DycProOrderQryAfterTypeServiceRspBO();
            rspBO.setBusiCode("0000");
            rspBO.setBusiMsg("\u6210\u529f");
            DycProOrderSaleOrderItemQryDTO saleOrderItemDto = new DycProOrderSaleOrderItemQryDTO();
            saleOrderItemDto.setSaleOrderId(reqBo.getSaleOrderId());
            List saleOrderItemList = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(saleOrderItemDto);
            Iterator<Long> iterator = reqBo.getSaleItemIdList().iterator();
            if (iterator.hasNext()) {
                Long itemId = iterator.next();
                DycProOrderAfterOrderTypeBO afterOrderType = this.buildThirdEntity(reqBo, itemId, saleOrderItemList);
                String hsn = DycPropertiesUtil.getProperty("SUPPLIER_ID_" + reqBo.getSupId());
                if (reqBo.getSupId().equals(DycPropertiesUtil.getProperty("SUPPLIER_JD_ID")) || reqBo.getSupId().equals(DycPropertiesUtil.getProperty("SUPPLIER_JDVOP_ID"))) {
                    DycProBaseCallEsbUtilAfterTypeForJdReqBO callEsbUtilAfterTypeForJdReqBO = new DycProBaseCallEsbUtilAfterTypeForJdReqBO();
                    callEsbUtilAfterTypeForJdReqBO.setHsn(hsn);
                    callEsbUtilAfterTypeForJdReqBO.setUrl(this.callEsbAfterTypeUrl);
                    DycProBaseCallEsbUtilAfterTypeParamForJdBO CallEsbUtilAfterTypeParamForJdBO = new DycProBaseCallEsbUtilAfterTypeParamForJdBO();
                    CallEsbUtilAfterTypeParamForJdBO.setOrderId(Long.valueOf(afterOrderType.getOrderId()));
                    CallEsbUtilAfterTypeParamForJdBO.setWareIds(Collections.singletonList(Long.valueOf(afterOrderType.getSkuId())));
                    callEsbUtilAfterTypeForJdReqBO.setParam(CallEsbUtilAfterTypeParamForJdBO);
                    try {
                        DycProBaseCallEsbUtilAfterTypeForJdRspBO CallEsbUtilAfterTypeForJdRspBO = DycProBaseCallEsbUtil.afterTypeForJd((DycProBaseCallEsbUtilAfterTypeForJdReqBO)callEsbUtilAfterTypeForJdReqBO);
                        this.resolveJDRsp(CallEsbUtilAfterTypeForJdRspBO, rspBO);
                    }
                    catch (ZTBusinessException e) {
                        throw new ZTBusinessException("\u4eac\u4e1c\u552e\u540e\u65b9\u5f0f\u67e5\u8be2\u5f02\u5e38: " + e.getMessage());
                    }
                }
                DycProBaseCallEsbUtilAfterTypeReqBO callEsbUtilAfterTypeReqBO = new DycProBaseCallEsbUtilAfterTypeReqBO();
                callEsbUtilAfterTypeReqBO.setHsn(hsn);
                callEsbUtilAfterTypeReqBO.setUrl(this.callEsbAfterTypeUrl);
                callEsbUtilAfterTypeReqBO.setOrderId(afterOrderType.getOrderId());
                callEsbUtilAfterTypeReqBO.setSkuId(afterOrderType.getSkuId());
                try {
                    DycProBaseCallEsbUtilAfterTypeRspBO CallEsbUtilAfterTypeRspBO = DycProBaseCallEsbUtil.afterType((DycProBaseCallEsbUtilAfterTypeReqBO)callEsbUtilAfterTypeReqBO);
                    this.resolveRsp(CallEsbUtilAfterTypeRspBO, rspBO);
                }
                catch (ZTBusinessException e) {
                    throw new ZTBusinessException("\u552e\u540e\u65b9\u5f0f\u67e5\u8be2\u5f02\u5e38: " + e.getMessage());
                }
                return rspBO;
            }
        } else if (DycProOrderManageServiceConstant.OrderSource.AGR_ORDER.equals(reqBo.getOrderSource()) || DycProOrderManageServiceConstant.OrderSource.SELF.equals(reqBo.getOrderSource())) {
            DycProOrderQryAfterTypeServiceRspBO rspBo = new DycProOrderQryAfterTypeServiceRspBO();
            rspBo.setServerTypes(new ArrayList<DycProOrderQryAfterTypeServiceBO>());
            DycProOrderShipOrderQryDTO ShipOrderQryBo = new DycProOrderShipOrderQryDTO();
            ShipOrderQryBo.setShipOrderId(reqBo.getShipOrderId());
            ShipOrderQryBo.setOrderId(reqBo.getOrderId());
            DycProOrderShipOrderDTO shipOrderById = this.dycProOrderShipOrderRepository.getShipOrderById(ShipOrderQryBo);
            log.info("\u6539\u53d1\u8d27\u5355\uff1a" + shipOrderById);
            Date date = new Date();
            Date arriveTime = shipOrderById.getArriveTime() == null ? date : shipOrderById.getArriveTime();
            boolean returnEffectFlag = (date.getTime() - arriveTime.getTime()) / 86400000L >= 7L;
            boolean exchangeFlag = (date.getTime() - arriveTime.getTime()) / 86400000L >= 7L;
            boolean repairFlag = (date.getTime() - arriveTime.getTime()) / 86400000L >= 7L;
            Date afterSeven = new Date(arriveTime.getTime() + 604800000L);
            ZoneId zoneId = ZoneId.systemDefault();
            LocalDateTime localDateTime = afterSeven.toInstant().atZone(zoneId).toLocalDateTime();
            ArrayList<DycProOrderSaleOrderItemDTO> saleOrderItems = new ArrayList<DycProOrderSaleOrderItemDTO>();
            List<Long> saleItemIdList = reqBo.getSaleItemIdList();
            DycProOrderSaleOrderItemQryDTO saleOrderItemDto = new DycProOrderSaleOrderItemQryDTO();
            saleOrderItemDto.setSaleOrderId(reqBo.getSaleOrderId());
            List saleOrderItemList = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(saleOrderItemDto);
            Map<Long, DycProOrderSaleOrderItemDTO> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSaleOrderItemId, item -> item, (k1, k2) -> k1));
            for (Long saleOrderItemId : saleItemIdList) {
                if (null == saleOrderItemMap.get(saleOrderItemId)) continue;
                saleOrderItems.add(saleOrderItemMap.get(saleOrderItemId));
            }
            if (CollectionUtil.isEmpty(saleOrderItems)) {
                throw new ZTBusinessException("\u67e5\u8be2\u9500\u552e\u5355\u660e\u7ec6\u5bf9\u8c61\u5c5e\u6027\u4e3a\u7a7a");
            }
            ArrayList afTypesList = new ArrayList();
            for (DycProOrderSaleOrderItemDTO saleOrderItem : saleOrderItems) {
                ArrayList<Integer> afTypesLists = new ArrayList<Integer>();
                if (null != saleOrderItem.getRejectAllowDate()) {
                    afTypesLists.add(DycProOrderManageServiceConstant.AfterServType.RETURN);
                }
                if (null != saleOrderItem.getExchangeAllowDate()) {
                    afTypesLists.add(DycProOrderManageServiceConstant.AfterServType.CHANGE);
                }
                if (null != saleOrderItem.getMaintainAllowDate()) {
                    afTypesLists.add(DycProOrderManageServiceConstant.AfterServType.FIX);
                }
                if (!CollectionUtils.isEmpty(afTypesList)) {
                    afTypesList = (ArrayList)CollectionUtil.intersection(afTypesList, afTypesLists);
                    continue;
                }
                afTypesList.addAll(afTypesLists);
            }
            afTypesList.stream().sorted(Comparator.comparingInt(o -> o)).forEach(integer -> {
                DycProOrderQryAfterTypeServiceBO afterOrderTypeServiceBo = new DycProOrderQryAfterTypeServiceBO();
                afterOrderTypeServiceBo.setServerType((Integer)integer);
                afterOrderTypeServiceBo.setServerTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)"EgcAfOrderServType", (String)afterOrderTypeServiceBo.getServerType().toString()));
                afterOrderTypeServiceBo.setCanApply(Boolean.TRUE);
                if (integer.equals(DycProOrderManageServiceConstant.ServiceType.RETURN_GOODS)) {
                    if ("FH_FH_YS".equals(shipOrderById.getShipOrderState())) {
                        afterOrderTypeServiceBo.setCanApply(Boolean.FALSE);
                        afterOrderTypeServiceBo.setServerDesc("\u5df2\u9a8c\u6536\u5546\u54c1\u4e0d\u652f\u6301\u552e\u540e");
                    } else {
                        afterOrderTypeServiceBo.setCanApply(returnEffectFlag ? Boolean.FALSE : Boolean.TRUE);
                        afterOrderTypeServiceBo.setServerDesc(returnEffectFlag ? "\u5df2\u4e8e" + localDateTime.toLocalDate() + "0\u65f6\u8d85\u8fc7\u7533\u8bf7\u671f" : localDateTime.toLocalDate() + "\u524d\u53ef\u7533\u8bf7");
                    }
                }
                if (integer.equals(DycProOrderManageServiceConstant.ServiceType.EXCHANGE_GOODS)) {
                    afterOrderTypeServiceBo.setCanApply(exchangeFlag ? Boolean.FALSE : Boolean.TRUE);
                    afterOrderTypeServiceBo.setServerDesc(exchangeFlag ? "\u5df2\u4e8e" + localDateTime.toLocalDate() + "0\u65f6\u8d85\u8fc7\u7533\u8bf7\u671f" : localDateTime.toLocalDate() + "\u524d\u53ef\u7533\u8bf7");
                }
                if (integer.equals(DycProOrderManageServiceConstant.ServiceType.REPAIR)) {
                    afterOrderTypeServiceBo.setCanApply(repairFlag ? Boolean.FALSE : Boolean.TRUE);
                    afterOrderTypeServiceBo.setServerDesc(repairFlag ? "\u5df2\u4e8e" + localDateTime.toLocalDate() + "0\u65f6\u8d85\u8fc7\u7533\u8bf7\u671f" : localDateTime.toLocalDate() + "\u524d\u53ef\u7533\u8bf7");
                }
                rspBo.getServerTypes().add(afterOrderTypeServiceBo);
            });
            return rspBo;
        }
        return new DycProOrderQryAfterTypeServiceRspBO();
    }

    private void resolveJDRsp(DycProBaseCallEsbUtilAfterTypeForJdRspBO callEsbUtilAfterTypeForJdRspBO, DycProOrderQryAfterTypeServiceRspBO rspBO) {
        ArrayList<DycProOrderQryAfterTypeServiceBO> afterOrderTypeServiceBos = new ArrayList<DycProOrderQryAfterTypeServiceBO>();
        if (callEsbUtilAfterTypeForJdRspBO.getSuccess().booleanValue() && callEsbUtilAfterTypeForJdRspBO.getResult() != null) {
            List result = callEsbUtilAfterTypeForJdRspBO.getResult();
            ArrayList customerExpect = new ArrayList();
            for (Object callEsbUtilAfterTypeSupportedInfoForJdBo : result) {
                customerExpect.addAll(callEsbUtilAfterTypeSupportedInfoForJdBo.getCustomerExpect());
            }
            List resultByOrder = customerExpect.stream().sorted(new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return o1.compareTo(o2);
                }
            }).collect(Collectors.toList());
            for (Integer type : resultByOrder) {
                DycProOrderQryAfterTypeServiceBO afterOrderTypeServiceBo;
                if (DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTypeConstant.JD_RETURN.equals(type)) {
                    afterOrderTypeServiceBo = new DycProOrderQryAfterTypeServiceBO();
                    afterOrderTypeServiceBo.setServerType(DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTypeConstant.LOCAL_RETURN);
                    afterOrderTypeServiceBo.setServerName("\u9000\u8d27");
                    afterOrderTypeServiceBo.setCanApply(Boolean.TRUE);
                    afterOrderTypeServiceBos.add(afterOrderTypeServiceBo);
                    continue;
                }
                if (DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTypeConstant.JD_CHANGE.equals(type)) {
                    afterOrderTypeServiceBo = new DycProOrderQryAfterTypeServiceBO();
                    afterOrderTypeServiceBo.setServerType(DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTypeConstant.LOCAL_CHANGE);
                    afterOrderTypeServiceBo.setServerName("\u6362\u8d27");
                    afterOrderTypeServiceBo.setCanApply(Boolean.TRUE);
                    afterOrderTypeServiceBos.add(afterOrderTypeServiceBo);
                    continue;
                }
                if (!DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTypeConstant.JD_FIX.equals(type)) continue;
                afterOrderTypeServiceBo = new DycProOrderQryAfterTypeServiceBO();
                afterOrderTypeServiceBo.setServerType(DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTypeConstant.LOCAL_FIX);
                afterOrderTypeServiceBo.setServerName("\u7ef4\u4fee");
                afterOrderTypeServiceBo.setCanApply(Boolean.TRUE);
                afterOrderTypeServiceBos.add(afterOrderTypeServiceBo);
            }
            if (CollectionUtils.isEmpty(rspBO.getServerTypes())) {
                rspBO.setServerTypes(afterOrderTypeServiceBos);
            } else {
                List intersection = (List)CollectionUtil.intersection(rspBO.getServerTypes(), afterOrderTypeServiceBos);
                rspBO.setServerTypes(intersection);
            }
        }
    }

    private void resolveRsp(DycProBaseCallEsbUtilAfterTypeRspBO callEsbUtilAfterTypeRspBO, DycProOrderQryAfterTypeServiceRspBO rspBO) {
        ArrayList<DycProOrderQryAfterTypeServiceBO> afterOrderTypeServiceBos = new ArrayList<DycProOrderQryAfterTypeServiceBO>();
        if (callEsbUtilAfterTypeRspBO.getSuccess().booleanValue() && callEsbUtilAfterTypeRspBO.getResult() != null) {
            List result = callEsbUtilAfterTypeRspBO.getResult();
            List resultByOrder = result.stream().sorted(new Comparator<DycProBaseCallEsbUtilAfterTypeBO>(){

                @Override
                public int compare(DycProBaseCallEsbUtilAfterTypeBO o1, DycProBaseCallEsbUtilAfterTypeBO o2) {
                    return o1.getType().compareTo(o1.getType());
                }
            }).collect(Collectors.toList());
            for (DycProBaseCallEsbUtilAfterTypeBO callEsbUtilAfterTypeBo : resultByOrder) {
                DycProOrderQryAfterTypeServiceBO afterOrderTypeServiceBo;
                Integer type = callEsbUtilAfterTypeBo.getType();
                if (DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTypeConstant.RETURN.equals(type)) {
                    afterOrderTypeServiceBo = new DycProOrderQryAfterTypeServiceBO();
                    afterOrderTypeServiceBo.setServerType(DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTypeConstant.LOCAL_RETURN);
                    afterOrderTypeServiceBo.setServerName("\u9000\u8d27");
                    afterOrderTypeServiceBo.setCanApply(Boolean.TRUE);
                    afterOrderTypeServiceBos.add(afterOrderTypeServiceBo);
                    continue;
                }
                if (DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTypeConstant.CHANGE.equals(type)) {
                    afterOrderTypeServiceBo = new DycProOrderQryAfterTypeServiceBO();
                    afterOrderTypeServiceBo.setServerType(DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTypeConstant.LOCAL_CHANGE);
                    afterOrderTypeServiceBo.setServerName("\u6362\u8d27");
                    afterOrderTypeServiceBo.setCanApply(Boolean.TRUE);
                    afterOrderTypeServiceBos.add(afterOrderTypeServiceBo);
                    continue;
                }
                if (!DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTypeConstant.FIX.equals(type)) continue;
                afterOrderTypeServiceBo = new DycProOrderQryAfterTypeServiceBO();
                afterOrderTypeServiceBo.setServerType(DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTypeConstant.LOCAL_FIX);
                afterOrderTypeServiceBo.setServerName("\u7ef4\u4fee");
                afterOrderTypeServiceBo.setCanApply(Boolean.TRUE);
                afterOrderTypeServiceBos.add(afterOrderTypeServiceBo);
            }
            if (CollectionUtil.isEmpty(rspBO.getServerTypes())) {
                rspBO.setServerTypes(afterOrderTypeServiceBos);
            } else {
                List intersection = (List)CollectionUtil.intersection(rspBO.getServerTypes(), afterOrderTypeServiceBos);
                rspBO.setServerTypes(intersection);
            }
        }
    }

    private DycProOrderAfterOrderTypeBO buildThirdEntity(DycProOrderQryAfterTypeServiceReqBO reqBo, Long itemId, List<DycProOrderSaleOrderItemDTO> saleOrderItemList) {
        Map<Long, DycProOrderSaleOrderItemDTO> itemMap = saleOrderItemList.stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSaleOrderItemId, o -> o));
        DycProOrderSaleOrderItemDTO SaleItem = itemMap.get(itemId);
        DycProOrderAfterOrderTypeBO afterOrderTypeBo = new DycProOrderAfterOrderTypeBO();
        afterOrderTypeBo.setOrderId(reqBo.getSaleOrderNoExt());
        afterOrderTypeBo.setSkuId(SaleItem.getSkuExtSkuId());
        return afterOrderTypeBo;
    }

    private void paramVerify(DycProOrderQryAfterTypeServiceReqBO reqBo) {
        if (reqBo == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBo.getSaleItemIdList())) {
            throw new ZTBusinessException("\u9500\u552e\u5355\u660e\u7ec6id\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new ZTBusinessException("\u8ba2\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new ZTBusinessException("\u9500\u552e\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getShipOrderId()) {
            throw new ZTBusinessException("\u53d1\u8d27\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderSource()) {
            throw new ZTBusinessException("\u8ba2\u5355\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBo.getSaleOrderNoExt())) {
            throw new ZTBusinessException("\u9500\u552e\u5916\u90e8\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBo.getSupId())) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

