/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.aforder.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtil;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTakeReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTakeRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTypeForJdReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTypeForJdRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTypeParamForJdBO;
import com.tydic.dyc.pro.egc.constant.DycProOrderRspConstants;
import com.tydic.dyc.pro.egc.repository.aforder.dto.DycProOrderSaleGoodsAfterTakeTypeDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderQueryAfterTakeService;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderAfterTakeBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderAfterTakeTypeBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderAfterTypeAndTakeValueEntity;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderJDAfterTypeAndTakeValueEntity;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderQueryAfterTakeServiceReqBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderQueryAfterTakeServiceRspBO;
import com.tydic.dyc.pro.egc.utils.DycPropertiesUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderQueryAfterTakeService"})
public class DycProOrderQueryAfterTakeServiceImpl
implements DycProOrderQueryAfterTakeService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderQueryAfterTakeServiceImpl.class);
    @Value(value="${ESB_QRY_AFTER_TAKE_TYPE_URL}")
    private String esbQryArterTakeUrl;
    @Value(value="${ESB_QRY_AFTER_TYPE_URL}")
    private String esbQryArterTypeUrl;
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;

    @Override
    @PostMapping(value={"queryAfterTake"})
    public DycProOrderQueryAfterTakeServiceRspBO queryAfterTake(@RequestBody DycProOrderQueryAfterTakeServiceReqBO reqBO) {
        this.validateArg(reqBO);
        List<String> orderSourceList = reqBO.getOrderSourceList();
        DycProOrderQueryAfterTakeServiceRspBO rspBO = new DycProOrderQueryAfterTakeServiceRspBO();
        if ("2".equals(orderSourceList.get(0))) {
            DycProOrderSaleOrderDTO dycProOrderSaleOrderDTO = new DycProOrderSaleOrderDTO();
            dycProOrderSaleOrderDTO.setSaleOrderId(reqBO.getSaleOrderId());
            DycProOrderSaleOrderDTO saleOrderDetail = this.dycProOrderSaleOrderRepository.querySaleOrderAllInfoById(dycProOrderSaleOrderDTO);
            String saleOrderNoExt = saleOrderDetail.getSaleOrderNoExt();
            String hsn = DycPropertiesUtil.getProperty("supplierId" + saleOrderDetail.getSaleStakeholder().getSupNo());
            Map<Long, DycProOrderSaleOrderItemDTO> itemBoMap = saleOrderDetail.getSaleItemList().stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSaleOrderItemId, o -> o));
            for (Long itemId : reqBO.getOrdItemList()) {
                String skuExtSkuId = itemBoMap.get(itemId).getSkuExtSkuId();
                if (saleOrderDetail.getSaleStakeholder().getSupNo().equals(DycPropertiesUtil.getProperty("SUPPLIER_JD_ID")) || saleOrderDetail.getSaleStakeholder().getSupNo().equals(DycPropertiesUtil.getProperty("SUPPLIER_JDVOP_ID"))) {
                    try {
                        DycProBaseCallEsbUtilAfterTypeForJdReqBO dycProBaseCallEsbUtilAfterTypeForJdReqBO = new DycProBaseCallEsbUtilAfterTypeForJdReqBO();
                        DycProBaseCallEsbUtilAfterTypeParamForJdBO parm = new DycProBaseCallEsbUtilAfterTypeParamForJdBO();
                        dycProBaseCallEsbUtilAfterTypeForJdReqBO.setUrl(this.esbQryArterTypeUrl);
                        dycProBaseCallEsbUtilAfterTypeForJdReqBO.setHsn(hsn);
                        parm.setOrderId(Long.valueOf(saleOrderNoExt));
                        parm.setWareIds(Collections.singletonList(Long.valueOf(skuExtSkuId)));
                        dycProBaseCallEsbUtilAfterTypeForJdReqBO.setParam(parm);
                        DycProBaseCallEsbUtilAfterTypeForJdRspBO dycProBaseCallEsbUtilAfterTypeForJdRspBO = DycProBaseCallEsbUtil.afterTypeForJd((DycProBaseCallEsbUtilAfterTypeForJdReqBO)dycProBaseCallEsbUtilAfterTypeForJdReqBO);
                        this.resolveJDRsp(dycProBaseCallEsbUtilAfterTypeForJdRspBO, rspBO);
                        continue;
                    }
                    catch (ZTBusinessException e2) {
                        throw new ZTBusinessException(e2.getMessage());
                    }
                }
                try {
                    DycProBaseCallEsbUtilAfterTakeReqBO dycProBaseCallEsbUtilAfterTakeReqBO = new DycProBaseCallEsbUtilAfterTakeReqBO();
                    dycProBaseCallEsbUtilAfterTakeReqBO.setUrl(this.esbQryArterTakeUrl);
                    dycProBaseCallEsbUtilAfterTakeReqBO.setHsn(hsn);
                    dycProBaseCallEsbUtilAfterTakeReqBO.setOrderId(saleOrderNoExt);
                    dycProBaseCallEsbUtilAfterTakeReqBO.setSkuId(skuExtSkuId);
                    DycProBaseCallEsbUtilAfterTakeRspBO dycProBaseCallEsbUtilAfterTakeRspBO = DycProBaseCallEsbUtil.afterTake((DycProBaseCallEsbUtilAfterTakeReqBO)dycProBaseCallEsbUtilAfterTakeReqBO);
                    this.resolveRsp(dycProBaseCallEsbUtilAfterTakeRspBO, rspBO);
                }
                catch (ZTBusinessException e3) {
                    throw new ZTBusinessException(e3.getMessage());
                }
            }
            return rspBO;
        }
        if ("3".equals(orderSourceList.get(0)) || "1".equals(orderSourceList.get(0))) {
            ArrayList<String> pCodes = new ArrayList<String>();
            pCodes.add("UOC_ORD_TAKE_TYPE");
            List<Long> saleOrderItemIds = reqBO.getOrdItemList();
            ArrayList takTypes = new ArrayList();
            saleOrderItemIds.forEach(e -> {
                DycProOrderSaleGoodsAfterTakeTypeDTO takeTypeDto = new DycProOrderSaleGoodsAfterTakeTypeDTO();
                takeTypeDto.setSaleOrderItemId(e);
                List takeTypeBos = this.dycProOrderSaleOrderRepository.qryCommityTakeTypes(takeTypeDto);
                takeTypeBos.forEach(t -> {
                    DycProOrderAfterTakeTypeBO dycProOrderAfterTakeTypeBO = new DycProOrderAfterTakeTypeBO();
                    dycProOrderAfterTakeTypeBO.setPickwareType(t.getAfterTakeType());
                    dycProOrderAfterTakeTypeBO.setPickwareTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)"EgcAfOrderPickwareType", (String)t.getAfterTakeType().toString()));
                    dycProOrderAfterTakeTypeBO.setSaleOrderItemId(t.getSaleOrderItemId());
                    takTypes.add(dycProOrderAfterTakeTypeBO);
                });
            });
            if (saleOrderItemIds.size() > 1) {
                ArrayList<DycProOrderAfterTakeBO> dycProOrderAfterTakeTypeBOS = new ArrayList<DycProOrderAfterTakeBO>();
                Map<Integer, List<DycProOrderAfterTakeTypeBO>> takTypeMap = takTypes.stream().collect(Collectors.groupingBy(DycProOrderAfterTakeTypeBO::getPickwareType));
                for (Integer pikcWareType : takTypeMap.keySet()) {
                    if (takTypeMap.get(pikcWareType).size() != saleOrderItemIds.size()) continue;
                    dycProOrderAfterTakeTypeBOS.add((DycProOrderAfterTakeBO)JSON.parseObject((String)JSON.toJSONString((Object)takTypeMap.get(pikcWareType).get(0)), DycProOrderAfterTakeBO.class));
                }
                rspBO.setAfterTakeList(dycProOrderAfterTakeTypeBOS);
                return rspBO;
            }
            rspBO.setAfterTakeList(JSON.parseArray((String)JSON.toJSONString(takTypes), DycProOrderAfterTakeBO.class));
            return rspBO;
        }
        return new DycProOrderQueryAfterTakeServiceRspBO();
    }

    private void resolveJDRsp(DycProBaseCallEsbUtilAfterTypeForJdRspBO dycProBaseCallEsbUtilAfterTypeForJdRspBO, DycProOrderQueryAfterTakeServiceRspBO funcRspBO) {
        ArrayList<DycProOrderAfterTakeBO> uocAfterServiceTypeQryServiceRspAfsBos = new ArrayList<DycProOrderAfterTakeBO>();
        if (dycProBaseCallEsbUtilAfterTypeForJdRspBO.getSuccess().booleanValue()) {
            try {
                List parseArray = JSON.parseArray((String)JSON.toJSONString((Object)dycProBaseCallEsbUtilAfterTypeForJdRspBO.getResult()), DycProOrderJDAfterTypeAndTakeValueEntity.class);
                ArrayList<Integer> pickupWareType = new ArrayList<Integer>();
                for (DycProOrderJDAfterTypeAndTakeValueEntity afterTypeAndTakeValueEntity : parseArray) {
                    pickupWareType.addAll(afterTypeAndTakeValueEntity.getPickupWareType());
                }
                List resultByOrder = pickupWareType.stream().sorted(new Comparator<Integer>(){

                    @Override
                    public int compare(Integer o1, Integer o2) {
                        return o1.compareTo(o2);
                    }
                }).collect(Collectors.toList());
                for (Integer type : resultByOrder) {
                    DycProOrderAfterTakeBO uocAfterServiceTypeQryServiceRspAfsBo;
                    if (DycProOrderRspConstants.ThirdApiCommonConstant.AfterTakeConstant.JD_SMQJ.equals(type)) {
                        uocAfterServiceTypeQryServiceRspAfsBo = new DycProOrderAfterTakeBO();
                        uocAfterServiceTypeQryServiceRspAfsBo.setPickwareType(type);
                        uocAfterServiceTypeQryServiceRspAfsBo.setPickwareTypeName("\u4e0a\u95e8\u53d6\u4ef6");
                        uocAfterServiceTypeQryServiceRspAfsBos.add(uocAfterServiceTypeQryServiceRspAfsBo);
                        continue;
                    }
                    if (DycProOrderRspConstants.ThirdApiCommonConstant.AfterTakeConstant.JD_KHFH.equals(type)) {
                        uocAfterServiceTypeQryServiceRspAfsBo = new DycProOrderAfterTakeBO();
                        uocAfterServiceTypeQryServiceRspAfsBo.setPickwareType(type);
                        uocAfterServiceTypeQryServiceRspAfsBo.setPickwareTypeName("\u5ba2\u6237\u53d1\u8d27");
                        uocAfterServiceTypeQryServiceRspAfsBos.add(uocAfterServiceTypeQryServiceRspAfsBo);
                        continue;
                    }
                    if (!DycProOrderRspConstants.ThirdApiCommonConstant.AfterTakeConstant.JD_KHSH.equals(type)) continue;
                    uocAfterServiceTypeQryServiceRspAfsBo = new DycProOrderAfterTakeBO();
                    uocAfterServiceTypeQryServiceRspAfsBo.setPickwareType(type);
                    uocAfterServiceTypeQryServiceRspAfsBo.setPickwareTypeName("\u5ba2\u6237\u9001\u8d27");
                    uocAfterServiceTypeQryServiceRspAfsBos.add(uocAfterServiceTypeQryServiceRspAfsBo);
                }
            }
            catch (Exception e) {
                funcRspBO.setAfterTakeList(uocAfterServiceTypeQryServiceRspAfsBos);
            }
            if (CollectionUtil.isEmpty(funcRspBO.getAfterTakeList())) {
                funcRspBO.setAfterTakeList(uocAfterServiceTypeQryServiceRspAfsBos);
            } else {
                List intersection = (List)CollectionUtil.intersection(funcRspBO.getAfterTakeList(), uocAfterServiceTypeQryServiceRspAfsBos);
                funcRspBO.setAfterTakeList(intersection);
            }
        }
    }

    private void resolveRsp(DycProBaseCallEsbUtilAfterTakeRspBO dycProBaseCallEsbUtilAfterTakeRspBO, DycProOrderQueryAfterTakeServiceRspBO funcRspBO) {
        ArrayList<DycProOrderAfterTakeBO> uocAfterServiceTypeQryServiceRspAfsBos = new ArrayList<DycProOrderAfterTakeBO>();
        if (dycProBaseCallEsbUtilAfterTakeRspBO.getSuccess().booleanValue()) {
            try {
                List parseArray = JSON.parseArray((String)JSON.toJSONString((Object)dycProBaseCallEsbUtilAfterTakeRspBO.getResult()), DycProOrderAfterTypeAndTakeValueEntity.class);
                List resultByOrder = parseArray.stream().sorted(new Comparator<DycProOrderAfterTypeAndTakeValueEntity>(){

                    @Override
                    public int compare(DycProOrderAfterTypeAndTakeValueEntity o1, DycProOrderAfterTypeAndTakeValueEntity o2) {
                        return o1.getType().compareTo(o2.getType());
                    }
                }).collect(Collectors.toList());
                for (DycProOrderAfterTypeAndTakeValueEntity dycProOrderAfterTypeAndTakeValueEntity : resultByOrder) {
                    DycProOrderAfterTakeBO uocAfterServiceTypeQryServiceRspAfsBo;
                    Integer type = dycProOrderAfterTypeAndTakeValueEntity.getType();
                    if (DycProOrderRspConstants.ThirdApiCommonConstant.AfterTakeConstant.SMQJ.equals(type)) {
                        uocAfterServiceTypeQryServiceRspAfsBo = new DycProOrderAfterTakeBO();
                        uocAfterServiceTypeQryServiceRspAfsBo.setPickwareType(type);
                        uocAfterServiceTypeQryServiceRspAfsBo.setPickwareTypeName("\u4e0a\u95e8\u53d6\u4ef6");
                        uocAfterServiceTypeQryServiceRspAfsBos.add(uocAfterServiceTypeQryServiceRspAfsBo);
                        continue;
                    }
                    if (DycProOrderRspConstants.ThirdApiCommonConstant.AfterTakeConstant.KHFH.equals(type)) {
                        uocAfterServiceTypeQryServiceRspAfsBo = new DycProOrderAfterTakeBO();
                        uocAfterServiceTypeQryServiceRspAfsBo.setPickwareType(type);
                        uocAfterServiceTypeQryServiceRspAfsBo.setPickwareTypeName("\u5ba2\u6237\u53d1\u8d27");
                        uocAfterServiceTypeQryServiceRspAfsBos.add(uocAfterServiceTypeQryServiceRspAfsBo);
                        continue;
                    }
                    if (!DycProOrderRspConstants.ThirdApiCommonConstant.AfterTakeConstant.KHSH.equals(type)) continue;
                    uocAfterServiceTypeQryServiceRspAfsBo = new DycProOrderAfterTakeBO();
                    uocAfterServiceTypeQryServiceRspAfsBo.setPickwareType(type);
                    uocAfterServiceTypeQryServiceRspAfsBo.setPickwareTypeName("\u5ba2\u6237\u9001\u8d27");
                    uocAfterServiceTypeQryServiceRspAfsBos.add(uocAfterServiceTypeQryServiceRspAfsBo);
                }
                if (CollectionUtil.isEmpty(funcRspBO.getAfterTakeList())) {
                    funcRspBO.setAfterTakeList(uocAfterServiceTypeQryServiceRspAfsBos);
                } else {
                    List intersection = (List)CollectionUtil.intersection(funcRspBO.getAfterTakeList(), uocAfterServiceTypeQryServiceRspAfsBos);
                    funcRspBO.setAfterTakeList(intersection);
                }
            }
            catch (Exception e) {
                funcRspBO.setAfterTakeList(uocAfterServiceTypeQryServiceRspAfsBos);
            }
        }
    }

    private void validateArg(DycProOrderQueryAfterTakeServiceReqBO reqBo) {
        if (null == reqBo) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new ZTBusinessException("\u9500\u552e\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtil.isEmpty(reqBo.getOrdItemList())) {
            throw new ZTBusinessException("\u8ba2\u5355\u660e\u7ec6Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtil.isEmpty(reqBo.getOrderSourceList())) {
            throw new ZTBusinessException("\u8ba2\u5355\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

