/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.chngorder.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.egc.repository.chngorder.api.DycProOrderChngOrderRepository;
import com.tydic.dyc.pro.egc.repository.chngorder.dto.DycProOrderChngOrderQryDTO;
import com.tydic.dyc.pro.egc.service.chngorder.api.DycProOrderQryChngOrderListPageService;
import com.tydic.dyc.pro.egc.service.chngorder.bo.DycProOrderChngOrderEsBO;
import com.tydic.dyc.pro.egc.service.chngorder.bo.DycProOrderQryChngOrderListPageReqBO;
import com.tydic.dyc.pro.egc.service.chngorder.bo.DycProOrderQryChngOrderListPageRspBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderTabCountBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.chngorder.api.DycProOrderQryChngOrderListPageService"})
public class DycProOrderQryChngOrderListPageServiceImpl
implements DycProOrderQryChngOrderListPageService {
    @Autowired
    private DycProOrderChngOrderRepository dycProOrderChngOrderRepository;

    @Override
    @PostMapping(value={"qryChngOrderListPage"})
    public DycProOrderQryChngOrderListPageRspBO qryChngOrderListPage(@RequestBody DycProOrderQryChngOrderListPageReqBO reqBO) {
        this.paramVerify(reqBO);
        DycProOrderChngOrderQryDTO qryDTO = (DycProOrderChngOrderQryDTO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycProOrderChngOrderQryDTO.class);
        qryDTO.setChngOrderStateList(this.getTabChngOrderState(reqBO.getTabId(), reqBO.getMenuCode()));
        RspPage rspPage = this.dycProOrderChngOrderRepository.queryChngOrderEsPageListByCondition(qryDTO);
        DycProOrderQryChngOrderListPageRspBO rspBO = new DycProOrderQryChngOrderListPageRspBO();
        if (!CollectionUtils.isEmpty((Collection)rspPage.getRows())) {
            rspBO = (DycProOrderQryChngOrderListPageRspBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)rspPage), DycProOrderQryChngOrderListPageRspBO.class));
            for (DycProOrderChngOrderEsBO saleOrder : rspBO.getRows()) {
                if (!saleOrder.getChngOrderObjList().isEmpty()) {
                    saleOrder.setSaleOrderId(saleOrder.getChngOrderObjList().get(0).getSaleOrderId());
                }
                saleOrder.setChngOrderStateStr(DictionaryFrameworkUtils.getDicDataByCode((String)"EgcSaleOrderChngOrderState", (String)saleOrder.getChngOrderState()));
            }
        }
        this.buildTabCount(rspBO, reqBO);
        return rspBO;
    }

    private void paramVerify(DycProOrderQryChngOrderListPageReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getMenuCode())) {
            throw new ZTBusinessException("\u5165\u53c2\u83dc\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getPageNo() < 1) {
            throw new ZTBusinessException("\u9875\u7801\u4e0d\u80fd\u5c0f\u4e8e1");
        }
        if (reqBO.getPageSize() < 1) {
            throw new ZTBusinessException("\u6bcf\u9875\u8bb0\u5f55\u6570\u4e0d\u80fd\u5c0f\u4e8e1");
        }
    }

    private List<String> getTabChngOrderState(String tabId, String menuCode) {
        ArrayList<String> chngOrderStateList = new ArrayList<String>(1);
        if ("cancleAppList".equals(menuCode)) {
            chngOrderStateList.add("CHNG_XS_QXSQZ");
            chngOrderStateList.add("CHNG_XS_YQR");
            chngOrderStateList.add("CHNG_XS_YJJ");
            chngOrderStateList.add("CHNG_XS_YCX");
        } else if ("orderTodoList".equals(menuCode)) {
            if ("1001".equals(tabId)) {
                chngOrderStateList.add("CHNG_XS_QXSQZ");
            } else if ("1002".equals(tabId)) {
                chngOrderStateList.add("CHNG_XS_YQR");
                chngOrderStateList.add("CHNG_XS_YJJ");
            }
        }
        return chngOrderStateList;
    }

    private void buildTabCount(DycProOrderQryChngOrderListPageRspBO rspBO, DycProOrderQryChngOrderListPageReqBO reqBO) {
        DycProOrderChngOrderQryDTO qryTabCountDTO = (DycProOrderChngOrderQryDTO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycProOrderChngOrderQryDTO.class);
        ArrayList<DycProOrderTabCountBO> tabCountList = new ArrayList<DycProOrderTabCountBO>(1);
        if ("orderTodoList".equals(reqBO.getMenuCode())) {
            qryTabCountDTO.setChngOrderStateList(this.getTabChngOrderState("1001", reqBO.getMenuCode()));
            DycProOrderTabCountBO inDoOrderTabCountBO = new DycProOrderTabCountBO();
            inDoOrderTabCountBO.setTabId("1001");
            inDoOrderTabCountBO.setTabName("\u5f85\u786e\u8ba4\u53d6\u6d88\u8ba2\u5355\u7533\u8bf7");
            inDoOrderTabCountBO.setTabCount(this.getTabCount(qryTabCountDTO));
            tabCountList.add(inDoOrderTabCountBO);
            qryTabCountDTO.setChngOrderStateList(this.getTabChngOrderState("1002", reqBO.getMenuCode()));
            DycProOrderTabCountBO inDoOrderTabCountBO1 = new DycProOrderTabCountBO();
            inDoOrderTabCountBO1.setTabId("1002");
            inDoOrderTabCountBO1.setTabName("\u5df2\u786e\u8ba4\u53d6\u6d88\u8ba2\u5355\u7533\u8bf7");
            inDoOrderTabCountBO1.setTabCount(this.getTabCount(qryTabCountDTO));
            tabCountList.add(inDoOrderTabCountBO1);
        }
        rspBO.setTabCountList(tabCountList);
    }

    private Integer getTabCount(DycProOrderChngOrderQryDTO qryDTO) {
        qryDTO.setPageSize(0);
        RspPage baseManagePageRspBO = this.dycProOrderChngOrderRepository.queryChngOrderEsPageListByCondition(qryDTO);
        return baseManagePageRspBO.getRecordsTotal();
    }
}

