/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.saleorder.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.egc.constant.DycProOrderConstant;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderQryDTO;
import com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderQrySaleOrderListPageForSupplierService;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderQrySaleOrderListPageForSupplierReqBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderQrySaleOrderListPageForSupplierRspBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderTabCountBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderQrySaleOrderListPageForSupplierService"})
public class DycProOrderQrySaleOrderListPageForSupplierServiceImpl
implements DycProOrderQrySaleOrderListPageForSupplierService {
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;

    @Override
    @PostMapping(value={"qrySaleOrderListPageForSupplier"})
    public DycProOrderQrySaleOrderListPageForSupplierRspBO qrySaleOrderListPageForSupplier(@RequestBody DycProOrderQrySaleOrderListPageForSupplierReqBO reqBO) {
        this.paramVerify(reqBO);
        DycProOrderSaleOrderQryDTO qryDTO = (DycProOrderSaleOrderQryDTO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycProOrderSaleOrderQryDTO.class);
        qryDTO.setSaleOrderStateList(this.getTabSaleOrderState(reqBO.getTabId()));
        qryDTO.setOrderSourceList((List)CollectionUtil.newArrayList((Object[])new Integer[]{DycProOrderConstant.SkuSource.ELC, DycProOrderConstant.SkuSource.AGR}));
        RspPage rspPage = this.dycProOrderSaleOrderRepository.querySaleOrderEsPageListByCondition(qryDTO);
        DycProOrderQrySaleOrderListPageForSupplierRspBO rspBO = new DycProOrderQrySaleOrderListPageForSupplierRspBO();
        if (!CollectionUtil.isEmpty((Collection)rspPage.getRows())) {
            rspBO = (DycProOrderQrySaleOrderListPageForSupplierRspBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)rspPage), DycProOrderQrySaleOrderListPageForSupplierRspBO.class));
        }
        this.buildTabCount(rspBO, reqBO);
        return rspBO;
    }

    private void paramVerify(DycProOrderQrySaleOrderListPageForSupplierReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getPageNo() < 1) {
            throw new ZTBusinessException("\u9875\u7801\u4e0d\u80fd\u5c0f\u4e8e1");
        }
        if (reqBO.getPageSize() < 1) {
            throw new ZTBusinessException("\u6bcf\u9875\u8bb0\u5f55\u6570\u4e0d\u80fd\u5c0f\u4e8e1");
        }
        if (null == reqBO.getTabId()) {
            throw new ZTBusinessException("\u9875\u7b7eID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private List<String> getTabSaleOrderState(String tabId) {
        ArrayList<String> saleOrderStateList = new ArrayList<String>(1);
        if ("1001".equals(tabId)) {
            saleOrderStateList.add("XS_YS_YS");
            saleOrderStateList.add("XS_YS_BFYS");
            saleOrderStateList.add("XS_DH_JS");
            saleOrderStateList.add("XS_FH_FHZ");
            saleOrderStateList.add("XS_FH_FHWC");
            saleOrderStateList.add("XS_DH_BFDH");
            saleOrderStateList.add("XS_DH_DH");
            saleOrderStateList.add("XS_FH_DFH");
            saleOrderStateList.add("XS_QR_DQR");
            saleOrderStateList.add("XS_QX_QX");
            saleOrderStateList.add("XS_XD_SB");
            saleOrderStateList.add("XS_QR_JDDCL");
            saleOrderStateList.add("XS_SP_SPZ");
            saleOrderStateList.add("XS_FK_FKZ");
            saleOrderStateList.add("XS_QX_QXSQ");
        } else if ("1002".equals(tabId)) {
            saleOrderStateList.add("XS_QR_DQR");
        } else if ("1003".equals(tabId)) {
            saleOrderStateList.add("XS_FH_DFH");
        } else if ("1004".equals(tabId)) {
            saleOrderStateList.add("XS_FH_FHZ");
            saleOrderStateList.add("XS_FH_FHWC");
        } else if ("1005".equals(tabId)) {
            saleOrderStateList.add("XS_YS_YS");
            saleOrderStateList.add("XS_YS_BFYS");
            saleOrderStateList.add("XS_DH_JS");
            saleOrderStateList.add("XS_DH_BFDH");
            saleOrderStateList.add("XS_DH_DH");
        } else if ("1006".equals(tabId)) {
            saleOrderStateList.add("XS_QX_QX");
            saleOrderStateList.add("XS_XD_SB");
        } else {
            throw new ZTBusinessException("\u9519\u8bef\u7684\u9875\u7b7eid,\u65e0\u6cd5\u8bc6\u522b");
        }
        return saleOrderStateList;
    }

    private void buildTabCount(DycProOrderQrySaleOrderListPageForSupplierRspBO rspBO, DycProOrderQrySaleOrderListPageForSupplierReqBO reqBO) {
        DycProOrderSaleOrderQryDTO qryTabCountDTO = (DycProOrderSaleOrderQryDTO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycProOrderSaleOrderQryDTO.class);
        ArrayList<DycProOrderTabCountBO> tabCountList = new ArrayList<DycProOrderTabCountBO>(1);
        qryTabCountDTO.setSaleOrderStateList(this.getTabSaleOrderState("1002"));
        DycProOrderTabCountBO toConfirmOrderTabCountBO = new DycProOrderTabCountBO();
        toConfirmOrderTabCountBO.setTabId("1002");
        toConfirmOrderTabCountBO.setTabName("\u5f85\u786e\u8ba4");
        toConfirmOrderTabCountBO.setTabCount(this.getTabCount(qryTabCountDTO));
        tabCountList.add(toConfirmOrderTabCountBO);
        qryTabCountDTO.setSaleOrderStateList(this.getTabSaleOrderState("1003"));
        DycProOrderTabCountBO toShipOrderTabCountBO = new DycProOrderTabCountBO();
        toShipOrderTabCountBO.setTabId("1003");
        toShipOrderTabCountBO.setTabName("\u5f85\u53d1\u8d27");
        toShipOrderTabCountBO.setTabCount(this.getTabCount(qryTabCountDTO));
        tabCountList.add(toShipOrderTabCountBO);
        qryTabCountDTO.setSaleOrderStateList(this.getTabSaleOrderState("1004"));
        DycProOrderTabCountBO inShipOrderTabCountBO = new DycProOrderTabCountBO();
        inShipOrderTabCountBO.setTabId("1004");
        inShipOrderTabCountBO.setTabName("\u53d1\u8d27\u4e2d");
        inShipOrderTabCountBO.setTabCount(this.getTabCount(qryTabCountDTO));
        tabCountList.add(inShipOrderTabCountBO);
        qryTabCountDTO.setSaleOrderStateList(this.getTabSaleOrderState("1005"));
        DycProOrderTabCountBO toTakeShipOrderTabCountBO = new DycProOrderTabCountBO();
        toTakeShipOrderTabCountBO.setTabId("1005");
        toTakeShipOrderTabCountBO.setTabName("\u6536\u8d27\u4e2d\u8ba2\u5355");
        toTakeShipOrderTabCountBO.setTabCount(this.getTabCount(qryTabCountDTO));
        tabCountList.add(toTakeShipOrderTabCountBO);
        qryTabCountDTO.setSaleOrderStateList(this.getTabSaleOrderState("1006"));
        DycProOrderTabCountBO invalidOrderTabCountBO = new DycProOrderTabCountBO();
        invalidOrderTabCountBO.setTabId("1006");
        invalidOrderTabCountBO.setTabName("\u5931\u6548\u8ba2\u5355");
        invalidOrderTabCountBO.setTabCount(this.getTabCount(qryTabCountDTO));
        tabCountList.add(invalidOrderTabCountBO);
        qryTabCountDTO.setSaleOrderStateList(this.getTabSaleOrderState("1001"));
        DycProOrderTabCountBO allOrderTabCountBO = new DycProOrderTabCountBO();
        allOrderTabCountBO.setTabId("1001");
        allOrderTabCountBO.setTabName("\u5168\u90e8\u8ba2\u5355");
        allOrderTabCountBO.setTabCount(this.getTabCount(qryTabCountDTO));
        tabCountList.add(allOrderTabCountBO);
        rspBO.setTabCountList(tabCountList);
    }

    private Integer getTabCount(DycProOrderSaleOrderQryDTO qryDTO) {
        qryDTO.setPageSize(0);
        RspPage baseManagePageRspBO = this.dycProOrderSaleOrderRepository.querySaleOrderEsPageListByCondition(qryDTO);
        return baseManagePageRspBO.getRecordsTotal();
    }
}

