/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.shiporder.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrdLogisticsRelaDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemQryDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderQryDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.api.DycProOrderShipOrderRepository;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderItemQryDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderQryDTO;
import com.tydic.dyc.pro.egc.service.shiporder.api.DycProOrderQryShipOrderDetailsService;
import com.tydic.dyc.pro.egc.service.shiporder.bo.DycProOrderQryShipOrderDetailsReqBO;
import com.tydic.dyc.pro.egc.service.shiporder.bo.DycProOrderQryShipOrderDetailsRspBO;
import com.tydic.dyc.pro.egc.service.shiporder.bo.DycProOrderQryShipOrderDetailsRspDataBO;
import com.tydic.dyc.pro.egc.service.shiporder.bo.DycProOrderQryShipOrderLogisticsDetailsRspDataBO;
import com.tydic.dyc.pro.egc.service.shiporder.bo.DycProOrderShipOrderItemBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.shiporder.api.DycProOrderQryShipOrderDetailsService"})
public class DycProOrderQryShipOrderDetailsServiceImpl
implements DycProOrderQryShipOrderDetailsService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderQryShipOrderDetailsServiceImpl.class);
    @Autowired
    private DycProOrderShipOrderRepository dycProOrderShipOrderRepository;
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;

    @Override
    @PostMapping(value={"qryShipOrderDetails"})
    public DycProOrderQryShipOrderDetailsRspBO qryShipOrderDetails(@RequestBody DycProOrderQryShipOrderDetailsReqBO reqBO) {
        DycProOrderQryShipOrderDetailsRspDataBO shipOrderDetailsInfo = this.queryShipOrderInfo(reqBO);
        DycProOrderQryShipOrderLogisticsDetailsRspDataBO orderLogisicsInfo = this.queryLogisticsInfo(reqBO.getOrderId());
        ArrayList<DycProOrderShipOrderItemBO> realShipOrderItemBoList = new ArrayList<DycProOrderShipOrderItemBO>();
        List<DycProOrderShipOrderItemBO> shipOrderItemBoList = shipOrderDetailsInfo.getShipOrderItemBoList();
        Map<Long, DycProOrderShipOrderItemBO> shipItemMaps = shipOrderItemBoList.stream().collect(Collectors.toMap(DycProOrderShipOrderItemBO::getShipOrderItemId, o -> o));
        List<Long> shipOrderItemIds = reqBO.getShipOrderItemIds();
        if (CollectionUtil.isNotEmpty(shipOrderItemIds)) {
            shipOrderItemIds.forEach(shipOrderItemId -> {
                DycProOrderShipOrderItemBO dycProOrderQryShipOrderDetailsRspItemBO = (DycProOrderShipOrderItemBO)shipItemMaps.get(shipOrderItemId);
                if (ObjectUtil.isNotEmpty((Object)dycProOrderQryShipOrderDetailsRspItemBO)) {
                    realShipOrderItemBoList.add(dycProOrderQryShipOrderDetailsRspItemBO);
                }
            });
        } else {
            realShipOrderItemBoList.addAll(shipOrderItemBoList);
        }
        shipOrderDetailsInfo.setShipOrderItemBoList(realShipOrderItemBoList);
        DycProOrderQryShipOrderDetailsRspBO rspBo = new DycProOrderQryShipOrderDetailsRspBO();
        rspBo.setShipOrderInfo(shipOrderDetailsInfo);
        rspBo.setOrdLogisticsRela(orderLogisicsInfo);
        return rspBo;
    }

    private DycProOrderQryShipOrderDetailsRspDataBO queryShipOrderInfo(DycProOrderQryShipOrderDetailsReqBO reqBo) {
        DycProOrderShipOrderQryDTO dycProOrderShipOrderQryDTO = new DycProOrderShipOrderQryDTO();
        dycProOrderShipOrderQryDTO.setOrderId(reqBo.getOrderId());
        dycProOrderShipOrderQryDTO.setShipOrderId(reqBo.getShipOrderId());
        DycProOrderShipOrderDTO shipOrderInfo = this.dycProOrderShipOrderRepository.getShipOrderById(dycProOrderShipOrderQryDTO);
        if (null != shipOrderInfo) {
            DycProOrderQryShipOrderDetailsRspDataBO uocQryShipOrderDetailsRspDetailBo = (DycProOrderQryShipOrderDetailsRspDataBO)JSONObject.parseObject((String)JSON.toJSONString((Object)shipOrderInfo), DycProOrderQryShipOrderDetailsRspDataBO.class);
            DycProOrderSaleOrderDTO saleOrderInfo = this.getSaleOrderDo(shipOrderInfo.getSaleOrderId(), shipOrderInfo.getOrderId());
            if (null != saleOrderInfo.getSaleStakeholder()) {
                BeanUtils.copyProperties((Object)saleOrderInfo.getSaleStakeholder(), (Object)uocQryShipOrderDetailsRspDetailBo);
                uocQryShipOrderDetailsRspDetailBo.setSaleOrderNo(saleOrderInfo.getSaleOrderNo());
            }
            List<DycProOrderSaleOrderItemDTO> saleOrderItemInfos = this.querySaleOrderItemInfos(shipOrderInfo.getSaleOrderId(), shipOrderInfo.getOrderId());
            Map<Long, DycProOrderSaleOrderItemDTO> saleOrderItemMap = saleOrderItemInfos.stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSaleOrderItemId, o -> o));
            List<DycProOrderShipOrderItemDTO> shipOrderItemInfos = this.getShipOrderItemInfos(reqBo.getShipOrderId(), reqBo.getOrderId());
            ArrayList<DycProOrderShipOrderItemBO> shipOrderItemBoList = new ArrayList<DycProOrderShipOrderItemBO>();
            for (DycProOrderShipOrderItemDTO shipOrderItem : shipOrderItemInfos) {
                DycProOrderShipOrderItemBO rspItemBo = new DycProOrderShipOrderItemBO();
                BeanUtils.copyProperties((Object)shipOrderItem, (Object)rspItemBo);
                if (saleOrderItemMap.containsKey(shipOrderItem.getSaleOrderItemId())) {
                    DycProOrderSaleOrderItemDTO saleOrderItem = saleOrderItemMap.get(shipOrderItem.getSaleOrderItemId());
                    if (shipOrderItem.getSendCount() != null && shipOrderItem.getReturnCount() != null && saleOrderItem.getAfterServingCount() != null) {
                        BigDecimal bigDecimal = shipOrderItem.getSendCount().subtract(shipOrderItem.getReturnCount()).subtract(shipOrderItem.getAfterServingCount());
                    }
                    BeanUtils.copyProperties((Object)saleOrderItem, (Object)rspItemBo);
                    rspItemBo.setRefuseCount(shipOrderItem.getRefuseCount());
                    rspItemBo.setSendCount(shipOrderItem.getSendCount());
                    rspItemBo.setReturnCount(shipOrderItem.getReturnCount());
                    rspItemBo.setAfterServingCount(shipOrderItem.getAfterServingCount());
                    rspItemBo.setInspCount(shipOrderItem.getInspCount());
                    rspItemBo.setArriveCount(shipOrderItem.getArriveCount());
                    rspItemBo.setChngingCount(shipOrderItem.getChngingCount());
                    if (null != shipOrderItem.getInspCount()) {
                        // empty if block
                    }
                }
                shipOrderItemBoList.add(rspItemBo);
            }
            uocQryShipOrderDetailsRspDetailBo.setShipOrderItemBoList(shipOrderItemBoList);
            return uocQryShipOrderDetailsRspDetailBo;
        }
        throw new ZTBusinessException("\u67e5\u8be2\u53d1\u8d27\u5355\u4fe1\u606f\u5931\u8d25");
    }

    private DycProOrderQryShipOrderLogisticsDetailsRspDataBO queryLogisticsInfo(Long orderId) {
        DycProOrderOrderDTO dycProOrderOrderDTO = new DycProOrderOrderDTO();
        dycProOrderOrderDTO.setOrderId(orderId);
        dycProOrderOrderDTO = this.dycProOrderSaleOrderRepository.getOrderBy(dycProOrderOrderDTO);
        DycProOrderOrdLogisticsRelaDTO dycProOrderOrdLogisticsRelaDTO = new DycProOrderOrdLogisticsRelaDTO();
        dycProOrderOrdLogisticsRelaDTO.setOrderId(orderId);
        dycProOrderOrdLogisticsRelaDTO.setContactId(dycProOrderOrderDTO.getContactId());
        DycProOrderOrdLogisticsRelaDTO uocOrdLogisticsRela = this.dycProOrderSaleOrderRepository.getOrderLogisticsRela(dycProOrderOrdLogisticsRelaDTO);
        if (null != uocOrdLogisticsRela) {
            DycProOrderQryShipOrderLogisticsDetailsRspDataBO uocQryShipOrderDetailsLogisticsRelaBo = new DycProOrderQryShipOrderLogisticsDetailsRspDataBO();
            BeanUtils.copyProperties((Object)uocOrdLogisticsRela, (Object)uocQryShipOrderDetailsLogisticsRelaBo);
            return uocQryShipOrderDetailsLogisticsRelaBo;
        }
        throw new ZTBusinessException("\u67e5\u8be2\u8ba2\u5355\u6536\u8d27\u5730\u5740\u4fe1\u606f\u5931\u8d25");
    }

    private DycProOrderSaleOrderDTO getSaleOrderDo(Long saleOrderId, Long orderId) {
        DycProOrderSaleOrderQryDTO dycProOrderSaleOrderQryDTO = new DycProOrderSaleOrderQryDTO();
        dycProOrderSaleOrderQryDTO.setSaleOrderId(saleOrderId);
        dycProOrderSaleOrderQryDTO.setOrderId(orderId);
        DycProOrderSaleOrderDTO dycProOrderSaleOrderDTO = this.dycProOrderSaleOrderRepository.qrySaleOrder(dycProOrderSaleOrderQryDTO);
        if (null != dycProOrderSaleOrderDTO) {
            return dycProOrderSaleOrderDTO;
        }
        throw new ZTBusinessException("\u67e5\u8be2\u9500\u552e\u5355\u4e3b\u4f53\u4fe1\u606f\u5931\u8d25");
    }

    private List<DycProOrderSaleOrderItemDTO> querySaleOrderItemInfos(Long saleOrderId, Long orderId) {
        DycProOrderSaleOrderItemQryDTO dycProOrderSaleOrderItemQryDTO = new DycProOrderSaleOrderItemQryDTO();
        dycProOrderSaleOrderItemQryDTO.setSaleOrderId(saleOrderId);
        dycProOrderSaleOrderItemQryDTO.setOrderId(orderId);
        DycProOrderSaleOrderDTO saleOrderItems = this.dycProOrderSaleOrderRepository.queryListSaleOrderItem(dycProOrderSaleOrderItemQryDTO);
        if (null != saleOrderItems) {
            return saleOrderItems.getSaleItemList();
        }
        throw new ZTBusinessException("\u67e5\u8be2\u9500\u552e\u5355\u660e\u7ec6\u4fe1\u606f\u5931\u8d25");
    }

    private List<DycProOrderShipOrderItemDTO> getShipOrderItemInfos(Long shipOrderId, Long orderId) {
        DycProOrderShipOrderItemQryDTO dycProOrderShipOrderItemQryDTO = new DycProOrderShipOrderItemQryDTO();
        dycProOrderShipOrderItemQryDTO.setShipOrderId(shipOrderId);
        dycProOrderShipOrderItemQryDTO.setOrderId(orderId);
        DycProOrderShipOrderDTO shipOrderItems = this.dycProOrderShipOrderRepository.queryListShipOrderItem(dycProOrderShipOrderItemQryDTO);
        if (null != shipOrderItems) {
            return shipOrderItems.getShipItemList();
        }
        throw new ZTBusinessException("\u67e5\u8be2\u53d1\u8d27\u5355\u660e\u7ec6\u4fe1\u606f\u5931\u8d25");
    }
}

