/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.aforder.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtil;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTypeBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTypeForJdReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTypeForJdRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTypeParamForJdBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTypeReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTypeRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTypeSupportedInfoForJdBO;
import com.tydic.dyc.pro.egc.constant.DycProOrderManageServiceConstant;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemQryDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.api.DycProOrderShipOrderRepository;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderDTO;
import com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderQryAfterTypeService;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderAfterOrderTypeBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderAfterTypeBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderQryAfterTypeServiceReqBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderQryAfterTypeServiceRspBO;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderQryAfterTypeService"})
public class DycProOrderQryAfterTypeServiceImpl
implements DycProOrderQryAfterTypeService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderQryAfterTypeServiceImpl.class);
    @Autowired
    private DycProOrderShipOrderRepository dycProOrderShipOrderRepository;
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;
    @Value(value="${call.esb.url.afterType}")
    private String callEsbAfterTypeUrl;
    @Autowired
    private Environment environment;

    @Override
    @PostMapping(value={"qryAfterServiceType"})
    public DycProOrderQryAfterTypeServiceRspBO qryAfterServiceType(@RequestBody DycProOrderQryAfterTypeServiceReqBO reqBo) {
        this.paramVerify(reqBo);
        DycProOrderQryAfterTypeServiceRspBO rspBO = new DycProOrderQryAfterTypeServiceRspBO();
        List<DycProOrderAfterTypeBO> serverTypes = new ArrayList<DycProOrderAfterTypeBO>();
        DycProOrderShipOrderDTO shipOrderQryDto = new DycProOrderShipOrderDTO();
        shipOrderQryDto.setShipOrderId(reqBo.getShipOrderId());
        shipOrderQryDto.setOrderId(reqBo.getOrderId());
        DycProOrderShipOrderDTO shipOrderDto = this.dycProOrderShipOrderRepository.queryShipOrderOneByCondition(shipOrderQryDto);
        if (null == shipOrderDto) {
            throw new ZTBusinessException("\u67e5\u8be2\u53d1\u8d27\u5355\u4e3b\u4f53\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (DycProOrderManageServiceConstant.OrderSource.E_ORDER.equals(reqBo.getOrderSource())) {
            DycProOrderSaleOrderItemQryDTO saleOrderItemDto = new DycProOrderSaleOrderItemQryDTO();
            saleOrderItemDto.setSaleOrderId(reqBo.getSaleOrderId());
            List saleOrderItemList = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(saleOrderItemDto);
            for (Long itemId : reqBo.getSaleItemIdList()) {
                DycProOrderAfterOrderTypeBO afterOrderType = this.buildThirdEntity(reqBo, itemId, saleOrderItemList);
                String hsn = this.environment.getProperty("SUPPLIER_ID_" + reqBo.getSupId());
                if ("jd".equals(hsn) || "jdvop".equals(hsn)) {
                    DycProBaseCallEsbUtilAfterTypeForJdReqBO callEsbUtilAfterTypeForJdReqBO = new DycProBaseCallEsbUtilAfterTypeForJdReqBO();
                    callEsbUtilAfterTypeForJdReqBO.setHsn(hsn);
                    callEsbUtilAfterTypeForJdReqBO.setUrl(this.callEsbAfterTypeUrl);
                    DycProBaseCallEsbUtilAfterTypeParamForJdBO callEsbUtilAfterTypeParamForJdBO = new DycProBaseCallEsbUtilAfterTypeParamForJdBO();
                    callEsbUtilAfterTypeParamForJdBO.setOrderId(Long.valueOf(afterOrderType.getOrderId()));
                    callEsbUtilAfterTypeParamForJdBO.setWareIds(Collections.singletonList(Long.valueOf(afterOrderType.getSkuId())));
                    callEsbUtilAfterTypeForJdReqBO.setParam(callEsbUtilAfterTypeParamForJdBO);
                    DycProBaseCallEsbUtilAfterTypeForJdRspBO callEsbUtilAfterTypeForJdRspBO = DycProBaseCallEsbUtil.afterTypeForJd((DycProBaseCallEsbUtilAfterTypeForJdReqBO)callEsbUtilAfterTypeForJdReqBO);
                    if (!callEsbUtilAfterTypeForJdRspBO.getSuccess().booleanValue() || !"0000".equals(callEsbUtilAfterTypeForJdRspBO.getResultCode())) {
                        throw new ZTBusinessException(callEsbUtilAfterTypeForJdRspBO.getResultMessage());
                    }
                    List<DycProOrderAfterTypeBO> afterTypeList = this.resolveJDRsp(callEsbUtilAfterTypeForJdRspBO, shipOrderDto);
                    if (CollectionUtils.isEmpty(serverTypes)) {
                        serverTypes.addAll(afterTypeList);
                        continue;
                    }
                    serverTypes = (List)CollectionUtil.intersection(serverTypes, afterTypeList);
                    continue;
                }
                DycProBaseCallEsbUtilAfterTypeReqBO callEsbUtilAfterTypeReqBO = new DycProBaseCallEsbUtilAfterTypeReqBO();
                callEsbUtilAfterTypeReqBO.setHsn(hsn);
                callEsbUtilAfterTypeReqBO.setUrl(this.callEsbAfterTypeUrl);
                callEsbUtilAfterTypeReqBO.setOrderId(afterOrderType.getOrderId());
                callEsbUtilAfterTypeReqBO.setSkuId(afterOrderType.getSkuId());
                DycProBaseCallEsbUtilAfterTypeRspBO CallEsbUtilAfterTypeRspBO = DycProBaseCallEsbUtil.afterType((DycProBaseCallEsbUtilAfterTypeReqBO)callEsbUtilAfterTypeReqBO);
                if (!CallEsbUtilAfterTypeRspBO.getSuccess().booleanValue() || !"0000".equals(CallEsbUtilAfterTypeRspBO.getResultCode())) {
                    throw new ZTBusinessException(CallEsbUtilAfterTypeRspBO.getResultMessage());
                }
                List<DycProOrderAfterTypeBO> afterTypeList = this.resolveRsp(CallEsbUtilAfterTypeRspBO, shipOrderDto);
                if (CollectionUtils.isEmpty(serverTypes)) {
                    serverTypes.addAll(afterTypeList);
                    continue;
                }
                serverTypes = (List)CollectionUtil.intersection(serverTypes, afterTypeList);
            }
            rspBO.setServerTypes(serverTypes);
            return rspBO;
        }
        if (DycProOrderManageServiceConstant.OrderSource.AGR_ORDER.equals(reqBo.getOrderSource())) {
            DycProOrderQryAfterTypeServiceRspBO rspBo = new DycProOrderQryAfterTypeServiceRspBO();
            rspBo.setServerTypes(serverTypes);
            Date date = new Date();
            Date arriveTime = shipOrderDto.getArriveTime() == null ? date : shipOrderDto.getArriveTime();
            boolean returnEffectFlag = (date.getTime() - arriveTime.getTime()) / 86400000L >= 7L;
            boolean exchangeFlag = (date.getTime() - arriveTime.getTime()) / 86400000L >= 7L;
            boolean repairFlag = (date.getTime() - arriveTime.getTime()) / 86400000L >= 7L;
            Date afterSeven = new Date(arriveTime.getTime() + 604800000L);
            ZoneId zoneId = ZoneId.systemDefault();
            LocalDateTime localDateTime = afterSeven.toInstant().atZone(zoneId).toLocalDateTime();
            DycProOrderSaleOrderItemQryDTO querySaleOrderItemDto = new DycProOrderSaleOrderItemQryDTO();
            querySaleOrderItemDto.setSaleOrderItemIdList(reqBo.getSaleItemIdList());
            List saleOrderItemDtoList = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(querySaleOrderItemDto);
            if (CollectionUtil.isEmpty((Collection)saleOrderItemDtoList)) {
                throw new ZTBusinessException("\u67e5\u8be2\u9500\u552e\u5355\u660e\u7ec6\u5bf9\u8c61\u5c5e\u6027\u4e3a\u7a7a");
            }
            List afTypesResultList = new ArrayList();
            for (DycProOrderSaleOrderItemDTO saleOrderItem : saleOrderItemDtoList) {
                ArrayList<Integer> afTypesList = new ArrayList<Integer>();
                if (null != saleOrderItem.getRejectAllowDate()) {
                    afTypesList.add(DycProOrderManageServiceConstant.AfterServType.RETURN);
                }
                if (null != saleOrderItem.getExchangeAllowDate()) {
                    afTypesList.add(DycProOrderManageServiceConstant.AfterServType.CHANGE);
                }
                if (null != saleOrderItem.getMaintainAllowDate()) {
                    afTypesList.add(DycProOrderManageServiceConstant.AfterServType.FIX);
                }
                if (CollectionUtils.isEmpty(afTypesResultList)) {
                    afTypesResultList.addAll(afTypesList);
                    continue;
                }
                afTypesResultList = (List)CollectionUtil.intersection(afTypesResultList, afTypesList);
            }
            afTypesResultList.stream().sorted(Comparator.comparingInt(o -> o)).forEach(integer -> {
                DycProOrderAfterTypeBO afterOrderTypeServiceBo = new DycProOrderAfterTypeBO();
                afterOrderTypeServiceBo.setServerType((Integer)integer);
                afterOrderTypeServiceBo.setServerTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)"EgcAfOrderServType", (String)afterOrderTypeServiceBo.getServerType().toString()));
                afterOrderTypeServiceBo.setCanApply(Boolean.TRUE);
                if (integer.equals(DycProOrderManageServiceConstant.ServiceType.RETURN_GOODS)) {
                    if ("FH_FH_YS".equals(shipOrderDto.getShipOrderState())) {
                        afterOrderTypeServiceBo.setCanApply(Boolean.FALSE);
                        afterOrderTypeServiceBo.setServerDesc("\u5df2\u9a8c\u6536\u5546\u54c1\u4e0d\u652f\u6301\u9000\u8d27");
                    } else {
                        afterOrderTypeServiceBo.setCanApply(returnEffectFlag ? Boolean.FALSE : Boolean.TRUE);
                        afterOrderTypeServiceBo.setServerDesc(returnEffectFlag ? "\u5df2\u4e8e" + localDateTime.toLocalDate() + "0\u65f6\u8d85\u8fc7\u7533\u8bf7\u671f" : localDateTime.toLocalDate() + "\u524d\u53ef\u7533\u8bf7");
                    }
                }
                if (integer.equals(DycProOrderManageServiceConstant.ServiceType.EXCHANGE_GOODS)) {
                    afterOrderTypeServiceBo.setCanApply(exchangeFlag ? Boolean.FALSE : Boolean.TRUE);
                    afterOrderTypeServiceBo.setServerDesc(exchangeFlag ? "\u5df2\u4e8e" + localDateTime.toLocalDate() + "0\u65f6\u8d85\u8fc7\u7533\u8bf7\u671f" : localDateTime.toLocalDate() + "\u524d\u53ef\u7533\u8bf7");
                }
                if (integer.equals(DycProOrderManageServiceConstant.ServiceType.REPAIR)) {
                    afterOrderTypeServiceBo.setCanApply(repairFlag ? Boolean.FALSE : Boolean.TRUE);
                    afterOrderTypeServiceBo.setServerDesc(repairFlag ? "\u5df2\u4e8e" + localDateTime.toLocalDate() + "0\u65f6\u8d85\u8fc7\u7533\u8bf7\u671f" : localDateTime.toLocalDate() + "\u524d\u53ef\u7533\u8bf7");
                }
                rspBo.getServerTypes().add(afterOrderTypeServiceBo);
            });
            return rspBo;
        }
        throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u8ba2\u5355\u6765\u6e90");
    }

    private List<DycProOrderAfterTypeBO> resolveJDRsp(DycProBaseCallEsbUtilAfterTypeForJdRspBO callEsbUtilAfterTypeForJdRspBO, DycProOrderShipOrderDTO shipOrderDto) {
        ArrayList<DycProOrderAfterTypeBO> afterOrderTypeServiceBos = new ArrayList<DycProOrderAfterTypeBO>();
        if (!CollectionUtils.isEmpty((Collection)callEsbUtilAfterTypeForJdRspBO.getResult())) {
            List result = callEsbUtilAfterTypeForJdRspBO.getResult();
            ArrayList customerExpect = new ArrayList();
            for (DycProBaseCallEsbUtilAfterTypeSupportedInfoForJdBO callEsbUtilAfterTypeSupportedInfoForJdBo : result) {
                customerExpect.addAll(callEsbUtilAfterTypeSupportedInfoForJdBo.getCustomerExpect());
            }
            List resultByOrder = customerExpect.stream().sorted(new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return o1.compareTo(o2);
                }
            }).collect(Collectors.toList());
            for (Integer type : resultByOrder) {
                DycProOrderAfterTypeBO afterOrderTypeServiceBo;
                if (DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTypeConstant.JD_RETURN.equals(type)) {
                    afterOrderTypeServiceBo = new DycProOrderAfterTypeBO();
                    afterOrderTypeServiceBo.setServerType(DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTypeConstant.LOCAL_RETURN);
                    afterOrderTypeServiceBo.setServerTypeStr("\u9000\u8d27");
                    if ("FH_FH_YS".equals(shipOrderDto.getShipOrderState())) {
                        afterOrderTypeServiceBo.setCanApply(Boolean.FALSE);
                        afterOrderTypeServiceBo.setServerDesc("\u5df2\u9a8c\u6536\u5546\u54c1\u4e0d\u652f\u6301\u9000\u8d27");
                        afterOrderTypeServiceBos.add(afterOrderTypeServiceBo);
                        continue;
                    }
                    afterOrderTypeServiceBo.setCanApply(Boolean.TRUE);
                    afterOrderTypeServiceBos.add(afterOrderTypeServiceBo);
                    continue;
                }
                if (DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTypeConstant.JD_CHANGE.equals(type)) {
                    afterOrderTypeServiceBo = new DycProOrderAfterTypeBO();
                    afterOrderTypeServiceBo.setServerType(DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTypeConstant.LOCAL_CHANGE);
                    afterOrderTypeServiceBo.setServerTypeStr("\u6362\u8d27");
                    afterOrderTypeServiceBo.setCanApply(Boolean.TRUE);
                    afterOrderTypeServiceBos.add(afterOrderTypeServiceBo);
                    continue;
                }
                if (!DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTypeConstant.JD_FIX.equals(type)) continue;
                afterOrderTypeServiceBo = new DycProOrderAfterTypeBO();
                afterOrderTypeServiceBo.setServerType(DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTypeConstant.LOCAL_FIX);
                afterOrderTypeServiceBo.setServerTypeStr("\u7ef4\u4fee");
                afterOrderTypeServiceBo.setCanApply(Boolean.TRUE);
                afterOrderTypeServiceBos.add(afterOrderTypeServiceBo);
            }
            return afterOrderTypeServiceBos;
        }
        return Collections.emptyList();
    }

    private List<DycProOrderAfterTypeBO> resolveRsp(DycProBaseCallEsbUtilAfterTypeRspBO callEsbUtilAfterTypeRspBO, DycProOrderShipOrderDTO shipOrderDto) {
        ArrayList<DycProOrderAfterTypeBO> afterOrderTypeServiceBos = new ArrayList<DycProOrderAfterTypeBO>();
        if (!CollectionUtils.isEmpty((Collection)callEsbUtilAfterTypeRspBO.getResult())) {
            List result = callEsbUtilAfterTypeRspBO.getResult();
            List resultByOrder = result.stream().sorted(new Comparator<DycProBaseCallEsbUtilAfterTypeBO>(){

                @Override
                public int compare(DycProBaseCallEsbUtilAfterTypeBO o1, DycProBaseCallEsbUtilAfterTypeBO o2) {
                    return o1.getType().compareTo(o1.getType());
                }
            }).collect(Collectors.toList());
            for (DycProBaseCallEsbUtilAfterTypeBO callEsbUtilAfterTypeBo : resultByOrder) {
                DycProOrderAfterTypeBO afterOrderTypeServiceBo;
                Integer type = callEsbUtilAfterTypeBo.getType();
                if (DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTypeConstant.RETURN.equals(type)) {
                    afterOrderTypeServiceBo = new DycProOrderAfterTypeBO();
                    afterOrderTypeServiceBo.setServerType(DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTypeConstant.LOCAL_RETURN);
                    afterOrderTypeServiceBo.setServerTypeStr("\u9000\u8d27");
                    if ("FH_FH_YS".equals(shipOrderDto.getShipOrderState())) {
                        afterOrderTypeServiceBo.setCanApply(Boolean.FALSE);
                        afterOrderTypeServiceBo.setServerDesc("\u5df2\u9a8c\u6536\u5546\u54c1\u4e0d\u652f\u6301\u9000\u8d27");
                        afterOrderTypeServiceBos.add(afterOrderTypeServiceBo);
                        continue;
                    }
                    afterOrderTypeServiceBo.setCanApply(Boolean.TRUE);
                    afterOrderTypeServiceBos.add(afterOrderTypeServiceBo);
                    continue;
                }
                if (DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTypeConstant.CHANGE.equals(type)) {
                    afterOrderTypeServiceBo = new DycProOrderAfterTypeBO();
                    afterOrderTypeServiceBo.setServerType(DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTypeConstant.LOCAL_CHANGE);
                    afterOrderTypeServiceBo.setServerTypeStr("\u6362\u8d27");
                    afterOrderTypeServiceBo.setCanApply(Boolean.TRUE);
                    afterOrderTypeServiceBos.add(afterOrderTypeServiceBo);
                    continue;
                }
                if (!DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTypeConstant.FIX.equals(type)) continue;
                afterOrderTypeServiceBo = new DycProOrderAfterTypeBO();
                afterOrderTypeServiceBo.setServerType(DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTypeConstant.LOCAL_FIX);
                afterOrderTypeServiceBo.setServerTypeStr("\u7ef4\u4fee");
                afterOrderTypeServiceBo.setCanApply(Boolean.TRUE);
                afterOrderTypeServiceBos.add(afterOrderTypeServiceBo);
            }
            return afterOrderTypeServiceBos;
        }
        return Collections.emptyList();
    }

    private DycProOrderAfterOrderTypeBO buildThirdEntity(DycProOrderQryAfterTypeServiceReqBO reqBo, Long itemId, List<DycProOrderSaleOrderItemDTO> saleOrderItemList) {
        Map<Long, DycProOrderSaleOrderItemDTO> itemMap = saleOrderItemList.stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSaleOrderItemId, o -> o));
        DycProOrderSaleOrderItemDTO SaleItem = itemMap.get(itemId);
        DycProOrderAfterOrderTypeBO afterOrderTypeBo = new DycProOrderAfterOrderTypeBO();
        afterOrderTypeBo.setOrderId(reqBo.getSaleOrderNoExt());
        afterOrderTypeBo.setSkuId(SaleItem.getSkuExtSkuId());
        return afterOrderTypeBo;
    }

    private void paramVerify(DycProOrderQryAfterTypeServiceReqBO reqBo) {
        if (reqBo == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBo.getSaleItemIdList())) {
            throw new ZTBusinessException("\u9500\u552e\u5355\u660e\u7ec6id\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new ZTBusinessException("\u8ba2\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new ZTBusinessException("\u9500\u552e\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getShipOrderId()) {
            throw new ZTBusinessException("\u53d1\u8d27\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderSource()) {
            throw new ZTBusinessException("\u8ba2\u5355\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (DycProOrderManageServiceConstant.OrderSource.E_ORDER.equals(reqBo.getOrderSource())) {
            if (StringUtils.isBlank((String)reqBo.getSaleOrderNoExt())) {
                throw new ZTBusinessException("\u9500\u552e\u5916\u90e8\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((String)reqBo.getSupId())) {
                throw new ZTBusinessException("\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

