/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.aforder.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtil;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTypeBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTypeForJdReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTypeForJdRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTypeParamForJdBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTypeReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTypeRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTypeSupportedInfoForJdBO;
import com.tydic.dyc.pro.egc.constant.DycProOrderManageServiceConstant;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemQryDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.api.DycProOrderShipOrderRepository;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderDTO;
import com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderCheckAfOrderAfterTypeService;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderCheckAfterOrderTypeReqBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderCheckAfterOrderTypeRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderCheckAfOrderAfterTypeService"})
public class DycProOrderCheckAfOrderAfterTypeServiceImpl
implements DycProOrderCheckAfOrderAfterTypeService {
    @Value(value="${call.esb.url.afterType}")
    private String callEsbAfterTypeUrl;
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;
    @Autowired
    private DycProOrderShipOrderRepository dycProOrderShipOrderRepository;
    @Autowired
    private Environment environment;

    @Override
    @PostMapping(value={"checkAfOrderAfterType"})
    public DycProOrderCheckAfterOrderTypeRspBO checkAfOrderAfterType(@RequestBody DycProOrderCheckAfterOrderTypeReqBO reqBo) {
        this.paramVerify(reqBo);
        DycProOrderSaleOrderItemQryDTO saleOrderItemQryDto = new DycProOrderSaleOrderItemQryDTO();
        saleOrderItemQryDto.setSaleOrderItemIdList(reqBo.getSaleItemIdList());
        List saleOrderItemDtoList = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(saleOrderItemQryDto);
        if (CollectionUtil.isEmpty((Collection)saleOrderItemDtoList)) {
            throw new ZTBusinessException("\u67e5\u8be2\u9500\u552e\u5355\u660e\u7ec6\u5bf9\u8c61\u5c5e\u6027\u4e3a\u7a7a");
        }
        DycProOrderShipOrderDTO shipOrderQryDto = new DycProOrderShipOrderDTO();
        shipOrderQryDto.setShipOrderId(reqBo.getShipOrderId());
        shipOrderQryDto.setOrderId(reqBo.getOrderId());
        DycProOrderShipOrderDTO shipOrderDto = this.dycProOrderShipOrderRepository.queryShipOrderOneByCondition(shipOrderQryDto);
        HashMap<Long, List<Integer>> afterTypeMap = new HashMap<Long, List<Integer>>();
        if (DycProOrderManageServiceConstant.OrderSource.E_ORDER.equals(reqBo.getOrderSource())) {
            for (DycProOrderSaleOrderItemDTO saleOrderItemDto : saleOrderItemDtoList) {
                String hsn = this.environment.getProperty("SUPPLIER_ID_" + reqBo.getSupId());
                if ("jd".equals(hsn) || "jdvop".equals(hsn)) {
                    DycProBaseCallEsbUtilAfterTypeForJdReqBO callEsbUtilAfterTypeForJdReqBo = new DycProBaseCallEsbUtilAfterTypeForJdReqBO();
                    callEsbUtilAfterTypeForJdReqBo.setHsn(hsn);
                    callEsbUtilAfterTypeForJdReqBo.setUrl(this.callEsbAfterTypeUrl);
                    DycProBaseCallEsbUtilAfterTypeParamForJdBO callEsbUtilAfterTypeParamForJdBo = new DycProBaseCallEsbUtilAfterTypeParamForJdBO();
                    callEsbUtilAfterTypeParamForJdBo.setOrderId(Long.valueOf(reqBo.getSaleOrderNoExt()));
                    callEsbUtilAfterTypeParamForJdBo.setWareIds(Collections.singletonList(Long.valueOf(saleOrderItemDto.getSkuExtSkuId())));
                    callEsbUtilAfterTypeForJdReqBo.setParam(callEsbUtilAfterTypeParamForJdBo);
                    DycProBaseCallEsbUtilAfterTypeForJdRspBO callEsbUtilAfterTypeForJdRspBo = DycProBaseCallEsbUtil.afterTypeForJd((DycProBaseCallEsbUtilAfterTypeForJdReqBO)callEsbUtilAfterTypeForJdReqBo);
                    if (!callEsbUtilAfterTypeForJdRspBo.getSuccess().booleanValue() || !"0000".equals(callEsbUtilAfterTypeForJdRspBo.getResultCode())) {
                        throw new ZTBusinessException(callEsbUtilAfterTypeForJdRspBo.getResultMessage());
                    }
                    this.resolveJDRspForCheck(callEsbUtilAfterTypeForJdRspBo, saleOrderItemDto.getSaleOrderItemId(), afterTypeMap, shipOrderDto);
                    continue;
                }
                DycProBaseCallEsbUtilAfterTypeReqBO callEsbUtilAfterTypeReqBo = new DycProBaseCallEsbUtilAfterTypeReqBO();
                callEsbUtilAfterTypeReqBo.setHsn(hsn);
                callEsbUtilAfterTypeReqBo.setUrl(this.callEsbAfterTypeUrl);
                callEsbUtilAfterTypeReqBo.setOrderId(String.valueOf(reqBo.getSaleOrderNoExt()));
                callEsbUtilAfterTypeReqBo.setSkuId(saleOrderItemDto.getSkuExtSkuId());
                DycProBaseCallEsbUtilAfterTypeRspBO callEsbUtilAfterTypeRspBo = DycProBaseCallEsbUtil.afterType((DycProBaseCallEsbUtilAfterTypeReqBO)callEsbUtilAfterTypeReqBo);
                if (!callEsbUtilAfterTypeRspBo.getSuccess().booleanValue() || !"0000".equals(callEsbUtilAfterTypeRspBo.getResultCode())) {
                    throw new ZTBusinessException(callEsbUtilAfterTypeRspBo.getResultMessage());
                }
                this.resolveRspForCheck(callEsbUtilAfterTypeRspBo, saleOrderItemDto.getSaleOrderItemId(), afterTypeMap, shipOrderDto);
            }
        } else if (DycProOrderManageServiceConstant.OrderSource.AGR_ORDER.equals(reqBo.getOrderSource())) {
            for (DycProOrderSaleOrderItemDTO saleOrderItem : saleOrderItemDtoList) {
                ArrayList<Integer> afTypesList = new ArrayList<Integer>();
                if (null != saleOrderItem.getRejectAllowDate()) {
                    afTypesList.add(DycProOrderManageServiceConstant.AfterServType.RETURN);
                }
                if (null != saleOrderItem.getExchangeAllowDate()) {
                    afTypesList.add(DycProOrderManageServiceConstant.AfterServType.CHANGE);
                }
                if (null != saleOrderItem.getMaintainAllowDate()) {
                    afTypesList.add(DycProOrderManageServiceConstant.AfterServType.FIX);
                }
                if (null == shipOrderDto) {
                    throw new ZTBusinessException("\u67e5\u8be2\u53d1\u8d27\u5355\u4e3b\u4f53\u4fe1\u606f\u4e3a\u7a7a");
                }
                Date date = new Date();
                Date arriveTime = shipOrderDto.getArriveTime() == null ? date : shipOrderDto.getArriveTime();
                boolean returnEffectFlag = (date.getTime() - arriveTime.getTime()) / 86400000L >= 7L;
                boolean exchangeFlag = (date.getTime() - arriveTime.getTime()) / 86400000L >= 7L;
                boolean repairFlag = (date.getTime() - arriveTime.getTime()) / 86400000L >= 7L;
                Iterator iterator = afTypesList.iterator();
                while (iterator.hasNext()) {
                    Integer integer = (Integer)iterator.next();
                    if (integer.equals(DycProOrderManageServiceConstant.ServiceType.RETURN_GOODS)) {
                        if ("FH_FH_YS".equals(shipOrderDto.getShipOrderState())) {
                            iterator.remove();
                            continue;
                        }
                        if (returnEffectFlag != Boolean.TRUE) continue;
                        iterator.remove();
                        continue;
                    }
                    if (integer.equals(DycProOrderManageServiceConstant.ServiceType.EXCHANGE_GOODS) && exchangeFlag == Boolean.TRUE) {
                        iterator.remove();
                        continue;
                    }
                    if (!integer.equals(DycProOrderManageServiceConstant.ServiceType.REPAIR) || repairFlag != Boolean.TRUE) continue;
                    iterator.remove();
                }
                afterTypeMap.put(saleOrderItem.getSaleOrderItemId(), afTypesList);
            }
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u8ba2\u5355\u6765\u6e90");
        }
        ArrayList<String> checkResultList = new ArrayList<String>();
        int isPass = 1;
        StringBuilder resultStr = new StringBuilder();
        ArrayList<String> skuCodeList = new ArrayList<String>();
        for (DycProOrderSaleOrderItemDTO saleOrderItemDto : saleOrderItemDtoList) {
            String skuCode = saleOrderItemDto.getSkuCode();
            if (!CollectionUtil.isEmpty(afterTypeMap) && !CollectionUtil.isEmpty((Collection)((Collection)afterTypeMap.get(saleOrderItemDto.getSaleOrderItemId())))) continue;
            if (reqBo.getSaleItemIdList().size() == 1) {
                resultStr.append("\u5f53\u524d\u5546\u54c1\u65e0\u552e\u540e\u65b9\u5f0f\uff0c\u65e0\u6cd5\u53d1\u8d77\u552e\u540e\u7533\u8bf7\uff0c\u8bf7\u77e5\u6653");
            } else {
                skuCodeList.add(skuCode);
            }
            isPass = 0;
        }
        if (!CollectionUtil.isEmpty(skuCodeList)) {
            String join = String.join((CharSequence)",", skuCodeList);
            resultStr.append("\u5546\u54c1\u7f16\u7801\u4e3a").append(join).append("\u7684\u5546\u54c1\u65e0\u552e\u540e\u65b9\u5f0f\uff0c\u65e0\u6cd5\u53d1\u8d77\u552e\u540e\u7533\u8bf7\uff0c\u8bf7\u77e5\u6653");
        }
        checkResultList.add(resultStr.toString());
        DycProOrderCheckAfterOrderTypeRspBO rspBO = new DycProOrderCheckAfterOrderTypeRspBO();
        rspBO.setCheckResultList(checkResultList);
        rspBO.setIsPass(isPass);
        return rspBO;
    }

    private void resolveRspForCheck(DycProBaseCallEsbUtilAfterTypeRspBO callEsbUtilAfterTypeRspBo, Long itemId, Map<Long, List<Integer>> afterTypeMap, DycProOrderShipOrderDTO shipOrderDto) {
        if (!CollectionUtils.isEmpty((Collection)callEsbUtilAfterTypeRspBo.getResult())) {
            List resultList = callEsbUtilAfterTypeRspBo.getResult();
            ArrayList<Integer> afterTypeList = new ArrayList<Integer>();
            for (DycProBaseCallEsbUtilAfterTypeBO callEsbUtilAfterTypeBo : resultList) {
                Integer type = callEsbUtilAfterTypeBo.getType();
                afterTypeList.add(type);
            }
            if (!CollectionUtil.isEmpty(afterTypeList)) {
                if ("FH_FH_YS".equals(shipOrderDto.getShipOrderState())) {
                    Iterator iterator = afterTypeList.iterator();
                    while (iterator.hasNext()) {
                        Integer next = (Integer)iterator.next();
                        if (!next.equals(DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTypeConstant.RETURN)) continue;
                        iterator.remove();
                    }
                }
                afterTypeMap.put(itemId, afterTypeList);
            }
        }
    }

    private void resolveJDRspForCheck(DycProBaseCallEsbUtilAfterTypeForJdRspBO callEsbUtilAfterTypeForJdRspBo, Long itemId, Map<Long, List<Integer>> afterTypeMap, DycProOrderShipOrderDTO shipOrderDto) {
        if (!CollectionUtils.isEmpty((Collection)callEsbUtilAfterTypeForJdRspBo.getResult())) {
            List resultList = callEsbUtilAfterTypeForJdRspBo.getResult();
            for (DycProBaseCallEsbUtilAfterTypeSupportedInfoForJdBO callEsbUtilAfterTypeSupportedInfoForJdBo : resultList) {
                List customerExpect = callEsbUtilAfterTypeSupportedInfoForJdBo.getCustomerExpect();
                if (CollectionUtil.isEmpty((Collection)customerExpect)) continue;
                if ("FH_FH_YS".equals(shipOrderDto.getShipOrderState())) {
                    Iterator iterator = customerExpect.iterator();
                    while (iterator.hasNext()) {
                        Integer next = (Integer)iterator.next();
                        if (!next.equals(DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTypeConstant.JD_RETURN)) continue;
                        iterator.remove();
                    }
                }
                afterTypeMap.put(itemId, customerExpect);
            }
        }
    }

    private void paramVerify(DycProOrderCheckAfterOrderTypeReqBO reqBo) {
        if (null == reqBo) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new ZTBusinessException("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new ZTBusinessException("\u9500\u552e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBo.getSaleItemIdList())) {
            throw new ZTBusinessException("\u9500\u552e\u5355\u660e\u7ec6Id\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderSource()) {
            throw new ZTBusinessException("\u8ba2\u5355\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (DycProOrderManageServiceConstant.OrderSource.E_ORDER.equals(reqBo.getOrderSource()) && StringUtils.isBlank((String)reqBo.getSaleOrderNoExt())) {
            throw new ZTBusinessException("\u5916\u90e8\u9500\u552e\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getShipOrderId()) {
            throw new ZTBusinessException("\u53d1\u8d27\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBo.getSupId())) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

