/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.aforder.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtil;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTakeBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTakeReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTakeRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTypeForJdReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTypeForJdRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTypeParamForJdBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilAfterTypeSupportedInfoForJdBO;
import com.tydic.dyc.pro.egc.constant.DycProOrderManageServiceConstant;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleAfterTakeTypeDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleAfterTakeTypeQryDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemQryDTO;
import com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderQueryAfterTakeService;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderAfterTakeBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderQueryAfterTakeReqBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderQueryAfterTakeRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderQueryAfterTakeService"})
public class DycProOrderQueryAfterTakeServiceImpl
implements DycProOrderQueryAfterTakeService {
    @Value(value="${call.esb.url.afterTake}")
    private String callEsbUrlAfterTake;
    @Value(value="${call.esb.url.afterType}")
    private String callEsbUrlAfterType;
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;
    @Autowired
    private Environment environment;

    @Override
    @PostMapping(value={"queryAfterTake"})
    public DycProOrderQueryAfterTakeRspBO queryAfterTake(@RequestBody DycProOrderQueryAfterTakeReqBO reqBO) {
        this.paramVerify(reqBO);
        DycProOrderQueryAfterTakeRspBO rspBO = new DycProOrderQueryAfterTakeRspBO();
        List<DycProOrderAfterTakeBO> afterTakeList = new ArrayList<DycProOrderAfterTakeBO>();
        if (DycProOrderManageServiceConstant.OrderSource.E_ORDER.equals(reqBO.getOrderSource())) {
            String hsn = this.environment.getProperty("SUPPLIER_ID_" + reqBO.getSupId());
            DycProOrderSaleOrderItemQryDTO dycProOrderSaleOrderItemQryDTO = new DycProOrderSaleOrderItemQryDTO();
            dycProOrderSaleOrderItemQryDTO.setSaleOrderId(reqBO.getSaleOrderId());
            List saleOrderItemList = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(dycProOrderSaleOrderItemQryDTO);
            if (!CollectionUtils.isEmpty((Collection)saleOrderItemList)) {
                Map<Long, DycProOrderSaleOrderItemDTO> itemBoMap = saleOrderItemList.stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSaleOrderItemId, item -> item, (k1, k2) -> k1));
                for (Long itemId : reqBO.getSaleOrderIdItemList()) {
                    DycProOrderSaleOrderItemDTO thisSaleOrderItem = itemBoMap.get(itemId);
                    if ("jd".equals(hsn) || "jdvop".equals(hsn)) {
                        DycProBaseCallEsbUtilAfterTypeForJdReqBO dycProBaseCallEsbUtilAfterTypeForJdReqBO = new DycProBaseCallEsbUtilAfterTypeForJdReqBO();
                        DycProBaseCallEsbUtilAfterTypeParamForJdBO param = new DycProBaseCallEsbUtilAfterTypeParamForJdBO();
                        dycProBaseCallEsbUtilAfterTypeForJdReqBO.setUrl(this.callEsbUrlAfterType);
                        dycProBaseCallEsbUtilAfterTypeForJdReqBO.setHsn(hsn);
                        param.setOrderId(Long.valueOf(reqBO.getSaleOrderNoExt()));
                        param.setWareIds(Collections.singletonList(Long.valueOf(thisSaleOrderItem.getSkuExtSkuId())));
                        dycProBaseCallEsbUtilAfterTypeForJdReqBO.setParam(param);
                        DycProBaseCallEsbUtilAfterTypeForJdRspBO dycProBaseCallEsbUtilAfterTypeForJdRspBO = DycProBaseCallEsbUtil.afterTypeForJd((DycProBaseCallEsbUtilAfterTypeForJdReqBO)dycProBaseCallEsbUtilAfterTypeForJdReqBO);
                        if (!dycProBaseCallEsbUtilAfterTypeForJdRspBO.getSuccess().booleanValue() || !"0000".equals(dycProBaseCallEsbUtilAfterTypeForJdRspBO.getResultCode())) {
                            throw new ZTBusinessException(dycProBaseCallEsbUtilAfterTypeForJdRspBO.getResultMessage());
                        }
                        List<DycProOrderAfterTakeBO> dycProOrderAfterTakeBOS = this.resolveJDRsp(dycProBaseCallEsbUtilAfterTypeForJdRspBO);
                        if (CollectionUtils.isEmpty(afterTakeList)) {
                            afterTakeList.addAll(dycProOrderAfterTakeBOS);
                            continue;
                        }
                        afterTakeList = (List)CollectionUtil.intersection(afterTakeList, dycProOrderAfterTakeBOS);
                        continue;
                    }
                    DycProBaseCallEsbUtilAfterTakeReqBO dycProBaseCallEsbUtilAfterTakeReqBO = new DycProBaseCallEsbUtilAfterTakeReqBO();
                    dycProBaseCallEsbUtilAfterTakeReqBO.setUrl(this.callEsbUrlAfterTake);
                    dycProBaseCallEsbUtilAfterTakeReqBO.setHsn(hsn);
                    dycProBaseCallEsbUtilAfterTakeReqBO.setOrderId(reqBO.getSaleOrderNoExt());
                    dycProBaseCallEsbUtilAfterTakeReqBO.setSkuId(thisSaleOrderItem.getSkuExtSkuId());
                    DycProBaseCallEsbUtilAfterTakeRspBO dycProBaseCallEsbUtilAfterTakeRspBO = DycProBaseCallEsbUtil.afterTake((DycProBaseCallEsbUtilAfterTakeReqBO)dycProBaseCallEsbUtilAfterTakeReqBO);
                    if (!dycProBaseCallEsbUtilAfterTakeRspBO.getSuccess().booleanValue() || !"0000".equals(dycProBaseCallEsbUtilAfterTakeRspBO.getResultCode())) {
                        throw new ZTBusinessException(dycProBaseCallEsbUtilAfterTakeRspBO.getResultMessage());
                    }
                    List<DycProOrderAfterTakeBO> dycProOrderAfterTakeBOS = this.resolveRsp(dycProBaseCallEsbUtilAfterTakeRspBO);
                    if (CollectionUtils.isEmpty(afterTakeList)) {
                        afterTakeList.addAll(dycProOrderAfterTakeBOS);
                        continue;
                    }
                    afterTakeList = (List)CollectionUtil.intersection(afterTakeList, dycProOrderAfterTakeBOS);
                }
                rspBO.setAfterTakeList(afterTakeList);
                return rspBO;
            }
            throw new ZTBusinessException("\u9500\u552e\u5355\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        if (DycProOrderManageServiceConstant.OrderSource.AGR_ORDER.equals(reqBO.getOrderSource())) {
            List<Long> saleOrderItemIds = reqBO.getSaleOrderIdItemList();
            ArrayList<DycProOrderAfterTakeBO> takTypes = new ArrayList<DycProOrderAfterTakeBO>();
            DycProOrderSaleAfterTakeTypeQryDTO dycProOrderSaleAfterTakeTypeQryDTO = new DycProOrderSaleAfterTakeTypeQryDTO();
            dycProOrderSaleAfterTakeTypeQryDTO.setSaleOrderItemIdList(saleOrderItemIds);
            List dycProOrderSaleAfterTakeTypePOHandleDTOList = this.dycProOrderSaleOrderRepository.querySaleOrderAfterTakeTypeListByCondition(dycProOrderSaleAfterTakeTypeQryDTO);
            Map<Long, List<DycProOrderSaleAfterTakeTypeDTO>> saleOrderItemIdMap = dycProOrderSaleAfterTakeTypePOHandleDTOList.stream().collect(Collectors.groupingBy(DycProOrderSaleAfterTakeTypeDTO::getSaleOrderItemId));
            saleOrderItemIds.forEach(e -> {
                List takeTypeBos = (List)saleOrderItemIdMap.get(e);
                takeTypeBos.forEach(t -> {
                    DycProOrderAfterTakeBO dycProOrderAfterTakeBO = new DycProOrderAfterTakeBO();
                    dycProOrderAfterTakeBO.setPickwareType(t.getAfterTakeType());
                    dycProOrderAfterTakeBO.setPickwareTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)"EgcAfOrderPickwareType", (String)t.getAfterTakeType().toString()));
                    takTypes.add(dycProOrderAfterTakeBO);
                });
            });
            if (saleOrderItemIds.size() > 1) {
                ArrayList<DycProOrderAfterTakeBO> dycProOrderAfterTakeTypeBOS = new ArrayList<DycProOrderAfterTakeBO>();
                Map<Integer, List<DycProOrderAfterTakeBO>> takTypeMap = takTypes.stream().collect(Collectors.groupingBy(DycProOrderAfterTakeBO::getPickwareType));
                for (Integer pikcWareType : takTypeMap.keySet()) {
                    if (takTypeMap.get(pikcWareType).size() != saleOrderItemIds.size()) continue;
                    dycProOrderAfterTakeTypeBOS.add(takTypeMap.get(pikcWareType).get(0));
                }
                rspBO.setAfterTakeList(dycProOrderAfterTakeTypeBOS);
                return rspBO;
            }
            rspBO.setAfterTakeList(takTypes);
            return rspBO;
        }
        return new DycProOrderQueryAfterTakeRspBO();
    }

    private List<DycProOrderAfterTakeBO> resolveJDRsp(DycProBaseCallEsbUtilAfterTypeForJdRspBO dycProBaseCallEsbUtilAfterTypeForJdRspBO) {
        ArrayList<DycProOrderAfterTakeBO> uocAfterServiceTypeQryServiceRspAfsBos = new ArrayList<DycProOrderAfterTakeBO>();
        List resultByOrder = dycProBaseCallEsbUtilAfterTypeForJdRspBO.getResult().stream().map(DycProBaseCallEsbUtilAfterTypeSupportedInfoForJdBO::getPickupWareType).filter(Objects::nonNull).flatMap(Collection::stream).sorted(Integer::compareTo).collect(Collectors.toList());
        for (Integer type : resultByOrder) {
            DycProOrderAfterTakeBO uocAfterServiceTypeQryServiceRspAfsBo;
            if (DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTakeConstant.JD_SMQJ.equals(type)) {
                uocAfterServiceTypeQryServiceRspAfsBo = new DycProOrderAfterTakeBO();
                uocAfterServiceTypeQryServiceRspAfsBo.setPickwareType(DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTakeConstant.SMQJ);
                uocAfterServiceTypeQryServiceRspAfsBo.setPickwareTypeStr("\u4e0a\u95e8\u53d6\u4ef6");
                uocAfterServiceTypeQryServiceRspAfsBos.add(uocAfterServiceTypeQryServiceRspAfsBo);
                continue;
            }
            if (!DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTakeConstant.JD_KHFH.equals(type)) continue;
            uocAfterServiceTypeQryServiceRspAfsBo = new DycProOrderAfterTakeBO();
            uocAfterServiceTypeQryServiceRspAfsBo.setPickwareType(DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTakeConstant.KHFH);
            uocAfterServiceTypeQryServiceRspAfsBo.setPickwareTypeStr("\u5ba2\u6237\u53d1\u8d27");
            uocAfterServiceTypeQryServiceRspAfsBos.add(uocAfterServiceTypeQryServiceRspAfsBo);
        }
        return uocAfterServiceTypeQryServiceRspAfsBos;
    }

    private List<DycProOrderAfterTakeBO> resolveRsp(DycProBaseCallEsbUtilAfterTakeRspBO dycProBaseCallEsbUtilAfterTakeRspBO) {
        ArrayList<DycProOrderAfterTakeBO> uocAfterServiceTypeQryServiceRspAfsBos = new ArrayList<DycProOrderAfterTakeBO>();
        List resultByType = dycProBaseCallEsbUtilAfterTakeRspBO.getResult().stream().map(DycProBaseCallEsbUtilAfterTakeBO::getType).sorted().collect(Collectors.toList());
        for (Integer type : resultByType) {
            DycProOrderAfterTakeBO uocAfterServiceTypeQryServiceRspAfsBo;
            if (DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTakeConstant.SMQJ.equals(type)) {
                uocAfterServiceTypeQryServiceRspAfsBo = new DycProOrderAfterTakeBO();
                uocAfterServiceTypeQryServiceRspAfsBo.setPickwareType(type);
                uocAfterServiceTypeQryServiceRspAfsBo.setPickwareTypeStr("\u4e0a\u95e8\u53d6\u4ef6");
                uocAfterServiceTypeQryServiceRspAfsBos.add(uocAfterServiceTypeQryServiceRspAfsBo);
                continue;
            }
            if (!DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTakeConstant.KHFH.equals(type)) continue;
            uocAfterServiceTypeQryServiceRspAfsBo = new DycProOrderAfterTakeBO();
            uocAfterServiceTypeQryServiceRspAfsBo.setPickwareType(type);
            uocAfterServiceTypeQryServiceRspAfsBo.setPickwareTypeStr("\u5ba2\u6237\u53d1\u8d27");
            uocAfterServiceTypeQryServiceRspAfsBos.add(uocAfterServiceTypeQryServiceRspAfsBo);
        }
        return uocAfterServiceTypeQryServiceRspAfsBos;
    }

    private void paramVerify(DycProOrderQueryAfterTakeReqBO reqBo) {
        if (null == reqBo) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new ZTBusinessException("\u9500\u552e\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtil.isEmpty(reqBo.getSaleOrderIdItemList())) {
            throw new ZTBusinessException("\u9500\u552e\u5355\u660e\u7ec6Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderSource()) {
            throw new ZTBusinessException("\u8ba2\u5355\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

