/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.aforder.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtil;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilServiceOrderAfsApplyInfoItemForJdBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilServiceOrderAfsCustomerInfoForJdBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilServiceOrderAfsPickupWareInfoForJdBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilServiceOrderAfsReturnWareInfoForJdBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilServiceOrderCustomerBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilServiceOrderDetailBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilServiceOrderForJdReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilServiceOrderForJdRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilServiceOrderParamForJdBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilServiceOrderPickwareBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilServiceOrderReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilServiceOrderReturnwareBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilServiceOrderRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilServiceOrderWareDescInfoForJdBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilServiceOrderWareDetailInfoForJdBO;
import com.tydic.dyc.pro.egc.constant.DycProOrderManageServiceConstant;
import com.tydic.dyc.pro.egc.repository.aforder.api.DycProOrderAfOrderRepository;
import com.tydic.dyc.pro.egc.repository.aforder.dto.DycProOrderAfOrderDTO;
import com.tydic.dyc.pro.egc.repository.aforder.dto.DycProOrderAfOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.aforder.dto.DycProOrderAfOrderObjDTO;
import com.tydic.dyc.pro.egc.repository.order.api.DycProOrderOrderRepository;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrdLogisticsRelaDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderAccessoryDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderQueryIndexDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemQryDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.api.DycProOrderShipOrderRepository;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderItemQryDTO;
import com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderCreateAfterOrderService;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderAfterOrderItemBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderCreateAfterOrderReqBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderCreateAfterOrderRspBO;
import com.tydic.dyc.pro.egc.service.order.bo.DycProOrderOrdLogisticsRelaBO;
import com.tydic.dyc.pro.egc.service.order.bo.DycProOrderOrderAccessoryBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderCreateAfterOrderService"})
public class DycProOrderCreateAfterOrderServiceImpl
implements DycProOrderCreateAfterOrderService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderCreateAfterOrderServiceImpl.class);
    @Value(value="${call.esb.url.serviceOrder}")
    private String callEsbUrlServiceOrder;
    @Autowired
    private DycProOrderShipOrderRepository dycProOrderShipOrderRepository;
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;
    @Autowired
    private DycProOrderAfOrderRepository dycProOrderAfOrderRepository;
    @Autowired
    private DycProOrderOrderRepository dycProOrderOrderRepository;
    @Autowired
    private Environment environment;

    @Override
    @PostMapping(value={"createAfterOrder"})
    public DycProOrderCreateAfterOrderRspBO createAfterOrder(@RequestBody DycProOrderCreateAfterOrderReqBO reqBo) {
        this.verifyParam(reqBo);
        DycProOrderCreateAfterOrderRspBO rspBo = new DycProOrderCreateAfterOrderRspBO();
        DycProOrderShipOrderItemQryDTO shipOrderItemDto = new DycProOrderShipOrderItemQryDTO();
        shipOrderItemDto.setShipOrderId(reqBo.getShipOrderId());
        List shipOrderItemList = this.dycProOrderShipOrderRepository.queryShipOrderItemByCondition(shipOrderItemDto);
        DycProOrderSaleOrderItemQryDTO saleOrderItemDto = new DycProOrderSaleOrderItemQryDTO();
        saleOrderItemDto.setSaleOrderId(reqBo.getSaleOrderId());
        List saleOrderItemList = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(saleOrderItemDto);
        this.checkAfterCount(reqBo);
        String extShipOrderId = null;
        if (DycProOrderManageServiceConstant.OrderSource.E_ORDER.equals(reqBo.getOrderSource())) {
            String hsn = this.environment.getProperty("SUPPLIER_ID_" + reqBo.getSupId());
            if ("jd".equals(hsn) || "jdvop".equals(hsn)) {
                this.buildJdAfterOrderAddressInfo(reqBo);
                DycProBaseCallEsbUtilServiceOrderForJdReqBO callEsbUtilServiceOrderForJdReqBO = new DycProBaseCallEsbUtilServiceOrderForJdReqBO();
                callEsbUtilServiceOrderForJdReqBO.setHsn(hsn);
                callEsbUtilServiceOrderForJdReqBO.setUrl(this.callEsbUrlServiceOrder);
                DycProBaseCallEsbUtilServiceOrderParamForJdBO dycProBaseCallEsbUtilServiceOrderParamForJdBO = this.buildJDAfterOrderEntity(reqBo, saleOrderItemList);
                callEsbUtilServiceOrderForJdReqBO.setParam(dycProBaseCallEsbUtilServiceOrderParamForJdBO);
                log.debug("\u4eac\u4e1c\u552e\u540e\u7533\u8bf7\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dycProBaseCallEsbUtilServiceOrderParamForJdBO));
                DycProBaseCallEsbUtilServiceOrderForJdRspBO dycProBaseCallEsbUtilServiceOrderForJdRspBO = DycProBaseCallEsbUtil.serviceOrderForJd((DycProBaseCallEsbUtilServiceOrderForJdReqBO)callEsbUtilServiceOrderForJdReqBO);
                log.debug("\u4eac\u4e1c\u552e\u540e\u7533\u8bf7\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dycProBaseCallEsbUtilServiceOrderForJdRspBO));
                if (!dycProBaseCallEsbUtilServiceOrderForJdRspBO.getSuccess().booleanValue()) {
                    throw new ZTBusinessException("\u8c03\u7528\u7533\u8bf7\u552e\u540e\uff08\u4eac\u4e1c\uff09\u5931\u8d25");
                }
                extShipOrderId = callEsbUtilServiceOrderForJdReqBO.getParam().getThirdApplyId();
            } else {
                this.buildJdAfterOrderAddressInfo(reqBo);
                DycProBaseCallEsbUtilServiceOrderReqBO callEsbUtilServiceOrderReqBO = this.buildAfterOrderEntity(reqBo, saleOrderItemList);
                callEsbUtilServiceOrderReqBO.setHsn(hsn);
                callEsbUtilServiceOrderReqBO.setUrl(this.callEsbUrlServiceOrder);
                log.debug("\u975e\u4eac\u4e1c\u552e\u540e\u7533\u8bf7\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)callEsbUtilServiceOrderReqBO));
                DycProBaseCallEsbUtilServiceOrderRspBO dycProBaseCallEsbUtilServiceOrderRspBO = DycProBaseCallEsbUtil.serviceOrder((DycProBaseCallEsbUtilServiceOrderReqBO)callEsbUtilServiceOrderReqBO);
                log.debug("\u975e\u4eac\u4e1c\u552e\u540e\u7533\u8bf7\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dycProBaseCallEsbUtilServiceOrderRspBO));
                if (!dycProBaseCallEsbUtilServiceOrderRspBO.getSuccess().booleanValue()) {
                    throw new ZTBusinessException("\u8c03\u7528\u7533\u8bf7\u552e\u540e\uff08\u975e\u4eac\u4e1c\uff09\u5931\u8d25");
                }
                extShipOrderId = dycProBaseCallEsbUtilServiceOrderRspBO.getResult().getServiceId();
            }
        }
        DycProOrderAfOrderDTO afterOrderApplyInfoDto = this.createAfterOrderApplyInfo(reqBo, extShipOrderId, shipOrderItemList, saleOrderItemList);
        this.updateAfingCount(reqBo, shipOrderItemList, saleOrderItemList, afterOrderApplyInfoDto);
        rspBo.setAfOrderId(afterOrderApplyInfoDto.getAfOrderId());
        return rspBo;
    }

    private void updateAfingCount(DycProOrderCreateAfterOrderReqBO reqBo, List<DycProOrderShipOrderItemDTO> shipOrderItemList, List<DycProOrderSaleOrderItemDTO> saleOrderItemList, DycProOrderAfOrderDTO afterOrderApplyInfoDto) {
        Map<Long, DycProOrderShipOrderItemDTO> shipOrderItemMap = shipOrderItemList.stream().collect(Collectors.toMap(DycProOrderShipOrderItemDTO::getShipOrderItemId, item -> item, (k1, k2) -> k1));
        Map<Long, DycProOrderSaleOrderItemDTO> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSaleOrderItemId, item -> item, (k1, k2) -> k1));
        ArrayList<DycProOrderShipOrderItemDTO> updateShipOrderItemDTOList = new ArrayList<DycProOrderShipOrderItemDTO>(1);
        ArrayList<DycProOrderSaleOrderItemDTO> updateSaleOrderItemDTOList = new ArrayList<DycProOrderSaleOrderItemDTO>(1);
        for (DycProOrderAfterOrderItemBO afterOrderItemApiBo : reqBo.getAfterOrderItemList()) {
            DycProOrderShipOrderItemDTO shipOrderItemDTO = shipOrderItemMap.get(afterOrderItemApiBo.getShipItemId());
            BigDecimal shipItemAfterServingCount = null == shipOrderItemDTO.getAfterServingCount() ? BigDecimal.ZERO : shipOrderItemDTO.getAfterServingCount();
            DycProOrderShipOrderItemDTO updateShipOrderItemDto = new DycProOrderShipOrderItemDTO();
            updateShipOrderItemDto.setShipOrderItemId(afterOrderItemApiBo.getShipItemId());
            updateShipOrderItemDto.setAfterServingCount(shipItemAfterServingCount.add(afterOrderItemApiBo.getReturnCount()));
            updateShipOrderItemDto.setUpdateOperId(String.valueOf(reqBo.getUserId()));
            updateShipOrderItemDTOList.add(updateShipOrderItemDto);
            DycProOrderSaleOrderItemDTO saleOrderItemDTO = saleOrderItemMap.get(afterOrderItemApiBo.getSaleOrderItemId());
            BigDecimal saleItemAfterServingCount = null == saleOrderItemDTO.getAfterServingCount() ? BigDecimal.ZERO : saleOrderItemDTO.getAfterServingCount();
            DycProOrderSaleOrderItemDTO updateSaleOrderItemDto = new DycProOrderSaleOrderItemDTO();
            updateSaleOrderItemDto.setSaleOrderItemId(afterOrderItemApiBo.getSaleOrderItemId());
            updateSaleOrderItemDto.setAfterServingCount(saleItemAfterServingCount.add(afterOrderItemApiBo.getReturnCount()));
            updateSaleOrderItemDto.setUpdateOperId(String.valueOf(reqBo.getUserId()));
            updateSaleOrderItemDTOList.add(updateSaleOrderItemDto);
        }
        DycProOrderShipOrderDTO updateShipOrderDTO = new DycProOrderShipOrderDTO();
        updateShipOrderDTO.setShipItemList(updateShipOrderItemDTOList);
        updateShipOrderDTO.setShipOrderId(reqBo.getShipOrderId());
        this.dycProOrderShipOrderRepository.updateShipOrderItemBatchByIdsAndSyncNosql(updateShipOrderDTO);
        this.dycProOrderSaleOrderRepository.updateSaleOrderItemBatchById(updateSaleOrderItemDTOList);
        ArrayList<DycProOrderAfOrderDTO> afOrderList = new ArrayList<DycProOrderAfOrderDTO>(1);
        afOrderList.add(afterOrderApplyInfoDto);
        DycProOrderSaleOrderDTO updateSaleOrderDTO = new DycProOrderSaleOrderDTO();
        updateSaleOrderDTO.setSaleOrderId(afterOrderApplyInfoDto.getSaleOrderId());
        updateSaleOrderDTO.setAfOrderList(afOrderList);
        this.dycProOrderSaleOrderRepository.updateSaleOrderNosqlForIncr(updateSaleOrderDTO);
    }

    private DycProOrderAfOrderDTO createAfterOrderApplyInfo(DycProOrderCreateAfterOrderReqBO reqBo, String extAfId, List<DycProOrderShipOrderItemDTO> shipOrderItemList, List<DycProOrderSaleOrderItemDTO> saleOrderItemList) {
        DycProOrderAfOrderDTO createAfterOrderDto = (DycProOrderAfOrderDTO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBo)), DycProOrderAfOrderDTO.class);
        createAfterOrderDto.setSubContactName(reqBo.getName());
        createAfterOrderDto.setSubContactMobile(reqBo.getCellphone());
        createAfterOrderDto.setCreateTime(new Date());
        createAfterOrderDto.setCreateOperId(String.valueOf(reqBo.getUserId()));
        createAfterOrderDto.setSubmiteTime(new Date());
        createAfterOrderDto.setSubmitterOperId(String.valueOf(reqBo.getUserId()));
        createAfterOrderDto.setSubmitterOperName(reqBo.getName());
        createAfterOrderDto.setSubDeptId(String.valueOf(reqBo.getOrgId()));
        createAfterOrderDto.setSubDeptName(reqBo.getOrgName());
        createAfterOrderDto.setSubCompId(String.valueOf(reqBo.getCompanyId()));
        createAfterOrderDto.setSubCompName(reqBo.getCompanyName());
        createAfterOrderDto.setServState(DycProOrderManageServiceConstant.ServiceState.SUMIT_APPLICATION);
        createAfterOrderDto.setWaybillFlag(Integer.valueOf(0));
        createAfterOrderDto.setExtAfId(extAfId);
        Map<Long, DycProOrderSaleOrderItemDTO> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSaleOrderItemId, item -> item, (k1, k2) -> k1));
        ArrayList<DycProOrderAfOrderItemDTO> uocAfOrderItemDtos = new ArrayList<DycProOrderAfOrderItemDTO>();
        for (DycProOrderAfterOrderItemBO afterOrderItemBo : reqBo.getAfterOrderItemList()) {
            DycProOrderAfOrderItemDTO createAfOrderItemDto = new DycProOrderAfOrderItemDTO();
            BeanUtils.copyProperties((Object)afterOrderItemBo, (Object)createAfOrderItemDto);
            createAfOrderItemDto.setCreateTime(new Date());
            createAfOrderItemDto.setCreateOperId(String.valueOf(reqBo.getUserId()));
            createAfOrderItemDto.setSkuId(Long.valueOf(saleOrderItemMap.get(afterOrderItemBo.getSaleOrderItemId()).getSkuId()));
            createAfOrderItemDto.setUnitName(saleOrderItemMap.get(afterOrderItemBo.getSaleOrderItemId()).getUnitName());
            createAfOrderItemDto.setSaleOrderItemId(afterOrderItemBo.getSaleOrderItemId());
            createAfOrderItemDto.setShipItemId(afterOrderItemBo.getShipItemId());
            createAfOrderItemDto.setReturnCount(afterOrderItemBo.getReturnCount());
            createAfOrderItemDto.setRetPurchaseFee(saleOrderItemMap.get(afterOrderItemBo.getSaleOrderItemId()).getPurchasePrice().multiply(afterOrderItemBo.getReturnCount()));
            createAfOrderItemDto.setRetSaleFee(saleOrderItemMap.get(afterOrderItemBo.getSaleOrderItemId()).getSalePrice().multiply(afterOrderItemBo.getReturnCount()));
            uocAfOrderItemDtos.add(createAfOrderItemDto);
        }
        createAfterOrderDto.setAfItemList(uocAfOrderItemDtos);
        createAfterOrderDto.setRetTotalSaleFee(uocAfOrderItemDtos.stream().map(DycProOrderAfOrderItemDTO::getRetSaleFee).reduce(BigDecimal::add).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP));
        createAfterOrderDto.setRetTotalPurchaseFee(uocAfOrderItemDtos.stream().map(DycProOrderAfOrderItemDTO::getRetPurchaseFee).reduce(BigDecimal::add).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP));
        if (DycProOrderManageServiceConstant.AfterServType.RETURN.equals(reqBo.getServType())) {
            createAfterOrderDto.setRealReturnFee(uocAfOrderItemDtos.stream().map(DycProOrderAfOrderItemDTO::getRetSaleFee).reduce(BigDecimal::add).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP));
        }
        ArrayList<DycProOrderAfOrderObjDTO> afOrderObjList = new ArrayList<DycProOrderAfOrderObjDTO>();
        DycProOrderAfOrderObjDTO createAfOrderObj = new DycProOrderAfOrderObjDTO();
        createAfOrderObj.setOrderId(reqBo.getOrderId());
        createAfOrderObj.setSaleOrderId(reqBo.getSaleOrderId());
        createAfOrderObj.setShipOrderId(reqBo.getShipOrderId());
        createAfOrderObj.setCreateOperId(String.valueOf(reqBo.getUserId()));
        afOrderObjList.add(createAfOrderObj);
        createAfterOrderDto.setAfOrderObjList(afOrderObjList);
        if (CollectionUtils.isNotEmpty(reqBo.getAfterOrderAccessoryList())) {
            List afterOrderAccessoryList = JSONArray.parseArray((String)JSON.toJSONString(reqBo.getAfterOrderAccessoryList())).toJavaList(DycProOrderOrderAccessoryDTO.class);
            createAfterOrderDto.setAfterOrderAccessoryList(afterOrderAccessoryList);
        }
        if (null != reqBo.getTakeAddress()) {
            DycProOrderOrdLogisticsRelaDTO takeAddress = new DycProOrderOrdLogisticsRelaDTO();
            BeanUtils.copyProperties((Object)reqBo.getTakeAddress(), (Object)takeAddress);
            takeAddress.setOrderId(reqBo.getOrderId());
            createAfterOrderDto.setTakeAddress(takeAddress);
        }
        if (null != reqBo.getReturnAddress()) {
            DycProOrderOrdLogisticsRelaDTO returnAddress = new DycProOrderOrdLogisticsRelaDTO();
            BeanUtils.copyProperties((Object)reqBo.getReturnAddress(), (Object)returnAddress);
            returnAddress.setOrderId(reqBo.getOrderId());
            createAfterOrderDto.setReturnAddress(returnAddress);
        }
        if (DycProOrderManageServiceConstant.OrderSource.E_ORDER.equals(reqBo.getOrderSource())) {
            DycProOrderOrderQueryIndexDTO orderQueryIndexDto = new DycProOrderOrderQueryIndexDTO();
            orderQueryIndexDto.setOrderId(reqBo.getOrderId());
            orderQueryIndexDto.setObjType(DycProOrderManageServiceConstant.OBJ_TYPE.AFTER);
            orderQueryIndexDto.setOutObjId(extAfId);
            createAfterOrderDto.setAfOrderQueryIndex(orderQueryIndexDto);
        }
        return this.dycProOrderAfOrderRepository.createAfterOderAllInfoAndSyncNosql(createAfterOrderDto);
    }

    private void checkAfterCount(DycProOrderCreateAfterOrderReqBO reqBo) {
        DycProOrderShipOrderItemQryDTO reqDto = new DycProOrderShipOrderItemQryDTO();
        reqDto.setOrderId(reqBo.getOrderId());
        reqDto.setShipOrderId(reqBo.getShipOrderId());
        List shipOrderItemDTOList = this.dycProOrderShipOrderRepository.queryShipOrderItemByCondition(reqDto);
        if (CollectionUtils.isEmpty((Collection)shipOrderItemDTOList)) {
            throw new ZTBusinessException("\u8be5\u53d1\u8d27\u5355\u4e0d\u5b58\u5728\u660e\u7ec6\u4fe1\u606f");
        }
        Map<Long, DycProOrderShipOrderItemDTO> shipOrderItemMap = shipOrderItemDTOList.stream().collect(Collectors.toMap(DycProOrderShipOrderItemDTO::getShipOrderItemId, o -> o));
        for (DycProOrderAfterOrderItemBO shipOrderItemBo : reqBo.getAfterOrderItemList()) {
            DycProOrderShipOrderItemDTO uocShipOrderItemDto = shipOrderItemMap.get(shipOrderItemBo.getShipItemId());
            BigDecimal returnCount = null == uocShipOrderItemDto.getReturnCount() ? BigDecimal.ZERO : uocShipOrderItemDto.getReturnCount();
            BigDecimal afterServingCount = null == uocShipOrderItemDto.getAfterServingCount() ? BigDecimal.ZERO : uocShipOrderItemDto.getAfterServingCount();
            BigDecimal afterCountEnable = uocShipOrderItemDto.getSendCount().subtract(returnCount).subtract(afterServingCount);
            if (shipOrderItemBo.getReturnCount().compareTo(afterCountEnable) <= 0) continue;
            throw new ZTBusinessException("\u552e\u540e\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u53ef\u552e\u540e\u6570\u91cf");
        }
    }

    private DycProBaseCallEsbUtilServiceOrderParamForJdBO buildJDAfterOrderEntity(DycProOrderCreateAfterOrderReqBO reqBo, List<DycProOrderSaleOrderItemDTO> saleOrderItemList) {
        DycProBaseCallEsbUtilServiceOrderAfsReturnWareInfoForJdBO returnWareInfo;
        DycProBaseCallEsbUtilServiceOrderParamForJdBO ParamForJdBo = new DycProBaseCallEsbUtilServiceOrderParamForJdBO();
        ParamForJdBo.setOrderId(reqBo.getSaleOrderNoExt());
        ParamForJdBo.setThirdApplyId(String.valueOf(System.currentTimeMillis()));
        DycProBaseCallEsbUtilServiceOrderAfsCustomerInfoForJdBO customerInfo = new DycProBaseCallEsbUtilServiceOrderAfsCustomerInfoForJdBO();
        customerInfo.setCustomerName(reqBo.getName());
        if (StringUtils.isNotBlank((String)reqBo.getClientName())) {
            customerInfo.setCustomerContactName(reqBo.getClientName());
        } else {
            customerInfo.setCustomerContactName(null != reqBo.getTakeAddress() ? reqBo.getTakeAddress().getContactName() : reqBo.getReturnAddress().getContactName());
        }
        if (StringUtils.isNotBlank((String)reqBo.getClientPhone())) {
            customerInfo.setCustomerMobilePhone(reqBo.getClientPhone());
        } else {
            customerInfo.setCustomerMobilePhone(null != reqBo.getTakeAddress() ? reqBo.getTakeAddress().getContactMobile() : reqBo.getReturnAddress().getContactMobile());
        }
        ParamForJdBo.setCustomerInfo(customerInfo);
        DycProOrderOrdLogisticsRelaBO takeAddress = reqBo.getTakeAddress();
        if (null != takeAddress) {
            DycProBaseCallEsbUtilServiceOrderAfsPickupWareInfoForJdBO pickwareInfo = new DycProBaseCallEsbUtilServiceOrderAfsPickupWareInfoForJdBO();
            pickwareInfo.setPickwareType(this.buildJdPickwareType(reqBo.getPickwareType()));
            pickwareInfo.setPickWareProvince(Integer.valueOf(takeAddress.getContactProvinceId()));
            pickwareInfo.setPickWareCity(StringUtils.isBlank((String)takeAddress.getContactCityId()) ? null : Integer.valueOf(takeAddress.getContactCityId()));
            pickwareInfo.setPickWareCounty(StringUtils.isBlank((String)takeAddress.getContactCountyId()) ? null : Integer.valueOf(takeAddress.getContactCountyId()));
            pickwareInfo.setPickWareVillage(Integer.valueOf(StringUtils.isBlank((String)takeAddress.getContactTownId()) ? 0 : Integer.parseInt(takeAddress.getContactTownId())));
            pickwareInfo.setPickWareAddress(StringUtils.isBlank((String)takeAddress.getContactAddress()) ? null : takeAddress.getContactAddress());
            ParamForJdBo.setPickwareInfo(pickwareInfo);
        }
        DycProOrderOrdLogisticsRelaBO returnAddress = reqBo.getReturnAddress();
        if (null != reqBo.getReturnAddress()) {
            returnWareInfo = new DycProBaseCallEsbUtilServiceOrderAfsReturnWareInfoForJdBO();
            returnWareInfo.setReturnWareType(Integer.valueOf(10));
            returnWareInfo.setReturnWareProvince(StringUtils.isBlank((String)returnAddress.getContactProvinceId()) ? null : Integer.valueOf(returnAddress.getContactProvinceId()));
            returnWareInfo.setReturnWareCity(StringUtils.isBlank((String)returnAddress.getContactCityId()) ? null : Integer.valueOf(returnAddress.getContactCityId()));
            returnWareInfo.setReturnWareCountry(StringUtils.isBlank((String)returnAddress.getContactCityId()) ? null : Integer.valueOf(returnAddress.getContactCityId()));
            returnWareInfo.setReturnWareVillage(Integer.valueOf(StringUtils.isBlank((String)returnAddress.getContactTownId()) ? 0 : Integer.parseInt(returnAddress.getContactTownId())));
            returnWareInfo.setReturnWareAddress(StringUtils.isBlank((String)returnAddress.getContactAddress()) ? null : returnAddress.getContactAddress());
            ParamForJdBo.setReturnWareInfo(returnWareInfo);
        }
        if (DycProOrderManageServiceConstant.AfterServType.RETURN.equals(reqBo.getServType()) && null != takeAddress) {
            returnWareInfo = new DycProBaseCallEsbUtilServiceOrderAfsReturnWareInfoForJdBO();
            returnWareInfo.setReturnWareType(Integer.valueOf(10));
            returnWareInfo.setReturnWareProvince(StringUtils.isBlank((String)takeAddress.getContactProvinceId()) ? null : Integer.valueOf(takeAddress.getContactProvinceId()));
            returnWareInfo.setReturnWareCity(StringUtils.isBlank((String)takeAddress.getContactCityId()) ? null : Integer.valueOf(takeAddress.getContactCityId()));
            returnWareInfo.setReturnWareCountry(StringUtils.isBlank((String)takeAddress.getContactCityId()) ? null : Integer.valueOf(takeAddress.getContactCityId()));
            returnWareInfo.setReturnWareVillage(Integer.valueOf(StringUtils.isBlank((String)takeAddress.getContactTownId()) ? 0 : Integer.parseInt(takeAddress.getContactTownId())));
            returnWareInfo.setReturnWareAddress(StringUtils.isBlank((String)takeAddress.getContactAddress()) ? null : takeAddress.getContactAddress());
            ParamForJdBo.setReturnWareInfo(returnWareInfo);
        }
        Map<Long, DycProOrderSaleOrderItemDTO> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSaleOrderItemId, item -> item, (k1, k2) -> k1));
        List<DycProOrderAfterOrderItemBO> afterOrderItemList = reqBo.getAfterOrderItemList();
        if (CollectionUtils.isNotEmpty(afterOrderItemList)) {
            ArrayList<DycProBaseCallEsbUtilServiceOrderAfsApplyInfoItemForJdBO> afsApplyInfoItemList = new ArrayList<DycProBaseCallEsbUtilServiceOrderAfsApplyInfoItemForJdBO>(1);
            for (DycProOrderAfterOrderItemBO AfterOrderItemBO : afterOrderItemList) {
                DycProBaseCallEsbUtilServiceOrderAfsApplyInfoItemForJdBO afsApplyInfoItem = new DycProBaseCallEsbUtilServiceOrderAfsApplyInfoItemForJdBO();
                afsApplyInfoItem.setCustomerExpect(reqBo.getServType());
                DycProBaseCallEsbUtilServiceOrderWareDescInfoForJdBO wareDescInfo = new DycProBaseCallEsbUtilServiceOrderWareDescInfoForJdBO();
                List<DycProOrderOrderAccessoryBO> orderAccessoryBoList = reqBo.getAfterOrderAccessoryList();
                if (CollectionUtils.isNotEmpty(orderAccessoryBoList)) {
                    wareDescInfo.setQuestionPic(orderAccessoryBoList.stream().map(DycProOrderOrderAccessoryBO::getAccessoryUrl).collect(Collectors.joining(";")));
                }
                wareDescInfo.setQuestionDesc(StringUtils.isNotBlank((String)reqBo.getQuestionDesc()) ? reqBo.getQuestionDesc() : DictionaryFrameworkUtils.getDicDataByCode((String)"EgcAfOrderAfsReason", (String)String.valueOf(reqBo.getAfsReason())));
                afsApplyInfoItem.setWareDescInfo(wareDescInfo);
                DycProBaseCallEsbUtilServiceOrderWareDetailInfoForJdBO wareDetailInfo = new DycProBaseCallEsbUtilServiceOrderWareDetailInfoForJdBO();
                wareDetailInfo.setWareId(Long.valueOf(saleOrderItemMap.get(AfterOrderItemBO.getSaleOrderItemId()).getSkuExtSkuId()));
                wareDetailInfo.setMainWareId(Long.valueOf(saleOrderItemMap.get(AfterOrderItemBO.getSaleOrderItemId()).getSkuExtSkuId()));
                wareDetailInfo.setWareName(saleOrderItemMap.get(AfterOrderItemBO.getSaleOrderItemId()).getSkuName());
                wareDetailInfo.setWareNum(Integer.valueOf(AfterOrderItemBO.getReturnCount().toPlainString()));
                wareDetailInfo.setWareType(Integer.valueOf(10));
                afsApplyInfoItem.setWareDetailInfo(wareDetailInfo);
                afsApplyInfoItemList.add(afsApplyInfoItem);
            }
            ParamForJdBo.setAfsApplyInfoItemList(afsApplyInfoItemList);
        }
        return ParamForJdBo;
    }

    private DycProBaseCallEsbUtilServiceOrderReqBO buildAfterOrderEntity(DycProOrderCreateAfterOrderReqBO reqBo, List<DycProOrderSaleOrderItemDTO> saleOrderItemList) {
        DycProBaseCallEsbUtilServiceOrderReqBO callEsbUtilreturnWareOrderReqBo = new DycProBaseCallEsbUtilServiceOrderReqBO();
        callEsbUtilreturnWareOrderReqBo.setOrderId(reqBo.getSaleOrderNoExt());
        callEsbUtilreturnWareOrderReqBo.setPackageId(reqBo.getShipOrderNoExt());
        callEsbUtilreturnWareOrderReqBo.setServiceType(reqBo.getServType());
        callEsbUtilreturnWareOrderReqBo.setQuestionDesc(StringUtils.isNotBlank((String)reqBo.getQuestionDesc()) ? reqBo.getQuestionDesc() : DictionaryFrameworkUtils.getDicDataByCode((String)"EgcAfOrderAfsReason", (String)String.valueOf(reqBo.getAfsReason())));
        DycProBaseCallEsbUtilServiceOrderCustomerBO customer = new DycProBaseCallEsbUtilServiceOrderCustomerBO();
        if (StringUtils.isNotBlank((String)reqBo.getClientName())) {
            customer.setCustomerContactName(reqBo.getClientName());
        } else {
            customer.setCustomerContactName(null != reqBo.getTakeAddress() ? reqBo.getTakeAddress().getContactName() : reqBo.getReturnAddress().getContactName());
        }
        if (StringUtils.isNotBlank((String)reqBo.getClientPhone())) {
            customer.setCustomerMobilePhone(reqBo.getClientPhone());
        } else {
            customer.setCustomerMobilePhone(null != reqBo.getTakeAddress() ? reqBo.getTakeAddress().getContactMobile() : reqBo.getReturnAddress().getContactMobile());
        }
        callEsbUtilreturnWareOrderReqBo.setCustomer(customer);
        DycProOrderOrdLogisticsRelaBO takeAddress = reqBo.getTakeAddress();
        DycProBaseCallEsbUtilServiceOrderPickwareBO pickWare = new DycProBaseCallEsbUtilServiceOrderPickwareBO();
        pickWare.setPickwareType(reqBo.getPickwareType());
        if (null != takeAddress) {
            pickWare.setPickwareProvince(StringUtils.isBlank((String)takeAddress.getContactProvinceId()) ? null : Integer.valueOf(takeAddress.getContactProvinceId()));
            pickWare.setPickwareCity(StringUtils.isBlank((String)takeAddress.getContactCityId()) ? null : Integer.valueOf(takeAddress.getContactCityId()));
            pickWare.setPickwareCounty(StringUtils.isBlank((String)takeAddress.getContactCountyId()) ? null : Integer.valueOf(takeAddress.getContactCountyId()));
            pickWare.setPickwareVillage(StringUtils.isBlank((String)takeAddress.getContactTownId()) ? null : Integer.valueOf(takeAddress.getContactTownId()));
            pickWare.setPickwareAddress(takeAddress.getContactAddress());
        }
        callEsbUtilreturnWareOrderReqBo.setPickware(pickWare);
        DycProOrderOrdLogisticsRelaBO returnAddress = reqBo.getReturnAddress();
        DycProBaseCallEsbUtilServiceOrderReturnwareBO returnWare = new DycProBaseCallEsbUtilServiceOrderReturnwareBO();
        if (null != returnAddress) {
            returnWare.setReturnwareProvince(StringUtils.isBlank((String)returnAddress.getContactProvinceId()) ? null : Integer.valueOf(returnAddress.getContactProvinceId()));
            returnWare.setReturnwareCity(StringUtils.isBlank((String)returnAddress.getContactCityId()) ? null : Integer.valueOf(returnAddress.getContactCityId()));
            returnWare.setReturnwareCounty(StringUtils.isBlank((String)returnAddress.getContactCountyId()) ? null : Integer.valueOf(returnAddress.getContactCountyId()));
            returnWare.setReturnwareVillage(StringUtils.isBlank((String)returnAddress.getContactTownId()) ? null : Integer.valueOf(returnAddress.getContactTownId()));
            returnWare.setReturnwareAddress(returnAddress.getContactAddress());
        }
        callEsbUtilreturnWareOrderReqBo.setReturnware(returnWare);
        ArrayList<DycProBaseCallEsbUtilServiceOrderDetailBO> detailEntities = new ArrayList<DycProBaseCallEsbUtilServiceOrderDetailBO>(1);
        Map<Long, DycProOrderSaleOrderItemDTO> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSaleOrderItemId, item -> item, (k1, k2) -> k1));
        List<DycProOrderAfterOrderItemBO> afterOrderItemList = reqBo.getAfterOrderItemList();
        if (CollectionUtils.isNotEmpty(afterOrderItemList)) {
            for (DycProOrderAfterOrderItemBO AfterOrderItemBO : afterOrderItemList) {
                DycProBaseCallEsbUtilServiceOrderDetailBO detailEntity = new DycProBaseCallEsbUtilServiceOrderDetailBO();
                detailEntity.setSkuId(saleOrderItemMap.get(AfterOrderItemBO.getSaleOrderItemId()).getSkuExtSkuId());
                detailEntity.setSkuNum(Integer.valueOf(AfterOrderItemBO.getReturnCount().toPlainString()));
                detailEntities.add(detailEntity);
            }
        }
        callEsbUtilreturnWareOrderReqBo.setDetail(detailEntities);
        List<DycProOrderOrderAccessoryBO> afterOrderAccessoryList = reqBo.getAfterOrderAccessoryList();
        if (CollectionUtils.isNotEmpty(afterOrderAccessoryList)) {
            callEsbUtilreturnWareOrderReqBo.setQuestionPic(afterOrderAccessoryList.stream().map(DycProOrderOrderAccessoryBO::getAccessoryUrl).collect(Collectors.joining(",")));
        }
        return callEsbUtilreturnWareOrderReqBo;
    }

    private void buildJdAfterOrderAddressInfo(DycProOrderCreateAfterOrderReqBO reqBO) {
        DycProOrderSaleOrderDTO querySaleOrder = new DycProOrderSaleOrderDTO();
        querySaleOrder.setSaleOrderId(reqBO.getSaleOrderId());
        DycProOrderSaleOrderDTO dycProOrderSaleOrderDTO = this.dycProOrderSaleOrderRepository.querySaleOrderOneByCondition(querySaleOrder);
        if (null == dycProOrderSaleOrderDTO) {
            throw new ZTBusinessException("\u67e5\u8be2\u9500\u552e\u5355\u4e3a\u7a7a");
        }
        DycProOrderOrdLogisticsRelaDTO dycProOrderOrdLogisticsRelaDTO = new DycProOrderOrdLogisticsRelaDTO();
        if (null != dycProOrderSaleOrderDTO.getContactId()) {
            DycProOrderOrdLogisticsRelaDTO queryOrderOrdLogisticsRelaOneByCondition = new DycProOrderOrdLogisticsRelaDTO();
            queryOrderOrdLogisticsRelaOneByCondition.setContactId(dycProOrderSaleOrderDTO.getContactId());
            dycProOrderOrdLogisticsRelaDTO = this.dycProOrderOrderRepository.queryOrderOrdLogisticsRelaOneByCondition(queryOrderOrdLogisticsRelaOneByCondition);
            if (null == dycProOrderOrdLogisticsRelaDTO) {
                throw new ZTBusinessException("\u67e5\u8be2\u6536\u8d27\u4fe1\u606f\u4e3a\u7a7a");
            }
        }
        if (null == reqBO.getTakeAddress()) {
            DycProOrderOrdLogisticsRelaBO takeAddress = new DycProOrderOrdLogisticsRelaBO();
            BeanUtils.copyProperties((Object)dycProOrderOrdLogisticsRelaDTO, (Object)takeAddress);
            reqBO.setTakeAddress(takeAddress);
        }
        if (null == reqBO.getReturnAddress()) {
            DycProOrderOrdLogisticsRelaBO returnAddress = new DycProOrderOrdLogisticsRelaBO();
            BeanUtils.copyProperties((Object)dycProOrderOrdLogisticsRelaDTO, (Object)returnAddress);
            reqBO.setReturnAddress(returnAddress);
        }
    }

    private Integer buildJdPickwareType(Integer pickwareType) {
        if (DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTakeConstant.SMQJ.equals(pickwareType)) {
            return DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTakeConstant.JD_SMQJ;
        }
        if (DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTakeConstant.KHFH.equals(pickwareType)) {
            return DycProOrderManageServiceConstant.ThirdApiCommonConstant.AfterTakeConstant.JD_KHFH;
        }
        return pickwareType;
    }

    private void verifyParam(DycProOrderCreateAfterOrderReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getShipOrderId()) {
            throw new ZTBusinessException("\u53d1\u8d27\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new ZTBusinessException("\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSaleOrderId()) {
            throw new ZTBusinessException("\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getServType()) {
            throw new ZTBusinessException("\u670d\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getAfsReason()) {
            throw new ZTBusinessException("\u552e\u540e\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPickwareType()) {
            throw new ZTBusinessException("\u53d6\u8d27\u670d\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (DycProOrderManageServiceConstant.AfterOrderPickWareType.UP_DOOR_PICK.equals(reqBO.getPickwareType())) {
            if (null == reqBO.getTakeAddress()) {
                throw new ZTBusinessException("\u53d6\u4ef6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (com.alibaba.cloud.commons.lang.StringUtils.isBlank((CharSequence)reqBO.getTakeAddress().getContactProvinceId())) {
                throw new ZTBusinessException("\u8054\u7cfb\u4eba\u7701\u4efd\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (com.alibaba.cloud.commons.lang.StringUtils.isBlank((CharSequence)reqBO.getTakeAddress().getContactProvinceName())) {
                throw new ZTBusinessException("\u8054\u7cfb\u4eba\u7701\u4efd\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (com.alibaba.cloud.commons.lang.StringUtils.isBlank((CharSequence)reqBO.getTakeAddress().getContactCityId())) {
                throw new ZTBusinessException("\u8054\u7cfb\u4eba\u5730\u5e02\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (com.alibaba.cloud.commons.lang.StringUtils.isBlank((CharSequence)reqBO.getTakeAddress().getContactCityName())) {
                throw new ZTBusinessException("\u8054\u7cfb\u4eba\u5730\u5e02\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (com.alibaba.cloud.commons.lang.StringUtils.isBlank((CharSequence)reqBO.getTakeAddress().getContactCountyId())) {
                throw new ZTBusinessException("\u8054\u7cfb\u4eba\u533a\u53bf\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (com.alibaba.cloud.commons.lang.StringUtils.isBlank((CharSequence)reqBO.getTakeAddress().getContactAddress())) {
                throw new ZTBusinessException("\u6536\u8d27\u4eba\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (DycProOrderManageServiceConstant.AfterServType.CHANGE.equals(reqBO.getServType())) {
            if (null == reqBO.getReturnAddress()) {
                throw new ZTBusinessException("\u8fd4\u4ef6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (com.alibaba.cloud.commons.lang.StringUtils.isBlank((CharSequence)reqBO.getReturnAddress().getContactProvinceId())) {
                throw new ZTBusinessException("\u8054\u7cfb\u4eba\u7701\u4efd\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (com.alibaba.cloud.commons.lang.StringUtils.isBlank((CharSequence)reqBO.getReturnAddress().getContactProvinceName())) {
                throw new ZTBusinessException("\u8054\u7cfb\u4eba\u7701\u4efd\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (com.alibaba.cloud.commons.lang.StringUtils.isBlank((CharSequence)reqBO.getReturnAddress().getContactCityId())) {
                throw new ZTBusinessException("\u8054\u7cfb\u4eba\u5730\u5e02\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (com.alibaba.cloud.commons.lang.StringUtils.isBlank((CharSequence)reqBO.getReturnAddress().getContactCityName())) {
                throw new ZTBusinessException("\u8054\u7cfb\u4eba\u5730\u5e02\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (com.alibaba.cloud.commons.lang.StringUtils.isBlank((CharSequence)reqBO.getReturnAddress().getContactCountyId())) {
                throw new ZTBusinessException("\u8054\u7cfb\u4eba\u533a\u53bf\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (CollectionUtil.isEmpty(reqBO.getAfterOrderItemList())) {
            throw new ZTBusinessException("\u552e\u540e\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (DycProOrderAfterOrderItemBO afterOrderItemBO : reqBO.getAfterOrderItemList()) {
            if (null == afterOrderItemBO.getShipItemId()) {
                throw new ZTBusinessException("\u53d1\u8d27\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == afterOrderItemBO.getReturnCount()) {
                throw new ZTBusinessException("\u552e\u540e\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (afterOrderItemBO.getReturnCount().compareTo(BigDecimal.ZERO) >= 0) continue;
            throw new ZTBusinessException("\u552e\u540e\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u96f6");
        }
        BigDecimal total = reqBO.getAfterOrderItemList().stream().map(DycProOrderAfterOrderItemBO::getReturnCount).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (total.compareTo(BigDecimal.ZERO) <= 0) {
            throw new ZTBusinessException("\u603b\u552e\u540e\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
        }
    }
}

