/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.chngorder.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.egc.constant.DycProOrderManageServiceConstant;
import com.tydic.dyc.pro.egc.repository.chngorder.api.DycProOrderChngOrderRepository;
import com.tydic.dyc.pro.egc.repository.chngorder.dto.DycProOrderChngOrderDTO;
import com.tydic.dyc.pro.egc.repository.chngorder.dto.DycProOrderChngOrderItemObjDTO;
import com.tydic.dyc.pro.egc.repository.chngorder.dto.DycProOrderChngOrderItemObjQryDTO;
import com.tydic.dyc.pro.egc.repository.chngorder.dto.DycProOrderChngOrderObjDTO;
import com.tydic.dyc.pro.egc.repository.chngorder.dto.DycProOrderChngOrderObjQryDTO;
import com.tydic.dyc.pro.egc.repository.chngorder.dto.DycProOrderChngOrderQryDTO;
import com.tydic.dyc.pro.egc.repository.insporder.api.DycProOrderInspOrderRepository;
import com.tydic.dyc.pro.egc.repository.insporder.dto.DycProOrderInspOrderDTO;
import com.tydic.dyc.pro.egc.repository.insporder.dto.DycProOrderInspOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.insporder.dto.DycProOrderInspOrderQryDTO;
import com.tydic.dyc.pro.egc.repository.order.api.DycProOrderOrderRepository;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderRelDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemQryDTO;
import com.tydic.dyc.pro.egc.service.chngorder.api.DycProOrderConfirmChngOrderService;
import com.tydic.dyc.pro.egc.service.chngorder.bo.DycProOrderChngOrderItemObjBO;
import com.tydic.dyc.pro.egc.service.chngorder.bo.DycProOrderConfirmChngOrderItemBO;
import com.tydic.dyc.pro.egc.service.chngorder.bo.DycProOrderConfirmChngOrderReqBO;
import com.tydic.dyc.pro.egc.service.chngorder.bo.DycProOrderConfirmChngOrderRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.chngorder.api.DycProOrderConfirmChngOrderService"})
public class DycProOrderConfirmChngOrderServiceImpl
implements DycProOrderConfirmChngOrderService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderConfirmChngOrderServiceImpl.class);
    @Autowired
    private DycProOrderChngOrderRepository dycProOrderChngOrderRepository;
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;
    @Autowired
    private DycProOrderInspOrderRepository dycProOrderInspOrderRepository;
    @Autowired
    private DycProOrderOrderRepository dycProOrderOrderRepository;
    @Lazy
    @Autowired
    private DycProOrderConfirmChngOrderService dycProOrderConfirmChngOrderService;

    @Override
    @PostMapping(value={"confirmChngOrder"})
    public DycProOrderConfirmChngOrderRspBO confirmChngOrder(@RequestBody DycProOrderConfirmChngOrderReqBO reqBo) {
        this.paramVerify(reqBo);
        DycProOrderConfirmChngOrderRspBO rspBo = new DycProOrderConfirmChngOrderRspBO();
        List<DycProOrderChngOrderItemObjBO> dycProOrderChngOrderItemObjBOList = this.getListChngOrderItemObj(reqBo);
        DycProOrderChngOrderQryDTO queryChngOrderQryDTO = new DycProOrderChngOrderQryDTO();
        queryChngOrderQryDTO.setChngOrderIdList(reqBo.getChngOrderList().stream().map(DycProOrderConfirmChngOrderItemBO::getChngOrderId).collect(Collectors.toList()));
        List chngOrderObjDTOList = this.dycProOrderChngOrderRepository.queryChngOrderObjListByCondition(queryChngOrderQryDTO);
        if (CollectionUtils.isEmpty((Collection)chngOrderObjDTOList)) {
            throw new ZTBusinessException("\u67e5\u8be2\u53d8\u66f4\u5355\u5bf9\u8c61\u4e3a\u7a7a");
        }
        this.modifyBatchChngOrderState(reqBo, chngOrderObjDTOList);
        ArrayList inspOrderItemsIdList = new ArrayList();
        dycProOrderChngOrderItemObjBOList.forEach(e -> inspOrderItemsIdList.add(e.getInspOrderItemId()));
        DycProOrderInspOrderItemDTO dycProOrderInspOrderItemDTO = new DycProOrderInspOrderItemDTO();
        dycProOrderInspOrderItemDTO.setInspOrderItemsIdList(inspOrderItemsIdList);
        List listInspOrderItem = this.dycProOrderInspOrderRepository.getListInspOrderItem(dycProOrderInspOrderItemDTO);
        if (CollectionUtils.isEmpty((Collection)listInspOrderItem)) {
            throw new ZTBusinessException("\u67e5\u8be2\u9a8c\u6536\u5355\u660e\u7ec6\u4fe1\u606f\u5931\u8d25");
        }
        if (DycProOrderManageServiceConstant.OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
            this.confirm(reqBo, dycProOrderChngOrderItemObjBOList, listInspOrderItem);
        }
        if (DycProOrderManageServiceConstant.OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
            this.refuse(reqBo, dycProOrderChngOrderItemObjBOList, listInspOrderItem);
        }
        this.updateSaleOrdersTate(reqBo);
        List<String> inspOrderIdList = listInspOrderItem.stream().map(x -> x.getInspOrderId() + "-" + x.getOrderId()).distinct().collect(Collectors.toList());
        if (!CollectionUtil.isEmpty(dycProOrderChngOrderItemObjBOList) && !CollectionUtils.isEmpty(inspOrderIdList)) {
            this.updateRelState(inspOrderIdList);
        }
        this.sendDealTodoNotice(reqBo);
        return rspBo;
    }

    private List<DycProOrderChngOrderItemObjBO> getListChngOrderItemObj(DycProOrderConfirmChngOrderReqBO reqBo) {
        List orderIdList = reqBo.getChngOrderList().stream().map(DycProOrderConfirmChngOrderItemBO::getOrderId).collect(Collectors.toList());
        DycProOrderChngOrderItemObjQryDTO dycProOrderChngOrderItemObjQryDTO = new DycProOrderChngOrderItemObjQryDTO();
        dycProOrderChngOrderItemObjQryDTO.setChngOrderIdList(reqBo.getChngOrderList().stream().map(DycProOrderConfirmChngOrderItemBO::getChngOrderId).collect(Collectors.toList()));
        dycProOrderChngOrderItemObjQryDTO.setOrderIdList(orderIdList);
        dycProOrderChngOrderItemObjQryDTO.setChngType(DycProOrderManageServiceConstant.ChngBusiType.NUM);
        List uocChngOrderItemObjList = this.dycProOrderChngOrderRepository.getListChngOrderItemObj(dycProOrderChngOrderItemObjQryDTO);
        if (CollectionUtils.isEmpty((Collection)uocChngOrderItemObjList)) {
            throw new ZTBusinessException("\u67e5\u8be2\u53d8\u66f4\u660e\u7ec6\u5bf9\u8c61\u4e3a\u7a7a");
        }
        return JSON.parseArray((String)JSON.toJSONString((Object)uocChngOrderItemObjList), DycProOrderChngOrderItemObjBO.class);
    }

    private void modifyBatchChngOrderState(DycProOrderConfirmChngOrderReqBO reqBo, List<DycProOrderChngOrderObjDTO> chngOrderObjDTOList) {
        Map<Long, List<DycProOrderChngOrderObjDTO>> chngOrderIdVsChngOrderObjMap = chngOrderObjDTOList.stream().collect(Collectors.groupingBy(DycProOrderChngOrderObjDTO::getChngOrderId));
        String chngOrderState = DycProOrderManageServiceConstant.OP_FLAG_REFUSE.equals(reqBo.getOpFlag()) ? "CHNG_CHNG_JJ" : "CHNG_CHNG_QR";
        for (DycProOrderConfirmChngOrderItemBO confirmChngOrderItemBO : reqBo.getChngOrderList()) {
            DycProOrderChngOrderDTO chngOrderDto = new DycProOrderChngOrderDTO();
            chngOrderDto.setOrderId(confirmChngOrderItemBO.getOrderId());
            chngOrderDto.setChngOrderId(confirmChngOrderItemBO.getChngOrderId());
            chngOrderDto.setChngOrderState(chngOrderState);
            chngOrderDto.setUpdateTime(new Date());
            chngOrderDto.setUpdateOperId(reqBo.getUserId().toString());
            chngOrderDto.setUpdateOperName(reqBo.getName());
            if (DycProOrderManageServiceConstant.OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
                chngOrderDto.setRejectReason(reqBo.getRejectRemark());
            }
            this.dycProOrderChngOrderRepository.updateChngOrderAndSyncNosql(chngOrderDto);
            ArrayList<DycProOrderChngOrderDTO> chngOrderList = new ArrayList<DycProOrderChngOrderDTO>(1);
            DycProOrderChngOrderDTO updateChngOrderDTO = new DycProOrderChngOrderDTO();
            updateChngOrderDTO.setChngOrderId(confirmChngOrderItemBO.getChngOrderId());
            updateChngOrderDTO.setChngOrderState(chngOrderState);
            chngOrderList.add(updateChngOrderDTO);
            DycProOrderSaleOrderDTO updateSaleOrderDTO = new DycProOrderSaleOrderDTO();
            updateSaleOrderDTO.setSaleOrderId(chngOrderIdVsChngOrderObjMap.get(confirmChngOrderItemBO.getChngOrderId()).get(0).getSaleOrderId());
            updateSaleOrderDTO.setChngOrderList(chngOrderList);
            this.dycProOrderSaleOrderRepository.updateSaleOrderNosqlForIncr(updateSaleOrderDTO);
        }
    }

    private List<DycProOrderInspOrderItemDTO> confirm(DycProOrderConfirmChngOrderReqBO reqBo, List<DycProOrderChngOrderItemObjBO> dycProOrderChngOrderItemObjBOList, List<DycProOrderInspOrderItemDTO> insoOrderItemList) {
        ArrayList<DycProOrderInspOrderItemDTO> inspOrderItemDTOList = new ArrayList<DycProOrderInspOrderItemDTO>();
        ArrayList<DycProOrderSaleOrderItemDTO> saleOrderItemDTOList = new ArrayList<DycProOrderSaleOrderItemDTO>();
        ArrayList<DycProOrderChngOrderItemObjDTO> chngOrderItemObjDTOList = new ArrayList<DycProOrderChngOrderItemObjDTO>();
        ArrayList saleOrderItemsIdList = new ArrayList();
        DycProOrderSaleOrderItemQryDTO dycProOrderSaleOrderItemDTO = new DycProOrderSaleOrderItemQryDTO();
        dycProOrderChngOrderItemObjBOList.forEach(e -> saleOrderItemsIdList.add(e.getSaleOrderItemId()));
        dycProOrderSaleOrderItemDTO.setSaleOrderItemsIdList(saleOrderItemsIdList);
        Map<Long, DycProOrderInspOrderItemDTO> inspOrderItemMap = insoOrderItemList.stream().collect(Collectors.toMap(DycProOrderInspOrderItemDTO::getInspOrderItemId, e -> e));
        List saleOrderItemList = this.dycProOrderSaleOrderRepository.getSaleOrderItemList(dycProOrderSaleOrderItemDTO);
        Map<Long, DycProOrderSaleOrderItemDTO> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSaleOrderItemId, e -> e));
        Map<Long, List<DycProOrderChngOrderItemObjBO>> objIdVsItemMap = dycProOrderChngOrderItemObjBOList.stream().collect(Collectors.groupingBy(DycProOrderChngOrderItemObjBO::getChngOrderObjId));
        for (Map.Entry<Long, List<DycProOrderChngOrderItemObjBO>> entry : objIdVsItemMap.entrySet()) {
            List<DycProOrderChngOrderItemObjBO> chngOrderItemObjBOList = entry.getValue();
            for (DycProOrderChngOrderItemObjBO dycProOrderChngOrderItemObjBO : chngOrderItemObjBOList) {
                DycProOrderInspOrderItemDTO inspOrderItemDto = new DycProOrderInspOrderItemDTO();
                inspOrderItemDto.setUpdateTime(new Date());
                inspOrderItemDto.setUpdateOperId(reqBo.getUserId().toString());
                inspOrderItemDto.setInspOrderId(inspOrderItemMap.get(dycProOrderChngOrderItemObjBO.getInspOrderItemId()).getInspOrderId());
                inspOrderItemDto.setSaleOrderItemId(inspOrderItemMap.get(dycProOrderChngOrderItemObjBO.getInspOrderItemId()).getSaleOrderItemId());
                inspOrderItemDto.setInspOrderItemId(dycProOrderChngOrderItemObjBO.getInspOrderItemId());
                inspOrderItemDto.setChngingCount(BigDecimal.ZERO);
                DycProOrderSaleOrderItemDTO saleOrderItemDto = new DycProOrderSaleOrderItemDTO();
                saleOrderItemDto.setUpdateOperId(reqBo.getUserId().toString());
                saleOrderItemDto.setUpdateTime(new Date());
                saleOrderItemDto.setSaleOrderItemId(dycProOrderChngOrderItemObjBO.getSaleOrderItemId());
                saleOrderItemDto.setChngingCount(BigDecimal.ZERO);
                saleOrderItemDto.setSaleOrderId(saleOrderItemMap.get(dycProOrderChngOrderItemObjBO.getSaleOrderItemId()).getSaleOrderId());
                DycProOrderChngOrderItemObjDTO chngOrderItemObjDto = new DycProOrderChngOrderItemObjDTO();
                BeanUtils.copyProperties((Object)dycProOrderChngOrderItemObjBO, (Object)chngOrderItemObjDto);
                if (dycProOrderChngOrderItemObjBO.getAddOrSubtractType().equals(DycProOrderManageServiceConstant.CHNG_TYPE_ADD) && DycProOrderManageServiceConstant.OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
                    inspOrderItemDto.setRemainInspCount(inspOrderItemMap.get(dycProOrderChngOrderItemObjBO.getInspOrderItemId()).getRemainInspCount().add(dycProOrderChngOrderItemObjBO.getChngNum()));
                    inspOrderItemDto.setInspCount(inspOrderItemMap.get(dycProOrderChngOrderItemObjBO.getInspOrderItemId()).getInspCount().add(dycProOrderChngOrderItemObjBO.getChngNum()));
                    saleOrderItemDto.setAcceptanceCount(saleOrderItemMap.get(dycProOrderChngOrderItemObjBO.getSaleOrderItemId()).getAcceptanceCount().add(dycProOrderChngOrderItemObjBO.getChngNum()));
                    chngOrderItemObjDto.setRemainInspCount(dycProOrderChngOrderItemObjBO.getRemainInspCount().add(dycProOrderChngOrderItemObjBO.getChngNum()));
                } else if (dycProOrderChngOrderItemObjBO.getAddOrSubtractType().equals(DycProOrderManageServiceConstant.CHNG_TYPE_SUBTRACT) && DycProOrderManageServiceConstant.OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
                    inspOrderItemDto.setRemainInspCount(inspOrderItemMap.get(dycProOrderChngOrderItemObjBO.getInspOrderItemId()).getRemainInspCount().subtract(dycProOrderChngOrderItemObjBO.getChngNum()));
                    inspOrderItemDto.setInspCount(inspOrderItemMap.get(dycProOrderChngOrderItemObjBO.getInspOrderItemId()).getInspCount().subtract(dycProOrderChngOrderItemObjBO.getChngNum()));
                    saleOrderItemDto.setAcceptanceCount(saleOrderItemMap.get(dycProOrderChngOrderItemObjBO.getSaleOrderItemId()).getAcceptanceCount().subtract(dycProOrderChngOrderItemObjBO.getChngNum()));
                    chngOrderItemObjDto.setRemainInspCount(dycProOrderChngOrderItemObjBO.getRemainInspCount().subtract(dycProOrderChngOrderItemObjBO.getChngNum()));
                }
                inspOrderItemDTOList.add(inspOrderItemDto);
                saleOrderItemDTOList.add(saleOrderItemDto);
                chngOrderItemObjDTOList.add(chngOrderItemObjDto);
            }
            DycProOrderInspOrderDTO updateInspOrderDTO = new DycProOrderInspOrderDTO();
            updateInspOrderDTO.setInspItemList(inspOrderItemDTOList);
            this.dycProOrderInspOrderRepository.updateInspOrderItemBatchByIdsAndSyncNosql(updateInspOrderDTO, saleOrderItemList);
            this.dycProOrderSaleOrderRepository.updateSaleOrderItemBatchById(saleOrderItemDTOList);
            this.dycProOrderChngOrderRepository.updateBatchChngOrderObjItemById(chngOrderItemObjDTOList);
        }
        return insoOrderItemList;
    }

    private void refuse(DycProOrderConfirmChngOrderReqBO reqBo, List<DycProOrderChngOrderItemObjBO> dycProOrderChngOrderItemObjBOList, List<DycProOrderInspOrderItemDTO> insoOrderItemList) {
        ArrayList<DycProOrderInspOrderItemDTO> inspOrderItemDTOList = new ArrayList<DycProOrderInspOrderItemDTO>();
        ArrayList<DycProOrderSaleOrderItemDTO> saleOrderItemDTOList = new ArrayList<DycProOrderSaleOrderItemDTO>();
        Map<Long, DycProOrderInspOrderItemDTO> inspOrderItemMap = insoOrderItemList.stream().collect(Collectors.toMap(DycProOrderInspOrderItemDTO::getInspOrderItemId, e -> e));
        Map<Long, List<DycProOrderChngOrderItemObjBO>> objIdVsItemMap = dycProOrderChngOrderItemObjBOList.stream().collect(Collectors.groupingBy(DycProOrderChngOrderItemObjBO::getChngOrderObjId));
        for (Map.Entry<Long, List<DycProOrderChngOrderItemObjBO>> entry : objIdVsItemMap.entrySet()) {
            List<DycProOrderChngOrderItemObjBO> chngOrderItemObjBOList = entry.getValue();
            for (DycProOrderChngOrderItemObjBO dycProOrderChngOrderItemObjBO : chngOrderItemObjBOList) {
                DycProOrderInspOrderItemDTO inspOrderItemDto = new DycProOrderInspOrderItemDTO();
                inspOrderItemDto.setUpdateTime(new Date());
                inspOrderItemDto.setUpdateOperId(reqBo.getUserId().toString());
                inspOrderItemDto.setInspOrderId(inspOrderItemMap.get(dycProOrderChngOrderItemObjBO.getInspOrderItemId()).getInspOrderId());
                inspOrderItemDto.setInspOrderItemId(dycProOrderChngOrderItemObjBO.getInspOrderItemId());
                inspOrderItemDto.setChngingCount(BigDecimal.ZERO);
                DycProOrderSaleOrderItemDTO saleOrderItemDto = new DycProOrderSaleOrderItemDTO();
                saleOrderItemDto.setUpdateOperId(reqBo.getUserId().toString());
                saleOrderItemDto.setUpdateTime(new Date());
                saleOrderItemDto.setSaleOrderItemId(dycProOrderChngOrderItemObjBO.getSaleOrderItemId());
                saleOrderItemDto.setChngingCount(BigDecimal.ZERO);
                inspOrderItemDTOList.add(inspOrderItemDto);
                saleOrderItemDTOList.add(saleOrderItemDto);
            }
            DycProOrderInspOrderDTO updateInspOrderDTO = new DycProOrderInspOrderDTO();
            updateInspOrderDTO.setInspItemList(inspOrderItemDTOList);
            this.dycProOrderInspOrderRepository.updateOnlyInspOrderItemBatchByIdsAndSyncNosql(updateInspOrderDTO);
            this.dycProOrderSaleOrderRepository.updateSaleOrderItemBatchById(saleOrderItemDTOList);
        }
    }

    private void updateSaleOrdersTate(DycProOrderConfirmChngOrderReqBO reqBo) {
        List chngOrderIdList = reqBo.getChngOrderList().stream().map(DycProOrderConfirmChngOrderItemBO::getChngOrderId).collect(Collectors.toList());
        DycProOrderChngOrderObjQryDTO uocChngOrderObjQryBo = new DycProOrderChngOrderObjQryDTO();
        uocChngOrderObjQryBo.setChngOrderIdList(chngOrderIdList);
        List chngOrderObjList = this.dycProOrderChngOrderRepository.getListChngOrderObjWithOutItem(uocChngOrderObjQryBo);
        if (ObjectUtil.isEmpty((Object)chngOrderObjList)) {
            throw new ZTBusinessException("\u67e5\u8be2\u53d8\u66f4\u5355\u5bf9\u8c61\u4e3a\u7a7a");
        }
        List saleOrderIdList = chngOrderObjList.stream().map(DycProOrderChngOrderObjDTO::getSaleOrderId).collect(Collectors.toList());
        DycProOrderSaleOrderItemQryDTO uocSaleOrderItemQryBo = new DycProOrderSaleOrderItemQryDTO();
        uocSaleOrderItemQryBo.setSaleOrderIdList(saleOrderIdList);
        List saleOrderItemList = this.dycProOrderSaleOrderRepository.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (ObjectUtil.isEmpty((Object)saleOrderItemList)) {
            throw new ZTBusinessException("\u67e5\u8be2\u9500\u552e\u660e\u7ec6\u4e3a\u7a7a");
        }
        List ecSaleOrderItemList = saleOrderItemList.stream().filter(bo -> DycProOrderManageServiceConstant.OrderSource.E_ORDER.equals(bo.getSkuSource())).collect(Collectors.toList());
        Boolean ecFlag = false;
        if (!CollectionUtils.isEmpty(ecSaleOrderItemList)) {
            ecFlag = true;
        }
        Map<Long, List<DycProOrderSaleOrderItemDTO>> saleOrderItemMapBySale = saleOrderItemList.stream().collect(Collectors.groupingBy(DycProOrderSaleOrderItemDTO::getSaleOrderId));
        for (Long saleOrderId : saleOrderItemMapBySale.keySet()) {
            List<DycProOrderSaleOrderItemDTO> itemList = saleOrderItemMapBySale.get(saleOrderId);
            BigDecimal totalInspCount = itemList.stream().map(DycProOrderSaleOrderItemDTO::getAcceptanceCount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalArrivedCount = itemList.stream().map(DycProOrderSaleOrderItemDTO::getArriveCount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalRefusedCount = itemList.stream().map(DycProOrderSaleOrderItemDTO::getRefuseCount).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (totalInspCount.compareTo(BigDecimal.ZERO) != 0 && totalRefusedCount.compareTo(BigDecimal.ZERO) != 0) {
                String saleOrderState = "XS_YS_BFYS";
                if (ecFlag.booleanValue()) {
                    saleOrderState = "XS_YS_YS";
                }
                this.updateSaleOrderMain(itemList.get(0).getOrderId(), saleOrderId, saleOrderState, reqBo.getUserId(), reqBo.getName());
            }
            if (totalInspCount.compareTo(BigDecimal.ZERO) == 0 && totalArrivedCount.compareTo(BigDecimal.ZERO) != 0 && totalRefusedCount.compareTo(BigDecimal.ZERO) != 0) {
                this.updateSaleOrderMain(itemList.get(0).getOrderId(), saleOrderId, "XS_DH_BFDH", reqBo.getUserId(), reqBo.getName());
            }
            if (totalInspCount.compareTo(BigDecimal.ZERO) == 0 && totalArrivedCount.compareTo(BigDecimal.ZERO) == 0 && totalRefusedCount.compareTo(BigDecimal.ZERO) != 0) {
                this.updateSaleOrderMain(itemList.get(0).getOrderId(), saleOrderId, "XS_DH_JS", reqBo.getUserId(), reqBo.getName());
            }
            if (totalInspCount.compareTo(BigDecimal.ZERO) != 0 && totalRefusedCount.compareTo(BigDecimal.ZERO) == 0) {
                this.updateSaleOrderMain(itemList.get(0).getOrderId(), saleOrderId, "XS_YS_YS", reqBo.getUserId(), reqBo.getName());
            }
            if (totalInspCount.compareTo(BigDecimal.ZERO) != 0 || totalArrivedCount.compareTo(BigDecimal.ZERO) == 0 || totalRefusedCount.compareTo(BigDecimal.ZERO) != 0) continue;
            this.updateSaleOrderMain(itemList.get(0).getOrderId(), saleOrderId, "XS_DH_DH", reqBo.getUserId(), reqBo.getName());
        }
    }

    private void updateRelState(List<String> inspOrderIdList) {
        for (String inspOrderId : inspOrderIdList) {
            List<Object> updateRelDtoList;
            String[] split = inspOrderId.split("-");
            DycProOrderOrderRelDTO orderRelQryDto = new DycProOrderOrderRelDTO();
            orderRelQryDto.setObjId(Long.valueOf(split[0]));
            orderRelQryDto.setOrderId(Long.valueOf(split[1]));
            orderRelQryDto.setObjType(DycProOrderManageServiceConstant.OrderQueryIndexObjType.INSPECTION);
            List qryRelResult = this.dycProOrderOrderRepository.qryListRelInfo(orderRelQryDto);
            DycProOrderInspOrderQryDTO inspOrderQryDto = new DycProOrderInspOrderQryDTO();
            inspOrderQryDto.setInspOrderId(Long.valueOf(split[0]));
            DycProOrderInspOrderDTO qryInspResult = this.dycProOrderInspOrderRepository.queryInspOrderById(inspOrderQryDto);
            if (null == qryInspResult) {
                throw new ZTBusinessException("\u67e5\u8be2\u9a8c\u6536\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            DycProOrderSaleOrderDTO saleOrderDto = new DycProOrderSaleOrderDTO();
            saleOrderDto.setSaleOrderId(qryInspResult.getSaleOrderId());
            DycProOrderSaleOrderDTO qrySaleResult = this.dycProOrderSaleOrderRepository.querySaleOrderOneByCondition(saleOrderDto);
            if (null == qrySaleResult) {
                throw new ZTBusinessException("\u67e5\u8be2\u9500\u552e\u5355\u4e3a\u7a7a\uff01");
            }
            if (DycProOrderManageServiceConstant.OrderSource.E_ORDER.equals(qrySaleResult.getOrderSource())) {
                List<Object> updateRelList;
                if (DycProOrderManageServiceConstant.ModelSettle.TRADE.equals(qrySaleResult.getModelSettle())) {
                    updateRelList = qryRelResult.stream().filter(bo -> DycProOrderManageServiceConstant.RelType.COMMON_INVOICE.equals(bo.getRelType()) || DycProOrderManageServiceConstant.RelType.UP_INVOICE.equals(bo.getRelType())).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(updateRelList)) continue;
                    this.updateRelStateData(updateRelList, DycProOrderManageServiceConstant.RelStatus.UN_SUBMITTED);
                    continue;
                }
                updateRelList = qryRelResult.stream().filter(bo -> DycProOrderManageServiceConstant.RelType.CH_INVOICE.equals(bo.getRelType())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(updateRelList)) continue;
                this.updateRelStateData(updateRelList, DycProOrderManageServiceConstant.RelStatus.UN_SUBMITTED);
                continue;
            }
            if (DycProOrderManageServiceConstant.ModelSettle.TRADE.equals(qrySaleResult.getModelSettle())) {
                updateRelDtoList = qryRelResult.stream().filter(bo -> (DycProOrderManageServiceConstant.RelType.COMMON_INVOICE.equals(bo.getRelType()) || DycProOrderManageServiceConstant.RelType.UP_INVOICE.equals(bo.getRelType())) && !DycProOrderManageServiceConstant.RelStatus.SUBMITTED.equals(bo.getRelStatus())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(updateRelDtoList)) continue;
                this.updateRelStateData(updateRelDtoList, DycProOrderManageServiceConstant.RelStatus.UN_SUBMITTED);
                continue;
            }
            updateRelDtoList = qryRelResult.stream().filter(bo -> DycProOrderManageServiceConstant.RelType.CH_INVOICE.equals(bo.getRelType()) && !DycProOrderManageServiceConstant.RelStatus.SUBMITTED.equals(bo.getRelStatus())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(updateRelDtoList)) continue;
            this.updateRelStateData(updateRelDtoList, DycProOrderManageServiceConstant.RelStatus.UN_SUBMITTED);
        }
    }

    private void updateRelStateData(List<DycProOrderOrderRelDTO> updateRelDtoList, Integer relStatus) {
        updateRelDtoList.stream().filter(Objects::nonNull).forEach(updateRelDto -> updateRelDto.setRelStatus(relStatus));
        this.dycProOrderOrderRepository.updateOrderRelBatchById(updateRelDtoList);
    }

    @Override
    @PostMapping(value={"dealTodoNotice"})
    public DycProOrderConfirmChngOrderRspBO dealTodoNotice(@RequestBody JSONObject reqBO) {
        return new DycProOrderConfirmChngOrderRspBO();
    }

    private void sendDealTodoNotice(DycProOrderConfirmChngOrderReqBO reqBO) {
        for (DycProOrderConfirmChngOrderItemBO chngOrderItemBO : reqBO.getChngOrderList()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("orderId", (Object)chngOrderItemBO.getOrderId());
            jsonObject.put("chngOrderId", (Object)chngOrderItemBO.getChngOrderId());
            jsonObject.put("opFlag", (Object)reqBO.getOpFlag());
            jsonObject.put("userId", (Object)reqBO.getUserId());
            this.dycProOrderConfirmChngOrderService.dealTodoNotice(jsonObject);
        }
    }

    private void updateSaleOrderMain(Long orderId, Long saleOrderId, String saleOrderState, Long userId, String name) {
        DycProOrderSaleOrderDTO saleOrderDto = new DycProOrderSaleOrderDTO();
        saleOrderDto.setSaleOrderState(saleOrderState);
        saleOrderDto.setOrderId(orderId);
        saleOrderDto.setSaleOrderId(saleOrderId);
        saleOrderDto.setUpdateOperId(userId.toString());
        saleOrderDto.setUpdateOperName(name);
        saleOrderDto.setUpdateTime(new Date());
        this.dycProOrderSaleOrderRepository.updateSaleOrderByCondition(saleOrderDto, false);
    }

    private void paramVerify(DycProOrderConfirmChngOrderReqBO reqBo) {
        if (null == reqBo) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBo.getOpFlag()) {
            throw new ZTBusinessException("\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (!DycProOrderManageServiceConstant.OP_FLAG_CONFIRM.equals(reqBo.getOpFlag()) && !DycProOrderManageServiceConstant.OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
            throw new ZTBusinessException("\u5165\u53c2\u64cd\u4f5c\u53ea\u652f\u6301\u786e\u8ba4\u6216\u62d2\u7edd");
        }
        if (DycProOrderManageServiceConstant.OP_FLAG_REFUSE.equals(reqBo.getOpFlag()) && StringUtils.isBlank((String)reqBo.getRejectRemark())) {
            throw new ZTBusinessException("\u62d2\u7edd\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBo.getChngOrderList())) {
            throw new ZTBusinessException("\u5165\u53c2\u53d8\u66f4\u4fe1\u606f\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

