/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dycpro.saas.order.shipOrder.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.pro.base.utils.msgPool.DycProBaseMsgPoolAfterServiceReqBO;
import com.tydic.dyc.pro.base.utils.msgPool.DycProBaseMsgPoolBeforeServiceReqBO;
import com.tydic.dyc.pro.base.utils.msgPool.DycProBaseMsgPoolUtil;
import com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderQueryOrderByOutIdApiService;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderQueryOrderByOutIdApiReqBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderQueryOrderByOutIdApiRspBO;
import com.tydic.dyc.pro.egc.service.shiporder.api.DycProOrderDealVoteShipOrderMsgApiService;
import com.tydic.dyc.pro.egc.service.shiporder.bo.DycProOrderDealVoteShipOrderMsgApiReqBO;
import com.tydic.dyc.pro.egc.service.shiporder.bo.DycProOrderDealVoteShipOrderMsgApiRspBO;
import com.tydic.dycpro.saas.order.shipOrder.api.DycProSaasOrderDealVoteShipOrderMsgService;
import com.tydic.dycpro.saas.order.shipOrder.bo.DycProSaasOrderDealVoteShipOrderMsgReqBO;
import com.tydic.dycpro.saas.order.shipOrder.bo.DycProSaasOrderDealVoteShipOrderMsgRspBO;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_PRO_GROUP/4.0.0/com.tydic.dycpro.saas.order.shipOrder.api.DycProSaasOrderDealVoteShipOrderMsgService"})
public class DycProSaasOrderDealVoteShipOrderMsgServiceImpl
implements DycProSaasOrderDealVoteShipOrderMsgService {
    private static final Logger log = LoggerFactory.getLogger(DycProSaasOrderDealVoteShipOrderMsgServiceImpl.class);
    @Autowired
    private DycProOrderDealVoteShipOrderMsgApiService dycProOrderDealVoteShipOrderMsgApiService;
    @Autowired
    private DycProOrderQueryOrderByOutIdApiService dycProOrderQueryOrderByOutIdApiService;
    @Value(value="${spool.api.before.url:${spool.ability.api.host}/spool/ability/before/do}")
    private String spoolAbilityBeforeServiceUrl;
    @Value(value="${spool.api.after.url:${spool.ability.api.host}/spool/ability/after/do}")
    private String spoolAbilityAfterServiceUrl;
    private static final Integer VOTE_CONFIRM_STATE = 1;
    private static final Integer VOTE_CONFUSE_STATE = 2;
    private static final String PROPER_CAST_FLAG = "properCastFlag";
    private static final Integer PROPER_CAST_CONFIRM_FLAG = 1;
    private static final Integer PROPER_CAST_CONFUSE_FLAG = 2;
    @Autowired
    private CacheClient cacheClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PostMapping(value={"dealVoteShipOrderMsg"})
    public DycProSaasOrderDealVoteShipOrderMsgRspBO dealVoteShipOrderMsg(@RequestBody DycProSaasOrderDealVoteShipOrderMsgReqBO reqBO) {
        String exceptionStr = null;
        try {
            this.spoolBeforeService(reqBO);
            Long orderId = this.getOrderId(reqBO);
            RLock lock = this.cacheClient.getJedisPool().getLock("order_lock_" + orderId);
            log.info("\u83b7\u53d6\u59a5\u6295\u6d88\u606f\u8ba2\u5355id\u9501:{}", (Object)orderId.toString());
            try {
                boolean b = lock.tryLock(5L, 5L, TimeUnit.SECONDS);
                log.info("\u83b7\u53d6\u9501\u7ed3\u679c:{},\u59a5\u6295\u6d88\u606f\u8ba2\u5355id\u9501:{}", (Object)b, (Object)orderId.toString());
                if (b) {
                    this.dealVoteShip(reqBO);
                }
            }
            catch (Exception e) {
                log.error("\u59a5\u6295\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff1a", (Throwable)e);
                throw new ZTBusinessException("\u59a5\u6295\u6d88\u606f\u5904\u7406\u5f02\u5e38" + e.getMessage());
            }
            finally {
                if (lock != null && lock.isHeldByCurrentThread()) {
                    lock.unlock();
                }
                log.info("\u83b7\u53d6\u59a5\u6295\u6d88\u606f\u8ba2\u5355id\u9501\u91ca\u653e:{}", (Object)orderId.toString());
            }
            this.spoolAfterService(reqBO, exceptionStr);
        }
        catch (Exception e) {
            try {
                log.error("\u7535\u5546\u53d1\u8d27\u6d88\u606f\u5904\u7406\u63a5\u53e3\u62a5\u9519\uff1a", (Throwable)e);
                exceptionStr = e.getMessage();
                this.spoolAfterService(reqBO, exceptionStr);
            }
            catch (Throwable throwable) {
                this.spoolAfterService(reqBO, exceptionStr);
                throw throwable;
            }
        }
        return new DycProSaasOrderDealVoteShipOrderMsgRspBO();
    }

    private Long getOrderId(DycProSaasOrderDealVoteShipOrderMsgReqBO reqBO) {
        DycProOrderQueryOrderByOutIdApiReqBO dycProOrderQueryOrderByOutIdApiReqBO = new DycProOrderQueryOrderByOutIdApiReqBO();
        dycProOrderQueryOrderByOutIdApiReqBO.setOutObjId(reqBO.getResult().getOrderId());
        dycProOrderQueryOrderByOutIdApiReqBO.setObjType(Integer.valueOf(4));
        DycProOrderQueryOrderByOutIdApiRspBO dycProOrderQueryOrderByOutIdApiRspBO = this.dycProOrderQueryOrderByOutIdApiService.dealVoteShipOrderMsg(dycProOrderQueryOrderByOutIdApiReqBO);
        if (!"0000".equals(dycProOrderQueryOrderByOutIdApiRspBO.getRespCode())) {
            throw new ZTBusinessException("\u5916\u90e8\u53d1\u8d27\u5355\uff1a" + reqBO.getResult().getOrderId() + "\u59a5\u6295\u53d1\u8d27\u5355\u67e5\u8be2\u5185\u90e8\u5355\u636e\u4fe1\u606f\u5f02\u5e38:" + dycProOrderQueryOrderByOutIdApiRspBO.getRespDesc());
        }
        return dycProOrderQueryOrderByOutIdApiRspBO.getOrderId();
    }

    private void dealVoteShip(DycProSaasOrderDealVoteShipOrderMsgReqBO reqBO) {
        DycProOrderDealVoteShipOrderMsgApiReqBO dycProOrderDealVoteShipOrderMsgApiReqBO = (DycProOrderDealVoteShipOrderMsgApiReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), DycProOrderDealVoteShipOrderMsgApiReqBO.class);
        DycProOrderDealVoteShipOrderMsgApiRspBO shipOrderMsgApiRspBO = this.dycProOrderDealVoteShipOrderMsgApiService.dealVoteShipOrderMsg(dycProOrderDealVoteShipOrderMsgApiReqBO);
        if (!"0000".equals(shipOrderMsgApiRspBO.getRespCode())) {
            throw new ZTBusinessException("\u5916\u90e8\u53d1\u8d27\u5355\uff1a" + reqBO.getResult().getOrderId() + "\u59a5\u6295\u53d1\u8d27\u5355\u4fe1\u606f\u5f02\u5e38:" + shipOrderMsgApiRspBO.getRespDesc());
        }
    }

    private void spoolAfterService(DycProSaasOrderDealVoteShipOrderMsgReqBO reqBO, String exceptionStr) {
        DycProBaseMsgPoolAfterServiceReqBO msgPoolAfterServiceReqBO = new DycProBaseMsgPoolAfterServiceReqBO();
        msgPoolAfterServiceReqBO.setMqMsgId(reqBO.getMqMsgId());
        msgPoolAfterServiceReqBO.setTraceId(reqBO.getTraceId());
        msgPoolAfterServiceReqBO.setException(exceptionStr);
        msgPoolAfterServiceReqBO.setBusiCenterCode("UOC");
        msgPoolAfterServiceReqBO.setUrl(this.spoolAbilityAfterServiceUrl);
        DycProBaseMsgPoolUtil.spoolAfterService((DycProBaseMsgPoolAfterServiceReqBO)msgPoolAfterServiceReqBO);
    }

    private void spoolBeforeService(DycProSaasOrderDealVoteShipOrderMsgReqBO reqBO) {
        DycProBaseMsgPoolBeforeServiceReqBO msgPoolBeforeServiceReqBO = new DycProBaseMsgPoolBeforeServiceReqBO();
        msgPoolBeforeServiceReqBO.setMqMsgId(reqBO.getMqMsgId());
        msgPoolBeforeServiceReqBO.setTraceId(reqBO.getTraceId());
        msgPoolBeforeServiceReqBO.setBusiCenterCode("UOC");
        msgPoolBeforeServiceReqBO.setUrl(this.spoolAbilityBeforeServiceUrl);
        DycProBaseMsgPoolUtil.spoolBeforeService((DycProBaseMsgPoolBeforeServiceReqBO)msgPoolBeforeServiceReqBO);
    }
}

