package com.tydic.dyc.act.service.constant;

import com.tydic.dyc.base.constants.BaseRspConstant;

/**
 * 标题:ActRspConstant
 * 说明:返回编码常量
 * 时间:2022/11/10 10:26
 * 作者:罗有
 */

public class ActRspConstant extends BaseRspConstant {

    /*
    编码生成规则：活动中心编码开头：30开头的6位编码
	调用成功的编码无需再自行定义，统一使用：RSP_CODE_SUCCESS
	每个接口调用失败的编码需自行定义，规则如下：
	编码key：以RSP_CODE开头，以ERROR结束，中间为自定义部分，
	自定义原则为具有可读性的英文单词（可简写），多个单词以“_”分隔
	编码值：领域服务层1开头，如：1001；领域方法以2开头，如：2001；基建层以3开头，如3001；编码值长度为4位
	*/
	public static final String RESP_CODE_SUCCESS = "0000";
    /**
     * 通用系统异常编码
     */
    public static final String RSP_CODE_SYSTEM_EXCEPTION = "300100";
    /**
     * 参数非空
     */
    public static final String RSP_CODE_PARAM_EMPTY_ERROR = "301001";
    /**
     * 参数为空 领域方法
     */
    public static final String RSP_CODE_FUNCTION_EMPTY_ERROR = "302001";
    /**
     * 字典服务入参错误
     */
    public static final String RSP_CODE_PEB_DIC_PARAM_ERROR = "301007";
    // 领域服务 开始
    ///////////////////////////////////////////////////////////////////

    /**
     * 活动提交
     */
    public static final String RSP_CODE_ACTIVE_SUBMIT_EMPTY_ERROR = "301001";

    /**
     * 活动复制
     */
    public static final String RSP_CODE_ACTIVE_COPY_EMPTY_ERROR = "301002";
    ///////////////////////////////////////////////////////////////////
    // 领域服务 结束


    // 领域方法 开始
    ///////////////////////////////////////////////////////////////////

    ///////////////////////////////////////////////////////////////////
    // 领域方法 结束


    // 基建层 开始
    ///////////////////////////////////////////////////////////////////
    /**
     * 删除商品池
     */
    public static final String RSP_CODE_DELETE_ACTIVE_POOL_EMPTY_ERROR = "303001";
    /**
     * 删除活动用户
     */
    public static final String RSP_CODE_DELETE_GRANT_MEM_EMPTY_ERROR = "303002";
    /**
     * 删除活动
     */
    public static final String RSP_CODE_DELETE_ACTIVE_EMPTY_ERROR = "303003";
    /**
     * 活动用户积分
     */
    public static final String RSP_CODE_UPDATE_GRANT_MEM_EMPTY_ERROR = "303004";
    /**
     * 获取编号
     */
    public static final String RSP_CODE_GET_ACTIVE_NO_ERROR = "303005";
    ///////////////////////////////////////////////////////////////////
    // 基建层 结束
}
