package com.tydic.dyc.act.service.commom;

import com.tydic.dyc.act.service.commom.bo.*;
import lombok.extern.ohaotian.HTServiceAPI;

/**
 * 描述：字典服务，前端使用
 *
 * @author tkl
 * @date 2022/3/9 14:20
 * <p>
 **/
@HTServiceAPI
public interface ActProDictionaryService {

    /**
     * 描述: 查字典
     *
     * @param reqBO 入参对象
     * @return UocProDictionaryRspBO
     */
    ActProDictionaryRspBO qryDic(ActProDictionaryReqBO reqBO);

    /**
     * 创建字典值
     *
     * @param reqBO 入参对象
     * @return UocProDictionaryCreateRspBO
     */
    ActProDictionaryCreateRspBO createDic(ActProDictionaryCreateReqBO reqBO);

    /**
     * 修改字典值
     *
     * @param reqBO 入参对象
     * @return UocProDictionaryUpdateRspBO
     */
    ActProDictionaryUpdateRspBO updateDic(ActProDictionaryUpdateReqBO reqBO);

    /**
     * 删除字典值
     *
     * @param reqBO 入参对象
     * @return FscDictionaryDeleteBusiRspBO
     */
    ActProDictionaryDeleteRspBO deleteDic(ActProDictionaryDeleteReqBO reqBO);

}
