package com.tydic.dyc.act.service.constant;

/**
 * 标题:ActCommConstant
 * 说明:通用常量
 * 时间:2022/11/10 10:23
 * 作者:罗有
 */

public class ActCommConstant {

    /**
     * 共用响应码 - 入参必填字段为空
     */
    public static final String RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR = "0001";

    public static final String ACT = "ACT";

    public static final String CODE_ORG_TYPE = "-1";

    /**
     * ES indexName
     */
    public static final class ActIndex {
        public static final String ACTIVE_INDEX = "act_active";
    }

    /**
     * 活动商品关联类型 1单位福利商品池 2本次活动商品池
     */
    public static final class ActiveRelType {
        public static final Integer ORG_COMPANY_POOL = 1;
        public static final Integer THIS_ACTIVE = 2;
    }

    /**
     * 附件类型 1活动附件
     */
    public static final class AccessoryType {
        public static final Integer ACTIVE = 1;
        public static final Integer CHANGE = 2;
    }

    /**
     * 活动状态 1草稿 2审批中 3启用 4变更中 5停用 6生效 7失效 8审批驳回
     */
    public static final class ActiveState {
        /**
         * 字典编码
         */
        public static final String P_CODE = "active_state";
        /**
         * 1草稿
         */
        public static final String DRAFT = "1";
        /**
         * 2审批中
         */
        public static final String APPROVAL = "2";
        /**
         * 3启用
         */
        public static final String ENABLE = "3";
        /**
         * 4变更中
         */
        public static final String CHANGING = "4";
        /**
         * 5停用
         */
        public static final String DEACTIVATE = "5";
        /**
         * 6生效
         */
        public static final String EFFECTIVE = "6";
        /**
         * 7失效
         */
        public static final String INVALID = "7";
        /**
         * 8审批驳回
         */
        public static final String REJECT = "8";
    }


    /**
     * 活动状态 0 审批中 1 审批通过 2 审批驳回
     */
    public static final class ChngStatus {
        /**
         * 0 审批中
         */
        public static final String APPROVAL = "0";
        /**
         * 1 审批通过
         */
        public static final String PASS = "1";
        /**
         * 2 审批驳回
         */
        public static final String REJECT = "2";
    }


    /**
     * 删除标志，1已删除，0未删除
     */
    public static final class DELETE_TAG {
        public static final Integer DELETED = 1;
        public static final Integer NO_DEL = 0;
    }

    /**
     * 类型 1使启用活动生效 2使生效活动失效
     */
    public static final class OperType {
        public static final String EFFECTIVE = "1";
        public static final String INVALID = "2";
    }

    /**
     * 积分对象类型 0用户 1机构
     */
    public static final class ItgObjType {
        public static final Integer USER = 0;
        public static final Integer OTG = 1;
    }

    /**
     * 积分类型 0通用 1活动专属
     */
    public static final class ItgType {
        public static final String P_CODE = "itg_type";
        public static final Integer COMMON = 0;
        public static final Integer ACTIVE = 1;
    }

    /**
     * 积分状态 1有效 2失效 0停用
     */
    public static final class ItgStatus {
        public static final Integer EFFECTIVE = 1;
        public static final Integer INVALID = 2;
        public static final Integer DEACTIVATE = 0;
    }

    /**
     * 积分来源对象类型 1活动
     */
    public static final class ItgSourceObjType {
        public static final Integer ACTIVE = 1;
        public static final Integer CHANGE = 2;
    }

    /**
     * 积分使用对象类型 1活动
     */
    public static final class ItgUseObjType {
        public static final Integer ACTIVE = 1;
        public static final Integer CHANGE = 2;
    }


    /**
     * 审批单状态
     */
    public static final class AUDIT_ORDER_STATUS {
        /**
         * 驳回
         */
        public static final String REJECT = "0";
        /**
         * 通过
         */
        public static final String PASS = "1";
        /**
         * 待审批
         */
        public static final String WAIT_AUDIT = "2";
    }

    /**
     * 单据类型
     */
    public static final class ObjType {
        /**
         * 审批单
         */
        public static final Integer APPROVE = 9;
        /**
         * 活动
         */
        public static final Integer ACTIVE = 1;
        /**
         * 变更
         */
        public static final Integer CHANGE = 2;
    }

    public static final class PROC_TASK_FINISHED {
        public static final Integer FINISHED = 1;
        public static final Integer NO_FINISHED = 0;
        public static final Integer END_TASK = 2;

    }

    public static final class TASK_DEAL_RESULT {
        public static final Integer APPROVING = 2;
        public static final Integer AUDIT_PASS = 1;
        public static final Integer AUDIT_REJECT = 0;

    }

    public static final class ActiveType {
        public static final String P_CODE = "active_type";
        /**
         * 0 公司
         */
        public static final Integer COMPANY = 0;
        /**
         * 1 工会
         */
        public static final Integer LABOUR_UNION = 1;

    }

    /**
     * 加签标识  0 ：环节任务   1：前加签任务  2：后加签任务  3：存在后加签任务
     */
    public static final class TASK_SING_TAG {
        public static final Integer TACHE_TASK = 0;
        public static final Integer PRE_TASK = 1;
        public static final Integer AF_TASK = 2;
        public static final Integer EXIST_AF_TASK = 3;

    }

    /**
     * 处理分类，1处理人，2候选人
     */
    public static final class TASK_DEAL_CLASS {
        public static final String ASSIGNEE = "1";
        public static final String CANDIDATE = "2";

    }

    /**
     * 长期有效标识 1长期有效 2非长期有效
     */
    public static final class LongTermFlag {
        public static final Integer YES = 1;
        public static final Integer NO = 2;

    }

    /**
     * 1活动，2活动变更
     */
    public static final class ObjBusiType {
        public static final String ACTIVE = "1";
        public static final String ACTIVE_CHNG = "2";
    }

    /**
     * 活动通知
     */
    public static final class ACT_NOTICE {
        /**
         * 福豆发放通知
         */
        public static final String act_bean_grant_notice = "act_bean_grant_notice";
        /**
         * 福利活动即将过期通知
         */
        public static final String act_will_expire_notice = "act_will_expire_notice";
        /**
         * 福利活动过期通知
         */
        public static final String act_active_expire_notice = "act_active_expire_notice";
        /**
         * 福利活动审批通知
         */
        public static final String act_active_approve_notice = "act_active_approve_notice";
        /**
         * 福利活动审批通过
         */
        public static final String act_active_pass_notice = "act_active_pass_notice";
        /**
         * 福利活动审批驳回
         */
        public static final String act_active_reject_notice = "act_active_reject_notice";
        /**
         * 福利活动变更审批通知
         */
        public static final String act_change_approve_notice = "act_change_approve_notice";
        /**
         * 福利活动变更审批通过
         */
        public static final String act_change_pass_notice = "act_change_pass_notice";
        /**
         * 福利活动变更审批驳回
         */
        public static final String act_change_reject_notice = "act_change_reject_notice";
    }


}
