package com.tydic.dyc.act.service.act.bo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 描述：发票抬头
 *
 * @author Lihulin
 * @date 2023-04-21 20:47
 **/
@Data
public class ActAccountInvoiceBO implements Serializable {
    private static final long serialVersionUID = -3496214834006077132L;

    /**
     * 活动ID
     */
    private Long activeId;
    private Long accountId;
    private String invoiceTitle;
    /**
     * 发票类型 00:专用 01:普通
     */
    private String invoiceType;
    private String taxpayerId;
    private String bank;
    /**
     * 银行账号
     */
    private String account;
    private String phone;
    private String address;
    /**
     * 停启用状态             00：停用             01：启用
     */
    private String status;
    /**
     * 有效状态             00：有效             01：无效
     */
    private String delStatus;
    /**
     * 联系人电话
     */
    private String contactPhone;
    /**
     * 联系人
     */
    private String contact;
    /**
     * 联系人邮箱
     */
    private String contactMail;
    /**
     * 0否 1是
     */
    private Integer mainFlag;
    private String createNo;
    private Date createTime;
    private String operateName;
    private Date operateTime;
    /**
     * 机构ID
     */
    private Long orgId;
    /**
     * 外部发票状态 0.暂存，1.审批中，2.通过，3.否决，4.中断
     */
    private String extinvoiceStatus;
    /**
     * 外部发票状态说明
     */
    private String extinvoiceStatusStr;
    /**
     * 外部发票来源 1：京东
     */
    private String extinvoiceSource;
    /**
     * 外部发票资质id
     */
    private String extinvoiceQuaId;
    /**
     * 发票类别 01:纸质发票 02:电子发票
     */
    private String invoiceClass;
    /**
     * 发票抬头类型PERSON:个人 COMPANY:公司
     */
    private String titleType;
    /**
     * 帐套归属 PERSON:个人 COMPANY:公司
     */
    private String accountOwner;
    private String operateNo;
    private String createName;
    /**
     * 排序
     */
    private String orderBy;

}
