package com.tydic.dyc.act.service.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题：DycActActivityBaseInfoBO
 * 说明：
 * 时间： 2023-12-12 11:23
 * 作者 @author LY
 */
@Data
public class DycActActivityBaseInfoBO implements Serializable {
    private static final long serialVersionUID = 272538515635759538L;

    /**
     * 活动id
     */
    private Long activityId;
    /**
     * 活动版本号
     */
    private Integer activityVersion;
    /**
     * 活动编号
     */
    private String activityCode;
    /**
     * 活动适用组织id
     */
    private Long activityScopeOrgId;
    /**
     * 活动适用组织名称
     */
    private String activityScopeOrgName;
    /**
     * 活动名称
     */
    private String activityName;
    /**
     * 活动类型:1:工会活动；2：劳防活动
     */
    private Integer activityType;
    /**
     * 活动期限:1:有限期，2:无限期
     */
    private Integer activityCycleType;
    /**
     * 活动开始时间
     */
    private Date activityStartTime;
    /**
     * 活动结束时间
     */
    private Date activityEndTime;
    /**
     * 活动状态:1:草稿；2：待审批；3：已驳回；4：启用；5：已生效；6：停用；7：已失效；8：变更中
     */
    private String activityState;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 创建人ID
     */
    private Long createUserId;
    /**
     * 创建人名称
     */
    private String createUserName;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 更新人名称
     */
    private String updateUserId;
    /**
     * 更新人ID
     */
    private Long updateUserName;
    /**
     * 创建人机构ID
     */
    private Long createOrgId;
    /**
     * 创建人机构名称
     */
    private String createOrgName;
    /**
     * 创建人机构路径
     */
    private String createOrgTreePath;
    /**
     * 创建人公司ID
     */
    private Long createCompanyId;
    /**
     * 创建人公司名称
     */
    private String createCompanyName;
    /**
     * 活动类型翻译
     */
    private String activityTypeStr;
    /**
     * 活动状态翻译
     */
    private String activityStateStr;
    /**
     * 活动期限类型翻译
     */
    private String activityCycleTypeStr;
}
