package com.tydic.dyc.act.constants;

/**
 * 标题：DycActivityConstants
 * 说明：
 * 时间： 2023-12-12 16:43
 * 作者 @author LY
 */
public class DycActivityConstants {


    /**
     * 发票类别
     */
    public static final class InvoiceClass{
        /**
         * 1:纸质发票
         */
        public static final String INVOICE_CLASS_ONE = "1";
        /**
         * 1:纸质发票(翻译)
         */
        public static final String INVOICE_CLASS_ONE_STR = "纸质发票";
        /**
         * 2:电子发票
         */
        public static final String INVOICE_CLASS_TWO = "2";
        /**
         * 2:电子发票(翻译)
         */
        public static final String INVOICE_CLASS_TWO_STR = "电子发票";
    }


    /**
     * 发票类型
     */
    public static final class InvoiceType{
        /**
         * 1:专用发票
         */
        public static final String INVOICE_TYPE_ONE = "1";
        /**
         * 1:专用发票(翻译)
         */
        public static final String INVOICE_TYPE_ONE_STR = "专用发票";
        /**
         * 2：普通发票
         */
        public static final String INVOICE_TYPE_TWO = "2";
        /**
         * 2：普通发票(翻译)
         */
        public static final String INVOICE_TYPE_TWO_STR = "普通发票";
    }

    /**
     * 活动类型
     */
    public static final class ActivityType{
        /**
         * 1:工会活动
         */
        public static final String ACTIVITY_TYPE_ONE = "1";
        /**
         * 1:工会活动(翻译)
         */
        public static final String ACTIVITY_TYPE_ONE_STR = "工会活动";
        /**
         * 2：劳防活动
         */
        public static final String ACTIVITY_TYPE_TWO = "2";
        /**
         * 2：劳防活动(翻译)
         */
        public static final String ACTIVITY_TYPE_TWO_STR = "劳防活动";
    }

    /**
     * 支付方式
     */
    public static final class ActivityPayMode{
        /**
         * 1:积分支付
         */
        public static final String ACTIVITY_PAY_MODE_ONE = "1";
        /**
         * 1:积分支付(翻译)
         */
        public static final String ACTIVITY_PAY_MODE_ONE_STR = "积分支付";
        /**
         * 2：混合支付
         */
        public static final String ACTIVITY_PAY_MODE_TWO = "2";
        /**
         * 2：混合支付(翻译)
         */
        public static final String ACTIVITY_PAY_MODE_TWO_STR = "混合支付";
    }

    /**
     * 活动状态:1:草稿；2：待审批；3：已驳回；4：启用；5：已生效；6：停用；7：已失效；8：变更中
     */
    public static final class ActivityState{
        /**
         * 1:草稿
         */
        public static final String ACTIVITY_STATE_ONE = "1";
        /**
         * 1:草稿(翻译)
         */
        public static final String ACTIVITY_STATE_ONE_STR = "草稿";
        /**
         * 2：待审批
         */
        public static final String ACTIVITY_STATE_TWO = "2";
        /**
         * 2：待审批(翻译)
         */
        public static final String ACTIVITY_STATE_TWO_STR = "待审批";
        /**
         * 3：已驳回
         */
        public static final String ACTIVITY_STATE_THREE = "3";
        /**
         * 3：已驳回(翻译)
         */
        public static final String ACTIVITY_STATE_THREE_STR = "已驳回";
        /**
         * 4：启用
         */
        public static final String ACTIVITY_STATE_FOUR = "4";
        /**
         * 4：启用(翻译)
         */
        public static final String ACTIVITY_STATE_FOUR_STR = "启用";
        /**
         * 5：已生效
         */
        public static final String ACTIVITY_STATE_FIVE = "5";
        /**
         * 5：已生效(翻译)
         */
        public static final String ACTIVITY_STATE_FIVE_STR = "已生效";
        /**
         * 6：停用
         */
        public static final String ACTIVITY_STATE_SIX = "6";
        /**
         * 6：停用(翻译)
         */
        public static final String ACTIVITY_STATE_SIX_STR = "停用";
        /**
         * 7：已失效
         */
        public static final String ACTIVITY_STATE_SEVEN = "7";
        /**
         * 7：已失效(翻译)
         */
        public static final String ACTIVITY_STATE_SEVEN_STR = "已失效";
        /**
         * 8：变更中
         */
        public static final String ACTIVITY_STATE_EIGHT = "8";
        /**
         * 8：变更中(翻译)
         */
        public static final String ACTIVITY_STATE_EIGHT_STR = "变更中";
    }

    /**
     * 业务对象类型
     */
    public static final class BusinessObject{
        /**
         * 1:活动
         */
        public static final String BUSINESS_OBJECT_MODE_ONE = "1";
        /**
         * 1:活动(翻译)
         */
        public static final String BUSINESS_OBJECT_MODE_ONE_STR = "活动";
        /**
         * 2：活动变更单
         */
        public static final String BUSINESS_OBJECT_MODE_TWO = "2";
        /**
         * 2：活动变更单(翻译)
         */
        public static final String BUSINESS_OBJECT_MODE_TWO_STR = "活动变更单";
        /**
         * 3：审批单
         */
        public static final String BUSINESS_OBJECT_MODE_THREE = "3";
        /**
         * 3：审批单(翻译)
         */
        public static final String BUSINESS_OBJECT_MODE_THREE_STR = "审批单";
    }

    /**
     *商品关联方式:1:商品池；2：商品类型；3：商品
     */
    public static final class CommodityRelaMethod{
        public static final String COMMODITY_TYPE_ONE = "1";
        public static final String COMMODITY_TYPE_TWO = "2";
        public static final String COMMODITY_TYPE_THREE = "3";
    }
}
