package com.tydic.dyc.act.service.bo;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class DycActTaskBO implements Serializable {

    private static final long serialVersionUID = -837910598801981530L;
    /**
     * 流程实例ID
     */
    private String procInstId;
    /**
     * 任务Id
     */
    private String taskId;
    /**
     * 环节编码
     */
    private String stepId;
    /**
     * 处理人
     */
    private String assignee;
    /**
     * 候选人列表
     */
    private List<DycActCandidatesBO> candidates;
    /**
     * 表单
     */
    private String formUrl;
    /**
     * 流程定义ID
     */
    private String procDefId;
    /**
     * 流程定义Key
     */
    private String procDefKey;
    /**
     * 流程名称
     */
    private String procDefName;
    /**
     * 业务对象ID
     */
    private String busiObjId;
    /**
     * 业务对象类型
     */
    private String busiObjType;

    private Boolean finish;
    /**
     * 审批环节编码
     */
    private String auditStepId;
    /**
     * 审批环节是否结束
     */
    private Boolean auditStepFinish;

    /**
     * 0 ：环节任务   1：前加签任务  2：后加签任务  3：存在后加签任务
     */
    private Integer taskSignTag = 0;

    @DocField(value = "处理结果")
    private Integer dealResult;

    @DocField(value = "处理备注")
    private String dealRemark;


    private String stepName;
    /**
     * 任务类型  1 ：业务流任务  2 审批流任务
     */
    private Integer taskType;
    /**
     * 源业务对象类型
     */
    private String sourceBusiObjType;
    /**
     * 业务id
     */
    private String businessId;

	private String userId;
	private String userName;
	private String tacheCode;
	private String tacheName;
	private String tacheInstId;
	private String status;
}
