package com.tydic.dyc.act.model.api;

import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.base.bo.BasePageRspBo;

import java.util.List;

/**
 * 描述: 〈活动子域相关方法〉
 * @author : yuhao
 * @date : 2023/12/12 15:13
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface DycActActivityModel {

    /**
     * 根据条件查询活动基本信息列表（分页）
     * @param reqBO
     * @return
     */
    BasePageRspBo<DycActivityBaseInfo> queryActivityPageList(DycActivityDO reqBO);
    /**
     * 根据条件查询活动基本信息列表
     * @param reqBO
     * @return
     */
    List<DycActivityBaseInfo> queryActivityList(DycActivityDO reqBO);
    /**
     * 根据条件查询活动附件信息列表
     * @param reqBO
     * @return
     */
    List<DycActivityFileInfo> queryActivityFileList(DycActivityDO reqBO);
    /**
     * 活动可选供应商列表分页查询服务
     * @param reqBO
     * @return
     */
    BasePageRspBo<DycActivitySupplierInfo> queryActivityUnselectSupplierPageList(DycActivityDO reqBO);
    /**
     * 活动已选供应商列表分页查询服务
     * @param reqBO
     * @return
     */
    BasePageRspBo<DycActivitySupplierInfo> queryActiveSupplierList(DycActivityDO reqBO);
    /**
     * 描述: 供应商批量更新
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivitySupplierInfo
     */
    DycActivitySupplierInfo addBatchActiveSupplier(DycActivitySupplierInfoAddBatchBO reqBO);

    /**
     * 描述: 供应商批量删除
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivitySupplierInfo
     */
    DycActivitySupplierInfo deleteBatchActiveSupplier(DycActivitySupplierInfoDeleteBatchBO reqBO);

    /**
     * 描述: 活动基本详情保存
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityFileInfo
     */
    DycActivityBaseInfo saveActiveBaseInfo(DycActiveBaseInfoSaveReqBO reqBO);

    /**
     * 描述:活动已选商品池列表分页查询
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityCommodityPoolInfo
     */
    BasePageRspBo<DycActivityCommodityPoolInfo> queryActivityCommodityPoolPageList(DycQueryActivityCommodityPoolPageListReqBO reqBO);

    /**
     * 描述:活动已选商品列表分页查询
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActActivityRelaCommodityInfo
     */
    BasePageRspBo<DycActActivityRelaCommodityInfo> queryActivityCommodityPageList(DycActivityDO reqBO);

    /**
     * 描述:活动已选商品类型列表分页查询
     *
     * @param reqBO
     * @return com.tydic.dyc.base.bo.BasePageRspBo<com.tydic.dyc.act.model.bo.DycActiveCommodityCatalogInfo>
     */
    BasePageRspBo<DycActiveCommodityCatalogInfo> queryActiveCommodityCatalogList(DycActiveCommodityCatalogQueryBO reqBO);

    /**
     * 描述:活动商品池选择（批量）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityCommodityPoolInfo
     */
    DycActivityCommodityPoolInfo batchSelectActivityCommodityPool(DycActivityDO reqBO);


    /**
     * 描述:活动商品池移除（批量）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActActivityRelaCommodityInfo
     */
    int batchRemoveActivityCommodityPool(DycActivityDO reqBO);

    /**
     * 描述:活动商品类型选择（批量）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActiveCommodityCatalogInfo
     */
    DycActiveCommodityCatalogInfo batchSelectActivityCommodityCatalog(DycActivityDO reqBO);
    /**
     * 描述:活动商品类型移除（批量）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActActivityRelaCommodityInfo
     */
    int batchRemoveActivityCommodityCatalog(DycActivityDO reqBO);

    /**
     * 描述:活动商品选择（批量）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActActivityRelaCommodityInfo
     */
    DycActActivityRelaCommodityInfo batchSelectActivityCommodity(DycActivityDO reqBO);

    /**
     * 活动商品移除（批量）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActActivityRelaCommodityInfo
     */
    int batchRemoveActivityCommodity(DycActivityDO reqBO);

    /**
     * 活动已选用户列表分页查询服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActActivityRelaCommodityInfo
     */
    BasePageRspBo<DycActivityUserInfo> queryActivityUserPageList(DycActivityDO reqBO);

    /**
     * 活动状态变更服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActActivityRelaCommodityInfo
     */
    int changeActivityState(DycActivityDO reqBO);

    /**
     * 活动删除服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActActivityRelaCommodityInfo
     */
    int deleteActivity(DycActivityDO reqBO);

    /**
     * 描述:活动复制服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityBaseInfo
     */
    DycActivityBaseInfo copyActivity(DycActivityDO reqBO);
    /**
     * 描述:活动用户选择（批量）
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityUserInfo
     */
    DycActivityUserInfo batchSelectActivityUser(DycActivityDO reqBO);
    /**
     * 描述:活动用户移除（批量）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityUserInfo
     */
    DycActivityUserInfo batchRemoveActivityUser(DycActivityDO reqBO);
    /**
     * 描述:活跃用户积分修改服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityUserInfo
     */
    DycActivityUserInfo modifyActivityUserScores(DycActivityDO reqBO);

    /**
     * 描述:活动用户积分修改（批量）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityUserInfo
     */
    DycActivityUserInfo batchModifyActivityUserScores(DycActivityDO reqBO);

    /**
     * 描述:活动用户导入服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityUserInfo
     */
    DycActImportActivityUserModelRspBO importActivityUser(DycActImportActivityUserModelReqBO reqBO);

    /**
     * 描述:活动自动生效定时任务服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityUserInfo
     */
    int autoEffectActivity(DycActivityDO reqBO);

    /**
     * 描述:活动自动失效定时任务服务
     *
     * @param
     * @return void
     */
    DycActivityBaseInfo autoLoseEffectActivity(DycActivityDO reqBO);

    /**
     * 根据条件查询活动基本信息列表（分页）
     * @param reqBO
     * @return
     */
    BasePageRspBo<DycActivityUserScoresUseRecordInfo> queryActivityUserScoresUseRecordPageList(DycActivityDO reqBO);
    /**
     * 描述:活动积分扣减/退还服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityUserInfo
     */
    int deductOrReturnActivityScores(DycActivityDO reqBO);
}
